/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects.generic;

import com.intellij.application.options.CodeStyleAbstractPanel;
import com.intellij.lang.Language;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.sql.dialects.generic.GenericDialect;
import com.intellij.sql.dialects.sql92.Sql92Dialect;
import com.intellij.sql.formatter.settings.SqlCodeStyleMainPanel;
import com.intellij.sql.formatter.settings.SqlCodeStyleSettings;
import com.intellij.sql.formatter.settings.SqlCodeStyleSettingsUtil;
import com.intellij.sql.formatter.settings.SqlCodeStyles;
import com.intellij.sql.formatter.settings.SqlPreviewExamples;
import com.intellij.ui.AncestorListenerAdapter;
import com.intellij.ui.components.JBLabel;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.TreeSet;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GenericSqlCodeStyleMainPanel
extends SqlCodeStyleMainPanel {
    @NotNull
    private SqlLanguageDialect myPreviewDialect = Sql92Dialect.INSTANCE;
    private ComboBox<DialectItem> myDialectSelector;
    private TreeSet<DialectItem> myCurrentInheritedDialects;

    public GenericSqlCodeStyleMainPanel(CodeStyleSettings currentSettings, CodeStyleSettings settings) {
        super((Language)GenericDialect.INSTANCE, currentSettings, settings);
        JComponent panel = this.getPanel();
        assert (panel != null);
        panel.addAncestorListener((AncestorListener)new AncestorListenerAdapter(){

            public void ancestorAdded(AncestorEvent event) {
                GenericSqlCodeStyleMainPanel.this.justShown();
            }
        });
    }

    @Override
    protected boolean isGeneric() {
        return true;
    }

    @Override
    @NotNull
    protected Language getSettingLanguage() {
        GenericDialect genericDialect = GenericDialect.INSTANCE;
        if (genericDialect == null) {
            GenericSqlCodeStyleMainPanel.$$$reportNull$$$0(0);
        }
        return genericDialect;
    }

    @Override
    @NotNull
    protected SqlLanguageDialect getPreviewDialect() {
        Sql92Dialect sql92Dialect = this.myPreviewDialect != null ? this.myPreviewDialect : Sql92Dialect.INSTANCE;
        if (sql92Dialect == null) {
            GenericSqlCodeStyleMainPanel.$$$reportNull$$$0(1);
        }
        return sql92Dialect;
    }

    @Nullable
    public Language getDefaultLanguage() {
        return this.getSettingLanguage();
    }

    @Override
    @NotNull
    protected Class<? extends SqlCodeStyleSettings> getSettingsClass() {
        if (SqlCodeStyleSettings.class == null) {
            GenericSqlCodeStyleMainPanel.$$$reportNull$$$0(2);
        }
        return SqlCodeStyleSettings.class;
    }

    @Override
    @Nullable
    protected JComponent createDialectSelectorStripe(CodeStyleSettings settings) {
        this.myCurrentInheritedDialects = GenericSqlCodeStyleMainPanel.gatherInheritedDialects(settings);
        DefaultComboBoxModel<DialectItem> dialectSelectorModel = new DefaultComboBoxModel<DialectItem>(this.myCurrentInheritedDialects.toArray(new DialectItem[0]));
        this.myDialectSelector = new ComboBox(dialectSelectorModel);
        this.myDialectSelector.setSelectedIndex(0);
        this.myDialectSelector.setMaximumRowCount(15);
        this.myDialectSelector.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                Object item;
                if (e.getStateChange() == 1 && (item = GenericSqlCodeStyleMainPanel.this.myDialectSelector.getSelectedItem()) instanceof DialectItem) {
                    GenericSqlCodeStyleMainPanel.this.handlePreviewDialectChanged((DialectItem)item);
                }
            }
        });
        JPanel dialectStripe = new JPanel(new BorderLayout());
        dialectStripe.setBorder((Border)JBUI.Borders.empty((int)2, (int)10));
        dialectStripe.add((Component)this.myDialectSelector, "Center");
        JBLabel dialectLabel = new JBLabel("Preview dialect:");
        dialectLabel.setLabelFor(this.myDialectSelector);
        dialectStripe.add((Component)dialectLabel, "West");
        return dialectStripe;
    }

    @NotNull
    private static TreeSet<DialectItem> gatherInheritedDialects(@NotNull CodeStyleSettings settings) {
        if (settings == null) {
            GenericSqlCodeStyleMainPanel.$$$reportNull$$$0(3);
        }
        TreeSet<DialectItem> dialectItems = new TreeSet<DialectItem>();
        dialectItems.add(new DialectItem(0, Sql92Dialect.INSTANCE));
        dialectItems.addAll(SqlCodeStyles.listSqlDialects().filter(d2 -> SqlCodeStyles.pickSqlSettings((CodeStyleSettings)settings, (Language)d2).USE_GENERIC_STYLE).transform(d2 -> new DialectItem(1, (SqlLanguageDialect)d2)).toList());
        TreeSet<DialectItem> treeSet = dialectItems;
        if (treeSet == null) {
            GenericSqlCodeStyleMainPanel.$$$reportNull$$$0(4);
        }
        return treeSet;
    }

    protected void justShown() {
        boolean somethingChanged;
        CodeStyleSettings settings = this.getModelSettings();
        TreeSet<DialectItem> dialectItems = GenericSqlCodeStyleMainPanel.gatherInheritedDialects(settings);
        boolean bl = somethingChanged = !this.myCurrentInheritedDialects.equals(dialectItems);
        if (somethingChanged) {
            DefaultComboBoxModel<DialectItem> model = new DefaultComboBoxModel<DialectItem>(dialectItems.toArray(new DialectItem[0]));
            this.myDialectSelector.setModel(model);
            boolean currentWasRemoved = JBIterable.from(dialectItems).filter(item -> item.dialect == this.myPreviewDialect).isEmpty();
            this.myCurrentInheritedDialects = dialectItems;
            if (currentWasRemoved) {
                this.myDialectSelector.setSelectedIndex(0);
                this.handlePreviewDialectChanged(this.myCurrentInheritedDialects.first());
            }
        }
    }

    private void handlePreviewDialectChanged(@NotNull DialectItem dialectItem) {
        if (dialectItem == null) {
            GenericSqlCodeStyleMainPanel.$$$reportNull$$$0(5);
        }
        if (this.myPreviewDialect == dialectItem.dialect) {
            return;
        }
        if (this.myPanels == null) {
            return;
        }
        this.myPreviewDialect = dialectItem.dialect;
        for (CodeStyleAbstractPanel panel : this.myPanels) {
            if (!(panel instanceof SqlCodeStyleMainPanel.SqlSettingsPanel)) continue;
            SqlCodeStyleMainPanel.SqlSettingsPanel p2 = (SqlCodeStyleMainPanel.SqlSettingsPanel)panel;
            String text2 = SqlPreviewExamples.read((Language)this.myPreviewDialect, p2.getType());
            p2.updatePreviewText(text2);
        }
    }

    @Override
    protected PsiFile createFileFromText(Project project, String text2) {
        PsiFile previewFile = SqlCodeStyleSettingsUtil.createSqlFileForCodeStyleSettingsPreview(project, text2, this.getPreviewDialect());
        previewFile.setName("Generic-SQL-preview.sql");
        return previewFile;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 3: 
            case 5: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 3: 
            case 5: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/dialects/generic/GenericSqlCodeStyleMainPanel";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dialectItem";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getSettingLanguage";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getPreviewDialect";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getSettingsClass";
                break;
            }
            case 3: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/dialects/generic/GenericSqlCodeStyleMainPanel";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "gatherInheritedDialects";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "gatherInheritedDialects";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "handlePreviewDialectChanged";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 3: 
            case 5: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class DialectItem
    implements Comparable<DialectItem> {
        final int weight;
        final SqlLanguageDialect dialect;

        private DialectItem(int weight, SqlLanguageDialect dialect) {
            this.weight = weight;
            this.dialect = dialect;
        }

        @Override
        public int compareTo(@NotNull DialectItem o) {
            if (o == null) {
                DialectItem.$$$reportNull$$$0(0);
            }
            if (this.weight < o.weight) {
                return -1;
            }
            if (this.weight > o.weight) {
                return 1;
            }
            return this.toString().compareTo(o.toString());
        }

        public String toString() {
            return this.dialect.getDisplayName();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o", "com/intellij/sql/dialects/generic/GenericSqlCodeStyleMainPanel$DialectItem", "compareTo"));
        }
    }
}

