/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects.postgres;

import com.intellij.lang.LighterASTNode;
import com.intellij.lang.PsiBuilder;
import com.intellij.lang.impl.PsiBuilderImpl;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.sql.dialects.base.SqlGeneratedParserUtil;
import com.intellij.sql.dialects.base.SqlParserUtil;
import com.intellij.sql.dialects.functions.SqlFunctionDefinition;
import com.intellij.sql.dialects.postgres.Pg83Parser;
import com.intellij.sql.dialects.postgres.PgDdlParsing;
import com.intellij.sql.dialects.postgres.PgDialect;
import com.intellij.sql.dialects.postgres.PgDmlParsing;
import com.intellij.sql.dialects.postgres.PgElementTypes;
import com.intellij.sql.dialects.postgres.PgExpressionParsing;
import com.intellij.sql.dialects.postgres.PgGeneratedParser;
import com.intellij.sql.dialects.postgres.PgPlParsing;
import com.intellij.sql.dialects.postgres.PgTypes;
import com.intellij.sql.psi.SqlReferenceElementType;
import com.intellij.util.ObjectUtils;
import org.jetbrains.annotations.Nullable;

public class PgParser
extends Pg83Parser {
    public PgParser(boolean pl) {
        super(PgDialect.INSTANCE, pl);
    }

    @Override
    protected boolean parseExtraRoots(IElementType root2, PsiBuilder builder, int level) {
        return PgGeneratedParser.parse_extra_roots_(root2, builder, level);
    }

    @Override
    public boolean parseValueExpression(PsiBuilder builder, int level, boolean optional, boolean allowBoolean) {
        boolean result2 = PgExpressionParsing.value_expression(builder, level);
        if (!result2 && !optional) {
            builder.error("<expression> expected");
        }
        return result2;
    }

    @Override
    public boolean parseEvaluableExpression(PsiBuilder builder, int level) {
        return SqlGeneratedParserUtil.parseAndRemapToGenericReference(builder, level, PgExpressionParsing::evaluable_expression);
    }

    @Override
    public boolean parseSqlStatement(PsiBuilder builder, int level) {
        if (this.isPlSql()) {
            return PgPlParsing.pl_statement(builder, level);
        }
        if (super.parseSqlStatement(builder, level)) {
            return true;
        }
        return PgGeneratedParser.statement(builder, level);
    }

    @Override
    protected TokenSet[] getExtendsTokenSets() {
        return PgGeneratedParser.EXTENDS_SETS_;
    }

    @Override
    public boolean parseQueryExpression(PsiBuilder builder, int level) {
        return PgDmlParsing.top_query_expression(builder, level);
    }

    @Override
    public boolean parseDataType(PsiBuilder builder, int level, boolean ext) {
        return ext ? PgPlParsing.type_element_ext(builder, level) : PgDdlParsing.type_element(builder, level);
    }

    @Override
    public IElementType consumeCustomParameterReference(PsiBuilder builder) {
        if (this.isPlSql() && SqlParserUtil.nextTokenIs(builder, (IElementType)SQL_IDENT) && builder.getTokenText() != null && builder.getTokenText().startsWith("$")) {
            this.consumeIdentifier(builder);
            return SQL_VARIABLE_REFERENCE;
        }
        return super.consumeCustomParameterReference(builder);
    }

    @Override
    public boolean parseParenContentQorV(PsiBuilder builder, int level) {
        return SqlGeneratedParserUtil.dispatchQandXconflict(builder, level, PgExpressionParsing::parenthesized_values_expr, PgDmlParsing::top_query_expression, PgParser::parseTopQueryExpressionTail, PgExpressionParsing::row_element_list, (b2, l) -> PgExpressionParsing.root_expr_0(b2, l, -1) && PgExpressionParsing.row_element_list_separator(b2, l) && PgExpressionParsing.row_element_list(b2, l));
    }

    @Override
    public boolean parseParenContentQorJ(PsiBuilder builder, int level) {
        return SqlGeneratedParserUtil.dispatchQandXconflict(builder, level, PgDmlParsing::parenthesized_aliased_join_expression, PgDmlParsing::top_query_expression, PgParser::parseTopQueryExpressionTail, (b2, l) -> PgDmlParsing.join_expression(b2, l, -1), (b2, l) -> PgDmlParsing.join_expression_0(b2, l, -1));
    }

    @Override
    public boolean parseFunctionCallTail(PsiBuilder builder, int level) {
        if (!super.parseFunctionCallTail(builder, level)) {
            return false;
        }
        if (PgGeneratedParser.within_group_clause(builder, level) | PgGeneratedParser.analytic_clause(builder, level)) {
            IElementType type;
            LighterASTNode ref = SqlGeneratedParserUtil.getExposedFunctionRef(builder);
            IElementType iElementType = type = ref == null ? null : ref.getTokenType();
            if (type == SQL_REFERENCE || type == SQL_ANY_CALLABLE_REFERENCE) {
                ((PsiBuilderImpl.ProductionMarker)ref).remapTokenType((IElementType)SQL_FUNCTION_REFERENCE);
            }
        }
        return true;
    }

    @Override
    public boolean parseFunctionParametersEnd(PsiBuilder builder, int level, SqlFunctionDefinition definition) {
        PgDmlParsing.order_by_clause(builder, level);
        return true;
    }

    @Override
    protected boolean parseTypedReference(PsiBuilder builder, SqlReferenceElementType refType) {
        boolean result2 = super.parseTypedReference(builder, refType);
        if (!result2 && SqlParserUtil.nextTokenIs(builder, (IElementType)SQL_STRING_TOKEN)) {
            PsiBuilder.Marker mark2 = builder.mark();
            builder.advanceLexer();
            mark2.done((IElementType)SQL_STRING_LITERAL);
            result2 = true;
        }
        if (result2 && SqlParserUtil.consumeOptionalToken(builder, (IElementType)PG_OP_TYPE_CAST)) {
            PsiBuilder.Marker marker = (PsiBuilder.Marker)ObjectUtils.assertNotNull((Object)((PsiBuilder.Marker)builder.getLatestDoneMarker()));
            PgPlParsing.type_element_ext_inner(builder, 0);
            marker.precede().done((IElementType)SQL_BINARY_EXPRESSION);
        }
        return result2;
    }

    @Override
    public boolean parseFunctionArgument(PsiBuilder builder, int level, boolean optional, boolean allowBoolean) {
        boolean variadic = SqlParserUtil.consumeToken(builder, true, PgTypes.PG_VARIADIC);
        return super.parseFunctionArgument(builder, level, optional && !variadic, allowBoolean);
    }

    @Override
    @Nullable
    public IElementType getLazyCodeBlockType() {
        return PgElementTypes.Misc.PG_LAZY_CODE_BLOCK;
    }

    public static boolean parseTopQueryExpressionTail(PsiBuilder builder, int level) {
        PgDmlParsing.query_expression_0(builder, level, -1);
        return PgDmlParsing.left_inner_table_op_tail(builder, level);
    }
}

