/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.editor;

import com.intellij.codeInsight.editorActions.moveUpDown.LineRange;
import com.intellij.codeInsight.editorActions.moveUpDown.StatementUpDownMover;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.sql.psi.SqlBlockStatement;
import com.intellij.sql.psi.SqlCommonKeywords;
import com.intellij.sql.psi.SqlFile;
import com.intellij.sql.psi.SqlStatement;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.TreeTraversal;
import java.util.Iterator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqlStatementUpDownMover
extends StatementUpDownMover {
    public boolean checkAvailable(@NotNull Editor editor, @NotNull PsiFile file, @NotNull StatementUpDownMover.MoveInfo info, boolean down) {
        if (editor == null) {
            SqlStatementUpDownMover.$$$reportNull$$$0(0);
        }
        if (file == null) {
            SqlStatementUpDownMover.$$$reportNull$$$0(1);
        }
        if (info == null) {
            SqlStatementUpDownMover.$$$reportNull$$$0(2);
        }
        if (!(file instanceof SqlFile)) {
            return false;
        }
        Couple<SqlStatement> statements2 = SqlStatementUpDownMover.getStatements(editor, file);
        if (statements2 == null) {
            return false;
        }
        Ref insertion = Ref.create();
        SqlStatement next = SqlStatementUpDownMover.getNextStatement(editor.getDocument(), file, down ? (SqlStatement)statements2.second : (SqlStatement)statements2.first, down, (Ref<Integer>)insertion);
        if (next == null && insertion.isNull()) {
            info.prohibitMove();
            return true;
        }
        PsiElement end = SqlStatementUpDownMover.extendTillSeparator((SqlStatement)statements2.second);
        info.toMove = new LineRange((PsiElement)statements2.first, end);
        if (next != null) {
            PsiElement toEnd = SqlStatementUpDownMover.extendTillSeparator(next);
            info.toMove2 = new LineRange((PsiElement)next, toEnd);
        } else {
            int line = (Integer)insertion.get();
            info.toMove2 = down ? new LineRange(info.toMove.endLine, line) : new LineRange(line, info.toMove.startLine);
        }
        return true;
    }

    @Nullable
    private static SqlStatement getNextStatement(@NotNull Document document, @NotNull PsiFile file, @NotNull SqlStatement stmt, boolean down, Ref<Integer> insertion) {
        SqlStatement border;
        SqlStatement contStmt;
        PsiElement container;
        SqlStatement next;
        if (document == null) {
            SqlStatementUpDownMover.$$$reportNull$$$0(3);
        }
        if (file == null) {
            SqlStatementUpDownMover.$$$reportNull$$$0(4);
        }
        if (stmt == null) {
            SqlStatementUpDownMover.$$$reportNull$$$0(5);
        }
        if ((next = (SqlStatement)((SyntaxTraverser)(down ? SqlImplUtil.sqlRevTraverser(container) : SqlImplUtil.sqlTraverser(container)).expand(arg_0 -> SqlStatementUpDownMover.lambda$getNextStatement$0(container = (PsiElement)ObjectUtils.notNull((Object)(contStmt = (SqlStatement)PsiTreeUtil.getParentOfType((PsiElement)stmt, SqlStatement.class, (boolean)true)), (Object)file), arg_0))).traverse(TreeTraversal.LEAVES_DFS).filter(SqlStatement.class).takeWhile(o -> o != stmt).last()) == null) {
            SqlStatement childOfFileOrBlock = (SqlStatement)SqlImplUtil.sqlParents((PsiElement)contStmt).filter(SqlStatement.class).takeWhile(o -> o == contStmt || !(o instanceof SqlBlockStatement)).last();
            if (childOfFileOrBlock != null) {
                if (down) {
                    insertion.set((Object)(document.getLineNumber(SqlStatementUpDownMover.extendTillSeparator(childOfFileOrBlock).getTextRange().getEndOffset()) + 1));
                } else {
                    insertion.set((Object)document.getLineNumber(childOfFileOrBlock.getTextRange().getStartOffset()));
                }
            }
            return null;
        }
        SqlBlockStatement block = (SqlBlockStatement)((SyntaxTraverser)(down ? SqlImplUtil.sqlTraverser((PsiElement)next) : SqlImplUtil.sqlRevTraverser((PsiElement)next)).expand(o -> !(o instanceof SqlBlockStatement))).preOrderDfsTraversal().filter(SqlBlockStatement.class).first();
        if (block == null) {
            return next;
        }
        JBIterable statements2 = block.getBlockElements().filter(SqlStatement.class);
        SqlStatement sqlStatement = border = down ? (SqlStatement)statements2.first() : (SqlStatement)statements2.last();
        if (border != null) {
            if (down) {
                insertion.set((Object)document.getLineNumber(border.getTextRange().getStartOffset()));
            } else {
                insertion.set((Object)(document.getLineNumber(SqlStatementUpDownMover.extendTillSeparator(border).getTextRange().getEndOffset()) + 1));
            }
            return null;
        }
        PsiElement end = SqlImplUtil.getChildOfType((PsiElement)block, (IElementType)SqlCommonKeywords.SQL_END);
        if (end == null) {
            return next;
        }
        insertion.set((Object)document.getLineNumber(end.getTextRange().getStartOffset()));
        return null;
    }

    @Nullable
    private static Couple<SqlStatement> getStatements(@NotNull Editor editor, @NotNull PsiFile file) {
        SqlStatement first2;
        if (editor == null) {
            SqlStatementUpDownMover.$$$reportNull$$$0(6);
        }
        if (file == null) {
            SqlStatementUpDownMover.$$$reportNull$$$0(7);
        }
        TextRange sel = editor.getSelectionModel().hasSelection() ? TextRange.create((int)editor.getSelectionModel().getSelectionStart(), (int)editor.getSelectionModel().getSelectionEnd()) : TextRange.from((int)editor.getCaretModel().getOffset(), (int)0);
        SqlStatement topMostStatement = (SqlStatement)((SyntaxTraverser)((SyntaxTraverser)SqlImplUtil.sqlTraverser((PsiElement)file).expandAndFilter(o -> o.getTextRange().contains(sel))).filter(Conditions.instanceOf(SqlStatement.class))).postOrderDfsTraversal().first();
        PsiElement topMost = (PsiElement)ObjectUtils.notNull((Object)topMostStatement, (Object)file);
        JBIterable statements2 = ((SyntaxTraverser)((SyntaxTraverser)SqlImplUtil.sqlTraverser(topMost).expand(o -> (o == topMost || !(o instanceof SqlStatement)) && o.getTextRange().intersectsStrict(sel))).filter(o -> o.getTextRange().intersectsStrict(sel))).traverse().filter(SqlStatement.class);
        Iterator it2 = statements2.iterator();
        if (!it2.hasNext()) {
            return topMostStatement == null ? null : Couple.of((Object)topMostStatement, (Object)topMostStatement);
        }
        SqlStatement last = first2 = (SqlStatement)it2.next();
        while (it2.hasNext()) {
            last = (SqlStatement)it2.next();
        }
        return Couple.of((Object)first2, (Object)last);
    }

    @NotNull
    private static PsiElement extendTillSeparator(@NotNull SqlStatement stmt) {
        if (stmt == null) {
            SqlStatementUpDownMover.$$$reportNull$$$0(8);
        }
        TokenSet sep = SqlImplUtil.getSqlDialectSafe((PsiElement)stmt).getStatementSeparators();
        for (PsiElement tmp = stmt.getNextSibling(); tmp != null; tmp = tmp.getNextSibling()) {
            if (tmp instanceof PsiWhiteSpace || tmp instanceof PsiComment) continue;
            Object object = sep.contains(PsiUtilCore.getElementType((PsiElement)tmp)) ? tmp : stmt;
            if (object == null) {
                SqlStatementUpDownMover.$$$reportNull$$$0(9);
            }
            return object;
        }
        SqlStatement sqlStatement = stmt;
        if (sqlStatement == null) {
            SqlStatementUpDownMover.$$$reportNull$$$0(10);
        }
        return sqlStatement;
    }

    private static /* synthetic */ boolean lambda$getNextStatement$0(PsiElement container, PsiElement o) {
        return o == container || !(o instanceof SqlStatement);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 9: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 9: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 1: 
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stmt";
                break;
            }
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/editor/SqlStatementUpDownMover";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/editor/SqlStatementUpDownMover";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "extendTillSeparator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "checkAvailable";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getNextStatement";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getStatements";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "extendTillSeparator";
                break;
            }
            case 9: 
            case 10: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 9: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

