/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.formatter.model;

import com.intellij.lang.ASTNode;
import com.intellij.sql.formatter.model.BlockRole;
import com.intellij.sql.formatter.model.FlowPattern;
import com.intellij.sql.formatter.model.FlowPatternKt;
import com.intellij.sql.formatter.model.NodeMatcher;
import com.intellij.sql.formatter.model.SqlBlock;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0005\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\u0018\u00002\u00020\u0001BU\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u0012\b\b\u0002\u0010\u000b\u001a\u00020\f\u0012\u0010\u0010\r\u001a\f\u0012\u0004\u0012\u00020\u000f0\u000ej\u0002`\u0010\u00a2\u0006\u0002\u0010\u0011J \u0010\u0014\u001a\u0004\u0018\u00010\u00152\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00170\u00062\u0006\u0010\u0018\u001a\u00020\u0019H\u0016R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\u00020\fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/intellij/sql/formatter/model/StartRowUntilPattern;", "Lcom/intellij/sql/formatter/model/FlowPattern;", "applicableState", "", "resultState", "startRowMatchers", "", "Lcom/intellij/sql/formatter/model/NodeMatcher;", "untilMatcher", "acceptEOF", "", "role", "Lcom/intellij/sql/formatter/model/BlockRole;", "producer", "Lkotlin/Function0;", "Lcom/intellij/sql/formatter/model/SqlBlock;", "Lcom/intellij/sql/formatter/model/SqlBlockProducer;", "(Ljava/lang/Byte;Ljava/lang/Byte;Ljava/util/List;Lcom/intellij/sql/formatter/model/NodeMatcher;ZLcom/intellij/sql/formatter/model/BlockRole;Lkotlin/jvm/functions/Function0;)V", "getRole", "()Lcom/intellij/sql/formatter/model/BlockRole;", "process", "Lkotlin/ranges/IntRange;", "nodes", "Lcom/intellij/lang/ASTNode;", "since", "", "intellij.database.sql.impl"})
public final class StartRowUntilPattern
extends FlowPattern {
    private final List<NodeMatcher> startRowMatchers;
    private final NodeMatcher untilMatcher;
    private final boolean acceptEOF;
    @NotNull
    private final BlockRole role;

    @Override
    @Nullable
    public IntRange process(@NotNull List<? extends ASTNode> nodes2, int since) {
        Intrinsics.checkParameterIsNotNull(nodes2, (String)"nodes");
        int m = this.startRowMatchers.size();
        int n = nodes2.size();
        if (since + m > n) {
            return null;
        }
        int rowLength = FlowPatternKt.access$parseRow(nodes2, since, this.startRowMatchers);
        if (rowLength <= 0) {
            return null;
        }
        int tailLength = FlowPatternKt.access$parseUntil(nodes2, since + rowLength, this.untilMatcher, this.acceptEOF);
        if (tailLength <= 0) {
            return null;
        }
        return RangesKt.until((int)since, (int)(since + rowLength + tailLength));
    }

    @Override
    @NotNull
    public BlockRole getRole() {
        return this.role;
    }

    public StartRowUntilPattern(@Nullable Byte applicableState, @Nullable Byte resultState, @NotNull List<? extends NodeMatcher> startRowMatchers, @NotNull NodeMatcher untilMatcher, boolean acceptEOF, @NotNull BlockRole role, @NotNull Function0<? extends SqlBlock> producer) {
        Intrinsics.checkParameterIsNotNull(startRowMatchers, (String)"startRowMatchers");
        Intrinsics.checkParameterIsNotNull((Object)untilMatcher, (String)"untilMatcher");
        Intrinsics.checkParameterIsNotNull((Object)((Object)role), (String)"role");
        Intrinsics.checkParameterIsNotNull(producer, (String)"producer");
        super(applicableState, resultState, producer, null);
        this.startRowMatchers = startRowMatchers;
        this.untilMatcher = untilMatcher;
        this.acceptEOF = acceptEOF;
        this.role = role;
    }

    public /* synthetic */ StartRowUntilPattern(Byte by, Byte by2, List list, NodeMatcher nodeMatcher, boolean bl, BlockRole blockRole, Function0 function0, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x10) != 0) {
            bl = true;
        }
        if ((n & 0x20) != 0) {
            blockRole = BlockRole.NOTHING;
        }
        this(by, by2, list, nodeMatcher, bl, blockRole, (Function0<? extends SqlBlock>)function0);
    }
}

