/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lcom/intellij/sql/inspections/DropPsiFix;", "Lcom/intellij/codeInspection/LocalQuickFix;", "()V", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "descriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "getFamilyName", "", "intellij.database.sql.impl"})
public final class DropPsiFix
implements LocalQuickFix {
    public static final DropPsiFix INSTANCE;

    @NotNull
    public String getFamilyName() {
        return "Delete element";
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)descriptor, (String)"descriptor");
        PsiElement startElement = descriptor.getStartElement();
        PsiElement endElement = descriptor.getEndElement();
        PsiElement psiElement = startElement;
        Intrinsics.checkExpressionValueIsNotNull((Object)psiElement, (String)"startElement");
        PsiElement parent2 = psiElement.getParent();
        PsiElement psiElement2 = endElement;
        Intrinsics.checkExpressionValueIsNotNull((Object)psiElement2, (String)"endElement");
        if (Intrinsics.areEqual((Object)psiElement2.getParent(), (Object)parent2) ^ true) {
            return;
        }
        parent2.deleteChildRange(startElement, endElement);
    }

    private DropPsiFix() {
    }

    static {
        DropPsiFix dropPsiFix;
        INSTANCE = dropPsiFix = new DropPsiFix();
    }
}

