/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.remote;

import com.google.common.collect.Lists;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.remote.RemoteCredentials;
import com.intellij.remote.RemoteSdkCredentials;
import com.intellij.ui.CollectionComboBoxModel;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.jetbrains.plugins.remotesdk.RemoteSdkUtil;
import com.jetbrains.plugins.remotesdk.ui.RemoteBrowseActionListener;
import com.jetbrains.plugins.webDeployment.config.WebServerConfig;
import com.jetbrains.python.remote.RemoteProjectSettings;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.jetbrains.annotations.NotNull;

public class PyProjectRootMappingDialog
extends DialogWrapper {
    private JPanel contentPane;
    private TextFieldWithBrowseButton myRemoteRoot;
    private JTextField myLocalRoot;
    private JBLabel myRemoteRootLabel;
    private JComboBox myDeploymentName;

    protected PyProjectRootMappingDialog(@NotNull VirtualFile baseDir, RemoteSdkCredentials data) {
        if (baseDir == null) {
            PyProjectRootMappingDialog.$$$reportNull$$$0(0);
        }
        super(null);
        this.$$$setupUI$$$();
        this.setTitle("Create Remote Deployment Configuration");
        this.myLocalRoot.setText(baseDir.getPath());
        this.myLocalRoot.setEnabled(false);
        this.myRemoteRootLabel.setLabelFor((Component)this.myRemoteRoot.getTextField());
        RemoteBrowseActionListener.addShowBrowseRemoteDialogAction((TextFieldWithBrowseButton)this.myRemoteRoot, (String)"Select Remote Project Root Path", consumer -> consumer.consume((Object)data));
        PyProjectRootMappingDialog.fillDeploymentCombo(this.myDeploymentName, (RemoteCredentials)data);
        this.init();
    }

    private static void fillDeploymentCombo(JComboBox name, RemoteCredentials data) {
        ArrayList list = Lists.newArrayList();
        for (WebServerConfig webConfig : RemoteSdkUtil.getSftpServerList()) {
            if (!webConfig.getFileTransferConfig().getHost().equals(data.getHost())) continue;
            list.add(webConfig.getName());
        }
        name.setModel(new CollectionComboBoxModel((List)list, null));
    }

    protected JComponent createCenterPanel() {
        JPanel result = new JPanel(new BorderLayout());
        result.add((Component)this.contentPane, "Center");
        return result;
    }

    public RemoteProjectSettings getRemoteProjectSettings() {
        return new RemoteProjectSettings(this.getDeploymentName(), this.myRemoteRoot.getText());
    }

    private String getDeploymentName() {
        return (String)this.myDeploymentName.getSelectedItem();
    }

    protected ValidationInfo doValidate() {
        if (StringUtil.isEmpty((String)this.getDeploymentName())) {
            return new ValidationInfo("Deployment name can't be empty", (JComponent)this.myDeploymentName);
        }
        if (StringUtil.isEmpty((String)this.myRemoteRoot.getText())) {
            return new ValidationInfo("Remote root can't be empty", (JComponent)this.myRemoteRoot);
        }
        return super.doValidate();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseDir", "com/jetbrains/python/remote/PyProjectRootMappingDialog", "<init>"));
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JComboBox jComboBox;
        TextFieldWithBrowseButton textFieldWithBrowseButton;
        JBLabel jBLabel;
        JTextField jTextField;
        JPanel jPanel;
        this.contentPane = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(10, 10, 10, 10), -1, -1, false, false));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(3, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel2, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel3, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JBLabel jBLabel2 = new JBLabel();
        jBLabel2.setText("Local project root:");
        jPanel3.add((Component)jBLabel2, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myLocalRoot = jTextField = new JTextField();
        jPanel3.add((Component)jTextField, new GridConstraints(0, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        this.myRemoteRootLabel = jBLabel = new JBLabel();
        jBLabel.setText("Remote project root:");
        jPanel3.add((Component)jBLabel, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myRemoteRoot = textFieldWithBrowseButton = new TextFieldWithBrowseButton();
        jPanel3.add((Component)textFieldWithBrowseButton, new GridConstraints(1, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        Spacer spacer = new Spacer();
        jPanel2.add((Component)spacer, new GridConstraints(2, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel4, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JBLabel jBLabel3 = new JBLabel();
        jBLabel3.setText("Deployment configuration name:");
        jPanel4.add((Component)jBLabel3, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myDeploymentName = jComboBox = new JComboBox();
        jComboBox.setEditable(true);
        jPanel4.add(jComboBox, new GridConstraints(0, 1, 1, 1, 8, 1, 2, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.contentPane;
    }
}

