/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.remote.console;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.SdkAdditionalData;
import com.intellij.remote.CredentialsType;
import com.intellij.ssh.process.SshExecProcess;
import com.intellij.util.net.NetUtils;
import com.jetbrains.python.console.PydevConsoleCli;
import com.jetbrains.python.console.PydevConsoleCommunication;
import com.jetbrains.python.console.PydevConsoleCommunicationClient;
import com.jetbrains.python.console.PydevConsoleRunnerImpl;
import com.jetbrains.python.console.PythonConsoleRemoteProcessCreator;
import com.jetbrains.python.console.RemoteConsoleProcessData;
import com.jetbrains.python.remote.PyRemotePathMapper;
import com.jetbrains.python.remote.PyRemoteProcessHandler;
import com.jetbrains.python.remote.PyRemoteProcessHandlerBase;
import com.jetbrains.python.remote.PyRemoteProcessHandlerUtil;
import com.jetbrains.python.remote.PyRemoteSdkAdditionalDataBase;
import com.jetbrains.python.remote.PythonRemoteInterpreterManager;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\b&\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B\u0013\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004\u00a2\u0006\u0002\u0010\u0005J=\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u0017R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0018"}, d2={"Lcom/jetbrains/python/remote/console/PythonConsoleSshProcessCreatorBase;", "T", "Lcom/jetbrains/python/console/PythonConsoleRemoteProcessCreator;", "credentialsType", "Lcom/intellij/remote/CredentialsType;", "(Lcom/intellij/remote/CredentialsType;)V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "getCredentialsType", "()Lcom/intellij/remote/CredentialsType;", "createRemoteConsoleProcess", "Lcom/jetbrains/python/console/RemoteConsoleProcessData;", "commandLine", "Lcom/intellij/execution/configurations/GeneralCommandLine;", "pathMapper", "Lcom/jetbrains/python/remote/PyRemotePathMapper;", "project", "Lcom/intellij/openapi/project/Project;", "data", "Lcom/jetbrains/python/remote/PyRemoteSdkAdditionalDataBase;", "runnerFileFromHelpers", "", "credentials", "(Lcom/intellij/execution/configurations/GeneralCommandLine;Lcom/jetbrains/python/remote/PyRemotePathMapper;Lcom/intellij/openapi/project/Project;Lcom/jetbrains/python/remote/PyRemoteSdkAdditionalDataBase;Ljava/lang/String;Ljava/lang/Object;)Lcom/jetbrains/python/console/RemoteConsoleProcessData;", "intellij.python.remoteInterpreter"})
public abstract class PythonConsoleSshProcessCreatorBase<T>
implements PythonConsoleRemoteProcessCreator<T> {
    private final Logger LOG;
    @NotNull
    private final CredentialsType<T> credentialsType;

    @NotNull
    public RemoteConsoleProcessData createRemoteConsoleProcess(@NotNull GeneralCommandLine commandLine, @NotNull PyRemotePathMapper pathMapper, @NotNull Project project, @NotNull PyRemoteSdkAdditionalDataBase data, @NotNull String runnerFileFromHelpers, T credentials) {
        Intrinsics.checkParameterIsNotNull((Object)commandLine, (String)"commandLine");
        Intrinsics.checkParameterIsNotNull((Object)pathMapper, (String)"pathMapper");
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
        Intrinsics.checkParameterIsNotNull((Object)runnerFileFromHelpers, (String)"runnerFileFromHelpers");
        int scriptPort = NetUtils.findAvailableSocketPort();
        PythonRemoteInterpreterManager pythonRemoteInterpreterManager = PythonRemoteInterpreterManager.getInstance();
        if (pythonRemoteInterpreterManager == null) {
            throw (Throwable)new PythonRemoteInterpreterManager.PyRemoteInterpreterExecutionException();
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)pythonRemoteInterpreterManager, (String)"PythonRemoteInterpreterM\u2026reterExecutionException()");
        PythonRemoteInterpreterManager manager = pythonRemoteInterpreterManager;
        PydevConsoleCli.setupPythonConsoleScriptInServerMode$default((GeneralCommandLine)commandLine, (SdkAdditionalData)((SdkAdditionalData)data), null, (int)2, null);
        try {
            PyRemoteProcessHandlerUtil.SshExecProcessWithHandler sshExecProcessWithHandler = PyRemoteProcessHandlerUtil.startRemoteProcess(project, commandLine, manager, data, pathMapper);
            Intrinsics.checkExpressionValueIsNotNull((Object)sshExecProcessWithHandler, (String)"PyRemoteProcessHandlerUt\u2026anager, data, pathMapper)");
            PyRemoteProcessHandlerUtil.SshExecProcessWithHandler result = sshExecProcessWithHandler;
            PyRemoteProcessHandler pyRemoteProcessHandler = result.getHandler();
            Intrinsics.checkExpressionValueIsNotNull((Object)((Object)pyRemoteProcessHandler), (String)"result.handler");
            PyRemoteProcessHandler processHandler = pyRemoteProcessHandler;
            SshExecProcess sshExecProcess = result.getProcess();
            Intrinsics.checkExpressionValueIsNotNull((Object)sshExecProcess, (String)"result.process");
            SshExecProcess remoteProcess = sshExecProcess;
            PydevConsoleCommunicationClient remoteConsoleCommunication = null;
            int remoteScriptPort = PydevConsoleRunnerImpl.getRemotePortFromProcess((Process)((Process)remoteProcess));
            remoteProcess.addLocalTunnel(scriptPort, "localhost", remoteScriptPort);
            if (this.LOG.isDebugEnabled()) {
                this.LOG.debug("Using tunneled communication for Python console:" + " port " + scriptPort + " (=> " + remoteScriptPort + ") on pydevconsole.py side");
            }
            remoteConsoleCommunication = new PydevConsoleCommunicationClient(project, "localhost", scriptPort, (Process)remoteProcess);
            remoteConsoleCommunication.connect();
            return new RemoteConsoleProcessData((PyRemoteProcessHandlerBase)processHandler, (PydevConsoleCommunication)remoteConsoleCommunication);
        }
        catch (Exception e) {
            throw (Throwable)new ExecutionException(e.getMessage(), (Throwable)e);
        }
    }

    @NotNull
    public CredentialsType<T> getCredentialsType() {
        return this.credentialsType;
    }

    public PythonConsoleSshProcessCreatorBase(@NotNull CredentialsType<T> credentialsType) {
        Intrinsics.checkParameterIsNotNull(credentialsType, (String)"credentialsType");
        this.credentialsType = credentialsType;
        Logger logger = Logger.getInstance(this.getClass());
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"Logger.getInstance(javaClass)");
        this.LOG = logger;
    }
}

