/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.remote.packaging;

import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkAdditionalData;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.remote.RemoteFile;
import com.intellij.remote.RemoteSdkAdditionalData;
import com.intellij.remote.RemoteSdkCredentials;
import com.intellij.remote.VagrantNotStartedException;
import com.intellij.remote.ext.CaseCollector;
import com.intellij.ssh.interaction.ConnectionOwner;
import com.intellij.ssh.interaction.ConnectionOwnerFactory;
import com.intellij.util.ArrayUtilRt;
import com.jetbrains.plugins.remotesdk.RemoteSdkUtil;
import com.jetbrains.python.packaging.PyExecutionException;
import com.jetbrains.python.packaging.PyExecutionFix;
import com.jetbrains.python.packaging.PyPackageManagerImpl;
import com.jetbrains.python.remote.PyRemoteInterpreterManagerImpl;
import com.jetbrains.python.remote.PyRemotePathMapper;
import com.jetbrains.python.remote.PyRemoteProcessUtil;
import com.jetbrains.python.remote.PyRemoteSdkAdditionalDataBase;
import com.jetbrains.python.remote.PyRemoteSdkCredentials;
import com.jetbrains.python.remote.PythonRemoteInterpreterManager;
import com.jetbrains.python.sdk.PythonSdkType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyRemotePackageManagerImpl
extends PyPackageManagerImpl {
    private static final Logger LOG = Logger.getInstance(PyRemotePackageManagerImpl.class);

    PyRemotePackageManagerImpl(@NotNull Sdk sdk) {
        if (sdk == null) {
            PyRemotePackageManagerImpl.$$$reportNull$$$0(0);
        }
        super(sdk);
    }

    @Nullable
    protected String getHelperPath(@NotNull String helper) throws ExecutionException {
        Sdk sdk;
        SdkAdditionalData sdkData;
        if (helper == null) {
            PyRemotePackageManagerImpl.$$$reportNull$$$0(1);
        }
        if ((sdkData = (sdk = this.getSdk()).getSdkAdditionalData()) instanceof PyRemoteSdkAdditionalDataBase) {
            PyRemoteSdkAdditionalDataBase remoteSdkData = (PyRemoteSdkAdditionalDataBase)sdkData;
            try {
                String helpersPath;
                if (CaseCollector.useRemoteCredentials((RemoteSdkAdditionalData)remoteSdkData)) {
                    RemoteSdkCredentials remoteSdkCredentials = remoteSdkData.getRemoteSdkCredentials(false);
                    helpersPath = remoteSdkCredentials.getHelpersPath();
                } else {
                    helpersPath = remoteSdkData.getHelpersPath();
                }
                if (!StringUtil.isEmpty((String)helpersPath)) {
                    return new RemoteFile(helpersPath, helper).getPath();
                }
                return null;
            }
            catch (InterruptedException e) {
                LOG.error((Throwable)e);
            }
            catch (ExecutionException e) {
                throw PyRemotePackageManagerImpl.analyzeException(e, helper, Collections.emptyList());
            }
        }
        return null;
    }

    @NotNull
    protected ProcessOutput getPythonProcessOutput(@NotNull String helperPath, @NotNull List<String> args, boolean askForSudo, boolean showProgress, @Nullable String workingDir) throws ExecutionException {
        Sdk sdk;
        String homePath;
        if (helperPath == null) {
            PyRemotePackageManagerImpl.$$$reportNull$$$0(2);
        }
        if (args == null) {
            PyRemotePackageManagerImpl.$$$reportNull$$$0(3);
        }
        if ((homePath = (sdk = this.getSdk()).getHomePath()) == null) {
            throw new ExecutionException("Cannot find Python interpreter for SDK " + sdk.getName());
        }
        SdkAdditionalData sdkData = sdk.getSdkAdditionalData();
        if (sdkData instanceof PyRemoteSdkAdditionalDataBase) {
            ProcessOutput processOutput;
            RemoteSdkCredentials remoteSdkCredentials;
            try {
                remoteSdkCredentials = ((RemoteSdkAdditionalData)sdkData).getRemoteSdkCredentials(false);
            }
            catch (InterruptedException e) {
                LOG.error((Throwable)e);
                remoteSdkCredentials = null;
            }
            catch (ExecutionException e) {
                throw PyRemotePackageManagerImpl.analyzeException(e, helperPath, args);
            }
            if (remoteSdkCredentials != null) {
                if (askForSudo) {
                    askForSudo = !PyRemotePackageManagerImpl.ensureCanWrite(remoteSdkCredentials);
                }
            } else {
                throw new PyExecutionException("Remote interpreter can't be executed. Please enable the Remote Hosts Access plugin.", helperPath, args);
            }
            ArrayList<String> cmdline = new ArrayList<String>();
            cmdline.add(homePath);
            cmdline.add(RemoteFile.detectSystemByPath((String)homePath).createRemoteFile(helperPath).getPath());
            cmdline.addAll(Collections2.transform(args, input -> PyRemotePackageManagerImpl.quoteIfNeeded(input)));
            do {
                PyRemoteSdkAdditionalDataBase remoteSdkAdditionalData = (PyRemoteSdkAdditionalDataBase)sdkData;
                PyRemotePathMapper pathMapper = PyRemotePackageManagerImpl.setupPathMappings(remoteSdkAdditionalData, null);
                try {
                    processOutput = PyRemotePackageManagerImpl.getSshProcessOutput(cmdline, workingDir, remoteSdkAdditionalData, pathMapper, askForSudo, helperPath);
                }
                catch (InterruptedException e) {
                    throw new ExecutionException((Throwable)e);
                }
            } while (askForSudo && processOutput.getStderr().contains("sudo: 3 incorrect password attempts"));
            ProcessOutput processOutput2 = processOutput;
            if (processOutput2 == null) {
                PyRemotePackageManagerImpl.$$$reportNull$$$0(4);
            }
            return processOutput2;
        }
        throw new PyExecutionException("Invalid remote SDK", helperPath, args);
    }

    private static boolean ensureCanWrite(@NotNull RemoteSdkCredentials remoteSdkCredentials) {
        if (remoteSdkCredentials == null) {
            PyRemotePackageManagerImpl.$$$reportNull$$$0(5);
        }
        ConnectionOwner connectionOwner = ConnectionOwnerFactory.createConnectionOwnerWithDialogMessages(null);
        return RemoteSdkUtil.ensureCanWriteFile((ConnectionOwner)connectionOwner, (RemoteSdkCredentials)remoteSdkCredentials, (String)remoteSdkCredentials.getInterpreterPath());
    }

    @NotNull
    private static ProcessOutput getSshProcessOutput(@NotNull List<String> cmdline, @Nullable String workingDir, @NotNull PyRemoteSdkAdditionalDataBase sdkAdditionalData, @NotNull PyRemotePathMapper pathMapper, boolean askForSudo, @NotNull String helperPath) throws ExecutionException, InterruptedException {
        if (cmdline == null) {
            PyRemotePackageManagerImpl.$$$reportNull$$$0(6);
        }
        if (sdkAdditionalData == null) {
            PyRemotePackageManagerImpl.$$$reportNull$$$0(7);
        }
        if (pathMapper == null) {
            PyRemotePackageManagerImpl.$$$reportNull$$$0(8);
        }
        if (helperPath == null) {
            PyRemotePackageManagerImpl.$$$reportNull$$$0(9);
        }
        String[] command = ArrayUtilRt.toStringArray(cmdline);
        PyRemotePathMapper mapper = PyRemotePackageManagerImpl.setupPathMappings(sdkAdditionalData, pathMapper);
        PyRemoteSdkCredentials cred = (PyRemoteSdkCredentials)sdkAdditionalData.getRemoteSdkCredentials(true);
        ProcessOutput processOutput = PyRemoteProcessUtil.getProcessOutput(null, (RemoteSdkCredentials)cred, mapper, command, workingDir, askForSudo, Sets.newHashSet((Object[])new String[]{mapper.convertToLocal(helperPath)}));
        if (processOutput == null) {
            PyRemotePackageManagerImpl.$$$reportNull$$$0(10);
        }
        return processOutput;
    }

    @NotNull
    private static PyRemotePathMapper setupPathMappings(@NotNull PyRemoteSdkAdditionalDataBase sdkAdditionalData, @Nullable PyRemotePathMapper pathMapper) {
        if (sdkAdditionalData == null) {
            PyRemotePackageManagerImpl.$$$reportNull$$$0(11);
        }
        PyRemotePathMapper pyRemotePathMapper = PyRemoteInterpreterManagerImpl.appendBasicMappings(null, pathMapper, (RemoteSdkAdditionalData)sdkAdditionalData);
        if (pyRemotePathMapper == null) {
            PyRemotePackageManagerImpl.$$$reportNull$$$0(12);
        }
        return pyRemotePathMapper;
    }

    private static ExecutionException analyzeException(ExecutionException exception, String command, List<String> args) {
        Throwable cause = exception.getCause();
        if (cause instanceof VagrantNotStartedException) {
            return new PyExecutionException("Vagrant instance is down", command, args, "", "", 0, (List)ImmutableList.of((Object)new LaunchVagrantFix(((VagrantNotStartedException)cause).getVagrantFolder(), ((VagrantNotStartedException)cause).getMachineName())));
        }
        return exception;
    }

    protected void subscribeToLocalChanges() {
    }

    protected void installManagement(@NotNull String name) throws ExecutionException {
        if (name == null) {
            PyRemotePackageManagerImpl.$$$reportNull$$$0(13);
        }
        super.installManagement(name);
    }

    private static String quoteIfNeeded(String arg) {
        return arg.replace("<", "\\<").replace(">", "\\>");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 10: 
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 10: 
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdk";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "helper";
                break;
            }
            case 2: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "helperPath";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "args";
                break;
            }
            case 4: 
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/remote/packaging/PyRemotePackageManagerImpl";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "remoteSdkCredentials";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cmdline";
                break;
            }
            case 7: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdkAdditionalData";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pathMapper";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/remote/packaging/PyRemotePackageManagerImpl";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getPythonProcessOutput";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getSshProcessOutput";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "setupPathMappings";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getHelperPath";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getPythonProcessOutput";
                break;
            }
            case 4: 
            case 10: 
            case 12: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "ensureCanWrite";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getSshProcessOutput";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "setupPathMappings";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "installManagement";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 10: 
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class LaunchVagrantFix
    implements PyExecutionFix {
        @NotNull
        private final String myVagrantFolder;
        @Nullable
        private final String myMachineName;

        LaunchVagrantFix(@NotNull String vagrantFolder, @Nullable String machineName) {
            if (vagrantFolder == null) {
                LaunchVagrantFix.$$$reportNull$$$0(0);
            }
            this.myVagrantFolder = vagrantFolder;
            this.myMachineName = machineName;
        }

        @NotNull
        public String getName() {
            if ("Launch Vagrant" == null) {
                LaunchVagrantFix.$$$reportNull$$$0(1);
            }
            return "Launch Vagrant";
        }

        public void run(@NotNull Sdk sdk) {
            PythonRemoteInterpreterManager manager;
            if (sdk == null) {
                LaunchVagrantFix.$$$reportNull$$$0(2);
            }
            if ((manager = PythonRemoteInterpreterManager.getInstance()) != null) {
                try {
                    manager.runVagrant(this.myVagrantFolder, this.myMachineName);
                    PythonSdkType.getInstance().setupSdkPaths(sdk);
                }
                catch (ExecutionException e) {
                    throw new RuntimeException(e);
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "vagrantFolder";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/python/remote/packaging/PyRemotePackageManagerImpl$LaunchVagrantFix";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sdk";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/python/remote/packaging/PyRemotePackageManagerImpl$LaunchVagrantFix";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "run";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

