/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.plugins.watcher.model;

import com.intellij.execution.configuration.EnvironmentVariablesData;
import com.intellij.ide.scratch.ScratchUtil;
import com.intellij.ide.util.scopeChooser.ScopeChooserUtils;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.UnknownFileType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.plugins.watcher.config.BackgroundTaskConsumer;
import com.intellij.plugins.watcher.config.FileTypeBackgroundTaskConsumer;
import com.intellij.plugins.watcher.problems.FwOutputSettings;
import com.intellij.plugins.watcher.util.TaskUtils;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.tools.FilterInfo;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TaskOptions {
    private String name;
    private String description;
    private String myProgram;
    private String myArguments;
    private String myWorkingDir;
    private boolean myCheckSyntaxErrors = true;
    private boolean myImmediateSync = true;
    private boolean myRunOnExternalChanges = true;
    private boolean myTrackOnlyRoot = true;
    private boolean myOutputFromStdout;
    private String myScopeName;
    private String myFileExtension;
    private String myOutput;
    private ExitCodeBehavior myExitCodeBehavior = ExitCodeBehavior.ERROR;
    private EnvironmentVariablesData myEnvData = EnvironmentVariablesData.DEFAULT;
    private FilterInfo[] myOutputFilters = new FilterInfo[0];

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getProgram() {
        return this.myProgram;
    }

    public void setProgram(String program) {
        this.myProgram = FileUtil.toSystemIndependentName((String)StringUtil.notNullize((String)program));
    }

    public void setArguments(String arguments) {
        this.myArguments = arguments;
    }

    public String getArguments() {
        return this.myArguments;
    }

    public void setWorkingDir(String workingDir) {
        this.myWorkingDir = workingDir == null ? null : FileUtil.toSystemIndependentName((String)workingDir);
    }

    public String getWorkingDir() {
        return this.myWorkingDir;
    }

    public void setTrackOnlyRoot(boolean trackOnlyRoot) {
        this.myTrackOnlyRoot = trackOnlyRoot;
    }

    public boolean isTrackOnlyRoot() {
        return this.myTrackOnlyRoot;
    }

    public void setScopeName(String scopeName) {
        this.myScopeName = scopeName;
    }

    public String getScopeName() {
        return this.myScopeName;
    }

    public void setFileExtension(String fileMask) {
        this.myFileExtension = fileMask;
    }

    @Nullable
    public String getFileExtension() {
        return this.myFileExtension;
    }

    public void setOutput(String output) {
        this.myOutput = output;
    }

    public String getOutput() {
        return this.myOutput;
    }

    public boolean isOutputFromStdout() {
        return this.myOutputFromStdout;
    }

    public void setOutputFromStdout(boolean outputFromStdout) {
        this.myOutputFromStdout = outputFromStdout;
    }

    public void setEnvData(@NotNull EnvironmentVariablesData envData) {
        if (envData == null) {
            TaskOptions.$$$reportNull$$$0(0);
        }
        this.myEnvData = envData;
    }

    @NotNull
    public EnvironmentVariablesData getEnvData() {
        EnvironmentVariablesData environmentVariablesData = this.myEnvData;
        if (environmentVariablesData == null) {
            TaskOptions.$$$reportNull$$$0(1);
        }
        return environmentVariablesData;
    }

    public FilterInfo[] getOutputFilters() {
        return this.myOutputFilters;
    }

    public void setOutputFilters(FilterInfo[] outputFilters) {
        this.myOutputFilters = outputFilters;
    }

    @NotNull
    public ExitCodeBehavior getExitCodeBehavior() {
        ExitCodeBehavior exitCodeBehavior = this.myExitCodeBehavior;
        if (exitCodeBehavior == null) {
            TaskOptions.$$$reportNull$$$0(2);
        }
        return exitCodeBehavior;
    }

    public void setExitCodeBehavior(@NotNull ExitCodeBehavior exitCodeBehavior) {
        if (exitCodeBehavior == null) {
            TaskOptions.$$$reportNull$$$0(3);
        }
        this.myExitCodeBehavior = exitCodeBehavior;
    }

    public boolean isCheckSyntaxErrors() {
        return this.myCheckSyntaxErrors;
    }

    public void setCheckSyntaxErrors(boolean checkSyntaxErrors) {
        this.myCheckSyntaxErrors = checkSyntaxErrors;
    }

    public boolean isImmediateSync() {
        return this.myImmediateSync;
    }

    public void setImmediateSync(boolean immediateSync) {
        this.myImmediateSync = immediateSync;
    }

    public boolean isRunOnExternalChanges() {
        return this.myRunOnExternalChanges;
    }

    public void setRunOnExternalChanges(boolean runOnExternalChanges) {
        this.myRunOnExternalChanges = runOnExternalChanges;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TaskOptions options = (TaskOptions)o;
        if (this.myOutputFromStdout != options.myOutputFromStdout) {
            return false;
        }
        if (this.myTrackOnlyRoot != options.myTrackOnlyRoot) {
            return false;
        }
        if (this.myCheckSyntaxErrors != options.myCheckSyntaxErrors) {
            return false;
        }
        if (this.myImmediateSync != options.myImmediateSync) {
            return false;
        }
        if (this.myRunOnExternalChanges != options.myRunOnExternalChanges) {
            return false;
        }
        if (!Comparing.equal((String)this.description, (String)options.description)) {
            return false;
        }
        if (!Comparing.equal((String)this.myArguments, (String)options.myArguments)) {
            return false;
        }
        if (!this.myEnvData.equals((Object)options.myEnvData)) {
            return false;
        }
        if (this.myExitCodeBehavior != options.myExitCodeBehavior) {
            return false;
        }
        if (!Comparing.equal((String)this.myFileExtension, (String)options.myFileExtension)) {
            return false;
        }
        if (!Comparing.equal((String)this.myOutput, (String)options.myOutput)) {
            return false;
        }
        if (!Arrays.equals(this.myOutputFilters, options.myOutputFilters)) {
            return false;
        }
        if (!Comparing.equal((String)this.myProgram, (String)options.myProgram)) {
            return false;
        }
        if (!Comparing.equal((String)this.myScopeName, (String)options.myScopeName)) {
            return false;
        }
        if (!Comparing.equal((String)this.myWorkingDir, (String)options.myWorkingDir)) {
            return false;
        }
        return Comparing.equal((String)this.name, (String)options.name);
    }

    public int hashCode() {
        int result = this.name != null ? this.name.hashCode() : 0;
        result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
        result = 31 * result + (this.myProgram != null ? this.myProgram.hashCode() : 0);
        result = 31 * result + (this.myArguments != null ? this.myArguments.hashCode() : 0);
        result = 31 * result + (this.myWorkingDir != null ? this.myWorkingDir.hashCode() : 0);
        result = 31 * result + (this.myCheckSyntaxErrors ? 1 : 0);
        result = 31 * result + (this.myImmediateSync ? 1 : 0);
        result = 31 * result + (this.myRunOnExternalChanges ? 1 : 0);
        result = 31 * result + (this.myTrackOnlyRoot ? 1 : 0);
        result = 31 * result + (this.myOutputFromStdout ? 1 : 0);
        result = 31 * result + (this.myScopeName != null ? this.myScopeName.hashCode() : 0);
        result = 31 * result + (this.myFileExtension != null ? this.myFileExtension.hashCode() : 0);
        result = 31 * result + (this.myOutput != null ? this.myOutput.hashCode() : 0);
        result = 31 * result + (this.myExitCodeBehavior != null ? this.myExitCodeBehavior.hashCode() : 0);
        result = 31 * result + this.myEnvData.hashCode();
        result = 31 * result + (this.myOutputFilters != null ? Arrays.hashCode(this.myOutputFilters) : 0);
        return result;
    }

    public TaskOptions createCopy() {
        TaskOptions result = new TaskOptions();
        result.setName(this.name);
        result.setDescription(this.description);
        result.setProgram(this.myProgram);
        result.setArguments(this.myArguments);
        result.setWorkingDir(this.myWorkingDir);
        result.setCheckSyntaxErrors(this.myCheckSyntaxErrors);
        result.setImmediateSync(this.myImmediateSync);
        result.setRunOnExternalChanges(this.myRunOnExternalChanges);
        result.setTrackOnlyRoot(this.myTrackOnlyRoot);
        result.setOutputFromStdout(this.myOutputFromStdout);
        result.setScopeName(this.myScopeName);
        result.setFileExtension(this.myFileExtension);
        result.setOutput(this.myOutput);
        result.setExitCodeBehavior(this.myExitCodeBehavior);
        result.setEnvData(this.myEnvData);
        FilterInfo[] filterInfos = new FilterInfo[this.myOutputFilters.length];
        for (int i = 0; i < this.myOutputFilters.length; ++i) {
            filterInfos[i] = this.myOutputFilters[i].createCopy();
        }
        result.setOutputFilters(filterInfos);
        return result;
    }

    public String toString() {
        return "TaskOptions{name='" + this.name + '\'' + ", description='" + this.description + '\'' + ", myProgram='" + this.myProgram + '\'' + ", myArguments='" + this.myArguments + '\'' + ", myWorkingDir='" + this.myWorkingDir + '\'' + ", myCheckSyntaxErrors=" + this.myCheckSyntaxErrors + ", myImmediateSync=" + this.myImmediateSync + ", myRunOnExternalChanges=" + this.myRunOnExternalChanges + ", myTrackOnlyRoot=" + this.myTrackOnlyRoot + ", myOutputFromStdout=" + this.myOutputFromStdout + ", myScopeName='" + this.myScopeName + '\'' + ", myFileExtension='" + this.myFileExtension + '\'' + ", myOutput='" + this.myOutput + '\'' + ", myExitCodeBehavior=" + (Object)((Object)this.myExitCodeBehavior) + '}';
    }

    @NotNull
    public GlobalSearchScope getFileScope(@NotNull Project project) {
        if (project == null) {
            TaskOptions.$$$reportNull$$$0(4);
        }
        GlobalSearchScope scope = ScopeChooserUtils.findScopeByName((Project)project, (String)this.myScopeName);
        GlobalSearchScope globalSearchScope = scope.intersectWith((GlobalSearchScope)new FileTypeScope());
        if (globalSearchScope == null) {
            TaskOptions.$$$reportNull$$$0(5);
        }
        return globalSearchScope;
    }

    @NotNull
    public FileType getFileType() {
        FileType fileType;
        if (StringUtil.isEmpty((String)this.myFileExtension)) {
            FileType fileType2 = UnknownFileType.INSTANCE;
            if (fileType2 == null) {
                TaskOptions.$$$reportNull$$$0(6);
            }
            return fileType2;
        }
        if (TaskUtils.FAKE_ANY_FILE_TYPE.getDefaultExtension().equalsIgnoreCase(this.myFileExtension)) {
            FileType fileType3 = TaskUtils.FAKE_ANY_FILE_TYPE;
            if (fileType3 == null) {
                TaskOptions.$$$reportNull$$$0(7);
            }
            return fileType3;
        }
        String extension = this.myFileExtension;
        int index = extension.indexOf(59);
        if (index > 0) {
            extension = extension.substring(0, index);
        }
        if ((fileType = FileTypeManager.getInstance().getFileTypeByExtension(extension)) == UnknownFileType.INSTANCE) {
            fileType = FileTypeManager.getInstance().getFileTypeByFileName("foo." + extension);
        }
        if (fileType == UnknownFileType.INSTANCE) {
            FileType typeByName = (FileType)ContainerUtil.find((Object[])FileTypeManager.getInstance().getRegisteredFileTypes(), type -> this.myFileExtension.equalsIgnoreCase(type.getName()));
            FileType fileType4 = typeByName == null ? UnknownFileType.INSTANCE : typeByName;
            if (fileType4 == null) {
                TaskOptions.$$$reportNull$$$0(8);
            }
            return fileType4;
        }
        FileType fileType5 = fileType;
        if (fileType5 == null) {
            TaskOptions.$$$reportNull$$$0(9);
        }
        return fileType5;
    }

    @NotNull
    public FwOutputSettings getOutputSettings() {
        FileType fileType = this.getFileType();
        FileTypeBackgroundTaskConsumer taskConsumer = BackgroundTaskConsumer.findConsumerByFileType(fileType);
        FwOutputSettings outputSettings = null;
        if (taskConsumer != null) {
            outputSettings = taskConsumer.getOutputSettings();
        }
        FwOutputSettings fwOutputSettings = (FwOutputSettings)ObjectUtils.notNull((Object)outputSettings, (Object)FwOutputSettings.DEFAULT);
        if (fwOutputSettings == null) {
            TaskOptions.$$$reportNull$$$0(10);
        }
        return fwOutputSettings;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "envData";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/plugins/watcher/model/TaskOptions";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exitCodeBehavior";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/plugins/watcher/model/TaskOptions";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getEnvData";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getExitCodeBehavior";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileScope";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileType";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getOutputSettings";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "setEnvData";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setExitCodeBehavior";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getFileScope";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class FileTypeScope
    extends GlobalSearchScope {
        private FileTypeScope() {
        }

        public boolean contains(@NotNull VirtualFile file) {
            FileType fileType;
            if (file == null) {
                FileTypeScope.$$$reportNull$$$0(0);
            }
            if ((fileType = TaskOptions.this.getFileType()) == TaskUtils.FAKE_ANY_FILE_TYPE) {
                return true;
            }
            if (fileType == UnknownFileType.INSTANCE) {
                return false;
            }
            if (file.getFileType() == fileType) {
                return true;
            }
            if (ScratchUtil.isScratch((VirtualFile)file)) {
                String extension = file.getExtension();
                return extension != null && FileTypeManager.getInstance().getFileTypeByExtension(extension) == fileType;
            }
            return false;
        }

        public boolean isSearchInModuleContent(@NotNull Module aModule) {
            if (aModule == null) {
                FileTypeScope.$$$reportNull$$$0(1);
            }
            return true;
        }

        public boolean isSearchInLibraries() {
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "aModule";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/plugins/watcher/model/TaskOptions$FileTypeScope";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "contains";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isSearchInModuleContent";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static enum ExitCodeBehavior {
        ALWAYS("Always"),
        ERROR("On error"),
        NEVER("Never");

        private final String myDisplayName;

        private ExitCodeBehavior(String name) {
            this.myDisplayName = name;
        }

        public String getDisplayName() {
            return this.myDisplayName;
        }
    }
}

