/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.performancePlugin.commands;

import com.intellij.openapi.ui.playback.PlaybackContext;
import com.intellij.openapi.ui.playback.commands.AbstractCommand;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.text.StringUtil;
import com.jetbrains.performancePlugin.MessagesBundle;
import com.jetbrains.performancePlugin.commands.Waiter;
import com.jetbrains.performancePlugin.profilers.AsyncProfilerHandler;
import com.jetbrains.performancePlugin.profilers.ProfilersController;
import com.jetbrains.performancePlugin.profilers.YourKitProfilerHandler;
import com.jetbrains.performancePlugin.utils.ActionCallbackProfilerStopper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

public class StartProfileCommand
extends AbstractCommand {
    public static final String PREFIX = "%startProfile";

    public StartProfileCommand(@NotNull String text, int line) {
        if (text == null) {
            StartProfileCommand.$$$reportNull$$$0(0);
        }
        super(text, line);
    }

    private static void startYKProfiling(String activityName, @NotNull List<String> commandParameters) throws RuntimeException {
        if (commandParameters == null) {
            StartProfileCommand.$$$reportNull$$$0(1);
        }
        YourKitProfilerHandler.getInstance().startProfiling(activityName, commandParameters);
    }

    private static void startAsyncProfiling(String activityName, @NotNull List<String> commandParameters) throws RuntimeException {
        if (commandParameters == null) {
            StartProfileCommand.$$$reportNull$$$0(2);
        }
        AsyncProfilerHandler.getInstance().startProfiling(activityName, commandParameters);
    }

    @NotNull
    protected Promise<Object> _execute(@NotNull PlaybackContext context) {
        if (context == null) {
            StartProfileCommand.$$$reportNull$$$0(3);
        }
        ActionCallbackProfilerStopper myActionCallback = new ActionCallbackProfilerStopper();
        String[] executedCommand = this.getText().substring(PREFIX.length()).trim().split("\\s+", 2);
        String myActivityName = executedCommand[0];
        if (StringUtil.isEmpty((String)myActivityName)) {
            myActionCallback.reject(MessagesBundle.message("command.start.error", new Object[0]));
        } else {
            try {
                if (ProfilersController.getInstance().getCurrentProfilerHandler() instanceof AsyncProfilerHandler) {
                    ArrayList<String> parameters = executedCommand.length > 1 ? Arrays.asList(executedCommand[1].trim().split(",")) : new ArrayList<String>();
                    StartProfileCommand.startAsyncProfiling(myActivityName, parameters);
                    Waiter.checkCondition(() -> AsyncProfilerHandler.getInstance().isProfilingStarted()).await();
                } else {
                    StartProfileCommand.startYKProfiling(myActivityName, new ArrayList<String>());
                    Waiter.checkCondition(() -> YourKitProfilerHandler.isCPUProfiling()).await();
                }
                myActionCallback.setDone();
            }
            catch (Throwable e) {
                myActionCallback.reject(e.getMessage());
            }
        }
        Promise promise = Promises.toPromise((ActionCallback)myActionCallback);
        if (promise == null) {
            StartProfileCommand.$$$reportNull$$$0(4);
        }
        return promise;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commandParameters";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/performancePlugin/commands/StartProfileCommand";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/performancePlugin/commands/StartProfileCommand";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "_execute";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "startYKProfiling";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "startAsyncProfiling";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "_execute";
                break;
            }
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

