/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.css.rearranger;

import com.intellij.lang.css.rearranger.CssArrangementEntry;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.codeStyle.arrangement.ArrangementEntry;
import com.intellij.psi.css.CssBlock;
import com.intellij.psi.css.CssDeclaration;
import com.intellij.psi.css.CssMedia;
import com.intellij.psi.css.CssRuleset;
import com.intellij.psi.css.CssRulesetList;
import com.intellij.psi.css.CssStylesheet;
import com.intellij.psi.css.impl.CssElementTypes;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Stack;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class CssArrangementVisitor {
    private final Collection<TextRange> myRanges;
    private final List<CssArrangementEntry> myTopLevelEntries;
    @NotNull
    private final Stack<CssArrangementEntry> myStack;
    private final boolean mySortByName;

    CssArrangementVisitor(@NotNull Collection<TextRange> ranges, boolean sortByName) {
        if (ranges == null) {
            CssArrangementVisitor.$$$reportNull$$$0(0);
        }
        this.myTopLevelEntries = new SmartList();
        this.myStack = new Stack();
        this.myRanges = ranges;
        this.mySortByName = sortByName;
    }

    public void visitCssStylesheet(@NotNull CssStylesheet stylesheet) {
        if (stylesheet == null) {
            CssArrangementVisitor.$$$reportNull$$$0(1);
        }
        this.visitCssRulesetList(stylesheet.getRulesetList());
    }

    public void visitCssRulesetList(CssRulesetList rulesetList) {
        for (PsiElement child = rulesetList.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (child instanceof CssRuleset) {
                this.visitCssRuleset((CssRuleset)child);
                continue;
            }
            if (!(child instanceof CssMedia)) continue;
            this.visitCssMedia((CssMedia)child);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void visitCssRuleset(@NotNull CssRuleset ruleset) {
        if (ruleset == null) {
            CssArrangementVisitor.$$$reportNull$$$0(2);
        }
        if (!CssArrangementVisitor.isWithinBounds(ruleset.getTextRange(), this.myRanges)) {
            return;
        }
        PsiElement firstChild = ruleset.getFirstChild();
        String name = firstChild instanceof CssDeclaration ? ((CssDeclaration)firstChild).getName() : null;
        CssArrangementEntry entry = this.createNewEntry(ruleset.getTextRange(), name);
        this.myStack.push((Object)entry);
        try {
            CssBlock block = ruleset.getBlock();
            if (block != null) {
                this.visitCssBlock(block);
            }
        }
        finally {
            this.myStack.pop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void visitCssMedia(CssMedia media) {
        if (!CssArrangementVisitor.isWithinBounds(media.getTextRange(), this.myRanges)) {
            return;
        }
        CssArrangementEntry entry = this.createNewEntry(media.getTextRange(), null);
        this.myStack.push((Object)entry);
        try {
            for (PsiElement child = media.getFirstChild(); child != null; child = child.getNextSibling()) {
                if (child instanceof CssRuleset) {
                    this.visitCssRuleset((CssRuleset)child);
                    continue;
                }
                if (!(child instanceof CssBlock)) continue;
                this.visitCssBlock((CssBlock)child);
            }
        }
        finally {
            this.myStack.pop();
        }
    }

    public void visitCssBlock(@NotNull CssBlock block) {
        if (block == null) {
            CssArrangementVisitor.$$$reportNull$$$0(3);
        }
        for (PsiElement child = block.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (child instanceof CssRuleset) {
                this.visitCssRuleset((CssRuleset)child);
                continue;
            }
            if (child instanceof CssMedia) {
                this.visitCssMedia((CssMedia)child);
                continue;
            }
            if (!(child instanceof CssDeclaration)) continue;
            this.visitCssDeclaration((CssDeclaration)child);
        }
    }

    public void visitCssDeclaration(@NotNull CssDeclaration declaration) {
        if (declaration == null) {
            CssArrangementVisitor.$$$reportNull$$$0(4);
        }
        this.createNewEntry(CssArrangementVisitor.getTextRangeForRearrangement((PsiElement)declaration), declaration.getPropertyName());
    }

    private static TextRange getTextRangeForRearrangement(@NotNull PsiElement psiElement) {
        if (psiElement == null) {
            CssArrangementVisitor.$$$reportNull$$$0(5);
        }
        int start = psiElement.getTextRange().getStartOffset();
        int end = psiElement.getTextRange().getEndOffset();
        PsiElement next = psiElement;
        while ((next = next.getNextSibling()) != null) {
            if (next instanceof PsiComment || next instanceof LeafPsiElement && ((LeafPsiElement)next).getElementType() == CssElementTypes.CSS_SEMICOLON) {
                end = next.getTextRange().getEndOffset();
                continue;
            }
            if (next instanceof PsiWhiteSpace && !next.getText().contains("\n")) continue;
        }
        return TextRange.create((int)start, (int)end);
    }

    @NotNull
    private CssArrangementEntry createNewEntry(@NotNull TextRange range, @Nullable String propertyName) {
        if (range == null) {
            CssArrangementVisitor.$$$reportNull$$$0(6);
        }
        CssArrangementEntry currentEntry = this.getCurrent();
        CssArrangementEntry entry = new CssArrangementEntry(propertyName, (ArrangementEntry)currentEntry, range, this.mySortByName);
        if (currentEntry == null) {
            this.myTopLevelEntries.add(entry);
        } else {
            currentEntry.addChild((ArrangementEntry)entry);
        }
        CssArrangementEntry cssArrangementEntry = entry;
        if (cssArrangementEntry == null) {
            CssArrangementVisitor.$$$reportNull$$$0(7);
        }
        return cssArrangementEntry;
    }

    @Nullable
    private CssArrangementEntry getCurrent() {
        return this.myStack.isEmpty() ? null : (CssArrangementEntry)((Object)this.myStack.peek());
    }

    List<CssArrangementEntry> getTopLevelEntries() {
        return this.myTopLevelEntries;
    }

    private static boolean isWithinBounds(@NotNull TextRange range, @NotNull Collection<TextRange> ranges) {
        if (range == null) {
            CssArrangementVisitor.$$$reportNull$$$0(8);
        }
        if (ranges == null) {
            CssArrangementVisitor.$$$reportNull$$$0(9);
        }
        return ContainerUtil.or(ranges, r -> r.intersects(range));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ranges";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stylesheet";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ruleset";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "block";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "declaration";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/css/rearranger/CssArrangementVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/css/rearranger/CssArrangementVisitor";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createNewEntry";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "visitCssStylesheet";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "visitCssRuleset";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "visitCssBlock";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "visitCssDeclaration";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getTextRangeForRearrangement";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createNewEntry";
                break;
            }
            case 7: {
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isWithinBounds";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

