/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs;

import com.intellij.openapi.vfs.SafeWriteRequestor;
import com.intellij.util.io.PathKt;
import com.intellij.util.io.SafeFileOutputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=2, d1={"\u0000\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\u001a\u0014\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u00a8\u0006\u0005"}, d2={"safeOutputStream", "Ljava/io/OutputStream;", "Ljava/nio/file/Path;", "requestor", "", "intellij.platform.ide"})
@JvmName(name="SafeWriteUtil")
public final class SafeWriteUtil {
    @NotNull
    public static final OutputStream safeOutputStream(@NotNull Path $this$safeOutputStream, @Nullable Object requestor) {
        OutputStream outputStream;
        Intrinsics.checkParameterIsNotNull((Object)$this$safeOutputStream, (String)"$this$safeOutputStream");
        Path path2 = $this$safeOutputStream.getParent();
        Intrinsics.checkExpressionValueIsNotNull((Object)path2, (String)"parent");
        PathKt.createDirectories((Path)path2);
        if (SafeWriteRequestor.shouldUseSafeWrite(requestor)) {
            outputStream = (OutputStream)new SafeFileOutputStream($this$safeOutputStream);
        } else {
            OutputStream outputStream2 = Files.newOutputStream($this$safeOutputStream, new OpenOption[0]);
            outputStream = outputStream2;
            Intrinsics.checkExpressionValueIsNotNull((Object)outputStream2, (String)"Files.newOutputStream(this)");
        }
        return outputStream;
    }
}

