/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.idea.lang.javascript.psiutil;

import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.psi.JSAssignmentExpression;
import com.intellij.lang.javascript.psi.JSBinaryExpression;
import com.intellij.lang.javascript.psi.JSBlockStatement;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSEmptyStatement;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSExpressionStatement;
import com.intellij.lang.javascript.psi.JSIfStatement;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.util.ControlFlowUtils;
import com.intellij.lang.javascript.psi.util.JSParenthesesUtils;
import com.intellij.lang.javascript.refactoring.util.JSRefactoringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.sixrr.inspectjs.utils.ComparisonUtils;
import com.sixrr.inspectjs.utils.EquivalenceChecker;
import org.intellij.idea.lang.javascript.psiutil.BoolUtils;
import org.jetbrains.annotations.NotNull;

public class ConditionalUtils {
    private ConditionalUtils() {
    }

    public static boolean isAssignment(JSStatement statement) {
        if (!(statement instanceof JSExpressionStatement)) {
            return false;
        }
        JSExpressionStatement expressionStatement = (JSExpressionStatement)statement;
        return expressionStatement.getExpression() instanceof JSAssignmentExpression;
    }

    public static boolean isSimplifiableImplicitReturn(JSIfStatement ifStatement, boolean negated) {
        JSStatement thenBranch = ControlFlowUtils.stripBraces((JSStatement)ifStatement.getThen());
        PsiElement nextStatement = PsiTreeUtil.skipWhitespacesForward((PsiElement)ifStatement);
        if (!(nextStatement instanceof JSStatement)) {
            return false;
        }
        JSStatement elseBranch = (JSStatement)nextStatement;
        if (negated) {
            return com.sixrr.inspectjs.utils.ConditionalUtils.returnsFalse((JSStatement)thenBranch) && com.sixrr.inspectjs.utils.ConditionalUtils.returnsTrue((JSStatement)elseBranch);
        }
        return com.sixrr.inspectjs.utils.ConditionalUtils.returnsTrue((JSStatement)thenBranch) && com.sixrr.inspectjs.utils.ConditionalUtils.returnsFalse((JSStatement)elseBranch);
    }

    public static boolean isSimplifiableReturn(JSIfStatement ifStatement, boolean negated) {
        JSStatement thenBranch = ControlFlowUtils.stripBraces((JSStatement)ifStatement.getThen());
        JSStatement elseBranch = ControlFlowUtils.stripBraces((JSStatement)ifStatement.getElse());
        if (negated) {
            return com.sixrr.inspectjs.utils.ConditionalUtils.returnsFalse((JSStatement)thenBranch) && com.sixrr.inspectjs.utils.ConditionalUtils.returnsTrue((JSStatement)elseBranch);
        }
        return com.sixrr.inspectjs.utils.ConditionalUtils.returnsTrue((JSStatement)thenBranch) && com.sixrr.inspectjs.utils.ConditionalUtils.returnsFalse((JSStatement)elseBranch);
    }

    public static boolean isSimplifiableAssignment(JSIfStatement ifStatement, boolean negated) {
        boolean isAssignment;
        JSStatement thenBranch = ControlFlowUtils.stripBraces((JSStatement)ifStatement.getThen());
        JSStatement elseBranch = ControlFlowUtils.stripBraces((JSStatement)ifStatement.getElse());
        if (negated) {
            isAssignment = com.sixrr.inspectjs.utils.ConditionalUtils.isAssignmentToFalse((JSStatement)thenBranch) && com.sixrr.inspectjs.utils.ConditionalUtils.isAssignmentToTrue((JSStatement)elseBranch);
        } else {
            boolean bl = isAssignment = com.sixrr.inspectjs.utils.ConditionalUtils.isAssignmentToTrue((JSStatement)thenBranch) && com.sixrr.inspectjs.utils.ConditionalUtils.isAssignmentToFalse((JSStatement)elseBranch);
        }
        if (isAssignment) {
            IElementType elseSign;
            JSAssignmentExpression thenExpression = (JSAssignmentExpression)((JSExpressionStatement)thenBranch).getExpression();
            JSAssignmentExpression elseExpression = (JSAssignmentExpression)((JSExpressionStatement)elseBranch).getExpression();
            IElementType thenSign = thenExpression.getOperationSign();
            if (!thenSign.equals(elseSign = elseExpression.getOperationSign())) {
                return false;
            }
            JSExpression thenLhs = thenExpression.getLOperand();
            JSExpression elseLhs = elseExpression.getLOperand();
            return EquivalenceChecker.expressionsAreEquivalent((JSExpression)thenLhs, (JSExpression)elseLhs);
        }
        return false;
    }

    public static boolean isSimplifiableImplicitAssignment(JSIfStatement ifStatement, boolean negated) {
        boolean isAssignment;
        if (ifStatement.getElse() != null) {
            return false;
        }
        JSStatement thenBranch = ControlFlowUtils.stripBraces((JSStatement)ifStatement.getThen());
        PsiElement nextStatement = PsiTreeUtil.skipWhitespacesBackward((PsiElement)ifStatement);
        if (!(nextStatement instanceof JSStatement)) {
            return false;
        }
        JSStatement elseBranch = ControlFlowUtils.stripBraces((JSStatement)((JSStatement)nextStatement));
        if (negated) {
            isAssignment = com.sixrr.inspectjs.utils.ConditionalUtils.isAssignmentToFalse((JSStatement)thenBranch) && com.sixrr.inspectjs.utils.ConditionalUtils.isAssignmentToTrue((JSStatement)elseBranch);
        } else {
            boolean bl = isAssignment = com.sixrr.inspectjs.utils.ConditionalUtils.isAssignmentToTrue((JSStatement)thenBranch) && com.sixrr.inspectjs.utils.ConditionalUtils.isAssignmentToFalse((JSStatement)elseBranch);
        }
        if (isAssignment) {
            IElementType elseSign;
            JSAssignmentExpression thenExpression = (JSAssignmentExpression)((JSExpressionStatement)thenBranch).getExpression();
            JSAssignmentExpression elseExpression = (JSAssignmentExpression)((JSExpressionStatement)elseBranch).getExpression();
            IElementType thenSign = thenExpression.getOperationSign();
            if (!thenSign.equals(elseSign = elseExpression.getOperationSign())) {
                return false;
            }
            JSExpression thenLhs = thenExpression.getLOperand();
            JSExpression elseLhs = elseExpression.getLOperand();
            return EquivalenceChecker.expressionsAreEquivalent((JSExpression)thenLhs, (JSExpression)elseLhs);
        }
        return false;
    }

    public static boolean isSimplifiableEmptyBranches(JSIfStatement ifStatement) {
        JSStatement thenBranch = ControlFlowUtils.stripBraces((JSStatement)ifStatement.getThen());
        JSStatement elseBranch = ControlFlowUtils.stripBraces((JSStatement)ifStatement.getElse());
        if (elseBranch == null) {
            return false;
        }
        return thenBranch instanceof JSEmptyStatement || thenBranch instanceof JSBlockStatement && ((JSBlockStatement)thenBranch).getStatementListItems().length == 0 || elseBranch instanceof JSEmptyStatement || elseBranch instanceof JSBlockStatement && ((JSBlockStatement)elseBranch).getStatementListItems().length == 0;
    }

    public static void replaceSimplifiableImplicitReturn(JSIfStatement statement, boolean negated) throws IncorrectOperationException {
        JSExpression condition = statement.getCondition();
        String conditionText = negated ? BoolUtils.getNegatedExpressionText(condition) : condition.getText();
        JSElement nextStatement = (JSElement)PsiTreeUtil.skipWhitespacesForward((PsiElement)statement);
        String newStatement = "return " + conditionText + ';';
        JSRefactoringUtil.replaceStatementAndReformat((JSStatement)statement, (String)newStatement);
        assert (nextStatement != null);
        JSRefactoringUtil.removeElementWithLinebreak((PsiElement)nextStatement);
    }

    public static void replaceSimplifiableReturn(JSIfStatement statement, boolean negated) {
        JSExpression condition = statement.getCondition();
        String conditionText = negated ? BoolUtils.getNegatedExpressionText(condition) : com.sixrr.inspectjs.utils.ConditionalUtils.castToBoolean((JSExpression)condition);
        String newStatement = "return " + conditionText + ';';
        JSRefactoringUtil.replaceStatementAndReformat((JSStatement)statement, (String)newStatement);
    }

    public static void replaceSimplifiableAssignment(JSIfStatement statement, boolean negated) throws IncorrectOperationException {
        JSExpression condition = statement.getCondition();
        String conditionText = negated ? BoolUtils.getNegatedExpressionText(condition) : condition.getText();
        JSExpressionStatement assignmentStatement = (JSExpressionStatement)ControlFlowUtils.stripBraces((JSStatement)statement.getThen());
        JSAssignmentExpression assignmentExpression = (JSAssignmentExpression)assignmentStatement.getExpression();
        ASTNode operator = assignmentExpression.getOperationNode();
        String operand = operator.getText();
        JSExpression lhs = assignmentExpression.getLOperand();
        String lhsText = lhs.getText();
        JSRefactoringUtil.replaceStatementAndReformat((JSStatement)statement, (String)(lhsText + operand + conditionText + ';'));
    }

    public static void replaceSimplifiableImplicitAssignment(JSIfStatement statement, boolean negated) throws IncorrectOperationException {
        JSElement prevStatement = (JSElement)PsiTreeUtil.skipWhitespacesBackward((PsiElement)statement);
        JSExpression condition = statement.getCondition();
        String conditionText = negated ? BoolUtils.getNegatedExpressionText(condition) : condition.getText();
        JSExpressionStatement assignmentStatement = (JSExpressionStatement)ControlFlowUtils.stripBraces((JSStatement)statement.getThen());
        JSAssignmentExpression assignmentExpression = (JSAssignmentExpression)assignmentStatement.getExpression();
        ASTNode operator = assignmentExpression.getOperationNode();
        String operand = operator.getText();
        JSExpression lhs = assignmentExpression.getLOperand();
        String lhsText = lhs.getText();
        JSRefactoringUtil.replaceStatementAndReformat((JSStatement)statement, (String)(lhsText + operand + conditionText + ';'));
        assert (prevStatement != null);
        JSRefactoringUtil.removeElementWithLinebreak((PsiElement)prevStatement);
    }

    private static void replaceSimplifiableEmptyBranch(JSIfStatement ifStatement) {
        String bodyText;
        String conditionText;
        JSStatement thenBranch = ControlFlowUtils.stripBraces((JSStatement)ifStatement.getThen());
        JSStatement elseBranch = ControlFlowUtils.stripBraces((JSStatement)ifStatement.getElse());
        assert (elseBranch != null) : "Condition worked unexpectedly for " + ifStatement.getText();
        if (thenBranch instanceof JSEmptyStatement || thenBranch instanceof JSBlockStatement && ((JSBlockStatement)thenBranch).getStatementListItems().length == 0) {
            conditionText = BoolUtils.getNegatedExpressionText(ifStatement.getCondition());
            bodyText = elseBranch.getText();
        } else if (elseBranch instanceof JSEmptyStatement || elseBranch instanceof JSBlockStatement && ((JSBlockStatement)elseBranch).getStatementListItems().length == 0) {
            conditionText = ifStatement.getCondition().getText();
            bodyText = thenBranch.getText();
        } else {
            assert (false) : "Condition worked unexpectedly for " + ifStatement.getText();
            return;
        }
        JSRefactoringUtil.replaceStatementAndReformat((JSStatement)ifStatement, (String)("if (" + conditionText + ") " + bodyText + ';'));
    }

    public static void replaceAssignmentOrReturnIfSimplifiable(JSIfStatement statement) throws IncorrectOperationException {
        if (ConditionalUtils.isSimplifiableAssignment(statement, false)) {
            ConditionalUtils.replaceSimplifiableAssignment(statement, false);
        } else if (ConditionalUtils.isSimplifiableAssignment(statement, true)) {
            ConditionalUtils.replaceSimplifiableAssignment(statement, true);
        } else if (ConditionalUtils.isSimplifiableReturn(statement, false)) {
            ConditionalUtils.replaceSimplifiableReturn(statement, false);
        } else if (ConditionalUtils.isSimplifiableReturn(statement, true)) {
            ConditionalUtils.replaceSimplifiableReturn(statement, true);
        } else if (ConditionalUtils.isSimplifiableImplicitReturn(statement, false)) {
            ConditionalUtils.replaceSimplifiableImplicitReturn(statement, false);
        } else if (ConditionalUtils.isSimplifiableImplicitReturn(statement, true)) {
            ConditionalUtils.replaceSimplifiableImplicitReturn(statement, true);
        } else if (ConditionalUtils.isSimplifiableImplicitAssignment(statement, false)) {
            ConditionalUtils.replaceSimplifiableImplicitAssignment(statement, false);
        } else if (ConditionalUtils.isSimplifiableImplicitAssignment(statement, true)) {
            ConditionalUtils.replaceSimplifiableImplicitAssignment(statement, true);
        } else if (ConditionalUtils.isSimplifiableEmptyBranches(statement)) {
            ConditionalUtils.replaceSimplifiableEmptyBranch(statement);
        }
    }

    public static void replaceExpressionWithNegatedExpression(@NotNull JSExpression newExpression, @NotNull JSExpression exp) throws IncorrectOperationException {
        String replacementString;
        JSExpression expressionToReplace;
        if (newExpression == null) {
            ConditionalUtils.$$$reportNull$$$0(0);
        }
        if (exp == null) {
            ConditionalUtils.$$$reportNull$$$0(1);
        }
        if ((expressionToReplace = BoolUtils.findNegation(exp)) == null) {
            expressionToReplace = exp;
            if (ComparisonUtils.isComparison((JSExpression)newExpression)) {
                JSBinaryExpression binaryExpression = (JSBinaryExpression)newExpression;
                IElementType operationSign = binaryExpression.getOperationSign();
                String negatedComparison = ComparisonUtils.getNegatedOperatorText((IElementType)operationSign);
                JSExpression leftOperand = binaryExpression.getLOperand();
                JSExpression rightOperand = binaryExpression.getROperand();
                assert (rightOperand != null);
                replacementString = leftOperand.getText() + negatedComparison + rightOperand.getText();
            } else {
                replacementString = '!' + JSParenthesesUtils.getParenthesized((JSExpression)newExpression, (int)3);
            }
        } else {
            replacementString = newExpression.getText();
        }
        JSRefactoringUtil.replaceExpressionAndReformat((JSExpression)expressionToReplace, (String)replacementString);
    }

    public static void replaceExpressionWithNegatedExpressionString(@NotNull JSExpression exp, String newExpression) throws IncorrectOperationException {
        if (exp == null) {
            ConditionalUtils.$$$reportNull$$$0(2);
        }
        JSExpression expressionToReplace = BoolUtils.findNegation(exp);
        String replacementString = newExpression;
        if (expressionToReplace == null) {
            expressionToReplace = exp;
            replacementString = "!(" + newExpression + ')';
        } else {
            PsiElement parent = expressionToReplace.getParent();
            if (parent instanceof JSBinaryExpression && exp instanceof JSBinaryExpression) {
                IElementType parentSign = ((JSBinaryExpression)parent).getOperationSign();
                IElementType childSign = ((JSBinaryExpression)exp).getOperationSign();
                if (childSign == JSTokenTypes.ANDAND && parentSign == JSTokenTypes.ANDAND) {
                    replacementString = "(" + newExpression + ")";
                }
            }
        }
        JSRefactoringUtil.replaceExpressionAndReformat((JSExpression)expressionToReplace, (String)replacementString);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newExpression";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exp";
                break;
            }
        }
        objectArray2[1] = "org/intellij/idea/lang/javascript/psiutil/ConditionalUtils";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "replaceExpressionWithNegatedExpression";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "replaceExpressionWithNegatedExpressionString";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

