/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.notebooks.jupyter.actions;

import com.intellij.ide.actions.CreateFileAction;
import com.intellij.ide.actions.CreateFileFromTemplateAction;
import com.intellij.ide.actions.CreateFileFromTemplateDialog;
import com.intellij.ide.fileTemplates.FileTemplate;
import com.intellij.ide.fileTemplates.FileTemplateManager;
import com.intellij.ide.fileTemplates.FileTemplateUtil;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.util.IncorrectOperationException;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.TypeCastException;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.apache.velocity.runtime.parser.ParseException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.notebooks.jupyter.JupyterFileType;
import org.jetbrains.plugins.notebooks.jupyter.actions.JupyterKernelSpecGuesserKt;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010$\n\u0002\b\u0005\u0018\u0000 \u001a2\u00020\u00012\u00020\u0002:\u0001\u001aB\u0005\u00a2\u0006\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0014J\"\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\tH\u0014J@\u0010\u0013\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\t2\b\u0010\u0014\u001a\u0004\u0018\u00010\u000f2\u0012\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u000f0\u0016H\u0002J \u0010\u0017\u001a\u00020\u000f2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0018\u001a\u00020\u000f2\u0006\u0010\u0019\u001a\u00020\u000fH\u0014\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/plugins/notebooks/jupyter/actions/JupyterCreateFileAction;", "Lcom/intellij/ide/actions/CreateFileFromTemplateAction;", "Lcom/intellij/openapi/project/DumbAware;", "()V", "buildDialog", "", "project", "Lcom/intellij/openapi/project/Project;", "directory", "Lcom/intellij/psi/PsiDirectory;", "builder", "Lcom/intellij/ide/actions/CreateFileFromTemplateDialog$Builder;", "createFileFromTemplate", "Lcom/intellij/psi/PsiFile;", "name", "", "template", "Lcom/intellij/ide/fileTemplates/FileTemplate;", "dir", "createFileFromTemplateWithProperties", "defaultTemplateProperty", "templateValues", "", "getActionName", "newName", "templateName", "Companion", "intellij.python.jupyter"})
public final class JupyterCreateFileAction
extends CreateFileFromTemplateAction
implements DumbAware {
    private static final Logger LOG;
    private static final String VAR_KERNEL_SPEC_DISPLAY_NAME = "KERNEL_SPEC_DISPLAY_NAME";
    private static final String VAR_KERNEL_SPEC_LANGUAGE = "KERNEL_SPEC_LANGUAGE";
    private static final String VAR_KERNEL_SPEC_NAME = "KERNEL_SPEC_NAME";
    public static final Companion Companion;

    protected void buildDialog(@NotNull Project project, @NotNull PsiDirectory directory, @NotNull CreateFileFromTemplateDialog.Builder builder) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)directory, (String)"directory");
        Intrinsics.checkParameterIsNotNull((Object)builder, (String)"builder");
        builder.setTitle("New Jupyter Notebook").addKind("Jupyter Notebook", JupyterFileType.INSTANCE.getIcon(), "Jupyter Notebook");
    }

    @NotNull
    protected String getActionName(@NotNull PsiDirectory directory, @NotNull String newName, @NotNull String templateName) {
        Intrinsics.checkParameterIsNotNull((Object)directory, (String)"directory");
        Intrinsics.checkParameterIsNotNull((Object)newName, (String)"newName");
        Intrinsics.checkParameterIsNotNull((Object)templateName, (String)"templateName");
        return "Create Jupyter Notebook " + newName;
    }

    @Nullable
    protected PsiFile createFileFromTemplate(@NotNull String name, @NotNull FileTemplate template, @NotNull PsiDirectory dir) {
        Object object;
        block3: {
            block2: {
                Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
                Intrinsics.checkParameterIsNotNull((Object)template, (String)"template");
                Intrinsics.checkParameterIsNotNull((Object)dir, (String)"dir");
                Module module = ModuleUtilCore.findModuleForFile((VirtualFile)dir.getVirtualFile(), (Project)dir.getProject());
                object = module;
                if (object == null) break block2;
                Module module2 = object;
                boolean bl = false;
                boolean bl2 = false;
                Module it = module2;
                boolean bl3 = false;
                object = JupyterKernelSpecGuesserKt.getMostSuitableKernelSpec(it);
                if (object != null) break block3;
            }
            object = JupyterKernelSpecGuesserKt.getPython3KernelSpec();
        }
        Object kernelSpec = object;
        Map templateValues = MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)VAR_KERNEL_SPEC_DISPLAY_NAME, (Object)kernelSpec.getDisplayName()), TuplesKt.to((Object)VAR_KERNEL_SPEC_LANGUAGE, (Object)kernelSpec.getLanguage()), TuplesKt.to((Object)VAR_KERNEL_SPEC_NAME, (Object)kernelSpec.getName())});
        return this.createFileFromTemplateWithProperties(name, template, dir, this.getDefaultTemplateProperty(), templateValues);
    }

    private final PsiFile createFileFromTemplateWithProperties(String name, FileTemplate template, PsiDirectory dir, String defaultTemplateProperty, Map<String, String> templateValues) {
        PsiDirectory actualDir;
        CreateFileAction.MkDirs mkdirs = new CreateFileAction.MkDirs(name, dir);
        String actualFileName = mkdirs.newName;
        PsiDirectory psiDirectory = actualDir = mkdirs.directory;
        Intrinsics.checkExpressionValueIsNotNull((Object)psiDirectory, (String)"actualDir");
        Project project = psiDirectory.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"actualDir.project");
        Project project2 = project;
        try {
            FileTemplateManager fileTemplateManager = FileTemplateManager.getInstance((Project)actualDir.getProject());
            Intrinsics.checkExpressionValueIsNotNull((Object)fileTemplateManager, (String)"FileTemplateManager.getInstance(actualDir.project)");
            Properties properties = fileTemplateManager.getDefaultProperties();
            Intrinsics.checkExpressionValueIsNotNull((Object)properties, (String)"FileTemplateManager.getI\u2026roject).defaultProperties");
            Properties properties2 = properties;
            Map<String, String> $this$forEach$iv = templateValues;
            boolean $i$f$forEach = false;
            Map<String, String> map = $this$forEach$iv;
            boolean bl = false;
            Iterator<Map.Entry<String, String>> iterator = map.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, String> element$iv;
                Map.Entry<String, String> $dstr$key$value = element$iv = iterator.next();
                boolean bl2 = false;
                Map.Entry<String, String> entry = $dstr$key$value;
                boolean bl3 = false;
                String key = entry.getKey();
                entry = $dstr$key$value;
                bl3 = false;
                String value = entry.getValue();
                ((Map)properties2).put(key, value);
            }
            PsiElement psiElement = FileTemplateUtil.createFromTemplate((FileTemplate)template, (String)actualFileName, (Properties)properties2, (PsiDirectory)actualDir);
            Intrinsics.checkExpressionValueIsNotNull((Object)psiElement, (String)"FileTemplateUtil.createF\u2026e, properties, actualDir)");
            PsiFile psiFile = psiElement.getContainingFile();
            SmartPsiElementPointer smartPsiElementPointer = SmartPointerManager.getInstance((Project)project2).createSmartPsiElementPointer((PsiElement)psiFile);
            Intrinsics.checkExpressionValueIsNotNull((Object)smartPsiElementPointer, (String)"SmartPointerManager.getI\u2026siElementPointer(psiFile)");
            SmartPsiElementPointer pointer = smartPsiElementPointer;
            PsiFile psiFile2 = psiFile;
            Intrinsics.checkExpressionValueIsNotNull((Object)psiFile2, (String)"psiFile");
            VirtualFile virtualFile2 = psiFile2.getVirtualFile();
            if (virtualFile2 != null) {
                FileEditorManager.getInstance((Project)project2).openFile(virtualFile2, true);
                if (defaultTemplateProperty != null) {
                    PropertiesComponent.getInstance((Project)project2).setValue(defaultTemplateProperty, template.getName());
                }
                return (PsiFile)pointer.getElement();
            }
        }
        catch (ParseException e) {
            ParseException parseException = e;
            if (parseException == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.Throwable");
            }
            throw (Throwable)new IncorrectOperationException("Error parsing Velocity template: " + e.getMessage(), (Throwable)parseException);
        }
        catch (IncorrectOperationException e) {
            throw (Throwable)e;
        }
        catch (Exception e) {
            LOG.error((Throwable)e);
        }
        return null;
    }

    public JupyterCreateFileAction() {
        super("Jupyter Notebook", "Creates a Jupyter Notebook file from the specified template", JupyterFileType.INSTANCE.getIcon());
    }

    static {
        Companion = new Companion(null);
        boolean $i$f$logger = false;
        Logger logger2 = Logger.getInstance(JupyterCreateFileAction.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)logger2, (String)"Logger.getInstance(T::class.java)");
        LOG = logger2;
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lorg/jetbrains/plugins/notebooks/jupyter/actions/JupyterCreateFileAction$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "VAR_KERNEL_SPEC_DISPLAY_NAME", "", "VAR_KERNEL_SPEC_LANGUAGE", "VAR_KERNEL_SPEC_NAME", "intellij.python.jupyter"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

