/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.notebooks.jupyter.actions;

import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ThrowableRunnable;
import com.jetbrains.extensions.python.VirtualFileExtKt;
import com.jetbrains.python.debugger.PyDebugProcess;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.notebooks.jupyter.JupyterBundle;
import org.jetbrains.plugins.notebooks.jupyter.JupyterLanguage;
import org.jetbrains.plugins.notebooks.jupyter.actions.InsertionDestination;
import org.jetbrains.plugins.notebooks.jupyter.actions.JupyterEditorActionsKt$WhenMappings;
import org.jetbrains.plugins.notebooks.jupyter.actions.JupyterExecutionData;
import org.jetbrains.plugins.notebooks.jupyter.connections.execution.JupyterCellExecutionManager;
import org.jetbrains.plugins.notebooks.jupyter.connections.ui.JupyterErrorReporter;
import org.jetbrains.plugins.notebooks.jupyter.debugger.JupyterDebugSessionManager;
import org.jetbrains.plugins.notebooks.jupyter.editor.JupyterCellUtilKt;
import org.jetbrains.plugins.notebooks.jupyter.editor.JupyterVirtualFile;
import org.jetbrains.plugins.notebooks.jupyter.nbformat.JupyterCellType;
import org.jetbrains.plugins.notebooks.jupyter.psi.JupyterCell;
import org.jetbrains.plugins.notebooks.jupyter.psi.JupyterCellBase;
import org.jetbrains.plugins.notebooks.jupyter.psi.JupyterPsiChangeListenerKt;
import org.jetbrains.plugins.notebooks.jupyter.psi.JupyterStemCell;
import org.jetbrains.plugins.notebooks.jupyter.psi.impl.JupyterCellImpl;
import org.jetbrains.plugins.notebooks.jupyter.server.ui.JupyterServerToolWindowKt;
import org.jetbrains.plugins.notebooks.jupyter.settings.JupyterSettings;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=2, d1={"\u0000\u0080\u0001\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u0018\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u001a2\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t2\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u0010H\u0002\u001a\u0018\u0010\u0011\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002\u001a\u001a\u0010\u0015\u001a\u00020\t2\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0016\u001a\u00020\u0017H\u0002\u001a\u0010\u0010\u0018\u001a\u00020\t2\u0006\u0010\u0016\u001a\u00020\u0017H\u0002\u001a\u0012\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u0016\u001a\u00020\u0017H\u0002\u001a\u001f\u0010\u001b\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0012\u001a\u00020\f2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002\u00a2\u0006\u0002\u0010\u001e\u001a\u001f\u0010\u001f\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0012\u001a\u00020\f2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002\u00a2\u0006\u0002\u0010\u001e\u001a4\u0010 \u001a\u00020!2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\n\u001a\u00020\t2\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\"\u001a\u00020\u00102\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u0002\u001a\u0018\u0010#\u001a\u00020!2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010$\u001a\u00020\u0007H\u0002\u001a\u0018\u0010%\u001a\u00020\u001d2\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u0014H\u0000\u001a\u0018\u0010%\u001a\u00020\u001d2\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\fH\u0000\u001a\u0018\u0010&\u001a\u00020!2\u0006\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020\tH\u0002\u001a\u0010\u0010*\u001a\u00020!2\u0006\u0010\u0016\u001a\u00020\u0017H\u0002\u001a\u0010\u0010+\u001a\u00020!2\u0006\u0010\u0016\u001a\u00020\u0017H\u0002\u001a\u0010\u0010,\u001a\u00020!2\u0006\u0010\u0016\u001a\u00020\u0017H\u0002\u001a\u0012\u0010-\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0016\u001a\u00020\u0017H\u0002\u001a(\u0010.\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010/\u001a\u00020\u00142\f\u00100\u001a\b\u0012\u0004\u0012\u00020\f01H\u0002\u001a\u001a\u00102\u001a\u0004\u0018\u0001032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u00104\u001a\u00020\u0014H\u0002\u001a<\u00105\u001a\u00020!2\u0006\u0010\u0012\u001a\u00020\f2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u001c\u001a\u00020\u001d2\u001a\u00106\u001a\u0016\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u001d\u0012\u0006\u0012\u0004\u0018\u00010\t07H\u0002\u001a\u0010\u00108\u001a\u00020!2\u0006\u0010\u0004\u001a\u00020\u0005H\u0000\u001a\u0018\u00109\u001a\u00020\u001d2\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\fH\u0000\u001a\n\u0010\u0011\u001a\u00020\u0007*\u00020\u0017\u001a\u000e\u0010:\u001a\u0004\u0018\u00010(*\u00020\u0017H\u0002\u001a\f\u0010;\u001a\u0004\u0018\u00010\f*\u00020\u0017\u001a\f\u0010;\u001a\u0004\u0018\u00010\f*\u00020<\u001a\u000e\u0010=\u001a\u0004\u0018\u00010\f*\u00020<H\u0002\u001a\u000e\u0010>\u001a\u0004\u0018\u00010\u0014*\u00020\fH\u0000\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006?"}, d2={"PSI_ELEMENT_DATA_ID", "", "createEmptyCell", "Lcom/intellij/lang/ASTNode;", "project", "Lcom/intellij/openapi/project/Project;", "jupyterCellType", "Lorg/jetbrains/plugins/notebooks/jupyter/nbformat/JupyterCellType;", "getCaretInsertPosition", "", "insertPosition", "cell", "Lorg/jetbrains/plugins/notebooks/jupyter/psi/JupyterCell;", "newCell", "newCellType", "insertionDestination", "Lorg/jetbrains/plugins/notebooks/jupyter/actions/InsertionDestination;", "getCellType", "psiCell", "virtualFile", "Lorg/jetbrains/plugins/notebooks/jupyter/editor/JupyterVirtualFile;", "getInsertPositionForCell", "event", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "getInsertPositionInNoCellNotebook", "getJupyterExecutionData", "Lorg/jetbrains/plugins/notebooks/jupyter/actions/JupyterExecutionData;", "getNextOffset", "skipNonCodeCells", "", "(Lorg/jetbrains/plugins/notebooks/jupyter/psi/JupyterCell;Z)Ljava/lang/Integer;", "getPreviousOffset", "insertCell", "", "destination", "insertCellToTheEnd", "cellType", "isUnderDebugger", "moveToOffset", "editor", "Lcom/intellij/openapi/editor/Editor;", "offset", "runAll", "runAllAbove", "runAllBelow", "runCell", "runCells", "jupyterVirtualFile", "cells", "", "searchStemCell", "Lorg/jetbrains/plugins/notebooks/jupyter/psi/JupyterStemCell;", "jupyterFile", "setCaretAndScrollPosition", "getOffset", "Lkotlin/Function2;", "showRemoteDebuggerWarning", "showWarningIfUnderDebugger", "getEditor", "getJupyterCell", "Lcom/intellij/openapi/actionSystem/DataContext;", "getLastJupyterCell", "getVirtualFile", "intellij.python.jupyter"})
public final class JupyterEditorActionsKt {
    @NotNull
    public static final String PSI_ELEMENT_DATA_ID = "PsiElementDataId";

    private static final void insertCellToTheEnd(AnActionEvent event, JupyterCellType cellType2) {
        DataContext dataContext = event.getDataContext();
        Intrinsics.checkExpressionValueIsNotNull((Object)dataContext, (String)"event.dataContext");
        JupyterCell cell = JupyterEditorActionsKt.getLastJupyterCell(dataContext);
        int insertPosition = JupyterEditorActionsKt.getInsertPositionForCell(cell, event);
        JupyterEditorActionsKt.insertCell(event, insertPosition, cell, InsertionDestination.BELOW, cellType2);
    }

    private static final int getInsertPositionInNoCellNotebook(AnActionEvent event) {
        Editor editor = JupyterEditorActionsKt.getEditor(event);
        return editor != null && (editor = editor.getCaretModel()) != null ? editor.getOffset() : 0;
    }

    private static final void insertCell(AnActionEvent event, int insertPosition, JupyterCell cell, InsertionDestination destination, JupyterCellType jupyterCellType) {
        Project project = (Project)event.getDataContext().getData(PlatformDataKeys.PROJECT);
        if (project == null) {
            return;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"event.dataContext.getDat\u2026taKeys.PROJECT) ?: return");
        Project project2 = project;
        Editor editor = JupyterEditorActionsKt.getEditor(event);
        if (!(editor instanceof EditorEx)) {
            editor = null;
        }
        EditorEx editorEx = (EditorEx)editor;
        if (editorEx == null) {
            return;
        }
        EditorEx editor2 = editorEx;
        VirtualFile virtualFile2 = editor2.getVirtualFile();
        if (!(virtualFile2 instanceof JupyterVirtualFile)) {
            virtualFile2 = null;
        }
        JupyterVirtualFile jupyterVirtualFile = (JupyterVirtualFile)virtualFile2;
        if (jupyterVirtualFile == null) {
            return;
        }
        JupyterVirtualFile jupyterFile = jupyterVirtualFile;
        FileViewProvider fileViewProvider = PsiManager.getInstance((Project)project2).findViewProvider((VirtualFile)jupyterFile);
        if (fileViewProvider == null) {
            return;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)fileViewProvider, (String)"PsiManager.getInstance(p\u2026er(jupyterFile) ?: return");
        FileViewProvider viewProvider = fileViewProvider;
        WriteCommandAction.writeCommandAction((Project)project2, (PsiFile[])new PsiFile[]{viewProvider.getPsi((Language)JupyterLanguage.INSTANCE)}).run((ThrowableRunnable)new ThrowableRunnable<RuntimeException>(editor2, insertPosition, project2, jupyterCellType, cell, destination, jupyterFile){
            final /* synthetic */ EditorEx $editor;
            final /* synthetic */ int $insertPosition;
            final /* synthetic */ Project $project;
            final /* synthetic */ JupyterCellType $jupyterCellType;
            final /* synthetic */ JupyterCell $cell;
            final /* synthetic */ InsertionDestination $destination;
            final /* synthetic */ JupyterVirtualFile $jupyterFile;

            /*
             * Unable to fully structure code
             * Could not resolve type clashes
             */
            public final void run() {
                var1_1 = this.$editor;
                var2_2 = false;
                var3_3 = false;
                $this$apply = var1_1;
                $i$a$-apply-JupyterEditorActionsKt$insertCell$1$1 = false;
                lineBreak = $this$apply.offsetToLogicalPosition((int)this.$insertPosition).column > 0 ? "\n" : "";
                $this$apply.getDocument().insertString(this.$insertPosition, (CharSequence)lineBreak);
                PsiDocumentManager.getInstance((Project)this.$project).commitDocument((Document)$this$apply.getDocument());
                newCell = new JupyterCellImpl(JupyterEditorActionsKt.access$createEmptyCell(this.$project, this.$jupyterCellType));
                v0 = this.$cell;
                if (v0 == null) ** GOTO lbl-1000
                var8_8 /* !! */  = v0;
                var9_9 = false;
                var10_10 = false;
                $this$apply = var8_8 /* !! */ ;
                $i$a$-apply-JupyterEditorActionsKt$insertCell$1$1$1 = false;
                switch (JupyterEditorActionsKt$WhenMappings.$EnumSwitchMapping$0[this.$destination.ordinal()]) {
                    case 1: {
                        $this$apply.getParent().addBefore((PsiElement)newCell, (PsiElement)$this$apply);
                        break;
                    }
                    case 2: {
                        $this$apply.getParent().addAfter((PsiElement)newCell, (PsiElement)$this$apply);
                    }
                }
                v0 = var8_8 /* !! */ ;
                if (v0 != null) {
                    (JupyterCellBase)v0;
                } else lbl-1000:
                // 2 sources

                {
                    v1 = JupyterEditorActionsKt.access$searchStemCell(this.$project, this.$jupyterFile);
                    if (v1 != null) {
                        var8_8 /* !! */  = v1;
                        var9_9 = false;
                        var10_10 = false;
                        $this$apply = var8_8 /* !! */ ;
                        $i$a$-apply-JupyterEditorActionsKt$insertCell$1$1$2 = false;
                        $this$apply.getParent().addAfter((PsiElement)newCell, (PsiElement)$this$apply);
                        v2 /* !! */  = var8_8 /* !! */ ;
                    } else {
                        v2 /* !! */  = null;
                    }
                    (JupyterCellBase)v2 /* !! */ ;
                }
                $this$apply.getCaretModel().moveToOffset(JupyterEditorActionsKt.access$getCaretInsertPosition(this.$insertPosition, this.$cell, newCell, this.$jupyterCellType, this.$destination));
            }
            {
                this.$editor = editorEx;
                this.$insertPosition = n;
                this.$project = project;
                this.$jupyterCellType = jupyterCellType;
                this.$cell = jupyterCell;
                this.$destination = insertionDestination;
                this.$jupyterFile = jupyterVirtualFile;
            }
        });
    }

    static /* synthetic */ void insertCell$default(AnActionEvent anActionEvent, int n, JupyterCell jupyterCell, InsertionDestination insertionDestination, JupyterCellType jupyterCellType, int n2, Object object) {
        if ((n2 & 0x10) != 0) {
            jupyterCellType = JupyterCellType.CODE;
        }
        JupyterEditorActionsKt.insertCell(anActionEvent, n, jupyterCell, insertionDestination, jupyterCellType);
    }

    private static final int getCaretInsertPosition(int insertPosition, JupyterCell cell, JupyterCell newCell, JupyterCellType newCellType, InsertionDestination insertionDestination) {
        int n;
        switch (JupyterEditorActionsKt$WhenMappings.$EnumSwitchMapping$1[insertionDestination.ordinal()]) {
            case 1: {
                JupyterCell jupyterCell = cell;
                if (jupyterCell != null) {
                    n = jupyterCell.getTextOffset();
                    break;
                }
                n = 0;
                break;
            }
            case 2: {
                n = insertPosition + newCell.getText().length();
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        int offset = n - 1;
        int span = newCellType == JupyterCellType.CODE ? JupyterSettings.Companion.getInstance().getSourceCodeLineSpan() : 0;
        return offset - span;
    }

    private static final JupyterStemCell searchStemCell(Project project, JupyterVirtualFile jupyterFile) {
        PsiFileSystemItem psiFile = VirtualFileExtKt.toPsi((VirtualFile)((VirtualFile)jupyterFile), (Project)project);
        return (JupyterStemCell)PsiTreeUtil.findChildOfType((PsiElement)((PsiElement)psiFile), JupyterStemCell.class);
    }

    private static final ASTNode createEmptyCell(Project project, JupyterCellType jupyterCellType) {
        PsiFile dummyFile;
        String string;
        switch (JupyterEditorActionsKt$WhenMappings.$EnumSwitchMapping$2[jupyterCellType.ordinal()]) {
            case 1: {
                string = "#%% md\n" + JupyterCellUtilKt.addExtraLines("\n");
                break;
            }
            case 2: {
                string = "#%% raw\n\n";
                break;
            }
            default: {
                string = "#%%\n" + JupyterCellUtilKt.addExtraLines("\n");
            }
        }
        String text = string;
        PsiFile psiFile = dummyFile = PsiFileFactory.getInstance((Project)project).createFileFromText((Language)JupyterLanguage.INSTANCE, (CharSequence)text);
        Intrinsics.checkExpressionValueIsNotNull((Object)psiFile, (String)"dummyFile");
        PsiFile psiFile2 = psiFile.getViewProvider().getPsi((Language)JupyterLanguage.INSTANCE);
        Intrinsics.checkExpressionValueIsNotNull((Object)psiFile2, (String)"dummyFile.viewProvider.getPsi(JupyterLanguage)");
        PsiElement psiElement = psiFile2.getChildren()[0];
        Intrinsics.checkExpressionValueIsNotNull((Object)psiElement, (String)"dummyFile.viewProvider.g\u2026yterLanguage).children[0]");
        PsiElement psiElement2 = psiElement.getChildren()[1];
        if (psiElement2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.plugins.notebooks.jupyter.psi.JupyterCell");
        }
        JupyterCell cell = (JupyterCell)psiElement2;
        ASTNode aSTNode = cell.getNode().copyElement();
        Intrinsics.checkExpressionValueIsNotNull((Object)aSTNode, (String)"cell.node.copyElement()");
        return aSTNode;
    }

    private static final void setCaretAndScrollPosition(JupyterCell psiCell, AnActionEvent event, boolean skipNonCodeCells, Function2<? super JupyterCell, ? super Boolean, Integer> getOffset) {
        Integer n = (Integer)getOffset.invoke((Object)psiCell, (Object)skipNonCodeCells);
        if (n == null) {
            return;
        }
        int nextCellOffset = n;
        Editor editor = JupyterEditorActionsKt.getEditor(event);
        if (editor == null) {
            return;
        }
        Editor editor2 = editor;
        JupyterEditorActionsKt.moveToOffset(editor2, nextCellOffset);
    }

    private static final Editor getEditor(@NotNull AnActionEvent $this$getEditor) {
        return (Editor)$this$getEditor.getDataContext().getData(PlatformDataKeys.EDITOR);
    }

    private static final void moveToOffset(Editor editor, int offset) {
        Editor editor2 = editor;
        boolean bl = false;
        boolean bl2 = false;
        Editor $this$apply = editor2;
        boolean bl3 = false;
        CaretModel caretModel = $this$apply.getCaretModel();
        Intrinsics.checkExpressionValueIsNotNull((Object)caretModel, (String)"caretModel");
        caretModel.getPrimaryCaret().moveToOffset(offset);
        $this$apply.getScrollingModel().scrollToCaret(ScrollType.MAKE_VISIBLE);
    }

    public static final boolean isUnderDebugger(@NotNull Project project, @NotNull JupyterVirtualFile virtualFile2) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)((Object)virtualFile2), (String)"virtualFile");
        String sessionPath = JupyterCellExecutionManager.Companion.getSessionPath(virtualFile2);
        return JupyterDebugSessionManager.Companion.getInstance(project).isSessionUnderDebug(sessionPath);
    }

    public static final boolean isUnderDebugger(@NotNull Project project, @NotNull JupyterCell psiCell) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)psiCell, (String)"psiCell");
        PsiFile psiFile = psiCell.getContainingFile();
        Intrinsics.checkExpressionValueIsNotNull((Object)psiFile, (String)"psiCell.containingFile");
        VirtualFile virtualFile2 = psiFile.getVirtualFile();
        if (!(virtualFile2 instanceof JupyterVirtualFile)) {
            virtualFile2 = null;
        }
        JupyterVirtualFile jupyterVirtualFile = (JupyterVirtualFile)virtualFile2;
        if (jupyterVirtualFile == null) {
            return false;
        }
        JupyterVirtualFile virtualFile3 = jupyterVirtualFile;
        return JupyterEditorActionsKt.isUnderDebugger(project, virtualFile3);
    }

    public static final boolean showWarningIfUnderDebugger(@NotNull Project project, @NotNull JupyterCell psiCell) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)psiCell, (String)"psiCell");
        if (JupyterEditorActionsKt.isUnderDebugger(project, psiCell)) {
            PyDebugProcess.NOTIFICATION_GROUP.createNotification(JupyterBundle.message("Jupyter.debugger.other.cell.under.debugger.warning", new Object[0]), NotificationType.ERROR).notify(project);
            return true;
        }
        return false;
    }

    public static final void showRemoteDebuggerWarning(@NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        JupyterServerToolWindowKt.getJUPYTER_NOTIFICATION_GROUP().createNotification(JupyterBundle.message("Jupyter.debugger.remote.warning", new Object[0]), NotificationType.ERROR).notify(project);
    }

    private static final JupyterExecutionData getJupyterExecutionData(AnActionEvent event) {
        Project project = (Project)event.getDataContext().getData(PlatformDataKeys.PROJECT);
        if (project == null) {
            return null;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"event.dataContext.getDat\u2026s.PROJECT) ?: return null");
        Project project2 = project;
        JupyterCell jupyterCell = JupyterEditorActionsKt.getJupyterCell(event);
        if (jupyterCell == null) {
            return null;
        }
        JupyterCell psiCell = jupyterCell;
        JupyterVirtualFile jupyterVirtualFile = JupyterEditorActionsKt.getVirtualFile(psiCell);
        if (jupyterVirtualFile == null) {
            return null;
        }
        JupyterVirtualFile jupyterVirtualFile2 = jupyterVirtualFile;
        if (JupyterEditorActionsKt.showWarningIfUnderDebugger(project2, psiCell)) {
            return null;
        }
        return new JupyterExecutionData(project2, psiCell, jupyterVirtualFile2);
    }

    /*
     * WARNING - void declaration
     */
    private static final JupyterCell runCell(AnActionEvent event) {
        void psiCell;
        void project;
        JupyterExecutionData result;
        JupyterExecutionData jupyterExecutionData = JupyterEditorActionsKt.getJupyterExecutionData(event);
        if (jupyterExecutionData == null) {
            return null;
        }
        JupyterExecutionData jupyterExecutionData2 = result = jupyterExecutionData;
        Project project2 = jupyterExecutionData2.component1();
        JupyterCell jupyterCell = jupyterExecutionData2.component2();
        JupyterVirtualFile jupyterVirtualFile = jupyterExecutionData2.component3();
        return JupyterEditorActionsKt.runCells((Project)project, jupyterVirtualFile, CollectionsKt.listOf((Object)psiCell));
    }

    private static final void runAll(AnActionEvent event) {
        block1: {
            List<JupyterCell> allCells;
            JupyterExecutionData jupyterExecutionData = JupyterEditorActionsKt.getJupyterExecutionData(event);
            if (jupyterExecutionData == null) {
                return;
            }
            JupyterExecutionData executionData = jupyterExecutionData;
            Project project = executionData.getProject();
            JupyterVirtualFile jupyterVirtualFile = executionData.getJupyterVirtualFile();
            List<JupyterCell> list = allCells = JupyterCellUtilKt.getCells(project, jupyterVirtualFile);
            if (list == null) break block1;
            List<JupyterCell> list2 = list;
            boolean bl = false;
            boolean bl2 = false;
            List<JupyterCell> $this$run = list2;
            boolean bl3 = false;
            JupyterEditorActionsKt.runCells(project, jupyterVirtualFile, $this$run);
        }
    }

    /*
     * WARNING - void declaration
     */
    private static final void runAllAbove(AnActionEvent event) {
        void psiCell;
        void project;
        JupyterExecutionData result;
        JupyterExecutionData jupyterExecutionData = JupyterEditorActionsKt.getJupyterExecutionData(event);
        if (jupyterExecutionData == null) {
            return;
        }
        JupyterExecutionData jupyterExecutionData2 = result = jupyterExecutionData;
        Project project2 = jupyterExecutionData2.component1();
        JupyterCell jupyterCell = jupyterExecutionData2.component2();
        JupyterVirtualFile jupyterVirtualFile = jupyterExecutionData2.component3();
        List<JupyterCell> list = JupyterCellUtilKt.getCells((Project)project, jupyterVirtualFile);
        if (list == null) {
            return;
        }
        List<JupyterCell> allCells = list;
        int index = allCells.indexOf(psiCell);
        List<JupyterCell> list2 = allCells.subList(0, index);
        boolean bl = false;
        boolean bl2 = false;
        List<JupyterCell> $this$run = list2;
        boolean bl3 = false;
        JupyterEditorActionsKt.runCells((Project)project, jupyterVirtualFile, $this$run);
    }

    /*
     * WARNING - void declaration
     */
    private static final void runAllBelow(AnActionEvent event) {
        void psiCell;
        void project;
        JupyterExecutionData result;
        JupyterExecutionData jupyterExecutionData = JupyterEditorActionsKt.getJupyterExecutionData(event);
        if (jupyterExecutionData == null) {
            return;
        }
        JupyterExecutionData jupyterExecutionData2 = result = jupyterExecutionData;
        Project project2 = jupyterExecutionData2.component1();
        JupyterCell jupyterCell = jupyterExecutionData2.component2();
        JupyterVirtualFile jupyterVirtualFile = jupyterExecutionData2.component3();
        List<JupyterCell> list = JupyterCellUtilKt.getCells((Project)project, jupyterVirtualFile);
        if (list == null) {
            return;
        }
        List<JupyterCell> allCells = list;
        int index = allCells.indexOf(psiCell);
        List<JupyterCell> list2 = allCells.subList(index, allCells.size());
        boolean bl = false;
        boolean bl2 = false;
        List<JupyterCell> $this$run = list2;
        boolean bl3 = false;
        JupyterEditorActionsKt.runCells((Project)project, jupyterVirtualFile, $this$run);
    }

    /*
     * WARNING - void declaration
     */
    private static final JupyterCell runCells(Project project, JupyterVirtualFile jupyterVirtualFile, List<? extends JupyterCell> cells2) {
        void firstExecutedCell;
        Ref.ObjectRef objectRef = new Ref.ObjectRef();
        objectRef.element = null;
        Iterable $this$forEach$iv = cells2;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            JupyterCell it = (JupyterCell)element$iv;
            boolean bl = false;
            if (JupyterEditorActionsKt.getCellType(it, jupyterVirtualFile) != JupyterCellType.CODE) continue;
            Project project2 = project;
            boolean bl2 = false;
            boolean bl3 = false;
            Project $this$run = project2;
            boolean bl4 = false;
            try {
                Project project3 = it.getProject();
                Intrinsics.checkExpressionValueIsNotNull((Object)project3, (String)"it.project");
                JupyterCellExecutionManager.Companion.getInstance(project3).execute(it, (Function1<? super Exception, Unit>)((Function1)new Function1<Exception, Unit>(it, jupyterVirtualFile, project, (Ref.ObjectRef)firstExecutedCell){
                    final /* synthetic */ JupyterCell $it$inlined;
                    final /* synthetic */ JupyterVirtualFile $jupyterVirtualFile$inlined;
                    final /* synthetic */ Project $project$inlined;
                    final /* synthetic */ Ref.ObjectRef $firstExecutedCell$inlined;
                    {
                        this.$it$inlined = jupyterCell;
                        this.$jupyterVirtualFile$inlined = jupyterVirtualFile;
                        this.$project$inlined = project;
                        this.$firstExecutedCell$inlined = objectRef;
                        super(1);
                    }

                    public final void invoke(@NotNull Exception e) {
                        Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
                        JupyterErrorReporter.Companion.displayAndLogError(this.$it$inlined.getProject(), e);
                    }
                }));
                if ((JupyterCell)firstExecutedCell.element != null) continue;
                firstExecutedCell.element = it;
            }
            catch (Exception e) {
                JupyterErrorReporter.Companion.displayAndLogError(it.getProject(), e);
            }
        }
        return (JupyterCell)firstExecutedCell.element;
    }

    private static final Integer getPreviousOffset(JupyterCell psiCell, boolean skipNonCodeCells) {
        PsiElement psiElement = psiCell.getPrevSibling();
        if (!(psiElement instanceof JupyterCell)) {
            psiElement = null;
        }
        JupyterCell jupyterCell = (JupyterCell)psiElement;
        if (jupyterCell == null) {
            return null;
        }
        JupyterCell previousCell = jupyterCell;
        JupyterVirtualFile jupyterVirtualFile = JupyterEditorActionsKt.getVirtualFile(psiCell);
        if (jupyterVirtualFile == null) {
            return null;
        }
        JupyterVirtualFile jupyterFile = jupyterVirtualFile;
        if (skipNonCodeCells && JupyterEditorActionsKt.getCellType(previousCell, jupyterFile) != JupyterCellType.CODE) {
            return JupyterEditorActionsKt.getPreviousOffset(previousCell, skipNonCodeCells);
        }
        return JupyterCellUtilKt.getCellSelectionOffset(previousCell);
    }

    private static final Integer getNextOffset(JupyterCell psiCell, boolean skipNonCodeCells) {
        PsiElement psiElement = psiCell.getNextSibling();
        if (!(psiElement instanceof JupyterCell)) {
            psiElement = null;
        }
        JupyterCell jupyterCell = (JupyterCell)psiElement;
        if (jupyterCell == null) {
            return null;
        }
        JupyterCell nextCell = jupyterCell;
        JupyterVirtualFile jupyterVirtualFile = JupyterEditorActionsKt.getVirtualFile(psiCell);
        if (jupyterVirtualFile == null) {
            return null;
        }
        JupyterVirtualFile jupyterFile = jupyterVirtualFile;
        if (skipNonCodeCells && JupyterEditorActionsKt.getCellType(nextCell, jupyterFile) != JupyterCellType.CODE) {
            return JupyterEditorActionsKt.getNextOffset(nextCell, skipNonCodeCells);
        }
        return JupyterCellUtilKt.getCellSelectionOffset(nextCell);
    }

    @Nullable
    public static final JupyterCell getJupyterCell(@NotNull AnActionEvent $this$getJupyterCell) {
        Intrinsics.checkParameterIsNotNull((Object)$this$getJupyterCell, (String)"$this$getJupyterCell");
        DataContext dataContext = $this$getJupyterCell.getDataContext();
        Intrinsics.checkExpressionValueIsNotNull((Object)dataContext, (String)"dataContext");
        return JupyterEditorActionsKt.getJupyterCell(dataContext);
    }

    private static final int getInsertPositionForCell(JupyterCell cell, AnActionEvent event) {
        int n;
        JupyterCell jupyterCell = cell;
        if (jupyterCell != null) {
            JupyterCell jupyterCell2 = jupyterCell;
            boolean bl = false;
            boolean bl2 = false;
            JupyterCell $this$run = jupyterCell2;
            boolean bl3 = false;
            n = $this$run.getTextOffset() + $this$run.getTextLength();
        } else {
            n = JupyterEditorActionsKt.getInsertPositionInNoCellNotebook(event);
        }
        return n;
    }

    @Nullable
    public static final JupyterCell getJupyterCell(@NotNull DataContext $this$getJupyterCell) {
        Intrinsics.checkParameterIsNotNull((Object)$this$getJupyterCell, (String)"$this$getJupyterCell");
        Object object = $this$getJupyterCell.getData(PSI_ELEMENT_DATA_ID);
        if (!(object instanceof PsiElement)) {
            object = null;
        }
        PsiElement psiElement = (PsiElement)object;
        JupyterCell jupyterCell = (JupyterCell)PsiTreeUtil.getParentOfType((PsiElement)psiElement, JupyterCell.class);
        if (jupyterCell != null) {
            JupyterCell jupyterCell2 = jupyterCell;
            boolean bl = false;
            boolean bl2 = false;
            JupyterCell it = jupyterCell2;
            boolean bl3 = false;
            return it;
        }
        Project project = (Project)$this$getJupyterCell.getData(PlatformDataKeys.PROJECT);
        if (project == null) {
            return null;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"getData(PlatformDataKeys.PROJECT) ?: return null");
        Project project2 = project;
        Object object2 = $this$getJupyterCell.getData(PlatformDataKeys.FILE_EDITOR);
        if (!(object2 instanceof TextEditor)) {
            object2 = null;
        }
        TextEditor textEditor = (TextEditor)object2;
        if (textEditor == null) {
            return null;
        }
        TextEditor editor = textEditor;
        VirtualFile virtualFile2 = editor.getFile();
        if (!(virtualFile2 instanceof JupyterVirtualFile)) {
            virtualFile2 = null;
        }
        JupyterVirtualFile jupyterVirtualFile = (JupyterVirtualFile)virtualFile2;
        if (jupyterVirtualFile == null) {
            return null;
        }
        JupyterVirtualFile jupyterFile = jupyterVirtualFile;
        Editor editor2 = editor.getEditor();
        Intrinsics.checkExpressionValueIsNotNull((Object)editor2, (String)"editor.editor");
        CaretModel caretModel = editor2.getCaretModel();
        Intrinsics.checkExpressionValueIsNotNull((Object)caretModel, (String)"editor.editor.caretModel");
        Caret caret = caretModel.getPrimaryCaret();
        Intrinsics.checkExpressionValueIsNotNull((Object)caret, (String)"editor.editor.caretModel.primaryCaret");
        int caretOffset = caret.getOffset();
        return JupyterCellUtilKt.getJupyterCellByOffset(project2, jupyterFile, caretOffset);
    }

    private static final JupyterCell getLastJupyterCell(@NotNull DataContext $this$getLastJupyterCell) {
        JupyterCell jupyterCell = JupyterEditorActionsKt.getJupyterCell($this$getLastJupyterCell);
        if (jupyterCell == null) {
            return null;
        }
        JupyterCell cell = jupyterCell;
        PsiElement psiElement = cell.getParent();
        Intrinsics.checkExpressionValueIsNotNull((Object)psiElement, (String)"cell.parent");
        PsiElement psiElement2 = psiElement.getLastChild();
        if (psiElement2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.plugins.notebooks.jupyter.psi.JupyterCell");
        }
        return (JupyterCell)psiElement2;
    }

    @NotNull
    public static final JupyterCellType getCellType(@NotNull AnActionEvent $this$getCellType) {
        Intrinsics.checkParameterIsNotNull((Object)$this$getCellType, (String)"$this$getCellType");
        JupyterCell jupyterCell = JupyterEditorActionsKt.getJupyterCell($this$getCellType);
        if (jupyterCell == null) {
            return JupyterCellType.UNDEFINED;
        }
        JupyterCell psiCell = jupyterCell;
        JupyterVirtualFile jupyterVirtualFile = JupyterEditorActionsKt.getVirtualFile(psiCell);
        if (jupyterVirtualFile == null) {
            return JupyterCellType.UNDEFINED;
        }
        JupyterVirtualFile jupyterFile = jupyterVirtualFile;
        return JupyterEditorActionsKt.getCellType(psiCell, jupyterFile);
    }

    @Nullable
    public static final JupyterVirtualFile getVirtualFile(@NotNull JupyterCell $this$getVirtualFile) {
        Intrinsics.checkParameterIsNotNull((Object)$this$getVirtualFile, (String)"$this$getVirtualFile");
        PsiFile psiFile = $this$getVirtualFile.getContainingFile();
        Intrinsics.checkExpressionValueIsNotNull((Object)psiFile, (String)"containingFile");
        VirtualFile virtualFile2 = psiFile.getVirtualFile();
        if (!(virtualFile2 instanceof JupyterVirtualFile)) {
            virtualFile2 = null;
        }
        return (JupyterVirtualFile)virtualFile2;
    }

    private static final JupyterCellType getCellType(JupyterCell psiCell, JupyterVirtualFile virtualFile2) {
        int cellIndex = JupyterPsiChangeListenerKt.getCellIndex(psiCell);
        Object object = (org.jetbrains.plugins.notebooks.jupyter.nbformat.JupyterCell)CollectionsKt.getOrNull(virtualFile2.getNotebook().getCells(), (int)cellIndex);
        if (object == null || (object = object.getCellType()) == null) {
            object = JupyterCellType.UNDEFINED;
        }
        return object;
    }

    public static final /* synthetic */ JupyterCell access$runCell(AnActionEvent event) {
        return JupyterEditorActionsKt.runCell(event);
    }

    public static final /* synthetic */ void access$setCaretAndScrollPosition(JupyterCell psiCell, AnActionEvent event, boolean skipNonCodeCells, Function2 getOffset) {
        JupyterEditorActionsKt.setCaretAndScrollPosition(psiCell, event, skipNonCodeCells, (Function2<? super JupyterCell, ? super Boolean, Integer>)getOffset);
    }

    public static final /* synthetic */ Integer access$getNextOffset(JupyterCell psiCell, boolean skipNonCodeCells) {
        return JupyterEditorActionsKt.getNextOffset(psiCell, skipNonCodeCells);
    }

    public static final /* synthetic */ void access$runAll(AnActionEvent event) {
        JupyterEditorActionsKt.runAll(event);
    }

    public static final /* synthetic */ void access$runAllAbove(AnActionEvent event) {
        JupyterEditorActionsKt.runAllAbove(event);
    }

    public static final /* synthetic */ void access$runAllBelow(AnActionEvent event) {
        JupyterEditorActionsKt.runAllBelow(event);
    }

    public static final /* synthetic */ Integer access$getPreviousOffset(JupyterCell psiCell, boolean skipNonCodeCells) {
        return JupyterEditorActionsKt.getPreviousOffset(psiCell, skipNonCodeCells);
    }

    public static final /* synthetic */ JupyterExecutionData access$getJupyterExecutionData(AnActionEvent event) {
        return JupyterEditorActionsKt.getJupyterExecutionData(event);
    }

    public static final /* synthetic */ int access$getInsertPositionForCell(JupyterCell cell, AnActionEvent event) {
        return JupyterEditorActionsKt.getInsertPositionForCell(cell, event);
    }

    public static final /* synthetic */ void access$insertCellToTheEnd(AnActionEvent event, JupyterCellType cellType2) {
        JupyterEditorActionsKt.insertCellToTheEnd(event, cellType2);
    }

    public static final /* synthetic */ ASTNode access$createEmptyCell(Project project, JupyterCellType jupyterCellType) {
        return JupyterEditorActionsKt.createEmptyCell(project, jupyterCellType);
    }

    public static final /* synthetic */ JupyterStemCell access$searchStemCell(Project project, JupyterVirtualFile jupyterFile) {
        return JupyterEditorActionsKt.searchStemCell(project, jupyterFile);
    }

    public static final /* synthetic */ int access$getCaretInsertPosition(int insertPosition, JupyterCell cell, JupyterCell newCell, JupyterCellType newCellType, InsertionDestination insertionDestination) {
        return JupyterEditorActionsKt.getCaretInsertPosition(insertPosition, cell, newCell, newCellType, insertionDestination);
    }
}

