/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.notebooks.jupyter.connections.execution;

import com.google.gson.JsonElement;
import com.intellij.credentialStore.OneTimeString;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.util.ThrowableRunnable;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.TypeIntrinsics;
import kotlin.reflect.KDeclarationContainer;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.notebooks.jupyter.actions.JupyterEditorActionsKt;
import org.jetbrains.plugins.notebooks.jupyter.connections.JupyterLoginException;
import org.jetbrains.plugins.notebooks.jupyter.connections.JupyterLoginKt;
import org.jetbrains.plugins.notebooks.jupyter.connections.execution.JupyterCellExecutionListener;
import org.jetbrains.plugins.notebooks.jupyter.connections.execution.JupyterCellExecutionManager;
import org.jetbrains.plugins.notebooks.jupyter.connections.execution.JupyterCellExecutionManagerKt;
import org.jetbrains.plugins.notebooks.jupyter.connections.execution.JupyterConnectionSettingsUtilKt;
import org.jetbrains.plugins.notebooks.jupyter.connections.execution.JupyterExecutionStatus;
import org.jetbrains.plugins.notebooks.jupyter.connections.execution.JupyterRestClientForbiddenException;
import org.jetbrains.plugins.notebooks.jupyter.connections.execution.JupyterRuntimeService;
import org.jetbrains.plugins.notebooks.jupyter.connections.execution.core.JupyterCellExecutionCallback;
import org.jetbrains.plugins.notebooks.jupyter.connections.execution.core.JupyterCellExecutionCallbackAdapter;
import org.jetbrains.plugins.notebooks.jupyter.connections.execution.core.JupyterKernelClient;
import org.jetbrains.plugins.notebooks.jupyter.connections.execution.core.JupyterNotebookSession;
import org.jetbrains.plugins.notebooks.jupyter.connections.execution.core.JupyterServer;
import org.jetbrains.plugins.notebooks.jupyter.connections.execution.message.JupyterInputReplyMessageBuilder;
import org.jetbrains.plugins.notebooks.jupyter.connections.execution.message.JupyterInputRequestMessage;
import org.jetbrains.plugins.notebooks.jupyter.connections.execution.message.JupyterMessage;
import org.jetbrains.plugins.notebooks.jupyter.connections.execution.message.JupyterMessageHeader;
import org.jetbrains.plugins.notebooks.jupyter.connections.execution.message.JupyterStatusMessage;
import org.jetbrains.plugins.notebooks.jupyter.connections.ui.JupyterLoginDialog;
import org.jetbrains.plugins.notebooks.jupyter.editor.JupyterVirtualFile;
import org.jetbrains.plugins.notebooks.jupyter.nbformat.JupyterNotebook;
import org.jetbrains.plugins.notebooks.jupyter.nbformat.JupyterOutputsBase;
import org.jetbrains.plugins.notebooks.jupyter.nbformat.JupyterOutputsBaseKt;
import org.jetbrains.plugins.notebooks.jupyter.psi.JupyterCell;
import org.jetbrains.plugins.notebooks.jupyter.psi.JupyterPsiChangeListenerKt;
import org.jetbrains.plugins.notebooks.jupyter.psi.JupyterSource;
import org.jetbrains.plugins.notebooks.jupyter.variables.JupyterVarsToolWindowManager;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u00b2\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010#\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 N2\u00020\u0001:\u0003NOPB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0007Jj\u0010\u0019\u001a\u00020\u00172\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u00142\u0006\u0010\u001d\u001a\u00020\u000f2\u0006\u0010\u001e\u001a\u00020\u000e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020 2\u0016\u0010\"\u001a\u0012\u0012\b\u0012\u00060$j\u0002`%\u0012\u0004\u0012\u00020\u00170#2\b\u0010&\u001a\u0004\u0018\u00010'2\u0006\u0010(\u001a\u00020 2\u0006\u0010)\u001a\u00020*H\u0002J\u0015\u0010+\u001a\u00020\u00172\u0006\u0010,\u001a\u00020\u000eH\u0000\u00a2\u0006\u0002\b-J\u0010\u0010.\u001a\u00020\u00172\u0006\u0010,\u001a\u00020\u000eH\u0002J \u0010/\u001a\u00020\u00172\u0006\u00100\u001a\u0002012\u0006\u00102\u001a\u0002032\u0006\u00104\u001a\u000205H\u0002J\u0010\u00106\u001a\u00020'2\u0006\u0010\u001e\u001a\u00020\u000eH\u0002J\b\u00107\u001a\u00020\u0017H\u0016J(\u00108\u001a\u00020\u00172\u0006\u0010\u001e\u001a\u00020\u000e2\u0018\b\u0002\u0010\"\u001a\u0012\u0012\b\u0012\u00060$j\u0002`%\u0012\u0004\u0012\u00020\u00170#JZ\u00109\u001a\u00020\u00172\b\u0010:\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u001e\u001a\u00020\u000e2\b\b\u0002\u0010\u001f\u001a\u00020 2\b\b\u0002\u0010!\u001a\u00020 2\u0018\b\u0002\u0010\"\u001a\u0012\u0012\b\u0012\u00060$j\u0002`%\u0012\u0004\u0012\u00020\u00170#2\n\b\u0002\u0010&\u001a\u0004\u0018\u00010'2\u0006\u0010(\u001a\u00020 JZ\u00109\u001a\u00020\u00172\u0006\u0010\u001c\u001a\u00020\u00142\u0006\u0010\u001d\u001a\u00020\u000f2\u0006\u0010\u001e\u001a\u00020\u000e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020 2\u0016\u0010\"\u001a\u0012\u0012\b\u0012\u00060$j\u0002`%\u0012\u0004\u0012\u00020\u00170#2\b\u0010&\u001a\u0004\u0018\u00010'2\u0006\u0010(\u001a\u00020 H\u0002J\u0010\u0010;\u001a\u0002032\u0006\u00104\u001a\u000205H\u0002J\u0010\u0010<\u001a\u00020=2\u0006\u00104\u001a\u000205H\u0002J\u000e\u0010>\u001a\u00020\u00172\u0006\u0010\u001e\u001a\u00020\u000eJZ\u0010?\u001a\u00020\u00172\u0006\u0010\u001c\u001a\u00020\u00142\u0006\u0010\u001d\u001a\u00020\u000f2\u0006\u0010\u001e\u001a\u00020\u000e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020 2\u0016\u0010\"\u001a\u0012\u0012\b\u0012\u00060$j\u0002`%\u0012\u0004\u0012\u00020\u00170#2\b\u0010&\u001a\u0004\u0018\u00010'2\u0006\u0010(\u001a\u00020 H\u0002J \u0010@\u001a\u00020\u00172\u0006\u00100\u001a\u0002012\u0006\u00102\u001a\u0002032\u0006\u00104\u001a\u000205H\u0002J \u0010A\u001a\u00020\u00172\u0006\u00100\u001a\u0002012\u0006\u00102\u001a\u0002032\u0006\u00104\u001a\u000205H\u0002J\u0018\u0010B\u001a\u00020\u00172\u0006\u0010\u001e\u001a\u00020\u000e2\u0006\u00104\u001a\u00020CH\u0002J\u0018\u0010D\u001a\u00020\u00172\u0006\u0010\u001e\u001a\u00020\u000e2\u0006\u0010E\u001a\u00020FH\u0002J\u000e\u0010G\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0007Je\u0010H\u001a\u00020\u00172\u0006\u0010\u001e\u001a\u00020\u000e2\u0006\u00104\u001a\u0002052K\u0010I\u001aG\u0012\u0013\u0012\u001101\u00a2\u0006\f\bK\u0012\b\bL\u0012\u0004\b\b(0\u0012\u0013\u0012\u001103\u00a2\u0006\f\bK\u0012\b\bL\u0012\u0004\b\b(2\u0012\u0013\u0012\u001105\u00a2\u0006\f\bK\u0012\b\bL\u0012\u0004\b\b(4\u0012\u0004\u0012\u00020\u00170JH\u0002J \u0010M\u001a\u00020\u00172\u0006\u00100\u001a\u0002012\u0006\u00102\u001a\u0002032\u0006\u00104\u001a\u000205H\u0002R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001a\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0010\u001a\u0014\u0012\u0004\u0012\u00020\u000f\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0\u00110\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00150\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006Q"}, d2={"Lorg/jetbrains/plugins/notebooks/jupyter/connections/execution/JupyterCellExecutionManager;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "cellExecutionListeners", "", "Lorg/jetbrains/plugins/notebooks/jupyter/connections/execution/JupyterCellExecutionListener;", "messageIdsLock", "Ljava/lang/Object;", "getProject", "()Lcom/intellij/openapi/project/Project;", "psiCellToMessageId", "Ljava/util/concurrent/ConcurrentHashMap;", "Lorg/jetbrains/plugins/notebooks/jupyter/psi/JupyterCell;", "", "sessionIdToMessageIds", "", "tasksLock", "tasksToExecute", "Lorg/jetbrains/plugins/notebooks/jupyter/editor/JupyterVirtualFile;", "Lorg/jetbrains/plugins/notebooks/jupyter/connections/execution/JupyterCellExecutionManager$TasksExecutorPair;", "addCellExecutionListener", "", "listener", "askLogInAndExecuteCode", "jupyterServer", "Lorg/jetbrains/plugins/notebooks/jupyter/connections/execution/core/JupyterServer;", "virtualFile", "source", "psiCell", "ignoreOutput", "", "cleanOutput", "onError", "Lkotlin/Function1;", "Ljava/lang/Exception;", "Lkotlin/Exception;", "callback", "Lorg/jetbrains/plugins/notebooks/jupyter/connections/execution/core/JupyterCellExecutionCallback;", "silent", "passwordLatch", "Ljava/util/concurrent/CountDownLatch;", "cellExecutionFinished", "cell", "cellExecutionFinished$intellij_python_jupyter", "cellExecutionStarted", "clearOutputs", "notebook", "Lorg/jetbrains/plugins/notebooks/jupyter/nbformat/JupyterNotebook;", "cellIndex", "", "message", "Lorg/jetbrains/plugins/notebooks/jupyter/connections/execution/message/JupyterMessage;", "createCellExecutionCallback", "dispose", "execute", "executeCode", "code", "getExecutionCount", "getExecutionStatus", "Lorg/jetbrains/plugins/notebooks/jupyter/connections/execution/JupyterExecutionStatus;", "interrupt", "logInAndExecuteCode", "onDisplayData", "onExecuteReply", "onInputRequest", "Lorg/jetbrains/plugins/notebooks/jupyter/connections/execution/message/JupyterInputRequestMessage;", "onStatus", "statusMessage", "Lorg/jetbrains/plugins/notebooks/jupyter/connections/execution/message/JupyterStatusMessage;", "removeCellExecutionListener", "updateCell", "doUpdate", "Lkotlin/Function3;", "Lkotlin/ParameterName;", "name", "updateOutputs", "Companion", "ExecutionTask", "TasksExecutorPair", "intellij.python.jupyter"})
public final class JupyterCellExecutionManager
implements Disposable {
    private final ConcurrentHashMap<String, Set<String>> sessionIdToMessageIds;
    private final ConcurrentHashMap<JupyterCell, String> psiCellToMessageId;
    private final Object messageIdsLock;
    private final List<JupyterCellExecutionListener> cellExecutionListeners;
    private final ConcurrentHashMap<JupyterVirtualFile, TasksExecutorPair> tasksToExecute;
    private final Object tasksLock;
    @NotNull
    private final Project project;
    @NotNull
    private static final Logger LOG;
    public static final Companion Companion;

    public final void execute(@NotNull JupyterCell psiCell, @NotNull Function1<? super Exception, Unit> onError) {
        Intrinsics.checkParameterIsNotNull((Object)psiCell, (String)"psiCell");
        Intrinsics.checkParameterIsNotNull(onError, (String)"onError");
        JupyterSource jupyterSource = psiCell.getSource();
        Intrinsics.checkExpressionValueIsNotNull((Object)jupyterSource, (String)"psiCell.source");
        JupyterCellExecutionManager.executeCode$default(this, jupyterSource.getText(), psiCell, false, true, onError, null, false, 32, null);
    }

    public static /* synthetic */ void execute$default(JupyterCellExecutionManager jupyterCellExecutionManager, JupyterCell jupyterCell, Function1 function1, int n, Object object) {
        if ((n & 2) != 0) {
            function1 = execute.1.INSTANCE;
        }
        jupyterCellExecutionManager.execute(jupyterCell, (Function1<? super Exception, Unit>)function1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public final void executeCode(@Nullable String code, @NotNull JupyterCell psiCell, boolean ignoreOutput, boolean cleanOutput, @NotNull Function1<? super Exception, Unit> onError, @Nullable JupyterCellExecutionCallback callback, boolean silent) {
        Intrinsics.checkParameterIsNotNull((Object)psiCell, (String)"psiCell");
        Intrinsics.checkParameterIsNotNull(onError, (String)"onError");
        String string = code;
        if (string == null) {
            JupyterSource jupyterSource = psiCell.getSource();
            Intrinsics.checkExpressionValueIsNotNull((Object)jupyterSource, (String)"psiCell.source");
            string = jupyterSource.getText();
        }
        String source2 = string;
        JupyterVirtualFile virtualFile2 = Companion.getJupyterVirtualFile(psiCell);
        Object object = this.tasksLock;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (object) {
            void tasks;
            boolean bl3 = false;
            TasksExecutorPair tasksExecutorPair = this.tasksToExecute.computeIfAbsent(virtualFile2, executeCode.2.1.INSTANCE);
            ConcurrentLinkedQueue<ExecutionTask> concurrentLinkedQueue = tasksExecutorPair.component1();
            ExecutorService executor = tasksExecutorPair.component2();
            String string2 = source2;
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"source");
            tasks.add(new ExecutionTask(virtualFile2, string2, psiCell, ignoreOutput, cleanOutput, onError, callback, silent));
            Future<?> future2 = executor.submit(new Runnable((ConcurrentLinkedQueue)tasks, this, virtualFile2, source2, psiCell, ignoreOutput, cleanOutput, onError, callback, silent){
                final /* synthetic */ ConcurrentLinkedQueue $tasks;
                final /* synthetic */ JupyterCellExecutionManager this$0;
                final /* synthetic */ JupyterVirtualFile $virtualFile$inlined;
                final /* synthetic */ String $source$inlined;
                final /* synthetic */ JupyterCell $psiCell$inlined;
                final /* synthetic */ boolean $ignoreOutput$inlined;
                final /* synthetic */ boolean $cleanOutput$inlined;
                final /* synthetic */ Function1 $onError$inlined;
                final /* synthetic */ JupyterCellExecutionCallback $callback$inlined;
                final /* synthetic */ boolean $silent$inlined;
                {
                    this.$tasks = concurrentLinkedQueue;
                    this.this$0 = jupyterCellExecutionManager;
                    this.$virtualFile$inlined = jupyterVirtualFile;
                    this.$source$inlined = string;
                    this.$psiCell$inlined = jupyterCell;
                    this.$ignoreOutput$inlined = bl;
                    this.$cleanOutput$inlined = bl2;
                    this.$onError$inlined = function1;
                    this.$callback$inlined = jupyterCellExecutionCallback;
                    this.$silent$inlined = bl3;
                }

                public final void run() {
                    Collection collection = this.$tasks;
                    boolean bl = false;
                    if (!collection.isEmpty()) {
                        ExecutionTask task = (ExecutionTask)this.$tasks.remove();
                        JupyterCellExecutionManager.access$executeCode(this.this$0, task.getVirtualFile(), task.getSource(), task.getPsiCell(), task.getIgnoreOutput(), task.getCleanOutput(), task.getOnError(), task.getCallback(), task.getSilent());
                    }
                }
            });
        }
    }

    public static /* synthetic */ void executeCode$default(JupyterCellExecutionManager jupyterCellExecutionManager, String string, JupyterCell jupyterCell, boolean bl, boolean bl2, Function1 function1, JupyterCellExecutionCallback jupyterCellExecutionCallback, boolean bl3, int n, Object object) {
        if ((n & 4) != 0) {
            bl = false;
        }
        if ((n & 8) != 0) {
            bl2 = true;
        }
        if ((n & 0x10) != 0) {
            function1 = executeCode.1.INSTANCE;
        }
        if ((n & 0x20) != 0) {
            jupyterCellExecutionCallback = null;
        }
        jupyterCellExecutionManager.executeCode(string, jupyterCell, bl, bl2, (Function1<? super Exception, Unit>)function1, jupyterCellExecutionCallback, bl3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void executeCode(JupyterVirtualFile virtualFile2, String source2, JupyterCell psiCell, boolean ignoreOutput, boolean cleanOutput, Function1<? super Exception, Unit> onError, JupyterCellExecutionCallback callback, boolean silent) {
        try {
            JupyterNotebookSession notebookSession = JupyterRuntimeService.Companion.getInstance(this.project).getOrCreateSession(virtualFile2);
            ReadAction.run((ThrowableRunnable)new ThrowableRunnable<E>(cleanOutput, psiCell){
                final /* synthetic */ boolean $cleanOutput;
                final /* synthetic */ JupyterCell $psiCell;

                public final void run() {
                    if (this.$cleanOutput) {
                        JupyterCellExecutionManagerKt.access$cleanOutput(this.$psiCell);
                    }
                }
                {
                    this.$cleanOutput = bl;
                    this.$psiCell = jupyterCell;
                }
            });
            notebookSession.execute(source2, (Function1<? super String, Unit>)((Function1)new Function1<String, Unit>(this, ignoreOutput, notebookSession, psiCell){
                final /* synthetic */ JupyterCellExecutionManager this$0;
                final /* synthetic */ boolean $ignoreOutput;
                final /* synthetic */ JupyterNotebookSession $notebookSession;
                final /* synthetic */ JupyterCell $psiCell;

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public final void invoke(@NotNull String messageId) {
                    Intrinsics.checkParameterIsNotNull((Object)messageId, (String)"messageId");
                    if (!this.$ignoreOutput) {
                        Object object = JupyterCellExecutionManager.access$getMessageIdsLock$p(this.this$0);
                        boolean bl = false;
                        boolean bl2 = false;
                        synchronized (object) {
                            boolean bl3 = false;
                            String sessionId = this.$notebookSession.getSessionId();
                            ((Set)JupyterCellExecutionManager.access$getSessionIdToMessageIds$p(this.this$0).computeIfAbsent(sessionId, executeCode.1.1.INSTANCE)).add(messageId);
                            String string = (String)JupyterCellExecutionManager.access$getPsiCellToMessageId$p(this.this$0).remove(this.$psiCell);
                            if (string != null) {
                                String string2 = string;
                                boolean bl4 = false;
                                boolean bl5 = false;
                                String it = string2;
                                boolean bl6 = false;
                                String string3 = it;
                                Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"it");
                                this.$notebookSession.stopListeningMessageReply(string3);
                            }
                            ((Map)JupyterCellExecutionManager.access$getPsiCellToMessageId$p(this.this$0)).put(this.$psiCell, messageId);
                            Unit unit = Unit.INSTANCE;
                        }
                    }
                }
                {
                    this.this$0 = jupyterCellExecutionManager;
                    this.$ignoreOutput = bl;
                    this.$notebookSession = jupyterNotebookSession;
                    this.$psiCell = jupyterCell;
                    super(1);
                }
            }), !ignoreOutput ? JupyterCellExecutionCallback.Companion.join(CollectionsKt.listOfNotNull((Object[])new JupyterCellExecutionCallback[]{this.createCellExecutionCallback(psiCell), callback})) : JupyterCellExecutionCallback.Companion.join(CollectionsKt.listOfNotNull((Object[])new JupyterCellExecutionCallback[]{JupyterCellExecutionCallbackAdapter.Companion.getINSTANCE(), callback})), silent);
            if (!ignoreOutput) {
                this.cellExecutionStarted(psiCell);
            }
        }
        catch (JupyterRestClientForbiddenException e) {
            this.logInAndExecuteCode(virtualFile2, source2, psiCell, ignoreOutput, cleanOutput, onError, callback, silent);
        }
        catch (JupyterLoginException e) {
            this.logInAndExecuteCode(virtualFile2, source2, psiCell, ignoreOutput, cleanOutput, onError, callback, silent);
        }
        catch (Exception e) {
            onError.invoke((Object)e);
            Object object = this.tasksLock;
            boolean bl = false;
            boolean bl2 = false;
            synchronized (object) {
                Unit unit;
                boolean bl3 = false;
                TasksExecutorPair tasksExecutorPair = this.tasksToExecute.get((Object)virtualFile2);
                if (tasksExecutorPair != null) {
                    tasksExecutorPair.clearTasks();
                    unit = Unit.INSTANCE;
                } else {
                    unit = null;
                }
                Unit unit2 = unit;
            }
        }
    }

    private final void logInAndExecuteCode(JupyterVirtualFile virtualFile2, String source2, JupyterCell psiCell, boolean ignoreOutput, boolean cleanOutput, Function1<? super Exception, Unit> onError, JupyterCellExecutionCallback callback, boolean silent) {
        block6: {
            JupyterServer jupyterServer = JupyterConnectionSettingsUtilKt.getJupyterServer(this.project, (VirtualFile)virtualFile2);
            if (jupyterServer == null) {
                return;
            }
            JupyterServer jupyterServer2 = jupyterServer;
            Function0 invokeAskLogInAndExecuteCode2 = (Function0)new Function0<CountDownLatch>(this, jupyterServer2, virtualFile2, source2, psiCell, ignoreOutput, cleanOutput, onError, callback, silent){
                final /* synthetic */ JupyterCellExecutionManager this$0;
                final /* synthetic */ JupyterServer $jupyterServer;
                final /* synthetic */ JupyterVirtualFile $virtualFile;
                final /* synthetic */ String $source;
                final /* synthetic */ JupyterCell $psiCell;
                final /* synthetic */ boolean $ignoreOutput;
                final /* synthetic */ boolean $cleanOutput;
                final /* synthetic */ Function1 $onError;
                final /* synthetic */ JupyterCellExecutionCallback $callback;
                final /* synthetic */ boolean $silent;

                /*
                 * WARNING - void declaration
                 */
                @NotNull
                public final CountDownLatch invoke() {
                    void var1_1;
                    CountDownLatch passwordLatch = new CountDownLatch(1);
                    ApplicationManager.getApplication().invokeLater(new Runnable(this, passwordLatch){
                        final /* synthetic */ logInAndExecuteCode.invokeAskLogInAndExecuteCode.1 this$0;
                        final /* synthetic */ CountDownLatch $passwordLatch;

                        public final void run() {
                            try {
                                JupyterCellExecutionManager.access$askLogInAndExecuteCode(this.this$0.this$0, this.this$0.$jupyterServer, this.this$0.$virtualFile, this.this$0.$source, this.this$0.$psiCell, this.this$0.$ignoreOutput, this.this$0.$cleanOutput, this.this$0.$onError, this.this$0.$callback, this.this$0.$silent, this.$passwordLatch);
                            }
                            catch (Exception e) {
                                this.$passwordLatch.countDown();
                            }
                        }
                        {
                            this.this$0 = var1_1;
                            this.$passwordLatch = countDownLatch;
                        }
                    });
                    return var1_1;
                }
                {
                    this.this$0 = jupyterCellExecutionManager;
                    this.$jupyterServer = jupyterServer;
                    this.$virtualFile = jupyterVirtualFile;
                    this.$source = string;
                    this.$psiCell = jupyterCell;
                    this.$ignoreOutput = bl;
                    this.$cleanOutput = bl2;
                    this.$onError = function1;
                    this.$callback = jupyterCellExecutionCallback;
                    this.$silent = bl3;
                    super(0);
                }
            };
            OneTimeString rememberedPasswordOrToken = JupyterLoginKt.getRememberedPasswordOrToken(jupyterServer2);
            CountDownLatch latch = null;
            if (rememberedPasswordOrToken == null) {
                latch = (CountDownLatch)invokeAskLogInAndExecuteCode2.invoke();
            } else {
                try {
                    jupyterServer2.logIn(rememberedPasswordOrToken);
                    this.executeCode(virtualFile2, source2, psiCell, ignoreOutput, cleanOutput, onError, callback, silent);
                }
                catch (JupyterRestClientForbiddenException e) {
                    latch = (CountDownLatch)invokeAskLogInAndExecuteCode2.invoke();
                }
                catch (JupyterLoginException e) {
                    latch = (CountDownLatch)invokeAskLogInAndExecuteCode2.invoke();
                }
            }
            CountDownLatch countDownLatch = latch;
            if (countDownLatch == null) break block6;
            countDownLatch.await();
        }
    }

    private final void askLogInAndExecuteCode(JupyterServer jupyterServer, JupyterVirtualFile virtualFile2, String source2, JupyterCell psiCell, boolean ignoreOutput, boolean cleanOutput, Function1<? super Exception, Unit> onError, JupyterCellExecutionCallback callback, boolean silent, CountDownLatch passwordLatch) {
        JupyterLoginDialog authDialog = new JupyterLoginDialog(this.project, jupyterServer);
        authDialog.pack();
        if (authDialog.showAndGet()) {
            OneTimeString passwordOrToken = authDialog.getPasswordOrToken();
            if (authDialog.getRememberPasswordOrToken()) {
                JupyterLoginKt.rememberPasswordOrToken(jupyterServer, passwordOrToken);
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)ApplicationManager.getApplication().executeOnPooledThread(new Runnable(this, jupyterServer, passwordOrToken, virtualFile2, source2, psiCell, ignoreOutput, cleanOutput, onError, callback, silent, passwordLatch){
                final /* synthetic */ JupyterCellExecutionManager this$0;
                final /* synthetic */ JupyterServer $jupyterServer;
                final /* synthetic */ OneTimeString $passwordOrToken;
                final /* synthetic */ JupyterVirtualFile $virtualFile;
                final /* synthetic */ String $source;
                final /* synthetic */ JupyterCell $psiCell;
                final /* synthetic */ boolean $ignoreOutput;
                final /* synthetic */ boolean $cleanOutput;
                final /* synthetic */ Function1 $onError;
                final /* synthetic */ JupyterCellExecutionCallback $callback;
                final /* synthetic */ boolean $silent;
                final /* synthetic */ CountDownLatch $passwordLatch;

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public final void run() {
                    try {
                        this.$jupyterServer.logIn(this.$passwordOrToken);
                        JupyterCellExecutionManager.access$executeCode(this.this$0, this.$virtualFile, this.$source, this.$psiCell, this.$ignoreOutput, this.$cleanOutput, this.$onError, this.$callback, this.$silent);
                    }
                    catch (JupyterRestClientForbiddenException e) {
                        this.$onError.invoke((Object)e);
                        Object object = JupyterCellExecutionManager.access$getTasksLock$p(this.this$0);
                        boolean bl = false;
                        boolean bl2 = false;
                        synchronized (object) {
                            Unit unit;
                            boolean bl3 = false;
                            TasksExecutorPair tasksExecutorPair = (TasksExecutorPair)JupyterCellExecutionManager.access$getTasksToExecute$p(this.this$0).get((Object)((Object)this.$virtualFile));
                            if (tasksExecutorPair != null) {
                                tasksExecutorPair.clearTasks();
                                unit = Unit.INSTANCE;
                            } else {
                                unit = null;
                            }
                            Unit unit2 = unit;
                        }
                    }
                    catch (JupyterLoginException e) {
                        this.$onError.invoke((Object)e);
                        Object object = JupyterCellExecutionManager.access$getTasksLock$p(this.this$0);
                        boolean bl = false;
                        boolean bl4 = false;
                        synchronized (object) {
                            Unit unit;
                            boolean bl5 = false;
                            TasksExecutorPair tasksExecutorPair = (TasksExecutorPair)JupyterCellExecutionManager.access$getTasksToExecute$p(this.this$0).get((Object)((Object)this.$virtualFile));
                            if (tasksExecutorPair != null) {
                                tasksExecutorPair.clearTasks();
                                unit = Unit.INSTANCE;
                            } else {
                                unit = null;
                            }
                            Unit unit3 = unit;
                        }
                    }
                    finally {
                        this.$passwordLatch.countDown();
                    }
                }
                {
                    this.this$0 = jupyterCellExecutionManager;
                    this.$jupyterServer = jupyterServer;
                    this.$passwordOrToken = oneTimeString;
                    this.$virtualFile = jupyterVirtualFile;
                    this.$source = string;
                    this.$psiCell = jupyterCell;
                    this.$ignoreOutput = bl;
                    this.$cleanOutput = bl2;
                    this.$onError = function1;
                    this.$callback = jupyterCellExecutionCallback;
                    this.$silent = bl3;
                    this.$passwordLatch = countDownLatch;
                }
            }), (String)"ApplicationManager.getAp\u2026tDown()\n        }\n      }");
        } else {
            passwordLatch.countDown();
        }
    }

    private final JupyterCellExecutionCallback createCellExecutionCallback(JupyterCell psiCell) {
        return new JupyterCellExecutionCallback(this, psiCell){
            final /* synthetic */ JupyterCellExecutionManager this$0;
            final /* synthetic */ JupyterCell $psiCell;

            public void onStatus(@NotNull JupyterStatusMessage message) {
                Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
                JupyterCellExecutionManagerKt.access$invokeLaterWriteAction((Function0)new Function0<Unit>(this, message){
                    final /* synthetic */ createCellExecutionCallback.1 this$0;
                    final /* synthetic */ JupyterStatusMessage $message;

                    public final void invoke() {
                        JupyterCellExecutionManager.access$onStatus(this.this$0.this$0, this.this$0.$psiCell, this.$message);
                    }
                    {
                        this.this$0 = var1_1;
                        this.$message = jupyterStatusMessage;
                        super(0);
                    }
                });
            }

            public void onExecuteInput(@NotNull JupyterMessage message) {
                Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
            }

            public void onUpdateOutput(@NotNull JupyterMessage message) {
                Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
                JupyterCellExecutionManagerKt.access$invokeLaterWriteAction((Function0)new Function0<Unit>(this, message){
                    final /* synthetic */ createCellExecutionCallback.1 this$0;
                    final /* synthetic */ JupyterMessage $message;

                    public final void invoke() {
                        JupyterCellExecutionManager.access$updateCell(this.this$0.this$0, this.this$0.$psiCell, this.$message, (Function3)new Function3<JupyterNotebook, Integer, JupyterMessage, Unit>(this.this$0.this$0){

                            public final void invoke(@NotNull JupyterNotebook p1, int p2, @NotNull JupyterMessage p3) {
                                Intrinsics.checkParameterIsNotNull((Object)p1, (String)"p1");
                                Intrinsics.checkParameterIsNotNull((Object)p3, (String)"p3");
                                JupyterCellExecutionManager.access$updateOutputs((JupyterCellExecutionManager)this.receiver, p1, p2, p3);
                            }

                            public final KDeclarationContainer getOwner() {
                                return Reflection.getOrCreateKotlinClass(JupyterCellExecutionManager.class);
                            }

                            public final String getName() {
                                return "updateOutputs";
                            }

                            public final String getSignature() {
                                return "updateOutputs(Lorg/jetbrains/plugins/notebooks/jupyter/nbformat/JupyterNotebook;ILorg/jetbrains/plugins/notebooks/jupyter/connections/execution/message/JupyterMessage;)V";
                            }
                        });
                    }
                    {
                        this.this$0 = var1_1;
                        this.$message = jupyterMessage;
                        super(0);
                    }
                });
            }

            public void onExecuteReply(@NotNull JupyterMessage message) {
                Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
                JupyterCellExecutionManagerKt.access$invokeLaterWriteAction((Function0)new Function0<Unit>(this, message){
                    final /* synthetic */ createCellExecutionCallback.1 this$0;
                    final /* synthetic */ JupyterMessage $message;

                    public final void invoke() {
                        JupyterCellExecutionManager.access$updateCell(this.this$0.this$0, this.this$0.$psiCell, this.$message, (Function3)new Function3<JupyterNotebook, Integer, JupyterMessage, Unit>(this){
                            final /* synthetic */ createCellExecutionCallback.onExecuteReply.1 this$0;

                            public final void invoke(@NotNull JupyterNotebook notebook, int cellIndex, @NotNull JupyterMessage m) {
                                Intrinsics.checkParameterIsNotNull((Object)notebook, (String)"notebook");
                                Intrinsics.checkParameterIsNotNull((Object)m, (String)"m");
                                JupyterCellExecutionManager.access$onExecuteReply(this.this$0.this$0.this$0, notebook, cellIndex, m);
                            }
                            {
                                this.this$0 = var1_1;
                                super(3);
                            }
                        });
                    }
                    {
                        this.this$0 = var1_1;
                        this.$message = jupyterMessage;
                        super(0);
                    }
                });
            }

            public void onDisplayData(@NotNull JupyterMessage message) {
                Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
                JupyterCellExecutionManagerKt.access$invokeLaterWriteAction((Function0)new Function0<Unit>(this, message){
                    final /* synthetic */ createCellExecutionCallback.1 this$0;
                    final /* synthetic */ JupyterMessage $message;

                    public final void invoke() {
                        JupyterCellExecutionManager.access$updateCell(this.this$0.this$0, this.this$0.$psiCell, this.$message, (Function3)new Function3<JupyterNotebook, Integer, JupyterMessage, Unit>(this){
                            final /* synthetic */ createCellExecutionCallback.onDisplayData.1 this$0;

                            public final void invoke(@NotNull JupyterNotebook notebook, int cellIndex, @NotNull JupyterMessage m) {
                                Intrinsics.checkParameterIsNotNull((Object)notebook, (String)"notebook");
                                Intrinsics.checkParameterIsNotNull((Object)m, (String)"m");
                                JupyterCellExecutionManager.access$onDisplayData(this.this$0.this$0.this$0, notebook, cellIndex, m);
                            }
                            {
                                this.this$0 = var1_1;
                                super(3);
                            }
                        });
                    }
                    {
                        this.this$0 = var1_1;
                        this.$message = jupyterMessage;
                        super(0);
                    }
                });
            }

            public void onClearOutput(@NotNull JupyterMessage message) {
                Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
                JupyterCellExecutionManagerKt.access$invokeLaterWriteAction((Function0)new Function0<Unit>(this, message){
                    final /* synthetic */ createCellExecutionCallback.1 this$0;
                    final /* synthetic */ JupyterMessage $message;

                    public final void invoke() {
                        JupyterCellExecutionManager.access$updateCell(this.this$0.this$0, this.this$0.$psiCell, this.$message, (Function3)new Function3<JupyterNotebook, Integer, JupyterMessage, Unit>(this){
                            final /* synthetic */ createCellExecutionCallback.onClearOutput.1 this$0;

                            public final void invoke(@NotNull JupyterNotebook notebook, int cellIndex, @NotNull JupyterMessage m) {
                                Intrinsics.checkParameterIsNotNull((Object)notebook, (String)"notebook");
                                Intrinsics.checkParameterIsNotNull((Object)m, (String)"m");
                                JupyterCellExecutionManager.access$clearOutputs(this.this$0.this$0.this$0, notebook, cellIndex, m);
                            }
                            {
                                this.this$0 = var1_1;
                                super(3);
                            }
                        });
                    }
                    {
                        this.this$0 = var1_1;
                        this.$message = jupyterMessage;
                        super(0);
                    }
                });
            }

            public void onInputRequest(@NotNull JupyterInputRequestMessage message) {
                Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
                JupyterCellExecutionManagerKt.access$invokeLaterWriteAction((Function0)new Function0<Unit>(this, message){
                    final /* synthetic */ createCellExecutionCallback.1 this$0;
                    final /* synthetic */ JupyterInputRequestMessage $message;

                    public final void invoke() {
                        JupyterCellExecutionManager.access$onInputRequest(this.this$0.this$0, this.this$0.$psiCell, this.$message);
                    }
                    {
                        this.this$0 = var1_1;
                        this.$message = jupyterInputRequestMessage;
                        super(0);
                    }
                });
            }

            public void onInspectReply(@NotNull JupyterMessage message) {
                Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
                JupyterCellExecutionManager.Companion.getLOG().warn("Not implemented: inspect_reply message received");
            }
            {
                this.this$0 = $outer;
                this.$psiCell = $captured_local_variable$1;
            }
        };
    }

    public final void interrupt(@NotNull JupyterCell psiCell) {
        block0: {
            Intrinsics.checkParameterIsNotNull((Object)psiCell, (String)"psiCell");
            JupyterNotebookSession session = JupyterRuntimeService.Companion.getInstance(this.project).getSession((VirtualFile)Companion.getJupyterVirtualFile(psiCell));
            Object object = session;
            if (object == null || (object = object.getKernelClient()) == null) break block0;
            ((JupyterKernelClient)object).interrupt();
        }
    }

    private final void updateCell(JupyterCell psiCell, JupyterMessage message, Function3<? super JupyterNotebook, ? super Integer, ? super JupyterMessage, Unit> doUpdate) {
        WriteAction.run((ThrowableRunnable)new ThrowableRunnable<E>(doUpdate, psiCell, message){
            final /* synthetic */ Function3 $doUpdate;
            final /* synthetic */ JupyterCell $psiCell;
            final /* synthetic */ JupyterMessage $message;

            public final void run() {
                PsiFile psiFile = this.$psiCell.getContainingFile();
                Intrinsics.checkExpressionValueIsNotNull((Object)psiFile, (String)"psiCell.containingFile");
                VirtualFile virtualFile2 = psiFile.getVirtualFile();
                if (virtualFile2 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.plugins.notebooks.jupyter.editor.JupyterVirtualFile");
                }
                this.$doUpdate.invoke((Object)((JupyterVirtualFile)virtualFile2).getNotebook(), (Object)JupyterPsiChangeListenerKt.getCellIndex(this.$psiCell), (Object)this.$message);
            }
            {
                this.$doUpdate = function3;
                this.$psiCell = jupyterCell;
                this.$message = jupyterMessage;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void onStatus(JupyterCell psiCell, JupyterStatusMessage statusMessage) {
        JupyterNotebookSession session;
        if (statusMessage.getExecutionState() == JupyterStatusMessage.JupyterExecutionState.IDLE) {
            JupyterMessageHeader jupyterMessageHeader = statusMessage.getParentHeader();
            String sessionId = jupyterMessageHeader != null ? jupyterMessageHeader.getSession() : null;
            Object object = this.messageIdsLock;
            boolean bl = false;
            boolean bl2 = false;
            synchronized (object) {
                Set executedMessages;
                boolean bl3 = false;
                Object object2 = this.sessionIdToMessageIds;
                String string = sessionId;
                boolean bl4 = false;
                Set set = executedMessages = (Set)object2.get(string);
                if (set != null) {
                    object2 = set;
                    JupyterMessageHeader jupyterMessageHeader2 = statusMessage.getParentHeader();
                    string = jupyterMessageHeader2 != null ? jupyterMessageHeader2.getMessageId() : null;
                    bl4 = false;
                    Object object3 = object2;
                    if (object3 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type kotlin.collections.MutableCollection<T>");
                    }
                    TypeIntrinsics.asMutableCollection((Object)object3).remove(string);
                }
                if (executedMessages == null || executedMessages.isEmpty()) {
                    this.cellExecutionFinished$intellij_python_jupyter(psiCell);
                }
                Unit unit = Unit.INSTANCE;
            }
        }
        if ((session = JupyterRuntimeService.Companion.getInstance(this.project).getSession((VirtualFile)Companion.getJupyterVirtualFile(psiCell))) != null) {
            LOG.debug("Execution State: " + (Object)((Object)statusMessage.getExecutionState()));
        }
    }

    private final void updateOutputs(JupyterNotebook notebook, int cellIndex, JupyterMessage message) {
        notebook.getCells().get(cellIndex).setOutputs(JupyterOutputsBase.Companion.update(notebook.getCells().get(cellIndex).getOutputs(), message));
    }

    private final void clearOutputs(JupyterNotebook notebook, int cellIndex, JupyterMessage message) {
        notebook.getCells().get(cellIndex).setOutputs(null);
    }

    private final void onExecuteReply(JupyterNotebook notebook, int cellIndex, JupyterMessage message) {
        if (this.getExecutionStatus(message) != JupyterExecutionStatus.ABORTED) {
            org.jetbrains.plugins.notebooks.jupyter.nbformat.JupyterCell jupyterCell = notebook.getCells().get(cellIndex);
            boolean bl = false;
            boolean bl2 = false;
            org.jetbrains.plugins.notebooks.jupyter.nbformat.JupyterCell $this$apply = jupyterCell;
            boolean bl3 = false;
            $this$apply.setExecutionCount(this.getExecutionCount(message));
            $this$apply.setExecuting(false);
            String info = JupyterOutputsBaseKt.getIntrospectionInfo(message);
            if (info != null) {
                CharSequence charSequence = info;
                bl2 = false;
                if (charSequence.length() > 0) {
                    JupyterVarsToolWindowManager.Companion.getInstance(this.project).showIntrospectionInfo(info);
                }
            }
        } else {
            org.jetbrains.plugins.notebooks.jupyter.nbformat.JupyterCell jupyterCell = notebook.getCells().get(cellIndex);
            boolean bl = false;
            boolean bl4 = false;
            org.jetbrains.plugins.notebooks.jupyter.nbformat.JupyterCell $this$apply = jupyterCell;
            boolean bl5 = false;
            $this$apply.setExecutionCount(null);
            $this$apply.setExecuting(false);
        }
    }

    private final JupyterExecutionStatus getExecutionStatus(JupyterMessage message) {
        JsonElement jsonElement = message.getMessageContent().get("status");
        Intrinsics.checkExpressionValueIsNotNull((Object)jsonElement, (String)"message.messageContent[\"status\"]");
        String string = jsonElement.getAsString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"message.messageContent[\"status\"].asString");
        String string2 = string;
        boolean bl = false;
        String string3 = string2;
        if (string3 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        String string4 = string3.toUpperCase();
        Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"(this as java.lang.String).toUpperCase()");
        return JupyterExecutionStatus.valueOf(string4);
    }

    private final int getExecutionCount(JupyterMessage message) {
        JsonElement jsonElement = message.getMessageContent().get("execution_count");
        Intrinsics.checkExpressionValueIsNotNull((Object)jsonElement, (String)"message.messageContent[\"execution_count\"]");
        return jsonElement.getAsInt();
    }

    private final void onDisplayData(JupyterNotebook notebook, int cellIndex, JupyterMessage message) {
        JupyterOutputsBase.Companion.update(notebook.getCells().get(cellIndex).getOutputs(), message);
    }

    private final void onInputRequest(JupyterCell psiCell, JupyterInputRequestMessage message) {
        String string;
        String prompt;
        String string2 = message.getPrompt();
        if (string2 == null) {
            string2 = prompt = "Enter value";
        }
        if (message.isPassword()) {
            string = Messages.showPasswordDialog((Project)this.project, (String)prompt, (String)"Jupyter Input Request", null);
            if (string == null) {
                string = "";
            }
        } else {
            string = Messages.showInputDialog((Project)this.project, (String)prompt, (String)"Jupyter Input Request", null);
            if (string == null) {
                string = "";
            }
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"if (message.isPassword) \u2026_TITLE, null) ?: \"\"\n    }");
        String variable = string;
        String string3 = message.getHeader().getSession();
        if (string3 == null) {
            JupyterCellExecutionManager jupyterCellExecutionManager = this;
            boolean bl = false;
            boolean bl2 = false;
            JupyterCellExecutionManager $this$run = jupyterCellExecutionManager;
            boolean bl3 = false;
            LOG.error("Session id is not defined");
            return;
        }
        String sessionId = string3;
        JupyterMessage inputReplyMessage = new JupyterInputReplyMessageBuilder(variable, sessionId, null, 4, null).build();
        JupyterNotebookSession notebookSession = JupyterRuntimeService.Companion.getInstance(this.project).getOrCreateSession(Companion.getJupyterVirtualFile(psiCell));
        notebookSession.sendMessage(inputReplyMessage, this.createCellExecutionCallback(psiCell));
    }

    public final void addCellExecutionListener(@NotNull JupyterCellExecutionListener listener) {
        Intrinsics.checkParameterIsNotNull((Object)listener, (String)"listener");
        this.cellExecutionListeners.add(listener);
    }

    public final void removeCellExecutionListener(@NotNull JupyterCellExecutionListener listener) {
        Intrinsics.checkParameterIsNotNull((Object)listener, (String)"listener");
        this.cellExecutionListeners.remove(listener);
    }

    private final void cellExecutionStarted(JupyterCell cell) {
        Iterable $this$forEach$iv = this.cellExecutionListeners;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            JupyterCellExecutionListener it = (JupyterCellExecutionListener)element$iv;
            boolean bl = false;
            it.executionStarted(cell);
        }
    }

    public final void cellExecutionFinished$intellij_python_jupyter(@NotNull JupyterCell cell) {
        Intrinsics.checkParameterIsNotNull((Object)cell, (String)"cell");
        if (!JupyterEditorActionsKt.isUnderDebugger(this.project, cell)) {
            Iterable $this$forEach$iv = this.cellExecutionListeners;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                JupyterCellExecutionListener it = (JupyterCellExecutionListener)element$iv;
                boolean bl = false;
                it.executionFinished(cell);
            }
        }
    }

    public void dispose() {
        this.psiCellToMessageId.clear();
        this.cellExecutionListeners.clear();
        this.tasksToExecute.clear();
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    public JupyterCellExecutionManager(@NotNull Project project) {
        List list;
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        this.project = project;
        this.sessionIdToMessageIds = new ConcurrentHashMap();
        this.psiCellToMessageId = new ConcurrentHashMap();
        this.messageIdsLock = new Object();
        JupyterCellExecutionManager jupyterCellExecutionManager = this;
        boolean bl = false;
        jupyterCellExecutionManager.cellExecutionListeners = list = (List)new ArrayList();
        this.tasksToExecute = new ConcurrentHashMap();
        this.tasksLock = new Object();
        this.addCellExecutionListener(JupyterVarsToolWindowManager.Companion.getInstance(this.project));
    }

    static {
        Companion = new Companion(null);
        Logger logger2 = Logger.getInstance(MethodHandles.lookup().lookupClass());
        Intrinsics.checkExpressionValueIsNotNull((Object)logger2, (String)"Logger.getInstance(Metho\u2026s.lookup().lookupClass())");
        LOG = logger2;
    }

    public static final /* synthetic */ void access$executeCode(JupyterCellExecutionManager $this, JupyterVirtualFile virtualFile2, String source2, JupyterCell psiCell, boolean ignoreOutput, boolean cleanOutput, Function1 onError, JupyterCellExecutionCallback callback, boolean silent) {
        $this.executeCode(virtualFile2, source2, psiCell, ignoreOutput, cleanOutput, (Function1<? super Exception, Unit>)onError, callback, silent);
    }

    public static final /* synthetic */ Object access$getMessageIdsLock$p(JupyterCellExecutionManager $this) {
        return $this.messageIdsLock;
    }

    public static final /* synthetic */ ConcurrentHashMap access$getSessionIdToMessageIds$p(JupyterCellExecutionManager $this) {
        return $this.sessionIdToMessageIds;
    }

    public static final /* synthetic */ ConcurrentHashMap access$getPsiCellToMessageId$p(JupyterCellExecutionManager $this) {
        return $this.psiCellToMessageId;
    }

    public static final /* synthetic */ void access$askLogInAndExecuteCode(JupyterCellExecutionManager $this, JupyterServer jupyterServer, JupyterVirtualFile virtualFile2, String source2, JupyterCell psiCell, boolean ignoreOutput, boolean cleanOutput, Function1 onError, JupyterCellExecutionCallback callback, boolean silent, CountDownLatch passwordLatch) {
        $this.askLogInAndExecuteCode(jupyterServer, virtualFile2, source2, psiCell, ignoreOutput, cleanOutput, (Function1<? super Exception, Unit>)onError, callback, silent, passwordLatch);
    }

    public static final /* synthetic */ Object access$getTasksLock$p(JupyterCellExecutionManager $this) {
        return $this.tasksLock;
    }

    public static final /* synthetic */ ConcurrentHashMap access$getTasksToExecute$p(JupyterCellExecutionManager $this) {
        return $this.tasksToExecute;
    }

    public static final /* synthetic */ void access$onStatus(JupyterCellExecutionManager $this, JupyterCell psiCell, JupyterStatusMessage statusMessage) {
        $this.onStatus(psiCell, statusMessage);
    }

    public static final /* synthetic */ void access$updateCell(JupyterCellExecutionManager $this, JupyterCell psiCell, JupyterMessage message, Function3 doUpdate) {
        $this.updateCell(psiCell, message, (Function3<? super JupyterNotebook, ? super Integer, ? super JupyterMessage, Unit>)doUpdate);
    }

    public static final /* synthetic */ void access$updateOutputs(JupyterCellExecutionManager $this, JupyterNotebook notebook, int cellIndex, JupyterMessage message) {
        $this.updateOutputs(notebook, cellIndex, message);
    }

    public static final /* synthetic */ void access$onExecuteReply(JupyterCellExecutionManager $this, JupyterNotebook notebook, int cellIndex, JupyterMessage message) {
        $this.onExecuteReply(notebook, cellIndex, message);
    }

    public static final /* synthetic */ void access$onDisplayData(JupyterCellExecutionManager $this, JupyterNotebook notebook, int cellIndex, JupyterMessage message) {
        $this.onDisplayData(notebook, cellIndex, message);
    }

    public static final /* synthetic */ void access$clearOutputs(JupyterCellExecutionManager $this, JupyterNotebook notebook, int cellIndex, JupyterMessage message) {
        $this.clearOutputs(notebook, cellIndex, message);
    }

    public static final /* synthetic */ void access$onInputRequest(JupyterCellExecutionManager $this, JupyterCell psiCell, JupyterInputRequestMessage message) {
        $this.onInputRequest(psiCell, message);
    }

    @JvmStatic
    @NotNull
    public static final JupyterCellExecutionManager getInstance(@NotNull Project project) {
        return Companion.getInstance(project);
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u001b\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0006\u0010\f\u001a\u00020\rJ\u000f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\t\u0010\u000f\u001a\u00020\u0006H\u00c6\u0003J#\u0010\u0010\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0006H\u00c6\u0001J\u0013\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/plugins/notebooks/jupyter/connections/execution/JupyterCellExecutionManager$TasksExecutorPair;", "", "tasks", "Ljava/util/concurrent/ConcurrentLinkedQueue;", "Lorg/jetbrains/plugins/notebooks/jupyter/connections/execution/JupyterCellExecutionManager$ExecutionTask;", "executor", "Ljava/util/concurrent/ExecutorService;", "(Ljava/util/concurrent/ConcurrentLinkedQueue;Ljava/util/concurrent/ExecutorService;)V", "getExecutor", "()Ljava/util/concurrent/ExecutorService;", "getTasks", "()Ljava/util/concurrent/ConcurrentLinkedQueue;", "clearTasks", "", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "intellij.python.jupyter"})
    private static final class TasksExecutorPair {
        @NotNull
        private final ConcurrentLinkedQueue<ExecutionTask> tasks;
        @NotNull
        private final ExecutorService executor;

        public final void clearTasks() {
            this.tasks.clear();
        }

        @NotNull
        public final ConcurrentLinkedQueue<ExecutionTask> getTasks() {
            return this.tasks;
        }

        @NotNull
        public final ExecutorService getExecutor() {
            return this.executor;
        }

        public TasksExecutorPair(@NotNull ConcurrentLinkedQueue<ExecutionTask> tasks, @NotNull ExecutorService executor) {
            Intrinsics.checkParameterIsNotNull(tasks, (String)"tasks");
            Intrinsics.checkParameterIsNotNull((Object)executor, (String)"executor");
            this.tasks = tasks;
            this.executor = executor;
        }

        @NotNull
        public final ConcurrentLinkedQueue<ExecutionTask> component1() {
            return this.tasks;
        }

        @NotNull
        public final ExecutorService component2() {
            return this.executor;
        }

        @NotNull
        public final TasksExecutorPair copy(@NotNull ConcurrentLinkedQueue<ExecutionTask> tasks, @NotNull ExecutorService executor) {
            Intrinsics.checkParameterIsNotNull(tasks, (String)"tasks");
            Intrinsics.checkParameterIsNotNull((Object)executor, (String)"executor");
            return new TasksExecutorPair(tasks, executor);
        }

        public static /* synthetic */ TasksExecutorPair copy$default(TasksExecutorPair tasksExecutorPair, ConcurrentLinkedQueue concurrentLinkedQueue, ExecutorService executorService, int n, Object object) {
            if ((n & 1) != 0) {
                concurrentLinkedQueue = tasksExecutorPair.tasks;
            }
            if ((n & 2) != 0) {
                executorService = tasksExecutorPair.executor;
            }
            return tasksExecutorPair.copy(concurrentLinkedQueue, executorService);
        }

        @NotNull
        public String toString() {
            return "TasksExecutorPair(tasks=" + this.tasks + ", executor=" + this.executor + ")";
        }

        public int hashCode() {
            ConcurrentLinkedQueue<ExecutionTask> concurrentLinkedQueue = this.tasks;
            ExecutorService executorService = this.executor;
            return (concurrentLinkedQueue != null ? concurrentLinkedQueue.hashCode() : 0) * 31 + (executorService != null ? executorService.hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof TasksExecutorPair)) break block3;
                    TasksExecutorPair tasksExecutorPair = (TasksExecutorPair)object;
                    if (!Intrinsics.areEqual(this.tasks, tasksExecutorPair.tasks) || !Intrinsics.areEqual((Object)this.executor, (Object)tasksExecutorPair.executor)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u001c\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001BW\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\t\u0012\u0016\u0010\u000b\u001a\u0012\u0012\b\u0012\u00060\rj\u0002`\u000e\u0012\u0004\u0012\u00020\u000f0\f\u0012\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011\u0012\u0006\u0010\u0012\u001a\u00020\t\u00a2\u0006\u0002\u0010\u0013J\t\u0010\"\u001a\u00020\u0003H\u00c6\u0003J\t\u0010#\u001a\u00020\u0005H\u00c6\u0003J\t\u0010$\u001a\u00020\u0007H\u00c6\u0003J\t\u0010%\u001a\u00020\tH\u00c6\u0003J\t\u0010&\u001a\u00020\tH\u00c6\u0003J\u0019\u0010'\u001a\u0012\u0012\b\u0012\u00060\rj\u0002`\u000e\u0012\u0004\u0012\u00020\u000f0\fH\u00c6\u0003J\u000b\u0010(\u001a\u0004\u0018\u00010\u0011H\u00c6\u0003J\t\u0010)\u001a\u00020\tH\u00c6\u0003Jk\u0010*\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\t2\u0018\b\u0002\u0010\u000b\u001a\u0012\u0012\b\u0012\u00060\rj\u0002`\u000e\u0012\u0004\u0012\u00020\u000f0\f2\n\b\u0002\u0010\u0010\u001a\u0004\u0018\u00010\u00112\b\b\u0002\u0010\u0012\u001a\u00020\tH\u00c6\u0001J\u0013\u0010+\u001a\u00020\t2\b\u0010,\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010-\u001a\u00020.H\u00d6\u0001J\t\u0010/\u001a\u00020\u0005H\u00d6\u0001R\u0013\u0010\u0010\u001a\u0004\u0018\u00010\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\n\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0017R!\u0010\u000b\u001a\u0012\u0012\b\u0012\u00060\rj\u0002`\u000e\u0012\u0004\u0012\u00020\u000f0\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0011\u0010\u0012\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u0017R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!\u00a8\u00060"}, d2={"Lorg/jetbrains/plugins/notebooks/jupyter/connections/execution/JupyterCellExecutionManager$ExecutionTask;", "", "virtualFile", "Lorg/jetbrains/plugins/notebooks/jupyter/editor/JupyterVirtualFile;", "source", "", "psiCell", "Lorg/jetbrains/plugins/notebooks/jupyter/psi/JupyterCell;", "ignoreOutput", "", "cleanOutput", "onError", "Lkotlin/Function1;", "Ljava/lang/Exception;", "Lkotlin/Exception;", "", "callback", "Lorg/jetbrains/plugins/notebooks/jupyter/connections/execution/core/JupyterCellExecutionCallback;", "silent", "(Lorg/jetbrains/plugins/notebooks/jupyter/editor/JupyterVirtualFile;Ljava/lang/String;Lorg/jetbrains/plugins/notebooks/jupyter/psi/JupyterCell;ZZLkotlin/jvm/functions/Function1;Lorg/jetbrains/plugins/notebooks/jupyter/connections/execution/core/JupyterCellExecutionCallback;Z)V", "getCallback", "()Lorg/jetbrains/plugins/notebooks/jupyter/connections/execution/core/JupyterCellExecutionCallback;", "getCleanOutput", "()Z", "getIgnoreOutput", "getOnError", "()Lkotlin/jvm/functions/Function1;", "getPsiCell", "()Lorg/jetbrains/plugins/notebooks/jupyter/psi/JupyterCell;", "getSilent", "getSource", "()Ljava/lang/String;", "getVirtualFile", "()Lorg/jetbrains/plugins/notebooks/jupyter/editor/JupyterVirtualFile;", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "component8", "copy", "equals", "other", "hashCode", "", "toString", "intellij.python.jupyter"})
    private static final class ExecutionTask {
        @NotNull
        private final JupyterVirtualFile virtualFile;
        @NotNull
        private final String source;
        @NotNull
        private final JupyterCell psiCell;
        private final boolean ignoreOutput;
        private final boolean cleanOutput;
        @NotNull
        private final Function1<Exception, Unit> onError;
        @Nullable
        private final JupyterCellExecutionCallback callback;
        private final boolean silent;

        @NotNull
        public final JupyterVirtualFile getVirtualFile() {
            return this.virtualFile;
        }

        @NotNull
        public final String getSource() {
            return this.source;
        }

        @NotNull
        public final JupyterCell getPsiCell() {
            return this.psiCell;
        }

        public final boolean getIgnoreOutput() {
            return this.ignoreOutput;
        }

        public final boolean getCleanOutput() {
            return this.cleanOutput;
        }

        @NotNull
        public final Function1<Exception, Unit> getOnError() {
            return this.onError;
        }

        @Nullable
        public final JupyterCellExecutionCallback getCallback() {
            return this.callback;
        }

        public final boolean getSilent() {
            return this.silent;
        }

        public ExecutionTask(@NotNull JupyterVirtualFile virtualFile2, @NotNull String source2, @NotNull JupyterCell psiCell, boolean ignoreOutput, boolean cleanOutput, @NotNull Function1<? super Exception, Unit> onError, @Nullable JupyterCellExecutionCallback callback, boolean silent) {
            Intrinsics.checkParameterIsNotNull((Object)((Object)virtualFile2), (String)"virtualFile");
            Intrinsics.checkParameterIsNotNull((Object)source2, (String)"source");
            Intrinsics.checkParameterIsNotNull((Object)psiCell, (String)"psiCell");
            Intrinsics.checkParameterIsNotNull(onError, (String)"onError");
            this.virtualFile = virtualFile2;
            this.source = source2;
            this.psiCell = psiCell;
            this.ignoreOutput = ignoreOutput;
            this.cleanOutput = cleanOutput;
            this.onError = onError;
            this.callback = callback;
            this.silent = silent;
        }

        @NotNull
        public final JupyterVirtualFile component1() {
            return this.virtualFile;
        }

        @NotNull
        public final String component2() {
            return this.source;
        }

        @NotNull
        public final JupyterCell component3() {
            return this.psiCell;
        }

        public final boolean component4() {
            return this.ignoreOutput;
        }

        public final boolean component5() {
            return this.cleanOutput;
        }

        @NotNull
        public final Function1<Exception, Unit> component6() {
            return this.onError;
        }

        @Nullable
        public final JupyterCellExecutionCallback component7() {
            return this.callback;
        }

        public final boolean component8() {
            return this.silent;
        }

        @NotNull
        public final ExecutionTask copy(@NotNull JupyterVirtualFile virtualFile2, @NotNull String source2, @NotNull JupyterCell psiCell, boolean ignoreOutput, boolean cleanOutput, @NotNull Function1<? super Exception, Unit> onError, @Nullable JupyterCellExecutionCallback callback, boolean silent) {
            Intrinsics.checkParameterIsNotNull((Object)((Object)virtualFile2), (String)"virtualFile");
            Intrinsics.checkParameterIsNotNull((Object)source2, (String)"source");
            Intrinsics.checkParameterIsNotNull((Object)psiCell, (String)"psiCell");
            Intrinsics.checkParameterIsNotNull(onError, (String)"onError");
            return new ExecutionTask(virtualFile2, source2, psiCell, ignoreOutput, cleanOutput, onError, callback, silent);
        }

        public static /* synthetic */ ExecutionTask copy$default(ExecutionTask executionTask, JupyterVirtualFile jupyterVirtualFile, String string, JupyterCell jupyterCell, boolean bl, boolean bl2, Function1 function1, JupyterCellExecutionCallback jupyterCellExecutionCallback, boolean bl3, int n, Object object) {
            if ((n & 1) != 0) {
                jupyterVirtualFile = executionTask.virtualFile;
            }
            if ((n & 2) != 0) {
                string = executionTask.source;
            }
            if ((n & 4) != 0) {
                jupyterCell = executionTask.psiCell;
            }
            if ((n & 8) != 0) {
                bl = executionTask.ignoreOutput;
            }
            if ((n & 0x10) != 0) {
                bl2 = executionTask.cleanOutput;
            }
            if ((n & 0x20) != 0) {
                function1 = executionTask.onError;
            }
            if ((n & 0x40) != 0) {
                jupyterCellExecutionCallback = executionTask.callback;
            }
            if ((n & 0x80) != 0) {
                bl3 = executionTask.silent;
            }
            return executionTask.copy(jupyterVirtualFile, string, jupyterCell, bl, bl2, function1, jupyterCellExecutionCallback, bl3);
        }

        @NotNull
        public String toString() {
            return "ExecutionTask(virtualFile=" + (Object)((Object)this.virtualFile) + ", source=" + this.source + ", psiCell=" + this.psiCell + ", ignoreOutput=" + this.ignoreOutput + ", cleanOutput=" + this.cleanOutput + ", onError=" + this.onError + ", callback=" + this.callback + ", silent=" + this.silent + ")";
        }

        public int hashCode() {
            JupyterVirtualFile jupyterVirtualFile = this.virtualFile;
            String string = this.source;
            JupyterCell jupyterCell = this.psiCell;
            int n = (((jupyterVirtualFile != null ? ((Object)((Object)jupyterVirtualFile)).hashCode() : 0) * 31 + (string != null ? string.hashCode() : 0)) * 31 + (jupyterCell != null ? jupyterCell.hashCode() : 0)) * 31;
            int n2 = this.ignoreOutput ? 1 : 0;
            if (n2 != 0) {
                n2 = 1;
            }
            int n3 = (n + n2) * 31;
            int n4 = this.cleanOutput ? 1 : 0;
            if (n4 != 0) {
                n4 = 1;
            }
            Function1<Exception, Unit> function1 = this.onError;
            JupyterCellExecutionCallback jupyterCellExecutionCallback = this.callback;
            int n5 = (((n3 + n4) * 31 + (function1 != null ? function1.hashCode() : 0)) * 31 + (jupyterCellExecutionCallback != null ? jupyterCellExecutionCallback.hashCode() : 0)) * 31;
            int n6 = this.silent ? 1 : 0;
            if (n6 != 0) {
                n6 = 1;
            }
            return n5 + n6;
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof ExecutionTask)) break block3;
                    ExecutionTask executionTask = (ExecutionTask)object;
                    if (!Intrinsics.areEqual((Object)((Object)this.virtualFile), (Object)((Object)executionTask.virtualFile)) || !Intrinsics.areEqual((Object)this.source, (Object)executionTask.source) || !Intrinsics.areEqual((Object)this.psiCell, (Object)executionTask.psiCell) || !(this.ignoreOutput == executionTask.ignoreOutput) || !(this.cleanOutput == executionTask.cleanOutput) || !Intrinsics.areEqual(this.onError, executionTask.onError) || !Intrinsics.areEqual((Object)this.callback, (Object)executionTask.callback) || !(this.silent == executionTask.silent)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0007J\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eJ\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u0010J\n\u0010\u0011\u001a\u00020\u000e*\u00020\u0010R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/plugins/notebooks/jupyter/connections/execution/JupyterCellExecutionManager$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "getInstance", "Lorg/jetbrains/plugins/notebooks/jupyter/connections/execution/JupyterCellExecutionManager;", "project", "Lcom/intellij/openapi/project/Project;", "getSessionPath", "", "virtualFile", "Lorg/jetbrains/plugins/notebooks/jupyter/editor/JupyterVirtualFile;", "psiCell", "Lorg/jetbrains/plugins/notebooks/jupyter/psi/JupyterCell;", "getJupyterVirtualFile", "intellij.python.jupyter"})
    public static final class Companion {
        @JvmStatic
        @NotNull
        public final JupyterCellExecutionManager getInstance(@NotNull Project project) {
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            Object object = ServiceManager.getService((Project)project, JupyterCellExecutionManager.class);
            Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"ServiceManager.getServic\u2026utionManager::class.java)");
            return (JupyterCellExecutionManager)object;
        }

        @NotNull
        public final Logger getLOG() {
            return LOG;
        }

        @NotNull
        public final String getSessionPath(@NotNull JupyterCell psiCell) {
            Intrinsics.checkParameterIsNotNull((Object)psiCell, (String)"psiCell");
            PsiFile psiFile = psiCell.getContainingFile();
            Intrinsics.checkExpressionValueIsNotNull((Object)psiFile, (String)"psiCell.containingFile");
            VirtualFile virtualFile2 = psiFile.getVirtualFile();
            if (virtualFile2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.plugins.notebooks.jupyter.editor.JupyterVirtualFile");
            }
            JupyterVirtualFile file = (JupyterVirtualFile)virtualFile2;
            String string = file.getPath();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"file.path");
            return StringsKt.removePrefix((String)string, (CharSequence)"/");
        }

        @NotNull
        public final JupyterVirtualFile getJupyterVirtualFile(@NotNull JupyterCell $this$getJupyterVirtualFile) {
            Intrinsics.checkParameterIsNotNull((Object)$this$getJupyterVirtualFile, (String)"$this$getJupyterVirtualFile");
            PsiFile psiFile = $this$getJupyterVirtualFile.getContainingFile();
            Intrinsics.checkExpressionValueIsNotNull((Object)psiFile, (String)"containingFile");
            VirtualFile virtualFile2 = psiFile.getVirtualFile();
            if (virtualFile2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.plugins.notebooks.jupyter.editor.JupyterVirtualFile");
            }
            return (JupyterVirtualFile)virtualFile2;
        }

        @NotNull
        public final String getSessionPath(@NotNull JupyterVirtualFile virtualFile2) {
            Intrinsics.checkParameterIsNotNull((Object)((Object)virtualFile2), (String)"virtualFile");
            String string = virtualFile2.getPath();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"virtualFile.path");
            return StringsKt.removePrefix((String)string, (CharSequence)"/");
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

