/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.notebooks.jupyter.nbformat;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.stream.JsonWriter;
import com.intellij.lang.Language;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.PlainTextLanguage;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.notebooks.jupyter.nbformat.CellAdded;
import org.jetbrains.plugins.notebooks.jupyter.nbformat.CellRemoved;
import org.jetbrains.plugins.notebooks.jupyter.nbformat.JupyterCell;
import org.jetbrains.plugins.notebooks.jupyter.nbformat.JupyterCellBase;
import org.jetbrains.plugins.notebooks.jupyter.nbformat.JupyterCellBuilder;
import org.jetbrains.plugins.notebooks.jupyter.nbformat.JupyterChangeListener;
import org.jetbrains.plugins.notebooks.jupyter.nbformat.JupyterEvent;
import org.jetbrains.plugins.notebooks.jupyter.nbformat.JupyterKernelSpec;
import org.jetbrains.plugins.notebooks.jupyter.nbformat.JupyterKernelSpecBase;
import org.jetbrains.plugins.notebooks.jupyter.nbformat.JupyterMetadataAwareBase;
import org.jetbrains.plugins.notebooks.jupyter.nbformat.JupyterNotebook;
import org.jetbrains.plugins.notebooks.jupyter.nbformat.JupyterNotebookBase$WhenMappings;
import org.jetbrains.plugins.notebooks.jupyter.nbformat.JupyterNotebookBase$getCellElements$;
import org.jetbrains.plugins.notebooks.jupyter.nbformat.JupyterNotebookBaseKt;
import org.jetbrains.plugins.notebooks.jupyter.nbformat.JupyterNotebookException;
import org.jetbrains.plugins.notebooks.jupyter.nbformat.JupyterNotebookSchema;
import org.jetbrains.plugins.notebooks.jupyter.nbformat.JupyterNotebookSchemaFactory;
import org.jetbrains.plugins.notebooks.jupyter.nbformat.JupyterOutputsBuilder;
import org.jetbrains.plugins.notebooks.jupyter.nbformat.JupyterOutputsBuilderBase;
import org.jetbrains.plugins.notebooks.jupyter.nbformat.NotebookChanged;
import org.jetbrains.plugins.notebooks.jupyter.python.JupyterPyDialect;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u008e\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\r\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0000\u0018\u0000 D2\u00020\u00012\u00020\u0002:\u0001DB\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0018\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020+H\u0016J\u0010\u0010,\u001a\u00020'2\u0006\u0010-\u001a\u00020\u0013H\u0016J\b\u0010.\u001a\u00020/H\u0016J\b\u00100\u001a\u000201H\u0016J\u0010\u00102\u001a\u00020'2\u0006\u0010(\u001a\u00020)H\u0002J\u0010\u00103\u001a\u0002042\u0006\u0010\u000b\u001a\u00020\fH\u0002J\b\u00105\u001a\u00020)H\u0016J\u000e\u00106\u001a\b\u0012\u0004\u0012\u00020\f07H\u0002J\u0010\u00108\u001a\u0002012\u0006\u00109\u001a\u00020\bH\u0002J\b\u0010:\u001a\u00020;H\u0016J\u0015\u0010<\u001a\u00020'2\u0006\u0010=\u001a\u00020>H\u0000\u00a2\u0006\u0002\b?J\u0010\u0010@\u001a\u00020'2\u0006\u0010*\u001a\u00020+H\u0016J\u0010\u0010A\u001a\u00020'2\u0006\u0010-\u001a\u00020\u0013H\u0016J\b\u0010B\u001a\u00020'H\u0016J\u0010\u0010C\u001a\u00020'2\u0006\u0010(\u001a\u00020)H\u0016R\u001a\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\f8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000eR\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R(\u0010\u0016\u001a\u0004\u0018\u00010\u00152\b\u0010\u0014\u001a\u0004\u0018\u00010\u00158V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR\u0014\u0010\u001b\u001a\u00020\u001c8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001eR\u0014\u0010\u001f\u001a\u00020 X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"R\u0016\u0010#\u001a\u0004\u0018\u00010\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b$\u0010%\u00a8\u0006E"}, d2={"Lorg/jetbrains/plugins/notebooks/jupyter/nbformat/JupyterNotebookBase;", "Lorg/jetbrains/plugins/notebooks/jupyter/nbformat/JupyterNotebook;", "Lorg/jetbrains/plugins/notebooks/jupyter/nbformat/JupyterMetadataAwareBase;", "reader", "Ljava/io/Reader;", "(Ljava/io/Reader;)V", "cells", "", "Lorg/jetbrains/plugins/notebooks/jupyter/nbformat/JupyterCell;", "getCells", "()Ljava/util/List;", "content", "Lcom/google/gson/JsonObject;", "getContent", "()Lcom/google/gson/JsonObject;", "json", "getJson", "jupyterChangeListeners", "", "Lorg/jetbrains/plugins/notebooks/jupyter/nbformat/JupyterChangeListener;", "value", "Lorg/jetbrains/plugins/notebooks/jupyter/nbformat/JupyterKernelSpec;", "kernelSpec", "getKernelSpec", "()Lorg/jetbrains/plugins/notebooks/jupyter/nbformat/JupyterKernelSpec;", "setKernelSpec", "(Lorg/jetbrains/plugins/notebooks/jupyter/nbformat/JupyterKernelSpec;)V", "language", "Lcom/intellij/lang/Language;", "getLanguage", "()Lcom/intellij/lang/Language;", "schema", "Lorg/jetbrains/plugins/notebooks/jupyter/nbformat/JupyterNotebookSchema;", "getSchema", "()Lorg/jetbrains/plugins/notebooks/jupyter/nbformat/JupyterNotebookSchema;", "stemCell", "getStemCell", "()Lorg/jetbrains/plugins/notebooks/jupyter/nbformat/JupyterCell;", "addCell", "", "builder", "Lorg/jetbrains/plugins/notebooks/jupyter/nbformat/JupyterCellBuilder;", "index", "", "addJupyterChangeListener", "jupyterChangeListener", "asJson", "", "asSource", "", "checkCellBuilder", "createCell", "Lorg/jetbrains/plugins/notebooks/jupyter/nbformat/JupyterCellBase;", "getCellBuilder", "getCellElements", "Lkotlin/sequences/Sequence;", "getCellMarkerSource", "cell", "getOutputsBuilder", "Lorg/jetbrains/plugins/notebooks/jupyter/nbformat/JupyterOutputsBuilder;", "notifyListeners", "jupyterEvent", "Lorg/jetbrains/plugins/notebooks/jupyter/nbformat/JupyterEvent;", "notifyListeners$intellij_python_jupyter", "removeCell", "removeJupyterChangeListener", "removeStemCell", "setStemCell", "Companion", "intellij.python.jupyter"})
public final class JupyterNotebookBase
extends JupyterMetadataAwareBase
implements JupyterNotebook {
    @NotNull
    private final JsonObject json;
    private final List<JupyterChangeListener> jupyterChangeListeners;
    @NotNull
    private final JupyterNotebookSchema schema;
    private static final Logger LOG;
    private static final Gson gson;
    public static final Companion Companion;

    @Override
    @NotNull
    public JsonObject getJson() {
        return this.json;
    }

    @Override
    @NotNull
    public JupyterNotebookSchema getSchema() {
        return this.schema;
    }

    @Override
    @Nullable
    public JupyterCell getStemCell() {
        return JupyterNotebookBaseKt.access$getStemCell(this, this.getJson(), this.getSchema(), this.getLanguage());
    }

    @Override
    @NotNull
    public List<JupyterCell> getCells() {
        return SequencesKt.toList((Sequence)SequencesKt.map(this.getCellElements(), (Function1)((Function1)new Function1<JsonObject, JupyterCellBase>(this){
            final /* synthetic */ JupyterNotebookBase this$0;

            @NotNull
            public final JupyterCellBase invoke(@NotNull JsonObject it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                return JupyterNotebookBase.access$createCell(this.this$0, it);
            }
            {
                this.this$0 = jupyterNotebookBase;
                super(1);
            }
        })));
    }

    @Override
    @Nullable
    public JupyterKernelSpec getKernelSpec() {
        JsonObject jsonObject = this.getJson().getAsJsonObject(this.getSchema().getMetadataFieldName());
        return JupyterKernelSpecBase.Companion.fromJson(jsonObject != null ? jsonObject.getAsJsonObject(this.getSchema().getKernelSpecFieldName()) : null, this.getSchema());
    }

    @Override
    public void setKernelSpec(@Nullable JupyterKernelSpec value) {
        JsonObject metadataField = this.getJson().getAsJsonObject(this.getSchema().getMetadataFieldName());
        JupyterKernelSpec jupyterKernelSpec = value;
        if (jupyterKernelSpec != null) {
            JupyterKernelSpec jupyterKernelSpec2 = jupyterKernelSpec;
            boolean bl = false;
            boolean bl2 = false;
            JupyterKernelSpec $this$run = jupyterKernelSpec2;
            boolean bl3 = false;
            JsonObject jsonObject = new JsonObject();
            String string = this.getSchema().getKernelSpecFieldName();
            JsonObject jsonObject2 = metadataField;
            boolean bl4 = false;
            boolean bl5 = false;
            JsonObject $this$apply = jsonObject;
            boolean bl6 = false;
            $this$apply.addProperty(this.getSchema().getKernelSpecNameFieldName(), value.getName());
            $this$apply.addProperty(this.getSchema().getKernelSpecLanguageFieldName(), value.getLanguage());
            $this$apply.addProperty(this.getSchema().getKernelSpecDisplayNameFieldName(), value.getDisplayName());
            JsonObject jsonObject3 = jsonObject;
            jsonObject2.add(string, (JsonElement)jsonObject3);
        } else {
            metadataField.remove(this.getSchema().getKernelSpecFieldName());
        }
        this.notifyListeners$intellij_python_jupyter(new NotebookChanged(this));
    }

    @Override
    @NotNull
    public JupyterCellBuilder getCellBuilder() {
        return new JupyterCellBase.JupyterCellBuilderBase(this, null, null, null, false, null, null, this.getSchema(), 126, null);
    }

    @Override
    @NotNull
    public JupyterOutputsBuilder getOutputsBuilder() {
        return new JupyterOutputsBuilderBase();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    @NotNull
    public Language getLanguage() {
        Language language;
        String languageField;
        String string = languageField = (String)this.getSchema().getGetLanguage().invoke((Object)this.getJson());
        if (string != null) {
            if (StringsKt.startsWith$default((String)string, (String)"python", (boolean)false, (int)2, null)) {
                language = JupyterPyDialect.INSTANCE;
                return language;
            }
        }
        PlainTextLanguage plainTextLanguage = PlainTextLanguage.INSTANCE;
        Intrinsics.checkExpressionValueIsNotNull((Object)plainTextLanguage, (String)"PlainTextLanguage.INSTANCE");
        language = (Language)plainTextLanguage;
        return language;
    }

    @Override
    public void setStemCell(@NotNull JupyterCellBuilder builder) {
        Intrinsics.checkParameterIsNotNull((Object)builder, (String)"builder");
        this.checkCellBuilder(builder);
        Object object = gson.fromJson(((Object)builder.build().asJson()).toString(), JsonElement.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"gson.fromJson(\n      bui\u2026Element::class.java\n    )");
        JsonObject stemCell = ((JsonElement)object).getAsJsonObject();
        this.getOrCreateMetadata().add("stem_cell", (JsonElement)stemCell);
    }

    @Override
    public void removeStemCell() {
        this.removeMetadata("stem_cell");
    }

    @Override
    public void addCell(@NotNull JupyterCellBuilder builder, int index) {
        int i;
        Intrinsics.checkParameterIsNotNull((Object)builder, (String)"builder");
        this.checkCellBuilder(builder);
        List oldCells = SequencesKt.toList(this.getCellElements());
        if (index > oldCells.size() + 1) {
            String string = "Trying to add cell to index " + index + " outside of cells range " + oldCells.size();
            boolean bl = false;
            System.out.println((Object)string);
            return;
        }
        JupyterCell cell = builder.build();
        Object object = gson.fromJson(((Object)cell.asJson()).toString(), JsonElement.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"gson.fromJson(\n      cel\u2026Element::class.java\n    )");
        JsonObject cellJson = ((JsonElement)object).getAsJsonObject();
        JsonArray newCells = new JsonArray(oldCells.size() + 1);
        int n = 0;
        int n2 = index;
        while (n < n2) {
            newCells.add((JsonElement)oldCells.get(i));
            ++i;
        }
        newCells.add((JsonElement)cellJson);
        n2 = oldCells.size();
        for (i = index; i < n2; ++i) {
            newCells.add((JsonElement)oldCells.get(i));
        }
        this.getJson().add(this.getSchema().getCellFieldName(), (JsonElement)newCells);
        this.notifyListeners$intellij_python_jupyter(new NotebookChanged(this));
        this.notifyListeners$intellij_python_jupyter(new CellAdded(this, cell, index));
    }

    @Override
    public void removeCell(int index) {
        JsonElement cellsElement = this.getJson().get(this.getSchema().getCellFieldName());
        if (cellsElement != null && cellsElement.isJsonArray()) {
            if (index >= cellsElement.getAsJsonArray().size()) {
                String string = "Trying to remove cell from index " + index + " outside of cells range " + cellsElement.getAsJsonArray().size();
                boolean bl = false;
                System.out.println((Object)string);
                return;
            }
            cellsElement.getAsJsonArray().remove(index);
            this.notifyListeners$intellij_python_jupyter(new NotebookChanged(this));
            this.notifyListeners$intellij_python_jupyter(new CellRemoved(this, index));
        }
    }

    private final void checkCellBuilder(JupyterCellBuilder builder) {
        if (!builder.isCompatible(this.getSchema())) {
            throw (Throwable)new JupyterNotebookException("Version of notebook cell builder " + builder + " is incompatible with notebook version " + this.getSchema());
        }
    }

    private final Sequence<JsonObject> getCellElements() {
        JsonElement cellsElement = this.getJson().get(this.getSchema().getCellFieldName());
        if (cellsElement == null || !cellsElement.isJsonArray()) {
            LOG.error("Can't find proper cells element: " + cellsElement);
            return SequencesKt.emptySequence();
        }
        JsonArray jsonArray = cellsElement.getAsJsonArray();
        Intrinsics.checkExpressionValueIsNotNull((Object)jsonArray, (String)"cellsElement.asJsonArray");
        Sequence $this$filterIsInstance$iv = CollectionsKt.asSequence((Iterable)((Iterable)jsonArray));
        boolean $i$f$filterIsInstance = false;
        Sequence sequence = SequencesKt.filter((Sequence)$this$filterIsInstance$iv, (Function1)getCellElements$$inlined$filterIsInstance$1.INSTANCE);
        if (sequence == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.sequences.Sequence<R>");
        }
        return sequence;
    }

    private final JupyterCellBase createCell(JsonObject content) {
        return new JupyterCellBase(this, content, this.getSchema(), this.getLanguage());
    }

    @Override
    @NotNull
    protected JsonObject getContent() {
        return this.getJson();
    }

    @Override
    @NotNull
    public CharSequence asSource() {
        StringBuilder builder = new StringBuilder();
        JupyterCell jupyterCell = this.getStemCell();
        if (jupyterCell != null) {
            JupyterCell jupyterCell2 = jupyterCell;
            boolean bl = false;
            boolean bl2 = false;
            JupyterCell it = jupyterCell2;
            boolean bl3 = false;
            builder.append(it.getSource());
            Collection collection = this.getCells();
            boolean bl4 = false;
            if (!collection.isEmpty()) {
                builder.append("\n");
            }
        }
        SequencesKt.joinTo$default((Sequence)SequencesKt.flatMap((Sequence)CollectionsKt.asSequence((Iterable)this.getCells()), (Function1)((Function1)new Function1<JupyterCell, Sequence<? extends String>>(this){
            final /* synthetic */ JupyterNotebookBase this$0;

            @NotNull
            public final Sequence<String> invoke(@NotNull JupyterCell it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                return SequencesKt.sequenceOf((Object[])new String[]{"" + JupyterNotebookBase.access$getCellMarkerSource(this.this$0, it) + it.getSource()});
            }
            {
                this.this$0 = jupyterNotebookBase;
                super(1);
            }
        })), (Appendable)builder, (CharSequence)"\n", null, null, (int)0, null, null, (int)124, null);
        return builder;
    }

    private final CharSequence getCellMarkerSource(JupyterCell cell) {
        CharSequence charSequence;
        Object object = cell.getMetadata("name");
        if (object != null && (object = object.getAsString()) != null) {
            charSequence = (CharSequence)object;
        } else {
            String string;
            switch (JupyterNotebookBase$WhenMappings.$EnumSwitchMapping$0[cell.getCellType().ordinal()]) {
                case 1: {
                    string = "#%% raw\n";
                    break;
                }
                case 2: {
                    string = "#%% md\n";
                    break;
                }
                default: {
                    string = "#%%\n";
                }
            }
            charSequence = string;
        }
        return charSequence;
    }

    @Override
    @NotNull
    public String asJson() {
        StringWriter writer = new StringWriter();
        JsonWriter jsonWriter = new JsonWriter((Writer)writer);
        boolean bl = false;
        boolean bl2 = false;
        JsonWriter $this$apply = jsonWriter;
        boolean bl3 = false;
        $this$apply.setIndent(" ");
        JsonWriter jupyterStyleWriter = jsonWriter;
        gson.toJson((JsonElement)this.getJson().deepCopy(), jupyterStyleWriter);
        String string = writer.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"writer.toString()");
        return string;
    }

    @Override
    public void removeJupyterChangeListener(@NotNull JupyterChangeListener jupyterChangeListener) {
        Intrinsics.checkParameterIsNotNull((Object)jupyterChangeListener, (String)"jupyterChangeListener");
        this.jupyterChangeListeners.remove(jupyterChangeListener);
    }

    @Override
    public void addJupyterChangeListener(@NotNull JupyterChangeListener jupyterChangeListener) {
        Intrinsics.checkParameterIsNotNull((Object)jupyterChangeListener, (String)"jupyterChangeListener");
        this.jupyterChangeListeners.add(jupyterChangeListener);
    }

    public final void notifyListeners$intellij_python_jupyter(@NotNull JupyterEvent jupyterEvent) {
        Intrinsics.checkParameterIsNotNull((Object)jupyterEvent, (String)"jupyterEvent");
        Iterable $this$forEach$iv = this.jupyterChangeListeners;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            JupyterChangeListener it = (JupyterChangeListener)element$iv;
            boolean bl = false;
            ApplicationManager.getApplication().invokeLater(new Runnable(it, jupyterEvent){
                final /* synthetic */ JupyterChangeListener $it;
                final /* synthetic */ JupyterEvent $jupyterEvent$inlined;
                {
                    this.$it = jupyterChangeListener;
                    this.$jupyterEvent$inlined = jupyterEvent;
                }

                public final void run() {
                    this.$it.onEvent(this.$jupyterEvent$inlined);
                }
            });
        }
    }

    public JupyterNotebookBase(@NotNull Reader reader) {
        List list;
        Intrinsics.checkParameterIsNotNull((Object)reader, (String)"reader");
        Object object = gson.fromJson(reader, JsonElement.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"gson.fromJson(reader, JsonElement::class.java)");
        JsonObject jsonObject = ((JsonElement)object).getAsJsonObject();
        Intrinsics.checkExpressionValueIsNotNull((Object)jsonObject, (String)"gson.fromJson(reader, Js\u2026:class.java).asJsonObject");
        this.json = jsonObject;
        JupyterNotebookBase jupyterNotebookBase = this;
        boolean bl = false;
        jupyterNotebookBase.jupyterChangeListeners = list = (List)new ArrayList();
        this.schema = JupyterNotebookSchemaFactory.INSTANCE.createSchema(this.getJson());
    }

    static {
        Companion = new Companion(null);
        Logger logger2 = Logger.getInstance(MethodHandles.lookup().lookupClass());
        Intrinsics.checkExpressionValueIsNotNull((Object)logger2, (String)"Logger.getInstance(Metho\u2026s.lookup().lookupClass())");
        LOG = logger2;
        gson = new GsonBuilder().disableHtmlEscaping().serializeNulls().setPrettyPrinting().create();
    }

    public static final /* synthetic */ JupyterCellBase access$createCell(JupyterNotebookBase $this, JsonObject content) {
        return $this.createCell(content);
    }

    public static final /* synthetic */ CharSequence access$getCellMarkerSource(JupyterNotebookBase $this, JupyterCell cell) {
        return $this.getCellMarkerSource(cell);
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\n"}, d2={"Lorg/jetbrains/plugins/notebooks/jupyter/nbformat/JupyterNotebookBase$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "gson", "Lcom/google/gson/Gson;", "kotlin.jvm.PlatformType", "getGson$intellij_python_jupyter", "()Lcom/google/gson/Gson;", "intellij.python.jupyter"})
    public static final class Companion {
        public final Gson getGson$intellij_python_jupyter() {
            return gson;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

