/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.util.containers.PeekableIterator;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.jetbrains.annotations.NotNull;

public class FilteringIterator<Dom, E extends Dom>
implements PeekableIterator<E> {
    private final Iterator<? extends Dom> myDelegate;
    private final Condition<? super Dom> myCondition;
    private boolean myNextObtained;
    private boolean myCurrentIsValid;
    private Dom myCurrent;
    private Boolean myCurrentPassedFilter;

    public FilteringIterator(@NotNull Iterator<? extends Dom> delegate, @NotNull Condition<? super Dom> condition) {
        if (delegate == null) {
            FilteringIterator.$$$reportNull$$$0(0);
        }
        if (condition == null) {
            FilteringIterator.$$$reportNull$$$0(1);
        }
        this.myDelegate = delegate;
        this.myCondition = condition;
    }

    private void obtainNext() {
        if (this.myNextObtained) {
            return;
        }
        boolean hasNext = this.myDelegate.hasNext();
        this.setCurrent(hasNext ? (Dom)this.myDelegate.next() : null);
        this.myCurrentIsValid = hasNext;
        this.myNextObtained = true;
    }

    @Override
    public boolean hasNext() {
        this.obtainNext();
        if (!this.myCurrentIsValid) {
            return false;
        }
        boolean value = this.isCurrentPassesFilter();
        while (!value && this.myDelegate.hasNext()) {
            Dom next = this.myDelegate.next();
            this.setCurrent(next);
            value = this.isCurrentPassesFilter();
        }
        return value;
    }

    private void setCurrent(Dom next) {
        this.myCurrent = next;
        this.myCurrentPassedFilter = null;
    }

    private boolean isCurrentPassesFilter() {
        if (this.myCurrentPassedFilter != null) {
            return this.myCurrentPassedFilter;
        }
        boolean passed = this.myCondition.value(this.myCurrent);
        this.myCurrentPassedFilter = passed;
        return passed;
    }

    @Override
    public E next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        Dom result = this.myCurrent;
        this.myNextObtained = false;
        return (E)result;
    }

    @Override
    public void remove() {
        if (this.myNextObtained) {
            throw new IllegalStateException();
        }
        this.myDelegate.remove();
    }

    @Override
    public E peek() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        return (E)this.myCurrent;
    }

    public static <T> Iterator<T> skipNulls(Iterator<? extends T> iterator) {
        return FilteringIterator.create(iterator, Conditions.notNull());
    }

    public static <T> Iterator<T> create(Iterator<? extends T> iterator, Condition<? super T> condition) {
        if (condition == Condition.TRUE || condition == Conditions.TRUE) {
            return iterator;
        }
        return new FilteringIterator(iterator, condition);
    }

    public static <T> Condition<T> alwaysTrueCondition(Class<T> aClass) {
        return Conditions.alwaysTrue();
    }

    public static <T> InstanceOf<T> instanceOf(Class<T> aClass) {
        return new InstanceOf<T>(aClass);
    }

    public static <T> Iterator<T> createInstanceOf(Iterator<?> iterator, Class<T> aClass) {
        return FilteringIterator.create(iterator, FilteringIterator.instanceOf(aClass));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "delegate";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "condition";
                break;
            }
        }
        objectArray[1] = "com/intellij/util/containers/FilteringIterator";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class InstanceOf<T>
    implements Condition<Object> {
        private final Class<T> myInstancesClass;

        public InstanceOf(Class<T> instancesClass) {
            this.myInstancesClass = instancesClass;
        }

        @Override
        public boolean value(Object object) {
            return this.myInstancesClass.isInstance(object);
        }
    }
}

