/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.nodejs;

import com.intellij.javascript.nodejs.interpreter.local.NodeJsLocalInterpreter;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.EnvironmentUtil;
import com.intellij.util.SystemProperties;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NodeSettings {
    private final String myInterpreterPath;
    private final AtomicReference<File> myGlobalNodeModulesDirRef;
    private final List<VirtualFile> myGlobalFolders;

    public NodeSettings(@NotNull String interpreterPath) {
        if (interpreterPath == null) {
            NodeSettings.$$$reportNull$$$0(0);
        }
        this.myGlobalNodeModulesDirRef = new AtomicReference();
        this.myInterpreterPath = interpreterPath;
        this.initGlobalNodeModulesDir();
        this.myGlobalFolders = NodeSettings.toVirtualFiles(this.getGlobalFolderPaths());
    }

    @NotNull
    private List<File> getGlobalFolderPaths() {
        File interpreterDir;
        File userHome;
        ArrayList<File> globalFolders = new ArrayList<File>(3);
        String userHomePath = SystemProperties.getUserHome();
        if (StringUtil.isNotEmpty((String)userHomePath) && (userHome = new File(userHomePath)).isAbsolute()) {
            globalFolders.add(new File(userHome, ".node_modules"));
            globalFolders.add(new File(userHome, ".node_libraries"));
        }
        if ((interpreterDir = this.getInterpreterDir()) != null) {
            globalFolders.add(new File(interpreterDir, "lib/node"));
        }
        ArrayList<File> arrayList = globalFolders;
        if (arrayList == null) {
            NodeSettings.$$$reportNull$$$0(1);
        }
        return arrayList;
    }

    @NotNull
    public static List<VirtualFile> toVirtualFiles(@NotNull List<? extends File> dirs) {
        if (dirs == null) {
            NodeSettings.$$$reportNull$$$0(2);
        }
        if (dirs.isEmpty()) {
            List<VirtualFile> list2 = Collections.emptyList();
            if (list2 == null) {
                NodeSettings.$$$reportNull$$$0(3);
            }
            return list2;
        }
        ArrayList<VirtualFile> vDirs = new ArrayList<VirtualFile>();
        for (File file2 : dirs) {
            VirtualFile vDir = VfsUtil.findFileByIoFile((File)file2, (boolean)false);
            if (vDir == null || !vDir.isValid() || !vDir.isDirectory()) continue;
            vDirs.add(vDir);
        }
        ArrayList<VirtualFile> arrayList = vDirs;
        if (arrayList == null) {
            NodeSettings.$$$reportNull$$$0(4);
        }
        return arrayList;
    }

    @Nullable
    public VirtualFile getGlobalNodeModulesVirtualDir() {
        VirtualFile virtualDir;
        File dir = this.myGlobalNodeModulesDirRef.get();
        if (dir != null && dir.isDirectory() && (virtualDir = VfsUtil.findFileByIoFile((File)dir, (boolean)false)) != null && virtualDir.isValid()) {
            return virtualDir;
        }
        return null;
    }

    @NotNull
    public List<VirtualFile> getGlobalFolders() {
        List<VirtualFile> list2 = this.myGlobalFolders;
        if (list2 == null) {
            NodeSettings.$$$reportNull$$$0(5);
        }
        return list2;
    }

    @Nullable
    private File getInterpreterDir() {
        File interpreterFile = new File(this.myInterpreterPath);
        if (!interpreterFile.isFile() || !interpreterFile.canExecute()) {
            return null;
        }
        return interpreterFile.getParentFile();
    }

    public void initGlobalNodeModulesDir() {
        File guessedDir = this.guessGlobalModulesDirByInterpreterPath();
        this.myGlobalNodeModulesDirRef.set(guessedDir);
    }

    @Nullable
    private File guessGlobalModulesDirByInterpreterPath() {
        File libDir;
        File interpreterDir = this.getInterpreterDir();
        if (SystemInfo.isWindows) {
            String npmRcContent = NodeSettings.readNpmRc(interpreterDir);
            boolean useAppDataPrefix = npmRcContent == null || !StringUtil.isEmptyOrSpaces((String)npmRcContent);
            String appDataDirPath = EnvironmentUtil.getValue((String)"APPDATA");
            if (useAppDataPrefix && appDataDirPath != null) {
                File nodeModulesDir;
                File appDataDir = new File(appDataDirPath);
                if (appDataDirPath.trim().length() > 0 && appDataDir.isAbsolute() && appDataDir.isDirectory() && (nodeModulesDir = new File(appDataDir, "npm" + File.separatorChar + "node_modules")).isDirectory()) {
                    return nodeModulesDir;
                }
            }
        }
        if (interpreterDir == null) {
            return null;
        }
        if (SystemInfo.isWindows) {
            libDir = interpreterDir;
        } else {
            File root = interpreterDir.getParentFile();
            if (root == null) {
                return null;
            }
            libDir = new File(root, "lib");
        }
        File nodeModulesDir = new File(libDir, "node_modules");
        return nodeModulesDir.isDirectory() ? nodeModulesDir : null;
    }

    @Nullable
    private static String readNpmRc(@Nullable File interpreterDir) {
        File npmRc;
        File file2 = npmRc = interpreterDir != null ? new File(interpreterDir, "node_modules" + File.separator + "npm" + File.separator + "npmrc") : null;
        if (npmRc == null || !npmRc.isFile()) {
            return null;
        }
        try {
            return FileUtil.loadFile((File)npmRc);
        }
        catch (IOException e) {
            return null;
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NodeSettings settings = (NodeSettings)o;
        return this.myInterpreterPath.equals(settings.myInterpreterPath);
    }

    public int hashCode() {
        return this.myInterpreterPath.hashCode();
    }

    @Nullable
    public static NodeSettings create(@Nullable NodeJsLocalInterpreter interpreter) {
        return interpreter == null ? null : new NodeSettings(interpreter.getInterpreterSystemDependentPath());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interpreterPath";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/nodejs/NodeSettings";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dirs";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/nodejs/NodeSettings";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getGlobalFolderPaths";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "toVirtualFiles";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getGlobalFolders";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "toVirtualFiles";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

