/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.nodejs.interpreter;

import com.intellij.javascript.nodejs.interpreter.LeftRightJustifyingLayoutManager;
import com.intellij.javascript.nodejs.interpreter.NodeInterpreterRefResolveResult;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterField;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterManager;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterRef;
import com.intellij.javascript.nodejs.interpreter.local.NodeJsLocalInterpreter;
import com.intellij.javascript.nodejs.interpreter.local.NodeJsLocalInterpreterType;
import com.intellij.javascript.nodejs.interpreter.local.NodeLocalInterpreterRefResolveResult;
import com.intellij.javascript.nodejs.interpreter.wsl.WslNodeInterpreter;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.NullableConsumer;
import com.intellij.util.ObjectUtils;
import com.intellij.util.text.SemVer;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NodeJsInterpreterRenderer
implements ListCellRenderer<NodeJsInterpreterRef> {
    private static final Logger LOG = Logger.getInstance(NodeJsInterpreterRenderer.class);
    private static final String NO_INTERPRETER_TEXT = "No interpreter";
    private final SimpleColoredComponent myNameComp;
    private final SimpleColoredComponent myVersionComp;
    private final JPanel myPanel;
    private final Project myProject;

    public NodeJsInterpreterRenderer(@NotNull Project project, boolean compact) {
        if (project == null) {
            NodeJsInterpreterRenderer.$$$reportNull$$$0(0);
        }
        this.myNameComp = new SimpleColoredComponent();
        this.myVersionComp = new SimpleColoredComponent();
        this.myPanel = new JPanel(new GridBagLayout());
        this.myProject = project;
        this.myNameComp.setOpaque(false);
        this.myVersionComp.setOpaque(false);
        JBInsets insets = compact ? new JBInsets(0, 1, 0, 1) : new JBInsets(2, UIUtil.getListCellHPadding(), 2, UIUtil.getListCellHPadding());
        this.myPanel.setBorder(IdeBorderFactory.createEmptyBorder((Insets)insets));
        this.myNameComp.setIpad((Insets)JBUI.emptyInsets());
        this.myVersionComp.setIpad((Insets)JBUI.insets((int)0, (int)10, (int)0, (int)0));
        if (compact) {
            NodeJsInterpreterRenderer.adjustBorderHeight(this.myNameComp);
            this.myVersionComp.setMyBorder(null);
        }
        JPanel nameContainer = NodeJsInterpreterRenderer.wrapInLeftRightJustifyingContainer(this.myNameComp);
        this.myPanel.add((Component)nameContainer, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 256, 2, (Insets)JBUI.emptyInsets(), 0, 0));
        this.myPanel.add((Component)this.myVersionComp, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 256, 0, (Insets)JBUI.emptyInsets(), 0, 0));
    }

    public static void adjustBorderHeight(@NotNull SimpleColoredComponent component) {
        if (component == null) {
            NodeJsInterpreterRenderer.$$$reportNull$$$0(1);
        }
        component.setMyBorder((Border)new EmptyBorder(1, 0, 1, 0));
    }

    @NotNull
    private static JPanel wrapInLeftRightJustifyingContainer(final @NotNull SimpleColoredComponent component) {
        if (component == null) {
            NodeJsInterpreterRenderer.$$$reportNull$$$0(2);
        }
        JPanel container = new JPanel((LayoutManager)new LeftRightJustifyingLayoutManager()){

            @Override
            public int getBaseline(int width, int height) {
                return component.getBaseline(width, height);
            }
        };
        container.setBorder((Border)JBUI.Borders.empty());
        container.setOpaque(false);
        container.add((Component)component);
        JPanel jPanel = container;
        if (jPanel == null) {
            NodeJsInterpreterRenderer.$$$reportNull$$$0(3);
        }
        return jPanel;
    }

    @Override
    public Component getListCellRendererComponent(JList<? extends NodeJsInterpreterRef> list2, NodeJsInterpreterRef value, int index, boolean isSelected, boolean cellHasFocus) {
        this.myNameComp.clear();
        this.myVersionComp.clear();
        Font baseFont = list2.getFont();
        this.myNameComp.setFont(baseFont);
        this.myVersionComp.setFont(UIUtil.getFont((UIUtil.FontSize)UIUtil.FontSize.SMALL, (Font)baseFont));
        if (this.myPanel.isEnabled() != list2.isEnabled()) {
            UIUtil.setEnabled((Component)this.myPanel, (boolean)list2.isEnabled(), (boolean)true);
        }
        if (value == null) {
            return this.myPanel;
        }
        this.myPanel.setBackground(isSelected ? list2.getSelectionBackground() : list2.getBackground());
        Color foreground = isSelected ? list2.getSelectionForeground() : list2.getForeground();
        this.myNameComp.setForeground(foreground);
        this.myVersionComp.setForeground(foreground);
        this.customize(list2, value, index, isSelected);
        return this.myPanel;
    }

    private void customize(@NotNull JList<? extends NodeJsInterpreterRef> list2, @NotNull NodeJsInterpreterRef interpreterRef, int index, boolean isSelected) {
        boolean valid;
        if (list2 == null) {
            NodeJsInterpreterRenderer.$$$reportNull$$$0(4);
        }
        if (interpreterRef == null) {
            NodeJsInterpreterRenderer.$$$reportNull$$$0(5);
        }
        if (interpreterRef.equals(NodeJsInterpreterField.NO_INTERPRETER_REF)) {
            this.myNameComp.append(NO_INTERPRETER_TEXT, SimpleTextAttributes.ERROR_ATTRIBUTES);
            return;
        }
        NodeInterpreterRefResolveResult resolveResult = interpreterRef.resolveResult(this.myProject);
        NodeJsInterpreter interpreter = resolveResult != null ? (NodeJsInterpreter)resolveResult.getInterpreter() : null;
        Ref<SemVer> versionRef = interpreter != null ? interpreter.getCachedVersion() : null;
        String errorMessage = null;
        if (versionRef != null && versionRef.isNull() && (interpreter instanceof NodeJsLocalInterpreter || interpreter instanceof WslNodeInterpreter)) {
            errorMessage = interpreter.validate(null);
        }
        this.myPanel.setToolTipText(errorMessage);
        boolean bl = valid = interpreter != null && errorMessage == null;
        if (interpreterRef.isConstantRef()) {
            if (interpreter != null) {
                this.myNameComp.append(interpreter.getPresentableName(), valid ? SimpleTextAttributes.REGULAR_ATTRIBUTES : SimpleTextAttributes.ERROR_ATTRIBUTES);
            } else {
                this.myNameComp.append(interpreterRef.getReferenceName() + " (not found)", SimpleTextAttributes.ERROR_ATTRIBUTES);
            }
        } else {
            this.myNameComp.append(NodeJsInterpreterRenderer.getPresentableRefName(interpreterRef));
            String text = this.getPresentableResolveText(interpreterRef, resolveResult);
            this.myNameComp.append("  " + text, !valid ? SimpleTextAttributes.ERROR_ATTRIBUTES : (isSelected ? SimpleTextAttributes.REGULAR_ATTRIBUTES : SimpleTextAttributes.GRAY_ATTRIBUTES));
        }
        if (versionRef != null) {
            SemVer version2 = (SemVer)versionRef.get();
            if (version2 != null) {
                this.addVersion(version2, isSelected);
            }
        } else if (interpreter != null) {
            ModalityState modalityState = ModalityState.current();
            interpreter.fetchVersion((NullableConsumer<? super SemVer>)((NullableConsumer)version -> {
                if (version != null) {
                    ApplicationManager.getApplication().invokeLater(() -> NodeJsInterpreterRenderer.scheduleRepaint(list2, interpreterRef, index), modalityState);
                }
            }));
        }
    }

    @NotNull
    private String getPresentableResolveText(@NotNull NodeJsInterpreterRef interpreterRef, @Nullable NodeInterpreterRefResolveResult resolveResult) {
        NodeJsInterpreterRef projectValueRef;
        if (interpreterRef == null) {
            NodeJsInterpreterRenderer.$$$reportNull$$$0(6);
        }
        if (interpreterRef.isProjectRef() && !(projectValueRef = NodeJsInterpreterManager.getInstance(this.myProject).getInterpreterRef()).isConstantRef()) {
            String string = projectValueRef.getReferenceName() + " (" + NodeJsInterpreterRenderer.getNonProjectRefPresentableResolveText(projectValueRef, resolveResult) + ")";
            if (string == null) {
                NodeJsInterpreterRenderer.$$$reportNull$$$0(7);
            }
            return string;
        }
        String string = NodeJsInterpreterRenderer.getNonProjectRefPresentableResolveText(interpreterRef, resolveResult);
        if (string == null) {
            NodeJsInterpreterRenderer.$$$reportNull$$$0(8);
        }
        return string;
    }

    @NotNull
    private static String getNonProjectRefPresentableResolveText(@NotNull NodeJsInterpreterRef ref, @Nullable NodeInterpreterRefResolveResult resolveResult) {
        if (ref == null) {
            NodeJsInterpreterRenderer.$$$reportNull$$$0(9);
        }
        NodeJsInterpreter interpreter = resolveResult != null ? (NodeJsInterpreter)resolveResult.getInterpreter() : null;
        NodeLocalInterpreterRefResolveResult localResolveResult = (NodeLocalInterpreterRefResolveResult)ObjectUtils.tryCast((Object)resolveResult, NodeLocalInterpreterRefResolveResult.class);
        if (localResolveResult != null && localResolveResult.getNodeVersionFileName() != null) {
            String text = localResolveResult.getNodeVersionFileName() + " " + UIUtil.rightArrow() + " ";
            if (interpreter != null) {
                String string = text + interpreter.getPresentableName();
                if (string == null) {
                    NodeJsInterpreterRenderer.$$$reportNull$$$0(10);
                }
                return string;
            }
            String string = text + StringUtil.notNullize((String)localResolveResult.getNodeVersionFileContent()).trim() + " not found";
            if (string == null) {
                NodeJsInterpreterRenderer.$$$reportNull$$$0(11);
            }
            return string;
        }
        if (interpreter != null) {
            String string = interpreter.getPresentableName();
            if (string == null) {
                NodeJsInterpreterRenderer.$$$reportNull$$$0(12);
            }
            return string;
        }
        if (NodeJsLocalInterpreterType.isNodeFromPathRef(ref)) {
            String string = "No executable found in " + (SystemInfo.isWindows ? "%PATH%" : "$PATH");
            if (string == null) {
                NodeJsInterpreterRenderer.$$$reportNull$$$0(13);
            }
            return string;
        }
        if (NO_INTERPRETER_TEXT == null) {
            NodeJsInterpreterRenderer.$$$reportNull$$$0(14);
        }
        return NO_INTERPRETER_TEXT;
    }

    private static void scheduleRepaint(@NotNull JList<? extends NodeJsInterpreterRef> list2, @NotNull NodeJsInterpreterRef interpreterRef, int index) {
        NodeJsInterpreterRef value;
        if (list2 == null) {
            NodeJsInterpreterRenderer.$$$reportNull$$$0(15);
        }
        if (interpreterRef == null) {
            NodeJsInterpreterRenderer.$$$reportNull$$$0(16);
        }
        if (!list2.isVisible()) {
            return;
        }
        ListModel<? extends NodeJsInterpreterRef> listModel = list2.getModel();
        if (index == -1) {
            if (listModel instanceof NodeJsInterpreterField.NodeJsInterpreterComboBoxModel) {
                ((NodeJsInterpreterField.NodeJsInterpreterComboBoxModel)listModel).repaintSelectedElementIfMatches(interpreterRef);
            } else {
                LOG.warn("Expected ListModel class: " + NodeJsInterpreterField.NodeJsInterpreterComboBoxModel.class + ", actual: " + listModel.getClass());
            }
        } else if (0 <= index && index < listModel.getSize() && (value = listModel.getElementAt(index)) == interpreterRef) {
            list2.repaint(list2.getCellBounds(index, index));
        }
    }

    private void addVersion(@NotNull SemVer version, boolean isSelected) {
        if (version == null) {
            NodeJsInterpreterRenderer.$$$reportNull$$$0(17);
        }
        SimpleTextAttributes attrs = isSelected ? SimpleTextAttributes.REGULAR_ATTRIBUTES : SimpleTextAttributes.GRAY_ATTRIBUTES;
        this.myVersionComp.append(version.getRawVersion(), attrs);
    }

    @NotNull
    private static String getPresentableRefName(@NotNull NodeJsInterpreterRef interpreterRef) {
        if (interpreterRef == null) {
            NodeJsInterpreterRenderer.$$$reportNull$$$0(18);
        }
        if (interpreterRef.isProjectRef()) {
            if ("Project" == null) {
                NodeJsInterpreterRenderer.$$$reportNull$$$0(19);
            }
            return "Project";
        }
        if (NodeJsLocalInterpreterType.isNodeFromPathRef(interpreterRef)) {
            if ("node" == null) {
                NodeJsInterpreterRenderer.$$$reportNull$$$0(20);
            }
            return "node";
        }
        String string = interpreterRef.getReferenceName();
        if (string == null) {
            NodeJsInterpreterRenderer.$$$reportNull$$$0(21);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 19: 
            case 20: 
            case 21: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 19: 
            case 20: 
            case 21: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 3: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 19: 
            case 20: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/nodejs/interpreter/NodeJsInterpreterRenderer";
                break;
            }
            case 4: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
            case 5: 
            case 6: 
            case 16: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interpreterRef";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "version";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/nodejs/interpreter/NodeJsInterpreterRenderer";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "wrapInLeftRightJustifyingContainer";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableResolveText";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getNonProjectRefPresentableResolveText";
                break;
            }
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableRefName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "adjustBorderHeight";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "wrapInLeftRightJustifyingContainer";
                break;
            }
            case 3: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 19: 
            case 20: 
            case 21: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "customize";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getPresentableResolveText";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getNonProjectRefPresentableResolveText";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "scheduleRepaint";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "addVersion";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getPresentableRefName";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 19: 
            case 20: 
            case 21: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

