/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.nodejs.library.core;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.intellij.lang.javascript.library.JSLibraryManager;
import com.intellij.lang.javascript.library.JSLibraryMappings;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.SemVer;
import com.intellij.webcore.ScriptingFrameworkDescriptor;
import com.intellij.webcore.libraries.ScriptingLibraryModel;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.annotations.NotNull;

public class NodeCoreLibraryUtil {
    private static final Logger LOG = Logger.getInstance(NodeCoreLibraryUtil.class);
    private static final String[] GLOBAL_STUB_NAMES = new String[]{"node-globals-stub.js", "node-buffer-stub.js", "node-console-stub.js", "node-timers-stub.js"};
    private static final String OLD_NODE_CORE_MODULE_FRAMEWORK_NAME = "Node.js Core Modules";
    private static final AtomicBoolean REFRESHED = new AtomicBoolean(false);
    private static volatile Set<VirtualFile> GLOBAL_STUB_FILES = null;

    private NodeCoreLibraryUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    public static Set<VirtualFile> getNodeGlobalStubFiles() {
        ImmutableSet files = GLOBAL_STUB_FILES;
        if (files == null) {
            String[] stringArray = GLOBAL_STUB_NAMES;
            // MONITORENTER : GLOBAL_STUB_NAMES
            files = GLOBAL_STUB_FILES;
            if (files == null) {
                GLOBAL_STUB_FILES = files = ImmutableSet.copyOf(NodeCoreLibraryUtil.listNodeGlobalStubFiles());
            }
            // MONITOREXIT : stringArray
        }
        ImmutableSet immutableSet = files;
        if (immutableSet != null) return immutableSet;
        NodeCoreLibraryUtil.$$$reportNull$$$0(0);
        return immutableSet;
    }

    @NotNull
    private static List<VirtualFile> listNodeGlobalStubFiles() {
        ArrayList<VirtualFile> files = new ArrayList<VirtualFile>(GLOBAL_STUB_NAMES.length);
        List toRefresh = ContainerUtil.newSmartList();
        for (String name : GLOBAL_STUB_NAMES) {
            URL url = NodeCoreLibraryUtil.class.getResource(name);
            if (url == null) {
                LOG.error("NodeJS plugin installation is possibly broken. Cannot find " + name);
                continue;
            }
            VirtualFile file2 = VfsUtil.findFileByURL((URL)url);
            if (file2 == null || !file2.isValid()) {
                LOG.warn("NodeJS plugin installation is possibly broken. Cannot find virtual file for " + name + ", url: " + url.toExternalForm());
                toRefresh.add(url);
                continue;
            }
            files.add(file2);
        }
        if (!toRefresh.isEmpty() && REFRESHED.compareAndSet(false, true)) {
            NodeCoreLibraryUtil.refreshAll(toRefresh);
        }
        ImmutableList immutableList = ImmutableList.copyOf(files);
        if (immutableList == null) {
            NodeCoreLibraryUtil.$$$reportNull$$$0(1);
        }
        return immutableList;
    }

    private static void refreshAll(@NotNull List<URL> toRefresh) {
        if (toRefresh == null) {
            NodeCoreLibraryUtil.$$$reportNull$$$0(2);
        }
        ApplicationManager.getApplication().invokeLater(() -> ApplicationManager.getApplication().runWriteAction(() -> {
            for (URL url : toRefresh) {
                NodeCoreLibraryUtil.refresh(url);
            }
            GLOBAL_STUB_FILES = null;
            for (Project project : ProjectManager.getInstance().getOpenProjects()) {
                JSLibraryManager.getInstance(project).commitChanges();
            }
        }), ModalityState.any());
    }

    private static void refresh(@NotNull URL url) {
        if (url == null) {
            NodeCoreLibraryUtil.$$$reportNull$$$0(3);
        }
        LOG.info("Refreshing " + url);
        VirtualFileManager virtualFileManager = VirtualFileManager.getInstance();
        String vfUrl = VfsUtilCore.convertFromUrl((URL)url);
        VirtualFile file2 = virtualFileManager.findFileByUrl(vfUrl);
        if (file2 == null || !file2.isValid()) {
            file2 = virtualFileManager.refreshAndFindFileByUrl(vfUrl);
        }
        if (file2 == null || !file2.isValid()) {
            LOG.error("NodeJS plugin installation is possibly broken. Cannot find virtual file by url: " + url.toExternalForm() + ", file: " + file2);
        }
    }

    private static boolean isOldCoreModulesLibrary(@NotNull ScriptingLibraryModel model) {
        ScriptingFrameworkDescriptor descriptor2;
        if (model == null) {
            NodeCoreLibraryUtil.$$$reportNull$$$0(4);
        }
        return (descriptor2 = model.getFrameworkDescriptor()) != null && !model.isPredefined() && OLD_NODE_CORE_MODULE_FRAMEWORK_NAME.equals(descriptor2.getFrameworkName());
    }

    public static boolean isOldLibraryOrderEntry(@NotNull OrderEntry orderEntry) {
        LibraryOrderEntry libraryOrderEntry;
        String libraryName;
        if (orderEntry == null) {
            NodeCoreLibraryUtil.$$$reportNull$$$0(5);
        }
        if (!orderEntry.isValid() && orderEntry instanceof LibraryOrderEntry && (libraryName = (libraryOrderEntry = (LibraryOrderEntry)orderEntry).getLibraryName()) != null && "application".equals(libraryOrderEntry.getLibraryLevel())) {
            String prefix = "Node.js ";
            String suffix = " Core Modules";
            if (libraryName.startsWith(prefix) && libraryName.endsWith(suffix)) {
                libraryName = StringUtil.trimStart((String)libraryName, (String)prefix);
                return SemVer.parseFromText((String)StringUtil.trimStart((String)(libraryName = StringUtil.trimEnd((String)libraryName, (String)suffix)), (String)"v")) != null;
            }
        }
        return false;
    }

    @NotNull
    public static List<ScriptingLibraryModel> listOldLibraries(@NotNull Project project) {
        if (project == null) {
            NodeCoreLibraryUtil.$$$reportNull$$$0(6);
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        JSLibraryManager libraryManager = JSLibraryManager.getInstance(project);
        List list2 = ContainerUtil.filter((Object[])libraryManager.getAllLibraries(), libraryModel -> NodeCoreLibraryUtil.isOldCoreModulesLibrary(libraryModel));
        if (list2 == null) {
            NodeCoreLibraryUtil.$$$reportNull$$$0(7);
        }
        return list2;
    }

    public static boolean removeOldLibraries(@NotNull Project project) {
        if (project == null) {
            NodeCoreLibraryUtil.$$$reportNull$$$0(8);
        }
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        JSLibraryManager libraryManager = JSLibraryManager.getInstance(project);
        JSLibraryMappings libraryMappings = JSLibraryMappings.getInstance(project);
        List<ScriptingLibraryModel> oldCoreLibraries = NodeCoreLibraryUtil.listOldLibraries(project);
        if (oldCoreLibraries.isEmpty()) {
            return false;
        }
        for (ScriptingLibraryModel oldLibrary : oldCoreLibraries) {
            LOG.info("Removing old Node.js library: " + oldLibrary.getName());
            List files = libraryMappings.getMappingsByLibraryName(oldLibrary.getName());
            for (VirtualFile file2 : files) {
                libraryMappings.disassociate(file2, oldLibrary.getName());
            }
            libraryManager.removeLibrary(oldLibrary);
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/nodejs/library/core/NodeCoreLibraryUtil";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toRefresh";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "orderEntry";
                break;
            }
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getNodeGlobalStubFiles";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "listNodeGlobalStubFiles";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/nodejs/library/core/NodeCoreLibraryUtil";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "listOldLibraries";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "refreshAll";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "refresh";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isOldCoreModulesLibrary";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isOldLibraryOrderEntry";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "listOldLibraries";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "removeOldLibraries";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

