/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ecmascript6.psi.impl;

import com.intellij.codeInsight.completion.CompletionUtil;
import com.intellij.javascript.JSFileReference;
import com.intellij.javascript.nodejs.NodeModuleDirectorySearchProcessor;
import com.intellij.javascript.nodejs.PackageJsonData;
import com.intellij.lang.ecmascript6.psi.ES6FromClause;
import com.intellij.lang.ecmascript6.psi.ES6ImportDeclaration;
import com.intellij.lang.ecmascript6.psi.impl.ES6CreateImportUtil;
import com.intellij.lang.ecmascript6.psi.impl.ES6ImportPsiUtil;
import com.intellij.lang.ecmascript6.psi.impl.JSAnyModuleImportPathBuilder;
import com.intellij.lang.ecmascript6.psi.impl.JSImportPathConfiguration;
import com.intellij.lang.ecmascript6.psi.impl.JSSymlinkLinkedProject;
import com.intellij.lang.ecmascript6.psi.impl.TypeScriptImportPathBuilder;
import com.intellij.lang.ecmascript6.psi.impl.TypeScriptInES6ImportPathBuilder;
import com.intellij.lang.ecmascript6.resolve.ES6PsiUtil;
import com.intellij.lang.ecmascript6.resolve.JSFileReferencesUtil;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSStringUtil;
import com.intellij.lang.javascript.buildTools.npm.PackageJsonUtil;
import com.intellij.lang.javascript.formatter.JSCodeStyleSettings;
import com.intellij.lang.javascript.frameworks.modules.JSExactFileReference;
import com.intellij.lang.javascript.frameworks.modules.JSModulePathSubstitution;
import com.intellij.lang.javascript.frameworks.modules.JSModulePattern;
import com.intellij.lang.javascript.frameworks.modules.JSPathMappingsUtil;
import com.intellij.lang.javascript.library.JSLibraryUtil;
import com.intellij.lang.javascript.modules.JSModuleNameInfo;
import com.intellij.lang.javascript.modules.JSModuleNameInfoImpl;
import com.intellij.lang.javascript.modules.NodeModuleUtil;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.resolve.JSModuleReferenceContributor;
import com.intellij.lang.typescript.modules.TypeScriptNodeReference;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfigUtil;
import com.intellij.lang.typescript.tsconfig.TypeScriptFileExportsImpl;
import com.intellij.lang.typescript.tsconfig.graph.TypeScriptImportGraph;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.ResolveResult;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PairFunction;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.webcore.resourceRoots.WebResourcesPathsConfiguration;
import gnu.trove.THashSet;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class JSImportPathBuilder {
    private static final Logger LOGGER = Logger.getInstance(JSImportPathBuilder.class);
    @Nullable
    protected final PsiElement myElementToImport;
    @NotNull
    protected final PsiElement myPlace;
    @NotNull
    protected final VirtualFile myPlaceFile;
    @NotNull
    protected final VirtualFile myFileToImport;
    @NotNull
    protected final Project myProject;
    @NotNull
    protected final PsiElement myPlaceModule;
    @NotNull
    private final String[] myExtensions;
    @NotNull
    protected final JSImportPathConfiguration myConfiguration;

    protected JSImportPathBuilder(@NotNull JSImportPathConfiguration configuration) {
        if (configuration == null) {
            JSImportPathBuilder.$$$reportNull$$$0(0);
        }
        this.myConfiguration = configuration;
        PsiElement place = this.myConfiguration.getPlace();
        this.myProject = place.getProject();
        String[] extensions = (String[])ArrayUtil.copyOf((Object[])configuration.extensions());
        Arrays.sort(extensions, Comparator.comparing(el -> -el.length()));
        this.myExtensions = extensions;
        PsiFile originalFile = place.getContainingFile().getOriginalFile();
        PsiElement originalElement = CompletionUtil.getOriginalElement((PsiElement)place);
        if (originalElement == null) {
            originalElement = originalFile;
        }
        this.myPlaceModule = ES6PsiUtil.isExternalModule(originalElement) ? originalElement : (PsiElement)ObjectUtils.coalesce((Object)ES6PsiUtil.findExternalModule(place), (Object)originalFile);
        this.myPlace = place;
        this.myPlaceFile = originalFile.getVirtualFile();
        this.myElementToImport = configuration.getElementToImport();
        this.myFileToImport = configuration.getFileToImport();
    }

    @NotNull
    public static JSImportPathBuilder createBuilder(@NotNull JSImportPathConfiguration configuration) {
        PsiElement place;
        if (configuration == null) {
            JSImportPathBuilder.$$$reportNull$$$0(1);
        }
        if (DialectDetector.isTypeScript(place = configuration.getPlace())) {
            TypeScriptImportPathBuilder typeScriptImportPathBuilder = new TypeScriptImportPathBuilder(configuration);
            if (typeScriptImportPathBuilder == null) {
                JSImportPathBuilder.$$$reportNull$$$0(2);
            }
            return typeScriptImportPathBuilder;
        }
        PsiElement toImport = configuration.getElementToImport();
        if (toImport != null && DialectDetector.isTypeScript(toImport)) {
            TypeScriptInES6ImportPathBuilder typeScriptInES6ImportPathBuilder = new TypeScriptInES6ImportPathBuilder(configuration);
            if (typeScriptInES6ImportPathBuilder == null) {
                JSImportPathBuilder.$$$reportNull$$$0(3);
            }
            return typeScriptInES6ImportPathBuilder;
        }
        JSAnyModuleImportPathBuilder jSAnyModuleImportPathBuilder = new JSAnyModuleImportPathBuilder(configuration);
        if (jSAnyModuleImportPathBuilder == null) {
            JSImportPathBuilder.$$$reportNull$$$0(4);
        }
        return jSAnyModuleImportPathBuilder;
    }

    @Nullable
    protected JSModuleNameInfo processRootPaths(@NotNull VirtualFile moduleFileOrDirectory, @NotNull VirtualFile resolvedModuleFile) {
        String rootPath;
        if (moduleFileOrDirectory == null) {
            JSImportPathBuilder.$$$reportNull$$$0(5);
        }
        if (resolvedModuleFile == null) {
            JSImportPathBuilder.$$$reportNull$$$0(6);
        }
        if ((rootPath = this.getPathRelativeToRoots(moduleFileOrDirectory)) != null) {
            return this.createModuleNameInfo(rootPath, moduleFileOrDirectory, resolvedModuleFile);
        }
        return null;
    }

    @NotNull
    protected JSModuleNameInfo createModuleNameInfo(@NotNull String rootPath, @NotNull VirtualFile moduleFileOrDirectory, @NotNull VirtualFile resolvedModuleFile) {
        if (rootPath == null) {
            JSImportPathBuilder.$$$reportNull$$$0(7);
        }
        if (moduleFileOrDirectory == null) {
            JSImportPathBuilder.$$$reportNull$$$0(8);
        }
        if (resolvedModuleFile == null) {
            JSImportPathBuilder.$$$reportNull$$$0(9);
        }
        JSModuleNameInfoImpl jSModuleNameInfoImpl = new JSModuleNameInfoImpl(rootPath, moduleFileOrDirectory, resolvedModuleFile, this.myPlace, this.myExtensions, this.myConfiguration.forceExtension());
        if (jSModuleNameInfoImpl == null) {
            JSImportPathBuilder.$$$reportNull$$$0(10);
        }
        return jSModuleNameInfoImpl;
    }

    protected final void processDirectModuleNames(boolean checkNodeResolution, @NotNull Processor<JSModuleNameInfo> processor) {
        if (processor == null) {
            JSImportPathBuilder.$$$reportNull$$$0(11);
        }
        if (checkNodeResolution && this.useNodeResolution()) {
            if (!this.processForNodeResolutionSymlinks(processor)) {
                return;
            }
            if (!this.processModuleFileWithNodeResolution(processor)) {
                return;
            }
        }
        this.processForModuleFile(processor, this.myFileToImport, this.myFileToImport);
    }

    protected boolean processForNodeResolutionSymlinks(@NotNull Processor<? super JSModuleNameInfo> processor) {
        String pathFromImportRoot;
        if (processor == null) {
            JSImportPathBuilder.$$$reportNull$$$0(12);
        }
        if (this.myFileToImport.isDirectory() || NodeModuleUtil.hasNodeModulesDirInPath(this.myFileToImport, ProjectUtil.guessProjectDir((Project)this.myProject))) {
            return true;
        }
        VirtualFile placeRoot = NodeModuleUtil.getMainModuleRoot(this.myPlace);
        if (placeRoot == null) {
            return true;
        }
        VirtualFile importRoot = NodeModuleUtil.findMainModuleRoot(this.myProject, this.myFileToImport);
        if (importRoot == null || placeRoot.equals(importRoot)) {
            return true;
        }
        VirtualFile importPackageJson = PackageJsonUtil.findChildPackageJsonFile(importRoot);
        if (importPackageJson == null) {
            return true;
        }
        VirtualFile commonParent = VfsUtilCore.getCommonAncestor((VirtualFile)placeRoot, (VirtualFile)importRoot);
        if (commonParent == null || importRoot.equals(commonParent)) {
            return true;
        }
        PackageJsonData importData = PackageJsonUtil.getOrCreateData(importPackageJson);
        String importPackageName = importData.getName();
        if (importPackageName == null) {
            importPackageName = importRoot.getName();
        }
        if ((pathFromImportRoot = VfsUtilCore.getRelativePath((VirtualFile)this.myFileToImport, (VirtualFile)importRoot)) == null) {
            return true;
        }
        VirtualFile placeRootNodeModules = placeRoot.findChild("node_modules");
        if (!this.processSymlinkForNodeModules(processor, this.getLinkedProject(importRoot, placeRootNodeModules, importPackageName))) {
            return false;
        }
        VirtualFile rootProject = NodeModuleUtil.findMainModuleRoot(this.myProject, commonParent);
        if (rootProject == null) {
            return true;
        }
        VirtualFile commonRootNodeModules = rootProject.findChild("node_modules");
        return this.processSymlinkForNodeModules(processor, this.getLinkedProject(importRoot, commonRootNodeModules, importPackageName));
    }

    private boolean processSymlinkForNodeModules(@NotNull Processor<? super JSModuleNameInfo> processor, @Nullable JSSymlinkLinkedProject linkedProject) {
        if (processor == null) {
            JSImportPathBuilder.$$$reportNull$$$0(13);
        }
        if (linkedProject == null) {
            return true;
        }
        VirtualFile importRoot = linkedProject.getImportRoot();
        for (VirtualFile packageResolveFile : this.resolveFileAsNpmPackage(linkedProject.getLinkedPackage())) {
            VirtualFile sourceFile;
            if (packageResolveFile == null || (sourceFile = linkedProject.getSourceFileByLinkedFile(packageResolveFile)) == null || this.checkSymbolAndGetFile(sourceFile) == null || processor.process((Object)this.createModuleNameInfo(linkedProject.getPackageName(), importRoot, sourceFile))) continue;
            return false;
        }
        return this.processHierarchy(importRoot, (PairFunction<? super VirtualFile, ? super VirtualFile, Boolean>)((PairFunction)(candidate, resolvedFile) -> {
            String path = linkedProject.getLinkedPath((VirtualFile)candidate);
            if (path == null) {
                return true;
            }
            return processor.process((Object)this.createModuleNameInfo(path, (VirtualFile)candidate, (VirtualFile)resolvedFile));
        }));
    }

    private boolean processModuleFileWithNodeResolution(@NotNull Processor<JSModuleNameInfo> processor) {
        if (processor == null) {
            JSImportPathBuilder.$$$reportNull$$$0(14);
        }
        VirtualFile importDirectory = this.myFileToImport.getParent();
        VirtualFile sourceRoot = ProjectFileIndex.getInstance((Project)this.myProject).getContentRootForFile(importDirectory);
        if (VfsUtilCore.isAncestor((VirtualFile)importDirectory, (VirtualFile)this.myPlaceFile, (boolean)true)) {
            return true;
        }
        VirtualFile placeDirectory = this.myPlaceFile.getParent();
        if (placeDirectory == null) {
            return true;
        }
        return this.iterateParentDirectoriesForNodeResolution(processor, importDirectory, placeDirectory, sourceRoot);
    }

    private boolean iterateParentDirectoriesForNodeResolution(@NotNull Processor<JSModuleNameInfo> processor, @NotNull VirtualFile toIterateDirectory, @NotNull VirtualFile placeDirectory, @Nullable VirtualFile sourceRoot) {
        if (processor == null) {
            JSImportPathBuilder.$$$reportNull$$$0(15);
        }
        if (toIterateDirectory == null) {
            JSImportPathBuilder.$$$reportNull$$$0(16);
        }
        if (placeDirectory == null) {
            JSImportPathBuilder.$$$reportNull$$$0(17);
        }
        while (!(toIterateDirectory == null || sourceRoot != null && sourceRoot.equals(toIterateDirectory) || toIterateDirectory.equals(placeDirectory))) {
            VirtualFile resolvedModuleFile = this.checkSymbolAndGetFile(toIterateDirectory);
            if (resolvedModuleFile != null && !this.processForModuleFile(processor, toIterateDirectory, resolvedModuleFile)) {
                return false;
            }
            toIterateDirectory = toIterateDirectory.getParent();
        }
        return true;
    }

    private boolean processForModuleFile(@NotNull Processor<JSModuleNameInfo> processor, VirtualFile moduleFileOrDirectory, VirtualFile resolvedModuleFile) {
        JSModuleNameInfo rootModuleInfo;
        if (processor == null) {
            JSImportPathBuilder.$$$reportNull$$$0(18);
        }
        if (!this.processContributorsForModuleFile(processor, moduleFileOrDirectory, resolvedModuleFile)) {
            return false;
        }
        if (this.myConfiguration.isProcessRootPaths() && (rootModuleInfo = this.processRootPaths(moduleFileOrDirectory, resolvedModuleFile)) != null && !processor.process((Object)rootModuleInfo)) {
            return false;
        }
        String externalModuleName = VfsUtilCore.findRelativePath((VirtualFile)this.myPlaceFile, (VirtualFile)moduleFileOrDirectory, (char)'/');
        if (externalModuleName == null) {
            externalModuleName = VfsUtilCore.findRelativePath((VirtualFile)this.myPlaceFile, (VirtualFile)this.myFileToImport, (char)'/');
            if (externalModuleName == null) {
                externalModuleName = this.myFileToImport.getName();
            }
            moduleFileOrDirectory = this.myFileToImport;
            resolvedModuleFile = this.myFileToImport;
        }
        if (!externalModuleName.startsWith(".") && !externalModuleName.startsWith(File.separator)) {
            externalModuleName = "./" + externalModuleName;
        }
        return processor.process((Object)this.createModuleNameInfo(externalModuleName, moduleFileOrDirectory, resolvedModuleFile));
    }

    private boolean processContributorsForModuleFile(@NotNull Processor<JSModuleNameInfo> processor, @NotNull VirtualFile moduleFileOrDirectory, @NotNull VirtualFile resolvedModuleFile) {
        if (processor == null) {
            JSImportPathBuilder.$$$reportNull$$$0(19);
        }
        if (moduleFileOrDirectory == null) {
            JSImportPathBuilder.$$$reportNull$$$0(20);
        }
        if (resolvedModuleFile == null) {
            JSImportPathBuilder.$$$reportNull$$$0(21);
        }
        for (JSModuleReferenceContributor contributor : JSModuleReferenceContributor.getSortedExtensions()) {
            JSModuleNameInfo contributorModulePath;
            if (!contributor.isApplicable(this.myPlace) || (contributorModulePath = contributor.getModuleInfo(this.myConfiguration, moduleFileOrDirectory, resolvedModuleFile)) == null || !contributorModulePath.isValid() || processor.process((Object)contributorModulePath)) continue;
            return false;
        }
        return true;
    }

    @Nullable
    protected JSModuleNameInfo getPathForRoot(@NotNull VirtualFile moduleFileOrDirectory, @NotNull VirtualFile resolvedModuleFile, @NotNull VirtualFile rootFile) {
        String path;
        if (moduleFileOrDirectory == null) {
            JSImportPathBuilder.$$$reportNull$$$0(22);
        }
        if (resolvedModuleFile == null) {
            JSImportPathBuilder.$$$reportNull$$$0(23);
        }
        if (rootFile == null) {
            JSImportPathBuilder.$$$reportNull$$$0(24);
        }
        if ((path = VfsUtilCore.findRelativePath((VirtualFile)rootFile, (VirtualFile)moduleFileOrDirectory, (char)'/')) == null) {
            path = VfsUtilCore.findRelativePath((VirtualFile)rootFile, (VirtualFile)this.myFileToImport, (char)'/');
        }
        if (path == null) {
            return null;
        }
        return this.createModuleNameInfo(path, moduleFileOrDirectory, resolvedModuleFile);
    }

    protected boolean useNodeResolution() {
        return JSCodeStyleSettings.isUseNodeResolution(this.myPlace);
    }

    public final void processModuleNames(@NotNull Processor<JSModuleNameInfo> processor) {
        if (processor == null) {
            JSImportPathBuilder.$$$reportNull$$$0(25);
        }
        if (!this.processExistingImports(processor)) {
            return;
        }
        this.processModuleNamesWithoutExistingImports(processor);
    }

    public void processModuleNamesWithoutExistingImports(@NotNull Processor<JSModuleNameInfo> processor) {
        if (processor == null) {
            JSImportPathBuilder.$$$reportNull$$$0(26);
        }
        this.processDirectModuleNames(true, processor);
    }

    protected boolean processExistingImports(@NotNull Processor<JSModuleNameInfo> processor) {
        if (processor == null) {
            JSImportPathBuilder.$$$reportNull$$$0(27);
        }
        if (!this.myConfiguration.useExistingImports() || !(this.myElementToImport instanceof JSElement)) {
            return true;
        }
        VirtualFile elementToExportFile = this.myElementToImport.getContainingFile().getVirtualFile();
        boolean isLibraryFile = JSLibraryUtil.isProbableLibraryFile(elementToExportFile, this.myProject);
        List<ES6ImportDeclaration> declarations = ES6ImportPsiUtil.getImportDeclarations(this.myPlaceModule);
        THashSet visitedModules = new THashSet();
        block0: for (ES6ImportDeclaration declaration : declarations) {
            PsiElement object;
            ES6FromClause clause = declaration.getFromClause();
            Collection<Object> objects = clause == null ? Collections.emptyList() : clause.resolveReferencedElements();
            Iterator<Object> iterator = objects.iterator();
            while (iterator.hasNext() && visitedModules.add(object = (PsiElement)iterator.next())) {
                if (!(object instanceof JSFile)) continue;
                VirtualFile virtualFile = ((JSFile)object).getVirtualFile();
                if (JSLibraryUtil.isProbableLibraryFile(virtualFile, this.myProject) != isLibraryFile) continue block0;
                ResolveResult result2 = ES6CreateImportUtil.resolveSymbolInModule((JSElement)this.myElementToImport, this.myPlace, (JSElement)((JSFile)object));
                if (result2 == null) continue;
                String path = JSStringUtil.unquoteStringLiteralValue(StringUtil.notNullize((String)clause.getReferenceText()));
                return processor.process((Object)this.createModuleNameInfo(path, virtualFile, virtualFile));
            }
        }
        return true;
    }

    @NotNull
    public static Processor<JSModuleNameInfo> createSearchProcessor(@NotNull Ref<? super JSModuleNameInfo> ref, @NotNull String[] excludedNames, @Nullable VirtualFile contextFile) {
        if (ref == null) {
            JSImportPathBuilder.$$$reportNull$$$0(28);
        }
        if (excludedNames == null) {
            JSImportPathBuilder.$$$reportNull$$$0(29);
        }
        boolean hasExcludedNames = excludedNames.length > 0;
        HashSet<String> excludedNamesSet = hasExcludedNames ? new HashSet<String>() : Collections.emptySet();
        List<String> excludePatterns = hasExcludedNames ? ContainerUtil.newSmartList() : Collections.emptyList();
        for (String name : excludedNames) {
            if (!name.contains("*")) {
                excludedNamesSet.add(name);
                continue;
            }
            excludePatterns.add(name);
        }
        Pattern excludePattern = JSImportPathBuilder.createExcludeNamePattern(contextFile, excludePatterns);
        Processor processor = info -> {
            if (!(!info.isValid() || hasExcludedNames && JSImportPathBuilder.isExcludedName(excludedNamesSet, excludePattern, info))) {
                if (ref.get() != null) {
                    LOGGER.error("Processor wasn't stop properly. Please make sure that all places use the returned value for stop");
                    return false;
                }
                ref.set(info);
                return false;
            }
            return true;
        };
        if (processor == null) {
            JSImportPathBuilder.$$$reportNull$$$0(30);
        }
        return processor;
    }

    public static boolean isExcludedName(@NotNull Set<String> excludedNames, @Nullable Pattern excludePattern, @NotNull JSModuleNameInfo info) {
        String path;
        if (excludedNames == null) {
            JSImportPathBuilder.$$$reportNull$$$0(31);
        }
        if (info == null) {
            JSImportPathBuilder.$$$reportNull$$$0(32);
        }
        if (excludedNames.contains(path = info.getModuleName())) {
            return true;
        }
        if (excludePattern == null) {
            return false;
        }
        return JSPathMappingsUtil.checkMappingPattern(path, excludePattern);
    }

    @Nullable
    public static Pattern createExcludeNamePattern(@Nullable VirtualFile contextFile, Collection<String> patterns) {
        if (patterns.isEmpty()) {
            return null;
        }
        String text = TypeScriptConfigUtil.getRegularExpressionForGlobPattern(patterns, "", TypeScriptConfigUtil.WildCardType.EXCLUDE);
        return JSPathMappingsUtil.createMappingPattern(text, contextFile);
    }

    @Nullable
    protected final VirtualFile checkSymbolAndGetFile(@NotNull VirtualFile moduleFileOrDirectory) {
        if (moduleFileOrDirectory == null) {
            JSImportPathBuilder.$$$reportNull$$$0(33);
        }
        if (moduleFileOrDirectory.equals(this.myFileToImport)) {
            return moduleFileOrDirectory;
        }
        Collection<VirtualFile> resolvedFiles = Collections.singleton(moduleFileOrDirectory);
        if (moduleFileOrDirectory.isDirectory()) {
            resolvedFiles = this.resolveFileAsNpmPackage(moduleFileOrDirectory);
        }
        if (resolvedFiles.isEmpty()) {
            return null;
        }
        VirtualFile candidate = resolvedFiles.stream().filter(el -> el.equals(this.myFileToImport)).findAny().orElse(null);
        if (candidate != null) {
            return candidate;
        }
        if (this.myElementToImport == null) {
            return null;
        }
        for (VirtualFile resolvedFile : resolvedFiles) {
            if (!ES6CreateImportUtil.checkSymbolInFile(this.myProject, resolvedFile, this.myElementToImport, this.myPlace)) continue;
            return resolvedFile;
        }
        return null;
    }

    @NotNull
    protected Collection<VirtualFile> resolveFileAsNpmPackage(@NotNull VirtualFile moduleFileOrDirectory) {
        if (moduleFileOrDirectory == null) {
            JSImportPathBuilder.$$$reportNull$$$0(34);
        }
        List list2 = ContainerUtil.createMaybeSingletonList((Object)this.resolveAsNpmPackage(moduleFileOrDirectory, this.myElementToImport == null ? this.myPlace : this.myElementToImport));
        if (list2 == null) {
            JSImportPathBuilder.$$$reportNull$$$0(35);
        }
        return list2;
    }

    @Nullable
    private VirtualFile resolveAsNpmPackage(@NotNull VirtualFile pathFile, @NotNull PsiElement context) {
        if (pathFile == null) {
            JSImportPathBuilder.$$$reportNull$$$0(36);
        }
        if (context == null) {
            JSImportPathBuilder.$$$reportNull$$$0(37);
        }
        NodeModuleDirectorySearchProcessor processor = DialectDetector.isTypeScript(context) ? new TypeScriptNodeReference.TypeScriptNodeModuleDirectorySearchProcessor(this.myProject) : NodeModuleDirectorySearchProcessor.PROCESSOR;
        return JSExactFileReference.resolveForNpmPackages(pathFile, processor);
    }

    @Nullable
    private String getPathRelativeToRoots(@NotNull VirtualFile moduleFile) {
        String path;
        ModuleRootManager rootManager;
        Object[] sourceRoots;
        String path2;
        WebResourcesPathsConfiguration pathsConfiguration;
        if (moduleFile == null) {
            JSImportPathBuilder.$$$reportNull$$$0(38);
        }
        if ((pathsConfiguration = WebResourcesPathsConfiguration.getInstance((Project)this.myProject)) != null && (path2 = JSFileReferencesUtil.getShortestPathInContexts(moduleFile, pathsConfiguration.getResourceDirectories(), false)) != null) {
            return path2;
        }
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)this.myPlace);
        if (module != null && (sourceRoots = (rootManager = ModuleRootManager.getInstance((Module)module)).getSourceRoots()).length > 0 && (path = JSFileReferencesUtil.getShortestPathInContexts(moduleFile, ContainerUtil.newArrayList((Object[])sourceRoots), false)) != null) {
            return path;
        }
        VirtualFile contentRoot = ProjectRootManager.getInstance((Project)this.myProject).getFileIndex().getContentRootForFile(this.myPlaceFile);
        return contentRoot != null ? VfsUtilCore.findRelativePath((VirtualFile)contentRoot, (VirtualFile)moduleFile, (char)'/') : null;
    }

    @Nullable
    protected final NodeModuleUtil.NodeModuleStructure getNodeModuleStructureForImportedFile() {
        return NodeModuleUtil.getNodeModuleStructure(this.myProject, this.myFileToImport);
    }

    @NotNull
    protected JSModuleNameInfo createNodeModuleNameInfo(@NotNull NodeModuleUtil.NodeModuleStructure structure, @NotNull VirtualFile moduleOrFileToImport, @NotNull VirtualFile resolvedFile) {
        if (structure == null) {
            JSImportPathBuilder.$$$reportNull$$$0(39);
        }
        if (moduleOrFileToImport == null) {
            JSImportPathBuilder.$$$reportNull$$$0(40);
        }
        if (resolvedFile == null) {
            JSImportPathBuilder.$$$reportNull$$$0(41);
        }
        String path = JSImportPathBuilder.getNodeModulePath(structure.moduleDirectory, structure.directoryToCalcModuleName, moduleOrFileToImport);
        JSModuleNameInfo jSModuleNameInfo = this.createModuleNameInfo(path, moduleOrFileToImport, resolvedFile);
        if (jSModuleNameInfo == null) {
            JSImportPathBuilder.$$$reportNull$$$0(42);
        }
        return jSModuleNameInfo;
    }

    @Nullable
    protected JSModuleNameInfo getModuleNameForMapping(@NotNull VirtualFile baseUrl, JSModulePathSubstitution substitution, @NotNull String mapping) {
        String pattern;
        if (baseUrl == null) {
            JSImportPathBuilder.$$$reportNull$$$0(43);
        }
        if (mapping == null) {
            JSImportPathBuilder.$$$reportNull$$$0(44);
        }
        if (StringUtil.isEmpty((String)(pattern = substitution.getPattern()))) {
            return null;
        }
        if ("*".equals(pattern) && ("*".equals(mapping) || "./*".equals(mapping))) {
            return null;
        }
        if ((mapping = FileUtil.toSystemIndependentName((String)mapping)).isEmpty()) {
            return null;
        }
        VirtualFile placeDirectory = this.myPlaceFile.getParent();
        if (substitution.isExact()) {
            VirtualFile pathFile = this.getPossibleFileWithExtension(baseUrl, mapping);
            if (pathFile != null) {
                VirtualFile file2;
                VirtualFile virtualFile = file2 = JSImportPathBuilder.isFromNestedDirectory(pathFile, this.myFileToImport) ? this.checkSymbolAndGetFile(pathFile) : null;
                if (file2 == null) {
                    return null;
                }
                if (Objects.equals(placeDirectory, file2.getParent()) && JSImportPathBuilder.isIndexFile(file2)) {
                    return null;
                }
                if (this.checkCircularDependency(file2)) {
                    return null;
                }
                return this.createModuleNameInfo(pattern, pathFile, file2);
            }
            return null;
        }
        VirtualFile startDirectory = baseUrl;
        String pathPrefix = substitution.getPathPrefix(mapping);
        if (pathPrefix != null) {
            startDirectory = JSPathMappingsUtil.getPathRelativeBaseUrlOrSelfIfAbsolute(baseUrl, pathPrefix);
        }
        if (startDirectory == null) {
            return null;
        }
        List<VirtualFile> parents = JSImportPathBuilder.collectParents(this.myFileToImport, startDirectory);
        if (parents.isEmpty()) {
            return null;
        }
        if (this.myConfiguration.relativeForSamePathMappings() && this.isPlaceFromSamePaths(startDirectory)) {
            return null;
        }
        String partOfString = substitution.getMappedString(mapping);
        for (VirtualFile pathFile : ContainerUtil.reverse(parents)) {
            VirtualFile file3;
            String stringToCheckPattern;
            if (pathFile.equals(placeDirectory) || StringUtil.isEmpty((String)(stringToCheckPattern = VfsUtilCore.findRelativePath((VirtualFile)startDirectory, (VirtualFile)pathFile, (char)'/')))) continue;
            JSModulePattern pathSubstitution = JSPathMappingsUtil.createPatternForString(partOfString, substitution.canStartWith());
            Pair matchedStar = JSPathMappingsUtil.findMaxElementByPaths((pathPrefix != null ? "/" : "") + stringToCheckPattern, ContainerUtil.createMaybeSingletonList((Object)pathSubstitution));
            if (matchedStar == null || (file3 = this.checkSymbolAndGetFile(pathFile)) == null) continue;
            return this.createModuleNameInfo(substitution.applyPattern((String)matchedStar.second), file3, pathFile);
        }
        return null;
    }

    private boolean checkCircularDependency(@NotNull VirtualFile resolvedModuleFile) {
        if (resolvedModuleFile == null) {
            JSImportPathBuilder.$$$reportNull$$$0(45);
        }
        TypeScriptFileExportsImpl exports = TypeScriptFileExportsImpl.create(this.myProject, this.myConfiguration.getTsConfig(), resolvedModuleFile);
        return new TypeScriptImportGraph(exports).containsFile(this.myPlaceFile);
    }

    private static boolean isIndexFile(@NotNull VirtualFile file2) {
        if (file2 == null) {
            JSImportPathBuilder.$$$reportNull$$$0(46);
        }
        return file2.getName().startsWith("index.");
    }

    private boolean isPlaceFromSamePaths(@NotNull VirtualFile startDirectory) {
        if (startDirectory == null) {
            JSImportPathBuilder.$$$reportNull$$$0(47);
        }
        return VfsUtilCore.isAncestor((VirtualFile)startDirectory, (VirtualFile)this.myPlaceFile, (boolean)true);
    }

    @Nullable
    private VirtualFile getPossibleFileWithExtension(@NotNull VirtualFile baseUrl, @NotNull String mapping) {
        if (baseUrl == null) {
            JSImportPathBuilder.$$$reportNull$$$0(48);
        }
        if (mapping == null) {
            JSImportPathBuilder.$$$reportNull$$$0(49);
        }
        if (JSFileReference.findExtension(mapping, this.myExtensions) != null) {
            return JSPathMappingsUtil.getPathRelativeBaseUrlOrSelfIfAbsolute(baseUrl, mapping);
        }
        for (String extension : this.myExtensions) {
            VirtualFile possibleFile = JSPathMappingsUtil.getPathRelativeBaseUrlOrSelfIfAbsolute(baseUrl, mapping + extension);
            if (possibleFile == null) continue;
            return possibleFile;
        }
        return JSPathMappingsUtil.getPathRelativeBaseUrlOrSelfIfAbsolute(baseUrl, mapping);
    }

    private static boolean isFromNestedDirectory(VirtualFile parentFile, VirtualFile dstFile) {
        if (parentFile.equals(dstFile)) {
            return true;
        }
        if (!parentFile.isDirectory()) {
            parentFile = parentFile.getParent();
        }
        return VfsUtilCore.isAncestor((VirtualFile)parentFile, (VirtualFile)dstFile, (boolean)false);
    }

    protected final boolean processModuleNameUsingNodeModules(@NotNull Processor<JSModuleNameInfo> processor) {
        NodeModuleUtil.NodeModuleStructure nodeModuleStructure;
        if (processor == null) {
            JSImportPathBuilder.$$$reportNull$$$0(50);
        }
        if ((nodeModuleStructure = this.getNodeModuleStructureForImportedFile()) == null) {
            return true;
        }
        if (!this.processModuleUsingNodeModules(processor, nodeModuleStructure)) {
            return false;
        }
        return NodeModuleUtil.hasNodeModulesDirInPath(this.myPlaceFile, null);
    }

    protected abstract boolean processModuleUsingNodeModules(@NotNull Processor<JSModuleNameInfo> var1, @NotNull NodeModuleUtil.NodeModuleStructure var2);

    @Nullable
    protected static String getNodeModulePath(@NotNull VirtualFile moduleDirectory, @NotNull VirtualFile directoryToCalcModuleName, @NotNull VirtualFile moduleOrFileToImport) {
        String path;
        if (moduleDirectory == null) {
            JSImportPathBuilder.$$$reportNull$$$0(51);
        }
        if (directoryToCalcModuleName == null) {
            JSImportPathBuilder.$$$reportNull$$$0(52);
        }
        if (moduleOrFileToImport == null) {
            JSImportPathBuilder.$$$reportNull$$$0(53);
        }
        if ((path = VfsUtilCore.findRelativePath((VirtualFile)directoryToCalcModuleName, (VirtualFile)moduleOrFileToImport, (char)'/')) == null || !NodeModuleUtil.isTypesDir(directoryToCalcModuleName)) {
            return path;
        }
        String name = moduleDirectory.getName();
        if (!path.startsWith(name)) {
            return path;
        }
        int separatorIndex = name.indexOf("__");
        if (separatorIndex <= 0) {
            return path;
        }
        String convertedName = ES6CreateImportUtil.convertScopedTypesName(name);
        if (convertedName.equals(name)) {
            return path;
        }
        String subPath = path.substring(name.length());
        return convertedName + subPath;
    }

    protected boolean processHierarchy(@NotNull VirtualFile parentToStop, @NotNull PairFunction<? super VirtualFile, ? super VirtualFile, Boolean> parentFileProcessor) {
        if (parentToStop == null) {
            JSImportPathBuilder.$$$reportNull$$$0(54);
        }
        if (parentFileProcessor == null) {
            JSImportPathBuilder.$$$reportNull$$$0(55);
        }
        return this.processElements(ContainerUtil.reverse(JSImportPathBuilder.collectParents(this.myFileToImport, parentToStop)), parentFileProcessor);
    }

    protected boolean processElements(@NotNull List<VirtualFile> elementsToProcess, @NotNull PairFunction<? super VirtualFile, ? super VirtualFile, Boolean> fileProcessor) {
        if (elementsToProcess == null) {
            JSImportPathBuilder.$$$reportNull$$$0(56);
        }
        if (fileProcessor == null) {
            JSImportPathBuilder.$$$reportNull$$$0(57);
        }
        for (VirtualFile current : elementsToProcess) {
            ProgressManager.checkCanceled();
            VirtualFile resolved = this.checkSymbolAndGetFile(current);
            if (resolved == null || ((Boolean)fileProcessor.fun((Object)current, (Object)resolved)).booleanValue()) continue;
            return false;
        }
        return true;
    }

    @NotNull
    protected static List<VirtualFile> collectParents(@NotNull VirtualFile dstFile, @NotNull VirtualFile parentToStop) {
        if (dstFile == null) {
            JSImportPathBuilder.$$$reportNull$$$0(58);
        }
        if (parentToStop == null) {
            JSImportPathBuilder.$$$reportNull$$$0(59);
        }
        ArrayList parents = ContainerUtil.newArrayList((Object[])new VirtualFile[]{dstFile});
        boolean hasParent = false;
        for (VirtualFile parent = dstFile.getParent(); parent != null; parent = parent.getParent()) {
            ProgressManager.checkCanceled();
            if (parentToStop.equals(parent)) {
                hasParent = true;
                break;
            }
            parents.add(parent);
        }
        if (!hasParent) {
            List list2 = ContainerUtil.emptyList();
            if (list2 == null) {
                JSImportPathBuilder.$$$reportNull$$$0(60);
            }
            return list2;
        }
        ArrayList arrayList = parents;
        if (arrayList == null) {
            JSImportPathBuilder.$$$reportNull$$$0(61);
        }
        return arrayList;
    }

    @Nullable
    protected JSSymlinkLinkedProject getLinkedProject(@NotNull VirtualFile importRoot, @Nullable VirtualFile nodeModules, @Nullable String packageName) {
        VirtualFile linkedPackage;
        if (importRoot == null) {
            JSImportPathBuilder.$$$reportNull$$$0(62);
        }
        if ((linkedPackage = JSImportPathBuilder.getLinkedPackage(importRoot, nodeModules, packageName)) == null) {
            return null;
        }
        return new JSSymlinkLinkedProject(importRoot, linkedPackage, packageName);
    }

    @Nullable
    public final JSModuleNameInfo resolveMappingsForBaseUrl(@NotNull VirtualFile baseUrl, @NotNull Collection<? extends JSModulePathSubstitution> mappings) {
        if (baseUrl == null) {
            JSImportPathBuilder.$$$reportNull$$$0(63);
        }
        if (mappings == null) {
            JSImportPathBuilder.$$$reportNull$$$0(64);
        }
        return this.resolveMappingsForBaseUrl(Collections.singleton(baseUrl), mappings);
    }

    @Nullable
    public final JSModuleNameInfo resolveMappingsForBaseUrl(@NotNull Collection<VirtualFile> baseUrls, @NotNull Collection<? extends JSModulePathSubstitution> mappings) {
        if (baseUrls == null) {
            JSImportPathBuilder.$$$reportNull$$$0(65);
        }
        if (mappings == null) {
            JSImportPathBuilder.$$$reportNull$$$0(66);
        }
        if (!this.myConfiguration.usePathMappings()) {
            return null;
        }
        JSModuleNameInfo currentInfo = null;
        String currentMapping = null;
        for (JSModulePathSubstitution jSModulePathSubstitution : mappings) {
            for (String mapping : jSModulePathSubstitution.getMappings()) {
                if (StringUtil.isEmpty((String)mapping)) continue;
                for (VirtualFile baseUrl : baseUrls) {
                    JSModuleNameInfo possibleMapping = this.getModuleNameForMapping(baseUrl, jSModulePathSubstitution, mapping);
                    if (possibleMapping == null || !JSImportPathBuilder.shouldUseNewMapping(currentInfo, currentMapping, possibleMapping, mapping)) continue;
                    currentInfo = possibleMapping;
                    currentMapping = mapping;
                }
            }
        }
        return currentInfo;
    }

    private static boolean shouldUseNewMapping(@Nullable JSModuleNameInfo oldInfo, @Nullable String oldMapping, @NotNull JSModuleNameInfo newInfo, @NotNull String newMapping) {
        if (newInfo == null) {
            JSImportPathBuilder.$$$reportNull$$$0(67);
        }
        if (newMapping == null) {
            JSImportPathBuilder.$$$reportNull$$$0(68);
        }
        if (oldInfo == null || oldMapping == null) {
            return true;
        }
        if (!oldMapping.equals(newMapping)) {
            if (oldMapping.startsWith(newMapping)) {
                return false;
            }
            if (newMapping.startsWith(oldMapping)) {
                return true;
            }
        }
        return oldInfo.getPath().length() > newInfo.getPath().length();
    }

    @Nullable
    protected static VirtualFile getLinkedPackage(@NotNull VirtualFile importRoot, @Nullable VirtualFile nodeModules, @Nullable String packageName) {
        if (importRoot == null) {
            JSImportPathBuilder.$$$reportNull$$$0(69);
        }
        if (packageName == null || nodeModules == null) {
            return null;
        }
        VirtualFile linkedPackage = nodeModules.findFileByRelativePath(packageName);
        if (linkedPackage == null || importRoot.equals(linkedPackage)) {
            return null;
        }
        if (!Objects.equals(linkedPackage.getCanonicalFile(), importRoot)) {
            return null;
        }
        return linkedPackage;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 10: 
            case 30: 
            case 35: 
            case 42: 
            case 60: 
            case 61: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 10: 
            case 30: 
            case 35: 
            case 42: 
            case 60: 
            case 61: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 10: 
            case 30: 
            case 35: 
            case 42: 
            case 60: 
            case 61: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/ecmascript6/psi/impl/JSImportPathBuilder";
                break;
            }
            case 5: 
            case 8: 
            case 20: 
            case 22: 
            case 33: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleFileOrDirectory";
                break;
            }
            case 6: 
            case 9: 
            case 21: 
            case 23: 
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolvedModuleFile";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootPath";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 18: 
            case 19: 
            case 25: 
            case 26: 
            case 27: 
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toIterateDirectory";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "placeDirectory";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootFile";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
            case 29: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "excludedNames";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pathFile";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleFile";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "structure";
                break;
            }
            case 40: 
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleOrFileToImport";
                break;
            }
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolvedFile";
                break;
            }
            case 43: 
            case 48: 
            case 63: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseUrl";
                break;
            }
            case 44: 
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mapping";
                break;
            }
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startDirectory";
                break;
            }
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleDirectory";
                break;
            }
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directoryToCalcModuleName";
                break;
            }
            case 54: 
            case 59: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentToStop";
                break;
            }
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentFileProcessor";
                break;
            }
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementsToProcess";
                break;
            }
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileProcessor";
                break;
            }
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dstFile";
                break;
            }
            case 62: 
            case 69: {
                objectArray2 = objectArray3;
                objectArray3[0] = "importRoot";
                break;
            }
            case 64: 
            case 66: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mappings";
                break;
            }
            case 65: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseUrls";
                break;
            }
            case 67: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newInfo";
                break;
            }
            case 68: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newMapping";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/ecmascript6/psi/impl/JSImportPathBuilder";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createBuilder";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "createModuleNameInfo";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "createSearchProcessor";
                break;
            }
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveFileAsNpmPackage";
                break;
            }
            case 42: {
                objectArray = objectArray2;
                objectArray2[1] = "createNodeModuleNameInfo";
                break;
            }
            case 60: 
            case 61: {
                objectArray = objectArray2;
                objectArray2[1] = "collectParents";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "createBuilder";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 10: 
            case 30: 
            case 35: 
            case 42: 
            case 60: 
            case 61: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "processRootPaths";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createModuleNameInfo";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "processDirectModuleNames";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "processForNodeResolutionSymlinks";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "processSymlinkForNodeModules";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "processModuleFileWithNodeResolution";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "iterateParentDirectoriesForNodeResolution";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "processForModuleFile";
                break;
            }
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "processContributorsForModuleFile";
                break;
            }
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getPathForRoot";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "processModuleNames";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "processModuleNamesWithoutExistingImports";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "processExistingImports";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "createSearchProcessor";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "isExcludedName";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "checkSymbolAndGetFile";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "resolveFileAsNpmPackage";
                break;
            }
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "resolveAsNpmPackage";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "getPathRelativeToRoots";
                break;
            }
            case 39: 
            case 40: 
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "createNodeModuleNameInfo";
                break;
            }
            case 43: 
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "getModuleNameForMapping";
                break;
            }
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "checkCircularDependency";
                break;
            }
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "isIndexFile";
                break;
            }
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "isPlaceFromSamePaths";
                break;
            }
            case 48: 
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "getPossibleFileWithExtension";
                break;
            }
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "processModuleNameUsingNodeModules";
                break;
            }
            case 51: 
            case 52: 
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "getNodeModulePath";
                break;
            }
            case 54: 
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "processHierarchy";
                break;
            }
            case 56: 
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "processElements";
                break;
            }
            case 58: 
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "collectParents";
                break;
            }
            case 62: {
                objectArray = objectArray;
                objectArray[2] = "getLinkedProject";
                break;
            }
            case 63: 
            case 64: 
            case 65: 
            case 66: {
                objectArray = objectArray;
                objectArray[2] = "resolveMappingsForBaseUrl";
                break;
            }
            case 67: 
            case 68: {
                objectArray = objectArray;
                objectArray[2] = "shouldUseNewMapping";
                break;
            }
            case 69: {
                objectArray = objectArray;
                objectArray[2] = "getLinkedPackage";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 10: 
            case 30: 
            case 35: 
            case 42: 
            case 60: 
            case 61: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

