/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ecmascript6.refactoring;

import com.intellij.ide.util.EditorHelper;
import com.intellij.lang.ecmascript6.refactoring.ES6ModuleMemberInfo;
import com.intellij.lang.ecmascript6.refactoring.ES6ModuleMemberInfoModel;
import com.intellij.lang.ecmascript6.refactoring.ES6ModuleMemberSelectionTable;
import com.intellij.lang.ecmascript6.refactoring.ES6MoveModuleMembersProcessor;
import com.intellij.lang.ecmascript6.refactoring.ES6MoveSymbolDialog;
import com.intellij.lang.ecmascript6.resolve.ES6PsiUtil;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.FlowJSFileType;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.ecmascript6.TypeScriptUtil;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.lang.javascript.refactoring.ui.JSVisibilityPanel;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlFile;
import com.intellij.refactoring.BaseRefactoringProcessor;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.classMembers.MemberInfoChange;
import com.intellij.refactoring.classMembers.MemberInfoChangeListener;
import com.intellij.refactoring.classMembers.MemberInfoModel;
import com.intellij.refactoring.move.MoveCallback;
import com.intellij.refactoring.ui.AbstractMemberSelectionTable;
import com.intellij.refactoring.ui.MemberSelectionPanelBase;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.util.Consumer;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ES6MoveModuleMembersDialog
extends ES6MoveSymbolDialog {
    private final ES6ModuleMemberSelectionTable mySelectionTable;
    @NotNull
    private final PsiElement mySourceModuleOrFile;
    @Nullable
    private final MoveCallback myMoveCallback;
    private final JSVisibilityPanel myVisibilityPanel;
    private static final List<FileType> JS_FILE_TYPES_WITHOUT_FLOW = ContainerUtil.filter((Object[])DialectDetector.JAVASCRIPT_FILE_TYPES_ARRAY, t -> t != FlowJSFileType.INSTANCE);

    public ES6MoveModuleMembersDialog(@NotNull Project project, @NotNull String fromPath, @NotNull String toPath, @NotNull Collection<JSQualifiedNamedElement> selectedElements, @NotNull PsiElement sourceModuleOrFile, @Nullable MoveCallback moveCallback) {
        if (project == null) {
            ES6MoveModuleMembersDialog.$$$reportNull$$$0(0);
        }
        if (fromPath == null) {
            ES6MoveModuleMembersDialog.$$$reportNull$$$0(1);
        }
        if (toPath == null) {
            ES6MoveModuleMembersDialog.$$$reportNull$$$0(2);
        }
        if (selectedElements == null) {
            ES6MoveModuleMembersDialog.$$$reportNull$$$0(3);
        }
        if (sourceModuleOrFile == null) {
            ES6MoveModuleMembersDialog.$$$reportNull$$$0(4);
        }
        super(project, fromPath, toPath, sourceModuleOrFile);
        this.mySourceModuleOrFile = sourceModuleOrFile;
        this.myMoveCallback = moveCallback;
        this.setTitle(JSBundle.message((String)"es6.move.module.members.refactoring.name", (Object[])new Object[0]));
        ES6ModuleMemberInfoModel memberInfoModel = new ES6ModuleMemberInfoModel(sourceModuleOrFile);
        List<ES6ModuleMemberInfo> moduleMemberInfos = ES6ModuleMemberInfo.getModuleMembers(sourceModuleOrFile, selectedElements);
        this.mySelectionTable = new ES6ModuleMemberSelectionTable(moduleMemberInfos, (MemberInfoModel<JSQualifiedNamedElement, ES6ModuleMemberInfo>)memberInfoModel);
        this.mySelectionTable.addMemberInfoChangeListener((MemberInfoChangeListener)memberInfoModel);
        memberInfoModel.memberInfoChanged(new MemberInfoChange(moduleMemberInfos));
        this.mySelectionTable.setShowColumns(false);
        this.mySelectionTable.setPreferredScrollableViewportSize(new Dimension(400, this.mySelectionTable.getRowHeight() * 8));
        this.myCenterPanel.add((Component)new MemberSelectionPanelBase("Members to move", (AbstractMemberSelectionTable)this.mySelectionTable), "Center");
        this.myVisibilityPanel = new JSVisibilityPanel();
        this.myVisibilityPanel.configureOptions(true, true, false, false, false, false);
        this.myVisibilityPanel.setVisibility("escalate");
        this.myVisibilityPanel.setVisible(ES6PsiUtil.isExternalModule(sourceModuleOrFile));
        this.myCenterPanel.add((Component)((Object)this.myVisibilityPanel), "East");
        this.init();
    }

    public String getSelectedVisibility() {
        return this.myVisibilityPanel.getVisibility();
    }

    public List<JSQualifiedNamedElement> getSelectedElements() {
        return ContainerUtil.map((Collection)this.mySelectionTable.getSelectedMemberInfos(), el -> (JSQualifiedNamedElement)el.getMember());
    }

    @Override
    protected FileType[] getSupportedFileTypes(@NotNull PsiElement sourceModuleOrFile) {
        if (sourceModuleOrFile == null) {
            ES6MoveModuleMembersDialog.$$$reportNull$$$0(5);
        }
        HashSet<Object> result2 = new HashSet<Object>();
        result2.add(sourceModuleOrFile.getContainingFile().getFileType());
        if (DialectDetector.isTypeScript(sourceModuleOrFile)) {
            result2.addAll(Arrays.asList(TypeScriptUtil.TYPESCRIPT_FILE_TYPES_ARRAY));
        } else if (DialectDetector.isFlow(sourceModuleOrFile)) {
            result2.add(FlowJSFileType.INSTANCE);
        } else {
            result2.addAll(JS_FILE_TYPES_WITHOUT_FLOW);
        }
        return result2.toArray(FileType.EMPTY_ARRAY);
    }

    @Override
    protected void doAction() {
        String message = this.validateData();
        if (!StringUtil.isEmpty((String)message)) {
            CommonRefactoringUtil.showErrorMessage((String)JSBundle.message((String)"es6.move.module.members.refactoring.name", (Object[])new Object[0]), (String)message, null, (Project)this.myProject);
            return;
        }
        PsiElement toModule = this.getToModule();
        if (toModule == null) {
            return;
        }
        try {
            this.invokeRefactoring(this.createProcessor(toModule, this.getSelectedElements(), "escalate".equals(this.getSelectedVisibility())));
        }
        catch (IncorrectOperationException e) {
            CommonRefactoringUtil.showErrorMessage((String)RefactoringBundle.message((String)"error.title"), (String)e.getMessage(), null, (Project)this.myProject);
        }
        super.doAction();
    }

    @NotNull
    public BaseRefactoringProcessor createProcessor(@NotNull PsiElement toModule, @NotNull List<JSQualifiedNamedElement> elements, boolean escalateVisibility) {
        if (toModule == null) {
            ES6MoveModuleMembersDialog.$$$reportNull$$$0(6);
        }
        if (elements == null) {
            ES6MoveModuleMembersDialog.$$$reportNull$$$0(7);
        }
        ES6MoveModuleMembersProcessor eS6MoveModuleMembersProcessor = new ES6MoveModuleMembersProcessor(elements, toModule, this.mySourceModuleOrFile, escalateVisibility, (Consumer<? super Collection<JSQualifiedNamedElement>>)((Consumer)newElements -> {
            JSQualifiedNamedElement first;
            if (this.isOpenInEditor() && (first = (JSQualifiedNamedElement)ContainerUtil.getFirstItem((Collection)newElements)) != null) {
                EditorHelper.openInEditor((PsiElement)first);
            }
            if (this.myMoveCallback != null) {
                this.myMoveCallback.refactoringCompleted();
            }
        }));
        if (eS6MoveModuleMembersProcessor == null) {
            ES6MoveModuleMembersDialog.$$$reportNull$$$0(8);
        }
        return eS6MoveModuleMembersProcessor;
    }

    @Nullable
    private String validateData() {
        if (this.getSelectedElements().isEmpty()) {
            return JSBundle.message((String)"es6.move.module.members.refactoring.dialog.error.no.selected.items", (Object[])new Object[0]);
        }
        String modulePath = this.getModuleString();
        if (StringUtil.isEmpty((String)modulePath)) {
            return JSBundle.message((String)"es6.move.module.members.refactoring.dialog.error.incorrect.module", (Object[])new Object[0]);
        }
        if (StringUtil.equals((CharSequence)this.myFromField.getText(), (CharSequence)modulePath)) {
            return JSBundle.message((String)"es6.move.module.members.refactoring.dialog.error.modules.same", (Object[])new Object[0]);
        }
        String fileCreationError = ES6MoveModuleMembersDialog.checkOrCreateFile(this.mySourceModuleOrFile, modulePath, this.getTitle());
        if (fileCreationError != null) {
            return fileCreationError;
        }
        PsiElement toModule = this.getToModule();
        if (toModule == null) {
            return null;
        }
        if (!ES6MoveModuleMembersDialog.isCompatibleLanguage(this.mySourceModuleOrFile, toModule)) {
            return "Target module has incompatible language";
        }
        return null;
    }

    private static boolean isCompatibleLanguage(@NotNull PsiElement source, @NotNull PsiElement destination) {
        if (source == null) {
            ES6MoveModuleMembersDialog.$$$reportNull$$$0(9);
        }
        if (destination == null) {
            ES6MoveModuleMembersDialog.$$$reportNull$$$0(10);
        }
        DialectOptionHolder sourceDialect = DialectDetector.dialectOfElement(source);
        DialectOptionHolder destinationDialect = DialectDetector.dialectOfElement(destination);
        if (sourceDialect == null || destinationDialect == null) {
            return false;
        }
        if (sourceDialect.isTypeScript) {
            return destinationDialect.isTypeScript;
        }
        if (sourceDialect.isFlow) {
            return destinationDialect.isFlow;
        }
        if (destinationDialect.isFlow) {
            return sourceDialect.isJavaScript();
        }
        return sourceDialect.isECMA6 && destinationDialect.isECMA6;
    }

    @Nullable
    public static String checkOrCreateFile(@NotNull PsiElement sourceModule, @NotNull String path, @NotNull String messageTitle) {
        if (sourceModule == null) {
            ES6MoveModuleMembersDialog.$$$reportNull$$$0(11);
        }
        if (path == null) {
            ES6MoveModuleMembersDialog.$$$reportNull$$$0(12);
        }
        if (messageTitle == null) {
            ES6MoveModuleMembersDialog.$$$reportNull$$$0(13);
        }
        Project project = sourceModule.getProject();
        PsiFile destinationPsi = ES6MoveModuleMembersDialog.getDestinationPsiFile(sourceModule, path = FileUtil.toSystemIndependentName((String)path));
        if (destinationPsi != null) {
            if (destinationPsi instanceof XmlFile && JSUtils.findScriptTagContent((XmlFile)destinationPsi) == null) {
                return JSBundle.message((String)"es6.move.module.members.refactoring.dialog.error.no.script.tag", (Object[])new Object[0]);
            }
            return null;
        }
        String fileName = VfsUtil.extractFileName((String)path);
        String parentDir = VfsUtil.getParentDir((String)path);
        if (parentDir == null || fileName == null) {
            return JSBundle.message((String)"es6.move.module.members.refactoring.dialog.error.incorrect.module", (Object[])new Object[0]);
        }
        FileType destinationFileType = FileTypeManager.getInstance().getFileTypeByFileName(fileName);
        if (!TypeScriptUtil.TYPESCRIPT_FILE_TYPES.contains(destinationFileType) && !DialectDetector.JAVASCRIPT_FILE_TYPES.contains(destinationFileType)) {
            return JSBundle.message((String)"es6.move.module.members.refactoring.file.does.not.exist", (Object[])new Object[]{fileName});
        }
        int answer = Messages.showYesNoDialog((Project)project, (String)JSBundle.message((String)"es6.move.module.members.refactoring.create.file.message", (Object[])new Object[]{fileName}), (String)messageTitle, (Icon)Messages.getQuestionIcon());
        if (answer == 0) {
            try {
                WriteCommandAction.writeCommandAction((Project)project).withName(JSBundle.message((String)"es6.move.module.members.refactoring.create.file", (Object[])new Object[0])).run(() -> {
                    VirtualFile directories = VfsUtil.createDirectories((String)parentDir);
                    directories.createChildData((Object)sourceModule, fileName);
                });
            }
            catch (IOException e) {
                return e.getMessage();
            }
        }
        return null;
    }

    @Nullable
    private static PsiFile getDestinationPsiFile(@NotNull PsiElement context, String path) {
        if (context == null) {
            ES6MoveModuleMembersDialog.$$$reportNull$$$0(14);
        }
        path = FileUtil.toSystemIndependentName((String)path);
        VirtualFile vFile = LocalFileSystem.getInstance().findFileByPath(path);
        if (vFile == null) {
            return null;
        }
        return context.getManager().findFile(vFile);
    }

    @Nullable
    private PsiElement getToModule() {
        PsiFile psiFile = ES6MoveModuleMembersDialog.getDestinationPsiFile(this.mySourceModuleOrFile, this.getModuleString());
        return psiFile instanceof XmlFile ? JSUtils.findScriptTagContent((XmlFile)psiFile) : psiFile;
    }

    public String getModuleString() {
        return this.myModuleField.getText();
    }

    @Nullable
    protected String getHelpId() {
        return "refactoring.javascript.move.symbol";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fromPath";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toPath";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selectedElements";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceModuleOrFile";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toModule";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/ecmascript6/refactoring/ES6MoveModuleMembersDialog";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "destination";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceModule";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "messageTitle";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/ecmascript6/refactoring/ES6MoveModuleMembersDialog";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "createProcessor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getSupportedFileTypes";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createProcessor";
                break;
            }
            case 8: {
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "isCompatibleLanguage";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "checkOrCreateFile";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getDestinationPsiFile";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

