/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ecmascript6.stubs.impl;

import com.intellij.javascript.JSFileReference;
import com.intellij.lang.ecmascript6.ES6StubElementTypes;
import com.intellij.lang.ecmascript6.psi.ES6ExportDefaultAssignment;
import com.intellij.lang.ecmascript6.psi.impl.ES6ExportDefaultAssignmentImpl;
import com.intellij.lang.ecmascript6.psi.stubs.ES6ExportDefaultAssignmentStub;
import com.intellij.lang.ecmascript6.resolve.ES6PsiUtil;
import com.intellij.lang.javascript.index.flags.BooleanStructureElement;
import com.intellij.lang.javascript.index.flags.FlagsStructure;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptModule;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.stubs.ES6DefaultAssignmentModuleIndex;
import com.intellij.lang.javascript.psi.stubs.ES6ExportedMembersByKindIndex;
import com.intellij.lang.javascript.psi.stubs.impl.JSStubBase;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.stubs.IndexSink;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.stubs.StubInputStream;
import com.intellij.psi.stubs.StubOutputStream;
import com.intellij.util.io.StringRef;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ES6ExportDefaultAssignmentStubImpl
extends JSStubBase<ES6ExportDefaultAssignment>
implements ES6ExportDefaultAssignmentStub {
    private static final BooleanStructureElement HAS_INITIALIZER_REFERENCE_FLAG = new BooleanStructureElement();
    private static final BooleanStructureElement HAS_TYPE_FLAG = new BooleanStructureElement();
    private static final BooleanStructureElement TYPE_STRICT_FLAG = new BooleanStructureElement();
    protected static final FlagsStructure FLAGS_STRUCTURE = new FlagsStructure(HAS_INITIALIZER_REFERENCE_FLAG, HAS_TYPE_FLAG, TYPE_STRICT_FLAG);
    @Nullable
    private final StringRef myInitializerReference;
    @Nullable
    private final StringRef myTypeString;

    public ES6ExportDefaultAssignmentStubImpl(ES6ExportDefaultAssignment psi, StubElement parent) {
        super(psi, parent, (IStubElementType)ES6StubElementTypes.EXPORT_DEFAULT_ASSIGNMENT);
        String initializerReference = psi.getInitializerReference();
        this.writeFlag(HAS_INITIALIZER_REFERENCE_FLAG, initializerReference != null);
        this.myInitializerReference = StringRef.fromString((String)initializerReference);
        JSType jsType = psi.getJSType();
        this.writeFlag(HAS_TYPE_FLAG, jsType != null);
        this.writeFlag(TYPE_STRICT_FLAG, jsType != null && jsType.isSourceStrict());
        this.myTypeString = StringRef.fromString((String)JSTypeUtils.serializeType(jsType));
    }

    public ES6ExportDefaultAssignmentStubImpl(StubInputStream dataStream, StubElement parentStub) throws IOException {
        super(dataStream, parentStub, (IStubElementType)ES6StubElementTypes.EXPORT_DEFAULT_ASSIGNMENT);
        this.myInitializerReference = this.readFlag(HAS_INITIALIZER_REFERENCE_FLAG) != false ? dataStream.readName() : null;
        this.myTypeString = this.readFlag(HAS_TYPE_FLAG) != false ? dataStream.readName() : null;
    }

    @Override
    public void serialize(StubOutputStream dataStream) throws IOException {
        super.serialize(dataStream);
        if (this.readFlag(HAS_INITIALIZER_REFERENCE_FLAG).booleanValue()) {
            ES6ExportDefaultAssignmentStubImpl.writeString(this.myInitializerReference, dataStream);
        }
        if (this.readFlag(HAS_TYPE_FLAG).booleanValue()) {
            ES6ExportDefaultAssignmentStubImpl.writeString(this.myTypeString, dataStream);
        }
    }

    public ES6ExportDefaultAssignment createPsi() {
        return new ES6ExportDefaultAssignmentImpl(this);
    }

    @Override
    @NotNull
    protected FlagsStructure getFlagsStructure() {
        FlagsStructure flagsStructure = FLAGS_STRUCTURE;
        if (flagsStructure == null) {
            ES6ExportDefaultAssignmentStubImpl.$$$reportNull$$$0(0);
        }
        return flagsStructure;
    }

    public void index(IndexSink sink) {
        String exactFileName;
        PsiFile containingFile;
        String name;
        PsiElement parent;
        String ownName;
        ES6ExportDefaultAssignment psi = (ES6ExportDefaultAssignment)this.getPsi();
        if (this.getInitializerReference() != null) {
            return;
        }
        JSElement element = psi.getStubSafeElement();
        String string = ownName = element instanceof JSQualifiedNamedElement ? element.getName() : null;
        if (ownName == null) {
            sink.occurrence(ES6ExportedMembersByKindIndex.KEY, (Object)"def");
        }
        if (ES6PsiUtil.isExternalModule(parent = psi.getContext()) && !(parent instanceof TypeScriptModule) && !StringUtil.isEmpty((String)(name = (containingFile = parent.getContainingFile()).getName())) && StringUtil.isJavaIdentifier((String)(exactFileName = JSFileReference.getFileNameWithoutExtension(name, JSFileReference.IMPLICIT_EXTENSIONS)))) {
            sink.occurrence(ES6DefaultAssignmentModuleIndex.KEY, (Object)exactFileName);
        }
    }

    public String getInitializerReference() {
        return StringRef.toString((StringRef)this.myInitializerReference);
    }

    @Nullable
    public String getTypeString() {
        return StringRef.toString((StringRef)this.myTypeString);
    }

    public boolean isTypeStrict() {
        return this.readFlag(TYPE_STRICT_FLAG);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/ecmascript6/stubs/impl/ES6ExportDefaultAssignmentStubImpl", "getFlagsStructure"));
    }
}

