/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.arrangement;

import com.intellij.lang.javascript.arrangement.JSArrangementEntry;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.codeStyle.arrangement.ArrangementEntry;
import com.intellij.psi.codeStyle.arrangement.DefaultArrangementEntry;
import com.intellij.psi.codeStyle.arrangement.ModifierAwareArrangementEntry;
import com.intellij.psi.codeStyle.arrangement.NameAwareArrangementEntry;
import com.intellij.psi.codeStyle.arrangement.TypeAwareArrangementEntry;
import com.intellij.psi.codeStyle.arrangement.std.ArrangementSettingsToken;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSElementArrangementEntry
extends DefaultArrangementEntry
implements JSArrangementEntry,
TypeAwareArrangementEntry,
ModifierAwareArrangementEntry,
NameAwareArrangementEntry {
    private final String myName;
    private Set<ArrangementSettingsToken> myTypes;
    private Set<ArrangementSettingsToken> myModifiers;

    public JSElementArrangementEntry(@Nullable ArrangementEntry parent, @Nullable String name, @NotNull Set<ArrangementSettingsToken> types2, @NotNull Set<ArrangementSettingsToken> modifiers, @NotNull TextRange range) {
        if (types2 == null) {
            JSElementArrangementEntry.$$$reportNull$$$0(0);
        }
        if (modifiers == null) {
            JSElementArrangementEntry.$$$reportNull$$$0(1);
        }
        if (range == null) {
            JSElementArrangementEntry.$$$reportNull$$$0(2);
        }
        super(parent, range.getStartOffset(), range.getEndOffset(), true);
        this.myName = name;
        this.myTypes = types2;
        this.myModifiers = modifiers;
    }

    @Nullable
    public String getName() {
        return this.myName;
    }

    public void setType(@NotNull ArrangementSettingsToken type) {
        if (type == null) {
            JSElementArrangementEntry.$$$reportNull$$$0(3);
        }
        this.myTypes = ContainerUtil.newHashSet((Object[])new ArrangementSettingsToken[]{type});
    }

    @Nullable
    public ArrangementSettingsToken getType() {
        return (ArrangementSettingsToken)ContainerUtil.getFirstItem(this.myTypes);
    }

    @NotNull
    public Set<ArrangementSettingsToken> getTypes() {
        Set<ArrangementSettingsToken> set = this.myTypes;
        if (set == null) {
            JSElementArrangementEntry.$$$reportNull$$$0(4);
        }
        return set;
    }

    public void setModifiers(@NotNull Set<ArrangementSettingsToken> modifiers) {
        if (modifiers == null) {
            JSElementArrangementEntry.$$$reportNull$$$0(5);
        }
        this.myModifiers = modifiers;
    }

    @NotNull
    public Set<ArrangementSettingsToken> getModifiers() {
        Set<ArrangementSettingsToken> set = this.myModifiers;
        if (set == null) {
            JSElementArrangementEntry.$$$reportNull$$$0(6);
        }
        return set;
    }

    public String toString() {
        return "JSArrangementEntry{myName='" + this.myName + '\'' + ", myType=" + this.myTypes + ", myModifiers=" + this.myModifiers + ", dependencies=[" + StringUtil.join((Collection)ContainerUtil.notNullize((List)this.getDependencies()), JSElementArrangementEntry::getNameOrNull, (String)", ") + "], startOffset=" + this.getStartOffset() + ", endOffset=" + this.getEndOffset() + '}';
    }

    @Nullable
    private static String getNameOrNull(ArrangementEntry o) {
        NameAwareArrangementEntry entry = o instanceof NameAwareArrangementEntry ? (NameAwareArrangementEntry)o : null;
        return entry != null ? entry.getName() : "";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "types";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modifiers";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/arrangement/JSElementArrangementEntry";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/arrangement/JSElementArrangementEntry";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypes";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getModifiers";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setType";
                break;
            }
            case 4: 
            case 6: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setModifiers";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

