/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.buildTools.npm;

import com.intellij.execution.ExecutionManager;
import com.intellij.execution.Executor;
import com.intellij.execution.RunManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.executors.DefaultRunExecutor;
import com.intellij.execution.runners.ExecutionEnvironmentBuilder;
import com.intellij.ide.actions.runAnything.RunAnythingAction;
import com.intellij.ide.actions.runAnything.activity.RunAnythingAnActionProvider;
import com.intellij.javascript.nodejs.npm.NpmManager;
import com.intellij.javascript.nodejs.npm.NpmUtil;
import com.intellij.javascript.nodejs.util.NodePackageRef;
import com.intellij.lang.javascript.buildTools.npm.NpmScriptRunAnythingProvider;
import com.intellij.lang.javascript.buildTools.npm.PackageJsonFileManager;
import com.intellij.lang.javascript.buildTools.npm.rc.NpmCommand;
import com.intellij.lang.javascript.buildTools.npm.rc.NpmConfigurationType;
import com.intellij.lang.javascript.buildTools.npm.rc.NpmRunConfiguration;
import com.intellij.lang.javascript.buildTools.npm.rc.NpmRunConfigurationProducer;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NpmCommandRunAnythingProvider
extends RunAnythingAnActionProvider<NpmCommandAction> {
    private static final NpmScriptRunAnythingProvider INSTANCE = new NpmScriptRunAnythingProvider();
    private static final List<NpmCommand> PREFERRED_COMMANDS = Arrays.asList(NpmCommand.INSTALL, NpmCommand.CI, NpmCommand.UPDATE, NpmCommand.TEST, NpmCommand.PUBLISH);

    @Nullable
    public NpmCommandAction findMatchingValue(@NotNull DataContext dataContext, @NotNull String pattern) {
        if (dataContext == null) {
            NpmCommandRunAnythingProvider.$$$reportNull$$$0(0);
        }
        if (pattern == null) {
            NpmCommandRunAnythingProvider.$$$reportNull$$$0(1);
        }
        return this.getValues(dataContext, pattern).stream().filter(value -> this.getCommand((NpmCommandAction)((Object)value)).startsWith(pattern)).findFirst().orElse(null);
    }

    @NotNull
    public Collection<NpmCommandAction> getValues(@NotNull DataContext dataContext, @NotNull String pattern) {
        Project project;
        if (dataContext == null) {
            NpmCommandRunAnythingProvider.$$$reportNull$$$0(2);
        }
        if (pattern == null) {
            NpmCommandRunAnythingProvider.$$$reportNull$$$0(3);
        }
        if ((project = (Project)CommonDataKeys.PROJECT.getData(dataContext)) == null) {
            List<NpmCommandAction> list2 = Collections.emptyList();
            if (list2 == null) {
                NpmCommandRunAnythingProvider.$$$reportNull$$$0(4);
            }
            return list2;
        }
        if (!pattern.startsWith(INSTANCE.getCommandPrefix(project))) {
            List<NpmCommandAction> list3 = Collections.emptyList();
            if (list3 == null) {
                NpmCommandRunAnythingProvider.$$$reportNull$$$0(5);
            }
            return list3;
        }
        NodePackageRef npmPkgRef = NpmManager.getInstance(project).getPackageRef();
        ArrayList<NpmCommand> commands = new ArrayList<NpmCommand>(PREFERRED_COMMANDS);
        commands.addAll(Arrays.asList(NpmCommand.values()));
        commands.remove((Object)NpmCommand.RUN_SCRIPT);
        LinkedHashMap<String, NpmCommandAction> result2 = new LinkedHashMap<String, NpmCommandAction>();
        boolean yarn = NpmUtil.isYarnAlikePackageRef(npmPkgRef);
        for (NpmCommand command : commands) {
            String cliOption = command.getCliOption(yarn);
            if (result2.containsKey(cliOption) && !StringUtil.toLowerCase((String)command.name()).equals(cliOption)) continue;
            result2.put(cliOption, new NpmCommandAction(command, npmPkgRef));
        }
        Collection<NpmCommandAction> collection = result2.values();
        if (collection == null) {
            NpmCommandRunAnythingProvider.$$$reportNull$$$0(6);
        }
        return collection;
    }

    @NotNull
    public String getCommand(@NotNull NpmCommandAction value) {
        if (value == null) {
            NpmCommandRunAnythingProvider.$$$reportNull$$$0(7);
        }
        String string = NpmManager.getNpmCommandPresentableText(value.myNpmPkgRef, value.myCommand);
        if (string == null) {
            NpmCommandRunAnythingProvider.$$$reportNull$$$0(8);
        }
        return string;
    }

    @Nullable
    public String getCompletionGroupTitle() {
        return "npm";
    }

    @Nullable
    public String getHelpGroupTitle() {
        return INSTANCE.getHelpGroupTitle();
    }

    @Nullable
    public Icon getHelpIcon() {
        return INSTANCE.getHelpIcon();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pattern";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/buildTools/npm/NpmCommandRunAnythingProvider";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/buildTools/npm/NpmCommandRunAnythingProvider";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getValues";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommand";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "findMatchingValue";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getValues";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 8: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getCommand";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static class NpmCommandAction
    extends DumbAwareAction {
        private final NpmCommand myCommand;
        private final NodePackageRef myNpmPkgRef;

        private NpmCommandAction(@NotNull NpmCommand command, @NotNull NodePackageRef npmPkgRef) {
            if (command == null) {
                NpmCommandAction.$$$reportNull$$$0(0);
            }
            if (npmPkgRef == null) {
                NpmCommandAction.$$$reportNull$$$0(1);
            }
            super(null, null, NpmScriptRunAnythingProvider.getIcon(NpmUtil.isYarnAlikePackageRef(npmPkgRef)));
            this.myCommand = command;
            this.myNpmPkgRef = npmPkgRef;
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                NpmCommandAction.$$$reportNull$$$0(2);
            }
            Executor executor = (Executor)e.getDataContext().getData(RunAnythingAction.EXECUTOR_KEY);
            executor = (Executor)ObjectUtils.notNull((Object)executor, (Object)DefaultRunExecutor.getRunExecutorInstance());
            Project project = e.getProject();
            if (project == null) {
                return;
            }
            RunManager runManager = RunManager.getInstance((Project)project);
            RunnerAndConfigurationSettings configuration = runManager.createConfiguration("", (ConfigurationFactory)NpmConfigurationType.getInstance());
            NpmRunConfiguration runConfiguration = (NpmRunConfiguration)ObjectUtils.tryCast((Object)configuration.getConfiguration(), NpmRunConfiguration.class);
            if (runConfiguration == null) {
                return;
            }
            VirtualFile packageJson = (VirtualFile)ContainerUtil.getFirstItem(PackageJsonFileManager.getInstance(project).getBuildfiles());
            if (packageJson == null) {
                return;
            }
            NpmRunConfigurationProducer.setupConfigurationFromSettings(runConfiguration, runConfiguration.getRunSettings().toBuilder().setPackageJsonPath(packageJson.getPath()).setCommand(this.myCommand).build());
            runManager.setUniqueNameIfNeeded(configuration);
            ExecutionEnvironmentBuilder builder = ExecutionEnvironmentBuilder.createOrNull((Executor)executor, (RunnerAndConfigurationSettings)configuration);
            if (builder != null) {
                ExecutionManager.getInstance((Project)project).restartRunProfile(builder.build());
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "command";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "npmPkgRef";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/lang/javascript/buildTools/npm/NpmCommandRunAnythingProvider$NpmCommandAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

