/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.documentation;

import com.intellij.lang.javascript.documentation.JSDocBuilderSimpleInfo;
import com.intellij.lang.javascript.documentation.JSDocBuilderSymbolInfo;
import com.intellij.lang.javascript.documentation.JSHtmlHighlightingUtil;
import com.intellij.lang.javascript.psi.JSParameterTypeDecorator;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class JSDocBuilderParameterInfo
extends JSDocBuilderSimpleInfo {
    boolean optional;
    boolean rest;
    String initialValue;
    String defaultValue;
    PsiElement context;
    @Nullable
    String docName;
    Map<String, JSDocBuilderParameterInfo> optionsMap;

    JSDocBuilderParameterInfo(@Nullable PsiElement context) {
        this.context = context;
    }

    JSDocBuilderParameterInfo(@Nullable JSParameterTypeDecorator parameterType) {
        this.type = parameterType != null ? parameterType.getSimpleType() : null;
        this.optional = parameterType != null && parameterType.isOptional();
        this.rest = parameterType != null && parameterType.isRest();
    }

    boolean hasSomeInfo() {
        return this.hasDescription() || this.optional || this.rest || this.hasType();
    }

    public void appendDoc(String actualName, @NotNull JSDocBuilderSymbolInfo symbolInfo, @NotNull StringBuilder result2) {
        if (symbolInfo == null) {
            JSDocBuilderParameterInfo.$$$reportNull$$$0(0);
        }
        if (result2 == null) {
            JSDocBuilderParameterInfo.$$$reportNull$$$0(1);
        }
        result2.append("<div class='definition'><pre>");
        StringBuilder options = new StringBuilder();
        JSDocBuilderSymbolInfo.addVisibilityAndAccess(this, options);
        if (options.length() > 0) {
            result2.append((CharSequence)options).append("<br>");
        }
        if (!StringUtil.isEmpty((String)symbolInfo.namespace)) {
            result2.append(symbolInfo.namespace).append('.');
        }
        result2.append(actualName);
        if (this.hasType()) {
            result2.append(": ");
            result2.append(this.getTypeString(this.context));
        }
        result2.append("</pre></div>");
        int contentStart = result2.length();
        result2.append("<div class='content'>");
        result2.append(this.getDescriptionMergedWithConfigOptions());
        if (result2.length() == contentStart + "<div class='content'>".length()) {
            result2.setLength(contentStart);
        } else {
            result2.append("</div>");
        }
    }

    public String getDescriptionMergedWithConfigOptions() {
        if (this.optionsMap != null) {
            StringBuilder optionsBuilder = new StringBuilder();
            optionsBuilder.append("<table class='sections'>");
            optionsBuilder.append("<tr><td valign='top' class='section'><p>");
            optionsBuilder.append("Config options").append(":");
            optionsBuilder.append("</td><td valign='top'>");
            for (Map.Entry<String, JSDocBuilderParameterInfo> field : this.optionsMap.entrySet()) {
                optionsBuilder.append("<p>");
                field.getValue().appendOptionDescription(field.getKey(), optionsBuilder);
            }
            optionsBuilder.append("</table>");
            String description = this.getFinalDescription();
            int i = description.indexOf("<tr><td valign='top' class='section'><p>See also:</td><td valign='top'>");
            if (i != -1) {
                return new StringBuilder(description).insert(i, optionsBuilder).toString();
            }
            return description + optionsBuilder;
        }
        return this.getFinalDescription();
    }

    @NotNull
    public List<JSHtmlHighlightingUtil.TextPlaceholder> appendParameterInfoInSignature(@NotNull String actualName, @NotNull StringBuilder result2, boolean withHolders) {
        String qName;
        if (actualName == null) {
            JSDocBuilderParameterInfo.$$$reportNull$$$0(2);
        }
        if (result2 == null) {
            JSDocBuilderParameterInfo.$$$reportNull$$$0(3);
        }
        if (this.rest) {
            result2.append("...");
        }
        List holders = withHolders ? new ArrayList() : ContainerUtil.emptyList();
        String string = qName = !StringUtil.isEmpty((String)this.namespace) ? this.namespace + "." + actualName : actualName;
        if (withHolders && !StringUtil.isJavaIdentifier((String)qName)) {
            JSHtmlHighlightingUtil.TextPlaceholder holder = JSHtmlHighlightingUtil.createSimpleHolder(qName, "$$Name$$" + this.hashCode());
            holders.add(holder);
            result2.append(holder.getHolderText());
        } else {
            result2.append(qName);
        }
        if (this.optional) {
            result2.append("?");
        }
        if (this.hasType()) {
            result2.append(": ");
            if (withHolders) {
                JSHtmlHighlightingUtil.TextPlaceholder placeholder = JSHtmlHighlightingUtil.getTypeTextPlaceholder(this.type, this.hasFiredEvents, "$$Type$$" + this.hashCode());
                holders.add(placeholder);
                result2.append(placeholder.getHolderText());
            } else {
                result2.append(this.getTypeString(this.context));
            }
            if (this.rest && !JSTypeUtils.isArrayLikeType(this.type)) {
                result2.append("[]");
            }
        }
        if (this.initialValue != null) {
            result2.append(" = ").append(this.initialValue);
        }
        List list2 = holders;
        if (list2 == null) {
            JSDocBuilderParameterInfo.$$$reportNull$$$0(4);
        }
        return list2;
    }

    public void appendOptionDescription(@NotNull String name, @NotNull StringBuilder builder) {
        if (name == null) {
            JSDocBuilderParameterInfo.$$$reportNull$$$0(5);
        }
        if (builder == null) {
            JSDocBuilderParameterInfo.$$$reportNull$$$0(6);
        }
        this.appendParameterInfoInSignature(name, builder, false);
        builder.append(" &ndash; ");
        builder.append(this.getFinalDescription());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "symbolInfo";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actualName";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/documentation/JSDocBuilderParameterInfo";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/documentation/JSDocBuilderParameterInfo";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "appendParameterInfoInSignature";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "appendDoc";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "appendParameterInfoInSignature";
                break;
            }
            case 4: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "appendOptionDescription";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

