/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.documentation;

import com.intellij.codeInsight.daemon.impl.AnnotationHolderImpl;
import com.intellij.lang.Language;
import com.intellij.lang.annotation.Annotation;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.AnnotationSession;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.JSAnalysisHandlersFactory;
import com.intellij.lang.javascript.JSLanguageDialect;
import com.intellij.lang.javascript.JavaScriptSupportLoader;
import com.intellij.lang.javascript.documentation.JSExampleDocBuilderInfo;
import com.intellij.lang.javascript.documentation.JSLinkTypeTextStringBuilder;
import com.intellij.lang.javascript.highlighting.JSHighlighter;
import com.intellij.lang.javascript.highlighting.JSSemanticHighlightingUtil;
import com.intellij.lang.javascript.psi.JSFunctionItem;
import com.intellij.lang.javascript.psi.JSPresentableTypeTextStringBuilder;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeTextBuilder;
import com.intellij.lang.javascript.psi.types.JSTypeImpl;
import com.intellij.lang.javascript.validation.JSAnnotatingVisitor;
import com.intellij.lang.javascript.validation.JSKeywordHighlighterVisitor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.editor.richcopy.HtmlSyntaxInfoUtil;
import com.intellij.openapi.editor.richcopy.SyntaxInfoBuilder;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSHtmlHighlightingUtil {
    public static final String TYPE_PLACEHOLDER = "$$Type$$";
    public static final String NAME_PLACEHOLDER = "$$Name$$";
    public static final String TYPE_SEPARATOR = ": ";
    public static final String STYLE_ITALIC = "font-style:italic;";
    public static final String STYLE_BOLD = "font-weight:bold;";

    @Nullable
    public static String tryGetHtmlHighlighting(@NotNull PsiFile fakeFile, @NotNull String text, @Nullable SyntaxInfoBuilder.RangeIterator iterator, int startOffset, int endOffset) {
        if (fakeFile == null) {
            JSHtmlHighlightingUtil.$$$reportNull$$$0(0);
        }
        if (text == null) {
            JSHtmlHighlightingUtil.$$$reportNull$$$0(1);
        }
        EditorColorsScheme scheme = EditorColorsManager.getInstance().getGlobalScheme();
        return JSHtmlHighlightingUtil.readHtmlText(HtmlSyntaxInfoUtil.getHtmlContent((PsiFile)fakeFile, (CharSequence)text, (SyntaxInfoBuilder.RangeIterator)iterator, (EditorColorsScheme)scheme, (int)startOffset, (int)endOffset));
    }

    @Nullable
    private static String tryGetHtmlHighlighting(@NotNull String text, @NotNull SyntaxInfoBuilder.RangeIterator iterator, int endOffset) {
        if (text == null) {
            JSHtmlHighlightingUtil.$$$reportNull$$$0(2);
        }
        if (iterator == null) {
            JSHtmlHighlightingUtil.$$$reportNull$$$0(3);
        }
        EditorColorsScheme scheme = EditorColorsManager.getInstance().getGlobalScheme();
        return JSHtmlHighlightingUtil.readHtmlText(HtmlSyntaxInfoUtil.getHtmlContent((CharSequence)text, (SyntaxInfoBuilder.RangeIterator)iterator, (EditorColorsScheme)scheme, (int)endOffset));
    }

    @Nullable
    private static String readHtmlText(@Nullable CharSequence text) {
        return text == null ? null : text.toString().replace(STYLE_BOLD, "");
    }

    @Nullable
    private static CharSequence tryGetHtmlHighlighting(@NotNull PsiElement elementOrContext, @NotNull String fakeText, @NotNull Language language, @Nullable TextRange identifierRange, int startOffset, int endOffset) {
        if (elementOrContext == null) {
            JSHtmlHighlightingUtil.$$$reportNull$$$0(4);
        }
        if (fakeText == null) {
            JSHtmlHighlightingUtil.$$$reportNull$$$0(5);
        }
        if (language == null) {
            JSHtmlHighlightingUtil.$$$reportNull$$$0(6);
        }
        if (DumbService.isDumb((Project)elementOrContext.getProject()) || StringUtil.isEmpty((String)fakeText)) {
            return null;
        }
        try {
            PsiFile fakeFile = PsiFileFactory.getInstance((Project)elementOrContext.getProject()).createFileFromText("dummy", language, (CharSequence)fakeText, false, false);
            AnnotationHolderImpl holder = new AnnotationHolderImpl(new AnnotationSession(fakeFile));
            if (identifierRange != null) {
                JSHtmlHighlightingUtil.highlightName(elementOrContext, holder, identifierRange, language);
            }
            JSHtmlHighlightingUtil.highlightSemanticKeywords(fakeFile, holder, language);
            SyntaxInfoBuilder.RangeIterator iterator = JSHtmlHighlightingUtil.createAnnotationsRangeIterator(holder, startOffset, endOffset);
            return JSHtmlHighlightingUtil.tryGetHtmlHighlighting(fakeFile, fakeText, iterator, startOffset, endOffset);
        }
        catch (ProcessCanceledException e) {
            throw e;
        }
        catch (Exception e) {
            Logger.getInstance(JSExampleDocBuilderInfo.class).error("Cannot process html highlighting for: " + fakeText, (Throwable)e);
            return null;
        }
    }

    private static void highlightName(@NotNull PsiElement elementOrContext, @NotNull AnnotationHolderImpl holder, @NotNull TextRange identifierRange, @NotNull Language language) {
        JSHighlighter highlighter;
        JSSemanticHighlightingUtil.TextAttributeKeyInfo info;
        if (elementOrContext == null) {
            JSHtmlHighlightingUtil.$$$reportNull$$$0(7);
        }
        if (holder == null) {
            JSHtmlHighlightingUtil.$$$reportNull$$$0(8);
        }
        if (identifierRange == null) {
            JSHtmlHighlightingUtil.$$$reportNull$$$0(9);
        }
        if (language == null) {
            JSHtmlHighlightingUtil.$$$reportNull$$$0(10);
        }
        if ((info = JSSemanticHighlightingUtil.buildHighlightForResolveResult(elementOrContext, elementOrContext, highlighter = JSAnnotatingVisitor.getHighlighter(language))) != null) {
            Annotation annotation = holder.createInfoAnnotation(identifierRange, null);
            annotation.setTextAttributes(info.getType());
        }
    }

    @Nullable
    public static CharSequence tryGetHtmlHighlighting(@NotNull PsiElement element, @NotNull String fakeText, @Nullable TextRange identifierRange, int startOffset, int endOffset) {
        if (element == null) {
            JSHtmlHighlightingUtil.$$$reportNull$$$0(11);
        }
        if (fakeText == null) {
            JSHtmlHighlightingUtil.$$$reportNull$$$0(12);
        }
        return JSHtmlHighlightingUtil.tryGetHtmlHighlighting(element, fakeText, JSHtmlHighlightingUtil.getLanguageForHighlighting(element), identifierRange, startOffset, endOffset);
    }

    @Nullable
    private static SyntaxInfoBuilder.RangeIterator createAnnotationsRangeIterator(@NotNull AnnotationHolderImpl holder, int startOffset, int endOffset) {
        if (holder == null) {
            JSHtmlHighlightingUtil.$$$reportNull$$$0(13);
        }
        if (holder.isEmpty()) {
            return null;
        }
        final List annotations = ((StreamEx)((StreamEx)StreamEx.of((Collection)holder).sorted(Comparator.comparing(el -> el.getStartOffset()))).filter(el -> startOffset <= el.getStartOffset() && el.getEndOffset() <= endOffset)).toList();
        return new SyntaxInfoBuilder.RangeIterator(){
            int index = -1;

            public boolean atEnd() {
                return this.index >= annotations.size() - 1;
            }

            public void advance() {
                ++this.index;
            }

            public int getRangeStart() {
                Annotation annotation = this.get();
                return annotation == null ? 0 : annotation.getStartOffset();
            }

            public int getRangeEnd() {
                Annotation annotation = this.get();
                return annotation == null ? 0 : annotation.getEndOffset();
            }

            public TextAttributes getTextAttributes() {
                Annotation annotation = this.get();
                return annotation == null ? null : annotation.getTextAttributes().getDefaultAttributes();
            }

            private Annotation get() {
                return annotations.size() > this.index ? (Annotation)annotations.get(this.index) : null;
            }

            public void dispose() {
                annotations.clear();
            }
        };
    }

    private static void highlightSemanticKeywords(@NotNull PsiFile fakeFile, @NotNull AnnotationHolderImpl holder, @NotNull Language language) {
        if (fakeFile == null) {
            JSHtmlHighlightingUtil.$$$reportNull$$$0(14);
        }
        if (holder == null) {
            JSHtmlHighlightingUtil.$$$reportNull$$$0(15);
        }
        if (language == null) {
            JSHtmlHighlightingUtil.$$$reportNull$$$0(16);
        }
        if (language instanceof JSLanguageDialect) {
            DialectOptionHolder optionHolder = ((JSLanguageDialect)language).getOptionHolder();
            JSKeywordHighlighterVisitor visitor = JSAnalysisHandlersFactory.forLanguage(language).createKeywordHighlighterVisitor((AnnotationHolder)holder, optionHolder);
            fakeFile.accept((PsiElementVisitor)visitor);
        }
    }

    @NotNull
    public static TextPlaceholder getTypeTextPlaceholder(@Nullable JSType type, final boolean hasFiredEvents, final @NotNull String placeHolderPrefix) {
        if (placeHolderPrefix == null) {
            JSHtmlHighlightingUtil.$$$reportNull$$$0(17);
        }
        if (type == null) {
            TextPlaceholder textPlaceholder = new TextPlaceholder(){

                @Override
                @NotNull
                public String getHolderText() {
                    if ("any" == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    return "any";
                }

                @Override
                public CharSequence restoreText(@NotNull CharSequence text) {
                    if (text == null) {
                        2.$$$reportNull$$$0(1);
                    }
                    return text;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    RuntimeException runtimeException;
                    Object[] objectArray;
                    Object[] objectArray2;
                    int n2;
                    String string;
                    switch (n) {
                        default: {
                            string = "@NotNull method %s.%s must not return null";
                            break;
                        }
                        case 1: {
                            string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            n2 = 2;
                            break;
                        }
                        case 1: {
                            n2 = 3;
                            break;
                        }
                    }
                    Object[] objectArray3 = new Object[n2];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "com/intellij/lang/javascript/documentation/JSHtmlHighlightingUtil$2";
                            break;
                        }
                        case 1: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "text";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[1] = "getHolderText";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[1] = "com/intellij/lang/javascript/documentation/JSHtmlHighlightingUtil$2";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            break;
                        }
                        case 1: {
                            objectArray = objectArray;
                            objectArray[2] = "restoreText";
                            break;
                        }
                    }
                    String string2 = String.format(string, objectArray);
                    switch (n) {
                        default: {
                            runtimeException = new IllegalStateException(string2);
                            break;
                        }
                        case 1: {
                            runtimeException = new IllegalArgumentException(string2);
                            break;
                        }
                    }
                    throw runtimeException;
                }
            };
            if (textPlaceholder == null) {
                JSHtmlHighlightingUtil.$$$reportNull$$$0(18);
            }
            return textPlaceholder;
        }
        final HashMap replacements = new HashMap();
        final AtomicInteger counter = new AtomicInteger();
        final JSPresentableTypeTextStringBuilder builder = new JSPresentableTypeTextStringBuilder(){

            public boolean startProcessType(@NotNull JSType type) {
                if (type == null) {
                    3.$$$reportNull$$$0(0);
                }
                if (!this.checkLimit()) {
                    return false;
                }
                if (type instanceof JSTypeImpl) {
                    String replacement = placeHolderPrefix + counter.incrementAndGet();
                    replacements.put(replacement, (JSTypeImpl)type);
                    this.append(replacement);
                    return false;
                }
                return super.startProcessType(type);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/lang/javascript/documentation/JSHtmlHighlightingUtil$3", "startProcessType"));
            }
        };
        type.buildTypeText(JSType.TypeTextFormat.PRESENTABLE, (JSTypeTextBuilder)builder);
        TextPlaceholder textPlaceholder = new TextPlaceholder(){

            @Override
            @NotNull
            public String getHolderText() {
                String string = builder.getResult();
                if (string == null) {
                    4.$$$reportNull$$$0(0);
                }
                return string;
            }

            @Override
            public CharSequence restoreText(@NotNull CharSequence text) {
                if (text == null) {
                    4.$$$reportNull$$$0(1);
                }
                for (Map.Entry entry : replacements.entrySet()) {
                    String key = (String)entry.getKey();
                    JSTypeImpl value = (JSTypeImpl)entry.getValue();
                    text = JSHtmlHighlightingUtil.replaceSubSequence(text, key, JSHtmlHighlightingUtil.getSimpleTypeStringWithLinks(value, hasFiredEvents));
                }
                return text;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                    case 1: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 2;
                        break;
                    }
                    case 1: {
                        n2 = 3;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/lang/javascript/documentation/JSHtmlHighlightingUtil$4";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "text";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getHolderText";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/lang/javascript/documentation/JSHtmlHighlightingUtil$4";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        break;
                    }
                    case 1: {
                        objectArray = objectArray;
                        objectArray[2] = "restoreText";
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                    case 1: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
        if (textPlaceholder == null) {
            JSHtmlHighlightingUtil.$$$reportNull$$$0(19);
        }
        return textPlaceholder;
    }

    @Nullable
    public static String tryGetHtmlHighlightingForName(@NotNull PsiElement context, @NotNull String name) {
        if (context == null) {
            JSHtmlHighlightingUtil.$$$reportNull$$$0(20);
        }
        if (name == null) {
            JSHtmlHighlightingUtil.$$$reportNull$$$0(21);
        }
        AnnotationHolderImpl holder = new AnnotationHolderImpl(new AnnotationSession(context.getContainingFile()));
        TextRange range = new TextRange(0, name.length());
        JSHtmlHighlightingUtil.highlightName(context, holder, range, JSHtmlHighlightingUtil.getLanguageForHighlighting(context));
        SyntaxInfoBuilder.RangeIterator iterator = JSHtmlHighlightingUtil.createAnnotationsRangeIterator(holder, 0, name.length());
        if (iterator != null) {
            try {
                return JSHtmlHighlightingUtil.tryGetHtmlHighlighting(name, iterator, name.length());
            }
            catch (ProcessCanceledException e) {
                throw e;
            }
            catch (Exception e) {
                Logger.getInstance(JSExampleDocBuilderInfo.class).error("Cannot process html highlighting for: " + name, (Throwable)e);
            }
        }
        return null;
    }

    @NotNull
    public static TextPlaceholder createSimpleHolder(final @NotNull String originalText, final @NotNull String holder) {
        if (originalText == null) {
            JSHtmlHighlightingUtil.$$$reportNull$$$0(22);
        }
        if (holder == null) {
            JSHtmlHighlightingUtil.$$$reportNull$$$0(23);
        }
        TextPlaceholder textPlaceholder = new TextPlaceholder(){

            @Override
            @NotNull
            public CharSequence getHolderText() {
                String string = holder;
                if (string == null) {
                    5.$$$reportNull$$$0(0);
                }
                return string;
            }

            @Override
            public CharSequence restoreText(@NotNull CharSequence text) {
                if (text == null) {
                    5.$$$reportNull$$$0(1);
                }
                return JSHtmlHighlightingUtil.replaceSubSequence(text, holder, originalText);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                    case 1: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 2;
                        break;
                    }
                    case 1: {
                        n2 = 3;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/lang/javascript/documentation/JSHtmlHighlightingUtil$5";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "text";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getHolderText";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/lang/javascript/documentation/JSHtmlHighlightingUtil$5";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        break;
                    }
                    case 1: {
                        objectArray = objectArray;
                        objectArray[2] = "restoreText";
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                    case 1: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
        if (textPlaceholder == null) {
            JSHtmlHighlightingUtil.$$$reportNull$$$0(24);
        }
        return textPlaceholder;
    }

    @NotNull
    private static CharSequence replaceSubSequence(@NotNull CharSequence text, @NotNull String oldText, @NotNull String newText) {
        int index;
        if (text == null) {
            JSHtmlHighlightingUtil.$$$reportNull$$$0(25);
        }
        if (oldText == null) {
            JSHtmlHighlightingUtil.$$$reportNull$$$0(26);
        }
        if (newText == null) {
            JSHtmlHighlightingUtil.$$$reportNull$$$0(27);
        }
        if ((index = StringUtil.indexOf((CharSequence)text, (CharSequence)oldText)) >= 0) {
            text = StringUtil.replaceSubSequence((CharSequence)text, (int)index, (int)(index + oldText.length()), (CharSequence)newText);
        }
        CharSequence charSequence = text;
        if (charSequence == null) {
            JSHtmlHighlightingUtil.$$$reportNull$$$0(28);
        }
        return charSequence;
    }

    @NotNull
    public static CharSequence getElementHtmlHighlighting(@NotNull PsiElement element, @NotNull String name, @Nullable JSType type) {
        if (element == null) {
            JSHtmlHighlightingUtil.$$$reportNull$$$0(29);
        }
        if (name == null) {
            JSHtmlHighlightingUtil.$$$reportNull$$$0(30);
        }
        if (!DumbService.isDumb((Project)element.getProject()) && StringUtil.isJavaIdentifier((String)name)) {
            TextPlaceholder placeholder = JSHtmlHighlightingUtil.getTypeTextPlaceholder(type, false, TYPE_PLACEHOLDER);
            String prefix = "var ";
            String fakeText = prefix + name + (type == null ? "" : TYPE_SEPARATOR + placeholder.getHolderText());
            int startOffset = prefix.length();
            int endOffset = fakeText.length();
            TextRange range = TextRange.create((int)prefix.length(), (int)(prefix.length() + name.length()));
            CharSequence result2 = JSHtmlHighlightingUtil.tryGetHtmlHighlighting(element, fakeText, range, startOffset, endOffset);
            if (result2 != null) {
                CharSequence charSequence = placeholder.restoreText(result2);
                if (charSequence == null) {
                    JSHtmlHighlightingUtil.$$$reportNull$$$0(31);
                }
                return charSequence;
            }
        }
        String string = name + TYPE_SEPARATOR + JSHtmlHighlightingUtil.getSimpleTypeStringWithLinks(type, false);
        if (string == null) {
            JSHtmlHighlightingUtil.$$$reportNull$$$0(32);
        }
        return string;
    }

    @NotNull
    public static CharSequence getFunctionHtmlHighlighting(@NotNull JSFunctionItem functionItem, @NotNull String qName, @NotNull CharSequence argumentsAndReturn, @NotNull List<TextPlaceholder> holders) {
        if (functionItem == null) {
            JSHtmlHighlightingUtil.$$$reportNull$$$0(33);
        }
        if (qName == null) {
            JSHtmlHighlightingUtil.$$$reportNull$$$0(34);
        }
        if (argumentsAndReturn == null) {
            JSHtmlHighlightingUtil.$$$reportNull$$$0(35);
        }
        if (holders == null) {
            JSHtmlHighlightingUtil.$$$reportNull$$$0(36);
        }
        String prefix = "function ";
        String fakeText = prefix + NAME_PLACEHOLDER + argumentsAndReturn;
        int startOffset = prefix.length();
        int endOffset = fakeText.length();
        TextRange range = TextRange.create((int)prefix.length(), (int)(prefix.length() + NAME_PLACEHOLDER.length()));
        CharSequence result2 = JSHtmlHighlightingUtil.tryGetHtmlHighlighting((PsiElement)functionItem, fakeText, range, startOffset, endOffset);
        result2 = result2 != null ? JSHtmlHighlightingUtil.replaceSubSequence(result2, NAME_PLACEHOLDER, qName) : qName + argumentsAndReturn;
        for (TextPlaceholder holder : holders) {
            result2 = holder.restoreText(result2);
        }
        CharSequence charSequence = result2;
        if (charSequence == null) {
            JSHtmlHighlightingUtil.$$$reportNull$$$0(37);
        }
        return charSequence;
    }

    @NotNull
    public static CharSequence getTypeHtmlHighlighting(@Nullable JSType type, @Nullable PsiElement context, boolean hasFiredEvents) {
        int endOffset;
        int startOffset;
        if (context == null) {
            String string = JSHtmlHighlightingUtil.getSimpleTypeStringWithLinks(type, hasFiredEvents);
            if (string == null) {
                JSHtmlHighlightingUtil.$$$reportNull$$$0(38);
            }
            return string;
        }
        TextPlaceholder placeholder = JSHtmlHighlightingUtil.getTypeTextPlaceholder(type, false, TYPE_PLACEHOLDER);
        String prefix = "var $$Name$$: ";
        String fakeText = prefix + placeholder.getHolderText();
        CharSequence result2 = JSHtmlHighlightingUtil.tryGetHtmlHighlighting(context, fakeText, null, startOffset = prefix.length(), endOffset = fakeText.length());
        if (result2 != null) {
            CharSequence charSequence = placeholder.restoreText(result2);
            if (charSequence == null) {
                JSHtmlHighlightingUtil.$$$reportNull$$$0(39);
            }
            return charSequence;
        }
        String string = JSHtmlHighlightingUtil.getSimpleTypeStringWithLinks(type, hasFiredEvents);
        if (string == null) {
            JSHtmlHighlightingUtil.$$$reportNull$$$0(40);
        }
        return string;
    }

    @NotNull
    private static String getSimpleTypeStringWithLinks(@Nullable JSType type, boolean hasFiredEvents) {
        if (type == null) {
            if ("any" == null) {
                JSHtmlHighlightingUtil.$$$reportNull$$$0(41);
            }
            return "any";
        }
        JSLinkTypeTextStringBuilder builder = new JSLinkTypeTextStringBuilder(hasFiredEvents);
        type.buildTypeText(JSType.TypeTextFormat.PRESENTABLE, (JSTypeTextBuilder)builder);
        String string = builder.getResult();
        if (string == null) {
            JSHtmlHighlightingUtil.$$$reportNull$$$0(42);
        }
        return string;
    }

    @NotNull
    private static Language getLanguageForHighlighting(@NotNull PsiElement context) {
        if (context == null) {
            JSHtmlHighlightingUtil.$$$reportNull$$$0(43);
        }
        if (DialectDetector.isJavaScript(context)) {
            JSLanguageDialect jSLanguageDialect = JavaScriptSupportLoader.FLOW_JS;
            if (jSLanguageDialect == null) {
                JSHtmlHighlightingUtil.$$$reportNull$$$0(44);
            }
            return jSLanguageDialect;
        }
        Language language = context.getLanguage();
        if (language == null) {
            JSHtmlHighlightingUtil.$$$reportNull$$$0(45);
        }
        return language;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 18: 
            case 19: 
            case 24: 
            case 28: 
            case 31: 
            case 32: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 44: 
            case 45: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 18: 
            case 19: 
            case 24: 
            case 28: 
            case 31: 
            case 32: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 44: 
            case 45: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fakeFile";
                break;
            }
            case 1: 
            case 2: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "iterator";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementOrContext";
                break;
            }
            case 5: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fakeText";
                break;
            }
            case 6: 
            case 10: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "language";
                break;
            }
            case 8: 
            case 13: 
            case 15: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "identifierRange";
                break;
            }
            case 11: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "placeHolderPrefix";
                break;
            }
            case 18: 
            case 19: 
            case 24: 
            case 28: 
            case 31: 
            case 32: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 44: 
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/documentation/JSHtmlHighlightingUtil";
                break;
            }
            case 20: 
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 21: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "originalText";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldText";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newText";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "functionItem";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qName";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "argumentsAndReturn";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holders";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/documentation/JSHtmlHighlightingUtil";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeTextPlaceholder";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "createSimpleHolder";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "replaceSubSequence";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "getElementHtmlHighlighting";
                break;
            }
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "getFunctionHtmlHighlighting";
                break;
            }
            case 38: 
            case 39: 
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeHtmlHighlighting";
                break;
            }
            case 41: 
            case 42: {
                objectArray = objectArray2;
                objectArray2[1] = "getSimpleTypeStringWithLinks";
                break;
            }
            case 44: 
            case 45: {
                objectArray = objectArray2;
                objectArray2[1] = "getLanguageForHighlighting";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "tryGetHtmlHighlighting";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "highlightName";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "createAnnotationsRangeIterator";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "highlightSemanticKeywords";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getTypeTextPlaceholder";
                break;
            }
            case 18: 
            case 19: 
            case 24: 
            case 28: 
            case 31: 
            case 32: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 44: 
            case 45: {
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "tryGetHtmlHighlightingForName";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "createSimpleHolder";
                break;
            }
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "replaceSubSequence";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "getElementHtmlHighlighting";
                break;
            }
            case 33: 
            case 34: 
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "getFunctionHtmlHighlighting";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "getLanguageForHighlighting";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 18: 
            case 19: 
            case 24: 
            case 28: 
            case 31: 
            case 32: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 44: 
            case 45: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static interface TextPlaceholder {
        @NotNull
        public CharSequence getHolderText();

        public CharSequence restoreText(@NotNull CharSequence var1);
    }
}

