/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.hierarchy.method;

import com.intellij.ide.hierarchy.HierarchyBrowserManager;
import com.intellij.ide.hierarchy.HierarchyNodeDescriptor;
import com.intellij.ide.hierarchy.HierarchyTreeStructure;
import com.intellij.lang.javascript.hierarchy.method.JSMethodHierarchyNodeDescriptor;
import com.intellij.lang.javascript.hierarchy.method.JSMethodHierarchyUtil;
import com.intellij.lang.javascript.index.JSTypeEvaluateManager;
import com.intellij.lang.javascript.psi.JSElementBase;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionItem;
import com.intellij.lang.javascript.psi.JSPsiElementBase;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.resolve.JSInheritanceUtil;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JSMethodHierarchyTreeStructure
extends HierarchyTreeStructure {
    private final SmartPsiElementPointer myMethod;

    public JSMethodHierarchyTreeStructure(Project project, JSFunctionItem method) {
        super(project, null);
        this.myBaseDescriptor = this.buildHierarchyElement(project, method);
        ((JSMethodHierarchyNodeDescriptor)this.myBaseDescriptor).setTreeStructure(this);
        this.myMethod = SmartPointerManager.getInstance((Project)this.myProject).createSmartPsiElementPointer((PsiElement)method);
        this.setBaseElement(this.myBaseDescriptor);
    }

    private HierarchyNodeDescriptor buildHierarchyElement(Project project, JSFunctionItem method) {
        List<JSPsiElementBase> classesToShow = JSMethodHierarchyTreeStructure.getSuperClassesToShow(method);
        JSMethodHierarchyNodeDescriptor descriptor2 = null;
        for (int i = classesToShow.size() - 1; i >= 0; --i) {
            JSPsiElementBase jsClass = classesToShow.get(i);
            JSMethodHierarchyNodeDescriptor newDescriptor = new JSMethodHierarchyNodeDescriptor(project, descriptor2, jsClass, false, this);
            if (descriptor2 != null) {
                descriptor2.setCachedChildren(new HierarchyNodeDescriptor[]{newDescriptor});
            }
            descriptor2 = newDescriptor;
        }
        JSPsiElementBase aClass = JSMethodHierarchyUtil.getContainingClass((JSPsiElementBase)method);
        if (aClass == null) {
            throw new IllegalArgumentException("Class for " + method.getClass() + " is null.");
        }
        JSMethodHierarchyNodeDescriptor newDescriptor = new JSMethodHierarchyNodeDescriptor(project, descriptor2, aClass, true, this);
        if (descriptor2 != null) {
            descriptor2.setCachedChildren(new HierarchyNodeDescriptor[]{newDescriptor});
        }
        return newDescriptor;
    }

    private static List<JSPsiElementBase> getSuperClassesToShow(@NotNull JSFunctionItem method) {
        Collection<JSPsiElementBase> interfaceMethods;
        JSPsiElementBase upperNonInterfaceClass;
        JSFunctionItem jsFunction;
        JSPsiElementBase[] superClasses;
        JSPsiElementBase jsClass;
        if (method == null) {
            JSMethodHierarchyTreeStructure.$$$reportNull$$$0(0);
        }
        if ((jsClass = JSMethodHierarchyUtil.getContainingClass((JSPsiElementBase)method)) == null) {
            throw new IllegalArgumentException("Class for " + method.getClass() + " is null.");
        }
        ArrayList<JSPsiElementBase> superClassesToShow = new ArrayList<JSPsiElementBase>();
        JSPsiElementBase superClass = jsClass;
        while ((superClasses = JSMethodHierarchyUtil.getSuperClasses(superClass)).length > 0 && !superClassesToShow.contains(superClass = superClasses[0])) {
            superClassesToShow.add(superClass);
            if (!JSResolveUtil.isObjectClass(superClass)) continue;
        }
        for (int i = superClassesToShow.size() - 1; i >= 0 && JSMethodHierarchyUtil.findMethodInClass(method, (JSPsiElementBase)superClassesToShow.get(i), false) == null; --i) {
            superClassesToShow.remove(i);
        }
        if (jsClass.isClassOrInterface() == JSElementBase.ClassOrInterface.CLASS && (jsFunction = JSMethodHierarchyUtil.findMethodInClass(method, upperNonInterfaceClass = superClassesToShow.isEmpty() ? jsClass : (JSPsiElementBase)superClassesToShow.get(superClassesToShow.size() - 1), false)) instanceof JSQualifiedNamedElement && !(interfaceMethods = JSInheritanceUtil.findImplementedMembers((JSQualifiedNamedElement)jsFunction)).isEmpty()) {
            superClassesToShow.add(JSMethodHierarchyUtil.getContainingClass(interfaceMethods.iterator().next()));
        }
        return superClassesToShow;
    }

    @Nullable
    public final JSFunction getBaseMethod() {
        PsiElement element = this.myMethod.getElement();
        return element instanceof JSFunction ? (JSFunction)element : null;
    }

    @NotNull
    protected final Object[] buildChildren(@NotNull HierarchyNodeDescriptor descriptor2) {
        if (descriptor2 == null) {
            JSMethodHierarchyTreeStructure.$$$reportNull$$$0(1);
        }
        JSPsiElementBase jsClass = ((JSMethodHierarchyNodeDescriptor)descriptor2).getJSClass();
        Collection<JSPsiElementBase> subclasses = JSMethodHierarchyTreeStructure.findDirectSubClasses(jsClass);
        ArrayList<JSMethodHierarchyNodeDescriptor> descriptors = new ArrayList<JSMethodHierarchyNodeDescriptor>(subclasses.size());
        for (JSPsiElementBase aClass : subclasses) {
            if (HierarchyBrowserManager.getInstance((Project)this.myProject).getState().HIDE_CLASSES_WHERE_METHOD_NOT_IMPLEMENTED && this.shouldHideClass(aClass)) continue;
            JSMethodHierarchyNodeDescriptor d = new JSMethodHierarchyNodeDescriptor(this.myProject, descriptor2, aClass, false, this);
            descriptors.add(d);
        }
        Object[] objectArray = descriptors.toArray(new HierarchyNodeDescriptor[0]);
        if (objectArray == null) {
            JSMethodHierarchyTreeStructure.$$$reportNull$$$0(2);
        }
        return objectArray;
    }

    private boolean shouldHideClass(JSPsiElementBase jsClass) {
        if (JSMethodHierarchyUtil.findMethodInClass((JSFunctionItem)this.getBaseMethod(), jsClass, false) != null) {
            return false;
        }
        if (this.hasBaseClassMethod(jsClass)) {
            for (JSPsiElementBase subclass : JSMethodHierarchyTreeStructure.findDirectSubClasses(jsClass)) {
                if (this.shouldHideClass(subclass)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private boolean hasBaseClassMethod(JSPsiElementBase jsClass) {
        JSFunctionItem baseClassMethod = JSMethodHierarchyUtil.findMethodInClass((JSFunctionItem)this.getBaseMethod(), jsClass, true);
        return baseClassMethod != null;
    }

    @NotNull
    private static Collection<JSPsiElementBase> findDirectSubClasses(@NotNull JSPsiElementBase clazz) {
        if (clazz == null) {
            JSMethodHierarchyTreeStructure.$$$reportNull$$$0(3);
        }
        if (clazz instanceof JSClass) {
            ArrayList<JSClass> arrayList = new ArrayList<JSClass>(JSInheritanceUtil.findDirectSubClasses((JSClass)clazz, true));
            if (arrayList == null) {
                JSMethodHierarchyTreeStructure.$$$reportNull$$$0(4);
            }
            return arrayList;
        }
        String qName = JSResolveUtil.getQNameToStartHierarchySearch(clazz);
        if (qName == null) {
            List<JSPsiElementBase> list2 = Collections.emptyList();
            if (list2 == null) {
                JSMethodHierarchyTreeStructure.$$$reportNull$$$0(5);
            }
            return list2;
        }
        final ArrayList<JSPsiElementBase> result2 = new ArrayList<JSPsiElementBase>();
        HashSet<JSPsiElementBase> initialElements = new HashSet<JSPsiElementBase>(Collections.singletonList(clazz));
        JSTypeEvaluateManager.iterateSubclasses((PsiElement)clazz, qName, new JSResolveUtil.MyNamespaceProcessor(initialElements, true){

            @Override
            protected boolean doProcess(PsiElement elt) {
                if (elt instanceof JSPsiElementBase) {
                    result2.add((JSPsiElementBase)elt);
                }
                return true;
            }
        });
        ArrayList<JSPsiElementBase> arrayList = result2;
        if (arrayList == null) {
            JSMethodHierarchyTreeStructure.$$$reportNull$$$0(6);
        }
        return arrayList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/hierarchy/method/JSMethodHierarchyTreeStructure";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/hierarchy/method/JSMethodHierarchyTreeStructure";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "buildChildren";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "findDirectSubClasses";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getSuperClassesToShow";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "buildChildren";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "findDirectSubClasses";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

