/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.index;

import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.library.JSCorePredefinedLibrariesProvider;
import com.intellij.lang.javascript.presentable.JSFormatUtil;
import com.intellij.lang.javascript.presentable.JSNamedElementPresenter;
import com.intellij.lang.javascript.psi.JSExecutionScope;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSFunctionItem;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSPsiElementBase;
import com.intellij.lang.javascript.psi.JSQualifiedName;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeDeclarationOwner;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeListOwner;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSNamespaceDeclaration;
import com.intellij.lang.javascript.psi.ecmal4.JSPackageStatement;
import com.intellij.lang.javascript.psi.impl.CompositeRootCollection;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.stubs.JSImplicitPrototypeElement;
import com.intellij.lang.typescript.psi.TypeScriptPsiUtil;
import com.intellij.navigation.ColoredItemPresentation;
import com.intellij.openapi.editor.colors.CodeInsightColors;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.fileEditor.UniqueVFilePathBuilder;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.JdkOrderEntry;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.io.File;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSItemPresentation
implements ColoredItemPresentation {
    public static final String TYPESCRIPT_PACKAGE = "typescript";
    private static final int LENGTH_LIMIT = 30;
    @NotNull
    private final JSPsiElementBase myElement;
    private static final String NODE_MODULES = "node_modules/";
    private static final String NODE_TYPES = "node_modules/@types/";

    public JSItemPresentation(@NotNull JSPsiElementBase element) {
        if (element == null) {
            JSItemPresentation.$$$reportNull$$$0(0);
        }
        this.myElement = element;
    }

    public String getPresentableText() {
        JSType type;
        String postfix = "";
        if (this.myElement instanceof JSFunctionItem) {
            postfix = !DumbService.isDumb((Project)this.myElement.getProject()) ? JSFormatUtil.buildFunctionSignaturePresentation((JSFunctionItem)this.myElement) : "";
        } else if (this.myElement instanceof JSTypeDeclarationOwner && ((JSTypeDeclarationOwner)this.myElement).getTypeElement() != null && (type = ((JSTypeDeclarationOwner)this.myElement).getJSType()) != null) {
            postfix = ": " + type.getTypeText();
        }
        if (postfix.length() > 30) {
            postfix = postfix.substring(0, 30) + "...";
        }
        return new JSNamedElementPresenter((PsiElement)this.myElement).getShortName() + postfix;
    }

    @Nullable
    public String getLocationString() {
        return this.getLocationString(false);
    }

    @Nullable
    public String getLocationString(boolean completion) {
        String qName;
        String packageName;
        PsiFile psiFile = this.myElement.getContainingFile();
        boolean showPathInformation = true;
        JSQualifiedName elementNamespace = this.myElement.getNamespace();
        if (elementNamespace != null) {
            StringBuilder presentation = new StringBuilder();
            String namespace = elementNamespace.getQualifiedName();
            if (!namespace.isEmpty()) {
                presentation.append("(");
                presentation.append(namespace);
                this.appendFileName(psiFile, true, presentation, completion);
                presentation.append(")");
                return presentation.toString();
            }
        } else if (this.myElement instanceof JSVariable || this.myElement instanceof JSFunction || this.myElement instanceof JSNamespaceDeclaration || this.myElement instanceof JSImplicitPrototypeElement) {
            PsiElement possibleClazz;
            Object object = possibleClazz = this.myElement instanceof JSImplicitPrototypeElement ? ((JSImplicitPrototypeElement)this.myElement).getOwnerClass() : JSResolveUtil.findParent((PsiElement)this.myElement);
            if (possibleClazz instanceof JSClass) {
                String namespace;
                StringBuilder result2 = new StringBuilder();
                JSAttributeList attributeList = this.myElement instanceof JSAttributeListOwner ? ((JSAttributeListOwner)this.myElement).getAttributeList() : null;
                String qualifiedName = ((JSClass)possibleClazz).getQualifiedName();
                if (qualifiedName != null) {
                    result2.append(qualifiedName);
                }
                if (attributeList != null && (namespace = attributeList.getNamespace()) != null) {
                    result2.append(".").append(namespace);
                }
                this.appendFileName(psiFile, !DialectDetector.isActionScript((PsiElement)psiFile), result2, completion);
                return result2.toString();
            }
            if (possibleClazz instanceof JSFile && DialectDetector.isActionScript(possibleClazz) || possibleClazz instanceof JSPackageStatement) {
                String s = this.myElement.getQualifiedName();
                String packageName2 = s == null ? "" : StringUtil.getPackageName((String)s);
                return packageName2.length() > 0 ? "(" + packageName2 + ")" : "";
            }
        } else if (this.myElement instanceof JSClass && (!StringUtil.isEmpty((String)(packageName = JSItemPresentation.representationFromQName(qName = this.myElement.getQualifiedName()))) || DialectDetector.isActionScript((PsiElement)this.myElement))) {
            return packageName;
        }
        if (this.myElement instanceof JSFunctionExpression && (qName = JSResolveUtil.getQNameToStartHierarchySearch(this.myElement)) != null) {
            StringBuilder result3 = new StringBuilder(qName);
            this.appendFileName(psiFile, true, result3, completion);
            return result3.toString();
        }
        StringBuilder res = new StringBuilder();
        this.appendFileName(psiFile, true, res, completion);
        return res.toString();
    }

    private void appendFileName(PsiFile psiFile, boolean showPathInformation, StringBuilder presentation, boolean completion) {
        if (JSItemPresentation.isLocalParameter((PsiElement)this.myElement)) {
            JSItemPresentation.appendParenthesizedIfNeeded(presentation, JSBundle.message((String)"javascript.language.term.parameter", (Object[])new Object[0]));
        } else if (JSItemPresentation.isLocalVariable((PsiElement)this.myElement)) {
            JSItemPresentation.appendParenthesizedIfNeeded(presentation, ((JSVariable)this.myElement).isConst() ? JSBundle.message((String)"javascript.language.term.local.const", (Object[])new Object[0]) : JSBundle.message((String)"javascript.language.term.local.variable", (Object[])new Object[0]));
        } else {
            JSItemPresentation.appendParenthesizedIfNeeded(presentation, JSItemPresentation.getFileName(psiFile, showPathInformation, true, completion));
        }
    }

    public static boolean isLocalVariable(@Nullable PsiElement element) {
        return !(element instanceof JSParameter) && element instanceof JSVariable && JSItemPresentation.isLocalScope(((JSVariable)element).getDeclarationScope());
    }

    public static boolean isLocalParameter(@Nullable PsiElement element) {
        return element instanceof JSParameter && !TypeScriptPsiUtil.isFieldParameter((JSParameter)element);
    }

    private static void appendParenthesizedIfNeeded(StringBuilder presentation, String str) {
        if (StringUtil.isEmpty((String)str)) {
            return;
        }
        if (str.charAt(0) == '(') {
            str = StringUtil.trimEnd((String)StringUtil.trimStart((String)str, (String)"("), (String)")");
        }
        boolean addParens = presentation.length() == 0;
        presentation.append(addParens ? "(" : ", ");
        presentation.append(str);
        if (addParens) {
            presentation.append(")");
        }
    }

    private static boolean isLocalScope(PsiElement scope) {
        return !(scope instanceof JSClass) && (!(scope instanceof JSExecutionScope) || scope instanceof JSFunction);
    }

    @NotNull
    private static String representationFromQName(String qName) {
        String packageName = qName != null ? StringUtil.getPackageName((String)qName) : "";
        String string = !StringUtil.isEmpty((String)packageName) ? "(" + packageName + ")" : "";
        if (string == null) {
            JSItemPresentation.$$$reportNull$$$0(1);
        }
        return string;
    }

    public static String getFileName(PsiFile psiFile) {
        return JSItemPresentation.getFileName(psiFile, true);
    }

    public static String getFileName(PsiFile psiFile, boolean showLocation) {
        return JSItemPresentation.getFileName(psiFile, showLocation, false, false);
    }

    private static String getFileName(PsiFile psiFile, boolean showLibraryLocation, boolean showFilePath, boolean completion) {
        String packageDesc;
        String fileName;
        ProjectFileIndex projectFileIndex;
        VirtualFile file2 = psiFile.getOriginalFile().getViewProvider().getVirtualFile();
        boolean isFromLibrary = false;
        if (showLibraryLocation && (projectFileIndex = ProjectRootManager.getInstance((Project)psiFile.getProject()).getFileIndex()).isInLibrary(file2)) {
            List entriesForFile = projectFileIndex.getOrderEntriesForFile(file2);
            for (int i = 0; i < entriesForFile.size(); ++i) {
                OrderEntry entry = (OrderEntry)entriesForFile.get(i);
                String s = null;
                if (entry instanceof LibraryOrderEntry) {
                    s = entry.getPresentableName();
                    int lastSlash = s.lastIndexOf(File.separatorChar);
                    if (lastSlash != -1) {
                        s = s.substring(lastSlash + 1);
                    }
                } else if (entry instanceof JdkOrderEntry) {
                    Sdk sdk = ((JdkOrderEntry)entry).getJdk();
                    s = sdk instanceof CompositeRootCollection ? ((CompositeRootCollection)sdk).getName(file2) : ((JdkOrderEntry)entry).getJdkName();
                }
                if (s == null) continue;
                return s;
            }
            file2 = JSItemPresentation.getNameOfPhysicalFile(file2);
            isFromLibrary = true;
        }
        if (JSResolveUtil.isFromPredefinedFile(psiFile) || JSCorePredefinedLibrariesProvider.isCoreLibraryFile(file2)) {
            return JSItemPresentation.formatPredefinedFileName(file2.getName(), completion);
        }
        String string = fileName = showFilePath ? JSItemPresentation.getUniqueFileName((PsiElement)psiFile, file2, completion) : file2.getName();
        if (isFromLibrary && (packageDesc = JSItemPresentation.getNodePackageDesc(file2)) != null) {
            return packageDesc;
        }
        return fileName;
    }

    @NotNull
    private static String getUniqueFileName(@NotNull PsiElement context, @NotNull VirtualFile virtualFile, boolean completion) {
        if (context == null) {
            JSItemPresentation.$$$reportNull$$$0(2);
        }
        if (virtualFile == null) {
            JSItemPresentation.$$$reportNull$$$0(3);
        }
        if (!completion) {
            String fileName = virtualFile.getName();
            if (fileName.startsWith("index.")) {
                VirtualFile parent = virtualFile.getParent();
                String string = parent.getName() + "/" + fileName;
                if (string == null) {
                    JSItemPresentation.$$$reportNull$$$0(4);
                }
                return string;
            }
            String string = virtualFile.getName();
            if (string == null) {
                JSItemPresentation.$$$reportNull$$$0(5);
            }
            return string;
        }
        Project project = context.getProject();
        if (DumbService.isDumb((Project)project)) {
            String string = virtualFile.getName();
            if (string == null) {
                JSItemPresentation.$$$reportNull$$$0(6);
            }
            return string;
        }
        String string = UniqueVFilePathBuilder.getInstance().getUniqueVirtualFilePath(context.getProject(), virtualFile);
        if (string == null) {
            JSItemPresentation.$$$reportNull$$$0(7);
        }
        return string;
    }

    @Nullable
    private static String getNodePackageDesc(@NotNull VirtualFile file2) {
        String path;
        int types2;
        if (file2 == null) {
            JSItemPresentation.$$$reportNull$$$0(8);
        }
        if ((types2 = (path = file2.getPath()).indexOf(NODE_TYPES)) != -1) {
            String rest = path.substring(types2 + NODE_TYPES.length());
            return JSItemPresentation.getPackageDesc(rest, file2);
        }
        int modules = path.indexOf(NODE_MODULES);
        if (modules != -1) {
            String rest = path.substring(modules + NODE_MODULES.length());
            return JSItemPresentation.getPackageDesc(rest, file2);
        }
        return null;
    }

    @NotNull
    private static String formatPredefinedFileName(@NotNull String name, boolean completion) {
        if (name == null) {
            JSItemPresentation.$$$reportNull$$$0(9);
        }
        if (!name.startsWith("lib.") || !name.endsWith(".d.ts")) {
            String string = name;
            if (string == null) {
                JSItemPresentation.$$$reportNull$$$0(10);
            }
            return string;
        }
        if (name.contains(".dom.") && completion) {
            if ("(DOM)" == null) {
                JSItemPresentation.$$$reportNull$$$0(11);
            }
            return "(DOM)";
        }
        String string = completion ? "(built-in)" : "(built-in, " + JSItemPresentation.trimLibFileName(name) + ")";
        if (string == null) {
            JSItemPresentation.$$$reportNull$$$0(12);
        }
        return string;
    }

    @NotNull
    private static String getPackageDesc(@NotNull String rest, @NotNull VirtualFile file2) {
        int slash;
        if (rest == null) {
            JSItemPresentation.$$$reportNull$$$0(13);
        }
        if (file2 == null) {
            JSItemPresentation.$$$reportNull$$$0(14);
        }
        if ((slash = rest.indexOf(47)) == -1) {
            String string = "(" + rest + ")";
            if (string == null) {
                JSItemPresentation.$$$reportNull$$$0(15);
            }
            return string;
        }
        String firstPart = rest.substring(0, slash);
        if (firstPart.length() > 0 && firstPart.charAt(0) == '@' && (slash = rest.indexOf(47, slash + 1)) != -1) {
            firstPart = rest.substring(0, slash);
        }
        String result2 = TYPESCRIPT_PACKAGE.equals(firstPart) ? firstPart + ", " + JSItemPresentation.trimLibFileName(file2.getName()) : firstPart;
        String string = "(" + result2 + ")";
        if (string == null) {
            JSItemPresentation.$$$reportNull$$$0(16);
        }
        return string;
    }

    @NotNull
    private static String trimLibFileName(@NotNull String name) {
        if (name == null) {
            JSItemPresentation.$$$reportNull$$$0(17);
        }
        if (!name.startsWith("lib.") || !name.endsWith(".d.ts")) {
            String string = name;
            if (string == null) {
                JSItemPresentation.$$$reportNull$$$0(18);
            }
            return string;
        }
        String string = StringUtil.trimStart((String)StringUtil.trimEnd((String)name, (String)".d.ts"), (String)"lib.");
        if (string == null) {
            JSItemPresentation.$$$reportNull$$$0(19);
        }
        return string;
    }

    public static VirtualFile getNameOfPhysicalFile(VirtualFile file2) {
        VirtualFile fileForJar;
        VirtualFileSystem fileSystem;
        if ("library.swf".equals(file2.getName()) && (fileSystem = file2.getFileSystem()) instanceof JarFileSystem && (fileForJar = ((JarFileSystem)fileSystem).getLocalByEntry(file2)) != null) {
            file2 = fileForJar;
        }
        return file2;
    }

    @Nullable
    public Icon getIcon(boolean open) {
        return this.myElement.getIcon(3);
    }

    @Nullable
    public TextAttributesKey getTextAttributesKey() {
        return this.myElement.isDeprecated() ? CodeInsightColors.DEPRECATED_ATTRIBUTES : null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 10: 
            case 11: 
            case 12: 
            case 15: 
            case 16: 
            case 18: 
            case 19: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 10: 
            case 11: 
            case 12: 
            case 15: 
            case 16: 
            case 18: 
            case 19: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 10: 
            case 11: 
            case 12: 
            case 15: 
            case 16: 
            case 18: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/index/JSItemPresentation";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 8: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 9: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rest";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/index/JSItemPresentation";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "representationFromQName";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getUniqueFileName";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "formatPredefinedFileName";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getPackageDesc";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "trimLibFileName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 10: 
            case 11: 
            case 12: 
            case 15: 
            case 16: 
            case 18: 
            case 19: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getUniqueFileName";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getNodePackageDesc";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "formatPredefinedFileName";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getPackageDesc";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "trimLibFileName";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 10: 
            case 11: 
            case 12: 
            case 15: 
            case 16: 
            case 18: 
            case 19: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

