/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.inspections;

import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.ASTNode;
import com.intellij.lang.ecmascript6.resolve.ES6PsiUtil;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.highlighting.JSFixFactory;
import com.intellij.lang.javascript.inspections.JSInspection;
import com.intellij.lang.javascript.psi.JSArgumentList;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSForInStatement;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSPrefixExpression;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ObjectUtils;
import org.jetbrains.annotations.NotNull;

public class ES6AwaitOutsideAsyncFunctionInspection
extends JSInspection {
    @Override
    @NotNull
    protected PsiElementVisitor createVisitor(final @NotNull ProblemsHolder holder, @NotNull LocalInspectionToolSession session) {
        if (holder == null) {
            ES6AwaitOutsideAsyncFunctionInspection.$$$reportNull$$$0(0);
        }
        if (session == null) {
            ES6AwaitOutsideAsyncFunctionInspection.$$$reportNull$$$0(1);
        }
        JSElementVisitor jSElementVisitor = new JSElementVisitor(){

            public void visitJSPrefixExpression(JSPrefixExpression node) {
                JSFunction parentFunction;
                if (!(node.getOperationSign() != JSTokenTypes.AWAIT_KEYWORD || (parentFunction = (JSFunction)PsiTreeUtil.getContextOfType((PsiElement)node, (Class[])new Class[]{JSFunction.class})) != null && ES6PsiUtil.isAsyncContext(parentFunction))) {
                    LocalQuickFix[] fixes = ES6AwaitOutsideAsyncFunctionInspection.getAsyncFunctionFixes(parentFunction);
                    holder.registerProblem(node.getFirstChild(), JSBundle.message((String)"js.possibly.async.function.error.description", (Object[])new Object[0]), fixes);
                }
            }

            public void visitJSForInStatement(JSForInStatement node) {
                JSFunction function;
                if (node.isForAwait() && ((function = (JSFunction)PsiTreeUtil.getContextOfType((PsiElement)node, (Class[])new Class[]{JSFunction.class})) == null || !ES6PsiUtil.isAsyncContext(function))) {
                    String message = JSBundle.message((String)"javascript.validation.message.for.await.no.async.context", (Object[])new Object[0]);
                    ASTNode awaitNode = node.getNode().findChildByType(JSTokenTypes.AWAIT_KEYWORD);
                    if (awaitNode != null) {
                        TextRange range = new TextRange(0, awaitNode.getTextRange().getEndOffset() - node.getTextRange().getStartOffset());
                        LocalQuickFix[] fixes = ES6AwaitOutsideAsyncFunctionInspection.getAsyncFunctionFixes(function);
                        holder.registerProblem((PsiElement)node, range, message, fixes);
                    }
                }
            }
        };
        if (jSElementVisitor == null) {
            ES6AwaitOutsideAsyncFunctionInspection.$$$reportNull$$$0(2);
        }
        return jSElementVisitor;
    }

    @NotNull
    private static LocalQuickFix[] getAsyncFunctionFixes(JSFunction parentFunction) {
        JSExpression expression;
        JSCallExpression callExpression;
        if (parentFunction == null) {
            if (LocalQuickFix.EMPTY_ARRAY == null) {
                ES6AwaitOutsideAsyncFunctionInspection.$$$reportNull$$$0(3);
            }
            return LocalQuickFix.EMPTY_ARRAY;
        }
        if (!ES6AwaitOutsideAsyncFunctionInspection.isCallbackParameter(parentFunction)) {
            LocalQuickFix[] localQuickFixArray = new LocalQuickFix[]{JSFixFactory.getInstance().createMakeFunctionAsyncFix(parentFunction)};
            if (localQuickFixArray == null) {
                ES6AwaitOutsideAsyncFunctionInspection.$$$reportNull$$$0(4);
            }
            return localQuickFixArray;
        }
        PsiElement parent = parentFunction.getParent();
        if (!ES6AwaitOutsideAsyncFunctionInspection.isCallbackParameter(parentFunction)) {
            LocalQuickFix[] localQuickFixArray = new LocalQuickFix[]{JSFixFactory.getInstance().createMakeFunctionAsyncFix(parentFunction)};
            if (localQuickFixArray == null) {
                ES6AwaitOutsideAsyncFunctionInspection.$$$reportNull$$$0(5);
            }
            return localQuickFixArray;
        }
        if (parent instanceof JSArgumentList && (callExpression = (JSCallExpression)ObjectUtils.tryCast((Object)parent.getParent(), JSCallExpression.class)) != null && (expression = callExpression.getMethodExpression()) instanceof JSReferenceExpression && "forEach".equals(((JSReferenceExpression)expression).getReferenceName())) {
            LocalQuickFix[] localQuickFixArray = new LocalQuickFix[]{JSFixFactory.getInstance().createForEachToForOfFix()};
            if (localQuickFixArray == null) {
                ES6AwaitOutsideAsyncFunctionInspection.$$$reportNull$$$0(6);
            }
            return localQuickFixArray;
        }
        if (LocalQuickFix.EMPTY_ARRAY == null) {
            ES6AwaitOutsideAsyncFunctionInspection.$$$reportNull$$$0(7);
        }
        return LocalQuickFix.EMPTY_ARRAY;
    }

    private static boolean isCallbackParameter(JSFunction function) {
        if (!(function instanceof JSFunctionExpression)) {
            return false;
        }
        return function.getParent() instanceof JSArgumentList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/inspections/ES6AwaitOutsideAsyncFunctionInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/inspections/ES6AwaitOutsideAsyncFunctionInspection";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createVisitor";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getAsyncFunctionFixes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createVisitor";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

