/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.inspections;

import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.LocalQuickFixOnPsiElement;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.inspections.JSInspection;
import com.intellij.lang.javascript.psi.JSAssignmentExpression;
import com.intellij.lang.javascript.psi.JSConditionOwner;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.psi.impl.JSPsiElementFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.NotNull;

public class JSAssignmentUsedAsConditionInspection
extends JSInspection {
    @Override
    @NotNull
    protected PsiElementVisitor createVisitor(final @NotNull ProblemsHolder holder, @NotNull LocalInspectionToolSession session) {
        if (holder == null) {
            JSAssignmentUsedAsConditionInspection.$$$reportNull$$$0(0);
        }
        if (session == null) {
            JSAssignmentUsedAsConditionInspection.$$$reportNull$$$0(1);
        }
        JSElementVisitor jSElementVisitor = new JSElementVisitor(){

            public void visitJSAssignmentExpression(JSAssignmentExpression node) {
                if (this.isCondition(node) && node.getOperationSign() == JSTokenTypes.EQ) {
                    holder.registerProblem((PsiElement)node, JSBundle.message((String)"js.assignment.used.as.condition.text", (Object[])new Object[0]), new LocalQuickFix[]{new JSReplaceWithComparisonFix((PsiElement)node, false), new JSReplaceWithComparisonFix((PsiElement)node, true)});
                }
            }

            private boolean isCondition(@NotNull JSAssignmentExpression node) {
                PsiElement parent;
                if (node == null) {
                    1.$$$reportNull$$$0(0);
                }
                return (parent = node.getParent()) instanceof JSConditionOwner && ((JSConditionOwner)parent).getCondition() == node;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/lang/javascript/inspections/JSAssignmentUsedAsConditionInspection$1", "isCondition"));
            }
        };
        if (jSElementVisitor == null) {
            JSAssignmentUsedAsConditionInspection.$$$reportNull$$$0(2);
        }
        return jSElementVisitor;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/inspections/JSAssignmentUsedAsConditionInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/inspections/JSAssignmentUsedAsConditionInspection";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createVisitor";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class JSReplaceWithComparisonFix
    extends LocalQuickFixOnPsiElement {
        private final String myNewOperator;

        protected JSReplaceWithComparisonFix(@NotNull PsiElement element, boolean useTripleEqual) {
            if (element == null) {
                JSReplaceWithComparisonFix.$$$reportNull$$$0(0);
            }
            super(element);
            this.myNewOperator = useTripleEqual ? "===" : "==";
        }

        @NotNull
        public String getText() {
            String string = JSBundle.message((String)"js.assignment.used.as.condition.fix", (Object[])new Object[]{this.myNewOperator});
            if (string == null) {
                JSReplaceWithComparisonFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        public void invoke(@NotNull Project project, @NotNull PsiFile file2, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
            ASTNode eqNode;
            if (project == null) {
                JSReplaceWithComparisonFix.$$$reportNull$$$0(2);
            }
            if (file2 == null) {
                JSReplaceWithComparisonFix.$$$reportNull$$$0(3);
            }
            if (startElement == null) {
                JSReplaceWithComparisonFix.$$$reportNull$$$0(4);
            }
            if (endElement == null) {
                JSReplaceWithComparisonFix.$$$reportNull$$$0(5);
            }
            if ((eqNode = startElement.getNode().findChildByType(JSTokenTypes.EQ)) != null) {
                TextRange eqRange = eqNode.getTextRange().shiftLeft(startElement.getTextRange().getStartOffset());
                String newText = StringUtil.replaceSubstring((String)startElement.getText(), (TextRange)eqRange, (String)this.myNewOperator);
                JSChangeUtil.replaceExpression((JSExpression)startElement, JSPsiElementFactory.createJSExpression(newText, startElement));
            }
        }

        @NotNull
        public String getFamilyName() {
            String string = this.getText();
            if (string == null) {
                JSReplaceWithComparisonFix.$$$reportNull$$$0(6);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 6: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 6: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 1: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/javascript/inspections/JSAssignmentUsedAsConditionInspection$JSReplaceWithComparisonFix";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "startElement";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "endElement";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/javascript/inspections/JSAssignmentUsedAsConditionInspection$JSReplaceWithComparisonFix";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getText";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 6: {
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "invoke";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 6: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

