/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.intentions;

import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.inspections.JSFunctionExpressionToArrowFunctionInspection;
import com.intellij.lang.javascript.intentions.ES6CoolRefactoring;
import com.intellij.lang.javascript.intentions.JSAnonymousToNamedFunctionIntention;
import com.intellij.lang.javascript.intentions.JavaScriptIntention;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSParenthesizedExpression;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.lang.javascript.refactoring.FormatFixer;
import com.intellij.lang.javascript.refactoring.util.JSFunctionsRefactoringUtil;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class JSArrowFunctionToAnonymousIntention
extends JavaScriptIntention
implements ES6CoolRefactoring {
    public JSArrowFunctionToAnonymousIntention() {
        this.setText(JSBundle.message((String)"js.convert.to.anonymous.function", (Object[])new Object[0]));
    }

    @Override
    public boolean isAvailable(@NotNull Project project, Editor editor, @NotNull PsiElement element) {
        if (project == null) {
            JSArrowFunctionToAnonymousIntention.$$$reportNull$$$0(0);
        }
        if (element == null) {
            JSArrowFunctionToAnonymousIntention.$$$reportNull$$$0(1);
        }
        if (!super.isAvailable(project, editor, element) || !ES6CoolRefactoring.isEs6Compatible(element)) {
            return false;
        }
        JSFunctionExpression functionExpression = JSAnonymousToNamedFunctionIntention.getWrappingAnonymousFunction(element);
        return functionExpression != null && functionExpression.isArrowFunction() && !JSUtils.isMember((PsiElement)functionExpression.getElementAssignedTo()) && !JSFunctionExpressionToArrowFunctionInspection.hasThisReferences((JSFunction)functionExpression);
    }

    public void invoke(@NotNull Project project, Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        if (project == null) {
            JSArrowFunctionToAnonymousIntention.$$$reportNull$$$0(2);
        }
        if (element == null) {
            JSArrowFunctionToAnonymousIntention.$$$reportNull$$$0(3);
        }
        JSFunctionExpression arrowFunction = JSAnonymousToNamedFunctionIntention.getWrappingAnonymousFunction(element);
        assert (arrowFunction != null);
        boolean removeParenthesis = arrowFunction.getParent() instanceof JSParenthesizedExpression && ((JSParenthesizedExpression)arrowFunction.getParent()).getInnerExpression() == arrowFunction;
        JSFunctionExpression anonymousFunction = JSFunctionsRefactoringUtil.createAnonymousFunctionExpression((JSFunction)arrowFunction);
        JSElement replaced = JSChangeUtil.replaceElement((JSElement)(removeParenthesis ? (JSElement)arrowFunction.getParent() : arrowFunction), (JSElement)anonymousFunction);
        FormatFixer.create((PsiElement)replaced, FormatFixer.Mode.Reformat).fixFormat();
    }

    @Nls
    @NotNull
    public String getFamilyName() {
        String string = JSBundle.message((String)"js.convert.to.anonymous.function.family.name", (Object[])new Object[0]);
        if (string == null) {
            JSArrowFunctionToAnonymousIntention.$$$reportNull$$$0(4);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/intentions/JSArrowFunctionToAnonymousIntention";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/intentions/JSArrowFunctionToAnonymousIntention";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

