/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.linter;

import com.intellij.lang.javascript.linter.ExtendedLinterState;
import com.intellij.lang.javascript.linter.JSLinterState;
import com.intellij.lang.javascript.linter.JSLinterView;
import com.intellij.openapi.util.Ref;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class JSLinterBaseView<T extends JSLinterState>
implements JSLinterView<T> {
    private final boolean myFullModeDialog;
    private final JCheckBox myEnableCheckBox;
    private volatile ExtendedLinterState<T> myDeferredState;
    private Ref<Component> myTopRightComponentRef;
    private Component myCenterComponent;
    private JComponent myComponent;

    protected JSLinterBaseView() {
        this(false);
    }

    protected JSLinterBaseView(boolean fullModeDialog) {
        this.myFullModeDialog = fullModeDialog;
        this.myEnableCheckBox = new JBCheckBox("Enable");
        this.myEnableCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JSLinterBaseView.this.onEnableChanged(JSLinterBaseView.this.myEnableCheckBox.isSelected());
            }
        });
    }

    public boolean isFullModeDialog() {
        return this.myFullModeDialog;
    }

    @Nullable
    protected Component createTopRightComponent() {
        return null;
    }

    @NotNull
    protected abstract Component createCenterComponent();

    protected void handleEnableStatusChanged(boolean enabled) {
    }

    @NotNull
    protected abstract T getState();

    protected abstract void setState(@NotNull T var1);

    @Override
    @NotNull
    public final JComponent getComponent() {
        if (this.myComponent == null) {
            Component topRightComponent = this.getTopRightComponent();
            JPanel topPanel = JSLinterBaseView.createTopPanel(this.myEnableCheckBox, topRightComponent);
            Component centerPanel = this.getCenterComponent();
            this.myComponent = JSLinterBaseView.createRootComponent(topPanel, centerPanel);
        }
        JComponent jComponent = this.myComponent;
        if (jComponent == null) {
            JSLinterBaseView.$$$reportNull$$$0(0);
        }
        return jComponent;
    }

    private static JComponent createRootComponent(@NotNull Component top, @NotNull Component center) {
        if (top == null) {
            JSLinterBaseView.$$$reportNull$$$0(1);
        }
        if (center == null) {
            JSLinterBaseView.$$$reportNull$$$0(2);
        }
        JPanel root = new JPanel(new GridBagLayout());
        root.add(top, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 23, 2, (Insets)JBUI.emptyInsets(), 0, 0));
        root.add(center, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 23, 1, (Insets)JBUI.emptyInsets(), 0, 0));
        return root;
    }

    @Override
    public final void setExtendedState(@NotNull ExtendedLinterState<T> extendedState) {
        if (extendedState == null) {
            JSLinterBaseView.$$$reportNull$$$0(3);
        }
        this.myDeferredState = extendedState;
        UIUtil.invokeLaterIfNeeded(() -> {
            boolean enabled = extendedState.isEnabled();
            this.myEnableCheckBox.setSelected(enabled);
            this.onEnableChanged(enabled);
            this.setState(extendedState.getState());
            this.myDeferredState = null;
        });
    }

    @Override
    @NotNull
    public final ExtendedLinterState<T> getExtendedState() {
        if (this.myDeferredState != null) {
            ExtendedLinterState<T> extendedLinterState = this.myDeferredState;
            if (extendedLinterState == null) {
                JSLinterBaseView.$$$reportNull$$$0(4);
            }
            return extendedLinterState;
        }
        T state = this.getState();
        ExtendedLinterState<T> extendedLinterState = ExtendedLinterState.create(this.myEnableCheckBox.isSelected(), state);
        if (extendedLinterState == null) {
            JSLinterBaseView.$$$reportNull$$$0(5);
        }
        return extendedLinterState;
    }

    @Nullable
    private Component getTopRightComponent() {
        if (this.myTopRightComponentRef == null) {
            Component c = this.createTopRightComponent();
            this.myTopRightComponentRef = Ref.create((Object)c);
        }
        return (Component)this.myTopRightComponentRef.get();
    }

    @NotNull
    private Component getCenterComponent() {
        if (this.myCenterComponent == null) {
            this.myCenterComponent = this.createCenterComponent();
        }
        Component component = this.myCenterComponent;
        if (component == null) {
            JSLinterBaseView.$$$reportNull$$$0(6);
        }
        return component;
    }

    @NotNull
    private static JPanel createTopPanel(@NotNull JCheckBox enableCheckBox, @Nullable Component topRightComponent) {
        if (enableCheckBox == null) {
            JSLinterBaseView.$$$reportNull$$$0(7);
        }
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)enableCheckBox, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, (Insets)JBUI.emptyInsets(), 0, 0));
        if (topRightComponent != null) {
            panel.add(topRightComponent, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 13, 0, (Insets)JBUI.insetsLeft((int)20), 0, 0));
        }
        JPanel jPanel = panel;
        if (jPanel == null) {
            JSLinterBaseView.$$$reportNull$$$0(8);
        }
        return jPanel;
    }

    private void onEnableChanged(boolean enabled) {
        Component topRightComponent = this.getTopRightComponent();
        if (topRightComponent != null) {
            UIUtil.setEnabled((Component)topRightComponent, (boolean)enabled, (boolean)true);
        }
        Component centerComponent = this.getCenterComponent();
        UIUtil.setEnabled((Component)centerComponent, (boolean)enabled, (boolean)true);
        this.handleEnableStatusChanged(enabled);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 7: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 7: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/linter/JSLinterBaseView";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "top";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "center";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extendedState";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "enableCheckBox";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/linter/JSLinterBaseView";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getExtendedState";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getCenterComponent";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "createTopPanel";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createRootComponent";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setExtendedState";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createTopPanel";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 7: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

