/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.linter.eslint;

import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterRef;
import com.intellij.javascript.nodejs.util.NodePackage;
import com.intellij.javascript.nodejs.util.NodePackageRef;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.linter.AutodetectLinterPackage;
import com.intellij.lang.javascript.linter.ExtendedLinterState;
import com.intellij.lang.javascript.linter.JSLinterView;
import com.intellij.lang.javascript.linter.NewLinterView;
import com.intellij.lang.javascript.linter.UntypedJSLinterConfigurable;
import com.intellij.lang.javascript.linter.eslint.EslintConfiguration;
import com.intellij.lang.javascript.linter.eslint.EslintPanel;
import com.intellij.lang.javascript.linter.eslint.EslintState;
import com.intellij.lang.javascript.linter.eslint.service.EslintLanguageServiceManager;
import com.intellij.lang.javascript.linter.eslint.standardjs.StandardJSConfiguration;
import com.intellij.lang.javascript.linter.eslint.standardjs.StandardJSLanguageServiceManager;
import com.intellij.lang.javascript.linter.eslint.standardjs.StandardJSState;
import com.intellij.openapi.project.Project;
import com.intellij.util.ObjectUtils;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class EslintConfigurable
extends UntypedJSLinterConfigurable {
    public static final String ID = "settings.javascript.linters.eslint";

    public EslintConfigurable(@NotNull Project project) {
        if (project == null) {
            EslintConfigurable.$$$reportNull$$$0(0);
        }
        this(project, false);
    }

    public EslintConfigurable(@NotNull Project project, boolean fullModeDialog) {
        if (project == null) {
            EslintConfigurable.$$$reportNull$$$0(1);
        }
        super(project, fullModeDialog);
    }

    @Override
    @NotNull
    public String getId() {
        if (ID == null) {
            EslintConfigurable.$$$reportNull$$$0(2);
        }
        return ID;
    }

    @Nls
    public String getDisplayName() {
        return JSBundle.message((String)"settings.javascript.linters.eslint.configurable.name", (Object[])new Object[0]);
    }

    @Override
    @NotNull
    protected JSLinterView<EslintState> createView() {
        NewEslintView newEslintView = new NewEslintView(this.getProject(), this.getDisplayName(), new EslintPanel(this.getProject(), this.isFullModeDialog(), false));
        if (newEslintView == null) {
            EslintConfigurable.$$$reportNull$$$0(3);
        }
        return newEslintView;
    }

    public void reset() {
        JSLinterView<EslintState> view = this.getEslintView();
        if (view == null) {
            return;
        }
        view.setExtendedState(this.loadUiState());
        if (view instanceof NewLinterView) {
            ((NewLinterView)view).reset();
        }
        this.resizeDialogToFitPreferredSize(view);
    }

    public void apply() {
        JSLinterView<EslintState> view = this.getEslintView();
        if (view == null) {
            return;
        }
        ExtendedLinterState<EslintState> extendedStateFromUi = view.getExtendedState();
        EslintState eslintStateFromUi = extendedStateFromUi.getState();
        boolean isStandardJS = EslintPanel.isStandardJs(eslintStateFromUi.getNodePackageRef());
        if (isStandardJS) {
            NodePackage nodePackage = (NodePackage)ObjectUtils.assertNotNull((Object)eslintStateFromUi.getNodePackageRef().getConstantPackage());
            StandardJSState standardJsState = new StandardJSState(eslintStateFromUi.getInterpreterRef(), nodePackage);
            this.setExtendedState(ExtendedLinterState.create(extendedStateFromUi.isEnabled(), standardJsState), StandardJSConfiguration.class);
            this.setExtendedState(ExtendedLinterState.create(false, EslintState.DEFAULT), EslintConfiguration.class);
        } else {
            this.setExtendedState(ExtendedLinterState.create(false, StandardJSState.DEFAULT), StandardJSConfiguration.class);
            this.setExtendedState(ExtendedLinterState.create(extendedStateFromUi.isEnabled(), eslintStateFromUi), EslintConfiguration.class);
        }
        if (view instanceof NewLinterView) {
            ((NewLinterView)view).apply();
        }
        EslintLanguageServiceManager.getInstance(this.myProject).terminateServices();
        StandardJSLanguageServiceManager.getInstance(this.myProject).terminateServices();
    }

    @Override
    public boolean isModified() {
        JSLinterView<EslintState> view = this.getEslintView();
        if (view == null) {
            return false;
        }
        return !this.loadUiState().equals(view.getExtendedState()) || view instanceof NewLinterView && ((NewLinterView)view).isModified();
    }

    private JSLinterView<EslintState> getEslintView() {
        return this.myView;
    }

    @NotNull
    private ExtendedLinterState<EslintState> loadUiState() {
        ExtendedLinterState eslintExtendedState = this.getExtendedState(EslintConfiguration.class);
        ExtendedLinterState standardJsExtendedState = this.getExtendedState(StandardJSConfiguration.class);
        EslintState eslintState = (EslintState)eslintExtendedState.getState();
        StandardJSState standardJSState = (StandardJSState)standardJsExtendedState.getState();
        boolean isStandardJS = standardJsExtendedState.isEnabled();
        EslintState uiState = isStandardJS ? new EslintState.Builder().setEslintPackage(NodePackageRef.create(standardJSState.getNodePackage())).setInterpreterRef(standardJSState.getInterpreterRef()).build() : eslintState;
        ExtendedLinterState<EslintState> extendedLinterState = ExtendedLinterState.create(eslintExtendedState.isEnabled() || standardJsExtendedState.isEnabled(), uiState);
        if (extendedLinterState == null) {
            EslintConfigurable.$$$reportNull$$$0(4);
        }
        return extendedLinterState;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/linter/eslint/EslintConfigurable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/linter/eslint/EslintConfigurable";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getId";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createView";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "loadUiState";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class NewEslintView
    extends NewLinterView<EslintState> {
        private final EslintPanel myEslintPanel;

        NewEslintView(Project project, String displayName, EslintPanel eslintPanel) {
            super(project, displayName, eslintPanel.getComponent(), ".eslint.*");
            this.myEslintPanel = eslintPanel;
        }

        @Override
        protected void setState(@NotNull EslintState state) {
            if (state == null) {
                NewEslintView.$$$reportNull$$$0(0);
            }
            this.myEslintPanel.setState(state);
        }

        @Override
        @NotNull
        protected EslintState getStateWithConfiguredAutomatically() {
            EslintState eslintState = EslintState.DEFAULT.withLinterPackage(AutodetectLinterPackage.INSTANCE).withInterpreterRef(NodeJsInterpreterRef.createProjectRef());
            if (eslintState == null) {
                NewEslintView.$$$reportNull$$$0(1);
            }
            return eslintState;
        }

        @Override
        protected void handleEnabledStatusChanged(boolean enabled) {
            this.myEslintPanel.handleEnableStatusChanged(enabled);
        }

        @Override
        @NotNull
        protected EslintState getState() {
            EslintState eslintState = this.myEslintPanel.getState();
            if (eslintState == null) {
                NewEslintView.$$$reportNull$$$0(2);
            }
            return eslintState;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "state";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/javascript/linter/eslint/EslintConfigurable$NewEslintView";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/javascript/linter/eslint/EslintConfigurable$NewEslintView";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getStateWithConfiguredAutomatically";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getState";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "setState";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

