/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.modules;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInsight.intention.FileModifier;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterManager;
import com.intellij.javascript.nodejs.npm.NpmManager;
import com.intellij.javascript.nodejs.npm.NpmUtil;
import com.intellij.javascript.nodejs.packageJson.PackageJsonDependenciesExternalUpdateManager;
import com.intellij.lang.ecmascript6.psi.ES6FromClause;
import com.intellij.lang.ecmascript6.resolve.JSFileReferencesUtil;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.JSStringUtil;
import com.intellij.lang.javascript.modules.InstallNodeLocalDependenciesAction;
import com.intellij.lang.javascript.modules.JSModulesQuickFix;
import com.intellij.lang.javascript.modules.NodeModuleUtil;
import com.intellij.lang.javascript.modules.NpmPackageInstallerLight;
import com.intellij.lang.javascript.modules.RecordModuleIntoPackageJsonQuickFix;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.ui.components.JBList;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Consumer;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.webcore.packaging.PackageManagementService;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.JList;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InstallNodeModuleQuickFix
implements LocalQuickFix,
IntentionAction,
JSModulesQuickFix,
Comparable<FileModifier> {
    private final ModuleElement myModuleElement;
    private final boolean myInstallAll;
    private final boolean myAsDevDependency;
    private final List<VirtualFile> myPackageJsonFiles;
    private final String myModuleName;

    public InstallNodeModuleQuickFix(@NotNull ModuleElement module, @NotNull Collection<? extends VirtualFile> virtualFiles) {
        if (module == null) {
            InstallNodeModuleQuickFix.$$$reportNull$$$0(0);
        }
        if (virtualFiles == null) {
            InstallNodeModuleQuickFix.$$$reportNull$$$0(1);
        }
        this(module, false, false, virtualFiles);
    }

    protected InstallNodeModuleQuickFix(@NotNull ModuleElement module, boolean installAll, boolean asDevDependency, @NotNull Collection<? extends VirtualFile> virtualFiles) {
        if (module == null) {
            InstallNodeModuleQuickFix.$$$reportNull$$$0(2);
        }
        if (virtualFiles == null) {
            InstallNodeModuleQuickFix.$$$reportNull$$$0(3);
        }
        this.myModuleElement = module;
        this.myModuleName = module.getModuleName();
        this.myInstallAll = installAll;
        this.myAsDevDependency = asDevDependency;
        this.myPackageJsonFiles = new ArrayList<VirtualFile>(virtualFiles);
    }

    @Nls
    @NotNull
    public String getText() {
        String moduleName = this.myModuleElement.getModuleName();
        if (this.myInstallAll) {
            String string = "Run " + NpmManager.getInstance(this.myModuleElement.getProject()).getNpmInstallPresentableText();
            if (string == null) {
                InstallNodeModuleQuickFix.$$$reportNull$$$0(4);
            }
            return string;
        }
        if (this.myAsDevDependency) {
            String string = JSBundle.message((String)"node.js.quickfix.install.node.module.with.dev.dependencies.text", (Object[])new Object[]{moduleName});
            if (string == null) {
                InstallNodeModuleQuickFix.$$$reportNull$$$0(5);
            }
            return string;
        }
        String string = JSBundle.message((String)"node.js.quickfix.install.node.module.text", (Object[])new Object[]{moduleName});
        if (string == null) {
            InstallNodeModuleQuickFix.$$$reportNull$$$0(6);
        }
        return string;
    }

    @Nls
    @NotNull
    public String getName() {
        String string = this.getText();
        if (string == null) {
            InstallNodeModuleQuickFix.$$$reportNull$$$0(7);
        }
        return string;
    }

    @Nls
    @NotNull
    public String getFamilyName() {
        String string = JSBundle.message((String)"node.js.quickfix.install.node.module.family.name", (Object[])new Object[0]);
        if (string == null) {
            InstallNodeModuleQuickFix.$$$reportNull$$$0(8);
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file2) {
        if (project == null) {
            InstallNodeModuleQuickFix.$$$reportNull$$$0(9);
        }
        return StringUtil.equals((CharSequence)this.myModuleName, (CharSequence)this.myModuleElement.getModuleName());
    }

    public final void invoke(@NotNull Project project, Editor editor, PsiFile file2) throws IncorrectOperationException {
        if (project == null) {
            InstallNodeModuleQuickFix.$$$reportNull$$$0(10);
        }
        this.applyFixImpl(project, file2);
    }

    public final boolean startInWriteAction() {
        return false;
    }

    public final void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
        if (project == null) {
            InstallNodeModuleQuickFix.$$$reportNull$$$0(11);
        }
        if (descriptor2 == null) {
            InstallNodeModuleQuickFix.$$$reportNull$$$0(12);
        }
        this.applyFixImpl(project, descriptor2.getPsiElement().getContainingFile());
    }

    private void applyFixImpl(@NotNull Project project, @NotNull PsiFile psiFile) {
        if (project == null) {
            InstallNodeModuleQuickFix.$$$reportNull$$$0(13);
        }
        if (psiFile == null) {
            InstallNodeModuleQuickFix.$$$reportNull$$$0(14);
        }
        InstallNodeModuleQuickFix.showSelectPackagePopupIfRequired(project, this.myPackageJsonFiles, (Consumer<? super VirtualFile>)((Consumer)packageJson -> this.invokeAction(project, psiFile, (VirtualFile)packageJson)));
    }

    private void invokeAction(@NotNull Project project, @NotNull PsiFile psiFile, @Nullable VirtualFile packageJson) {
        if (project == null) {
            InstallNodeModuleQuickFix.$$$reportNull$$$0(15);
        }
        if (psiFile == null) {
            InstallNodeModuleQuickFix.$$$reportNull$$$0(16);
        }
        if (this.myInstallAll && packageJson != null) {
            InstallNodeLocalDependenciesAction.runAndShowConsole(project, packageJson);
            return;
        }
        NodeJsInterpreter interpreter = NodeJsInterpreterManager.getInstance(project).getInterpreter();
        if (interpreter == null) {
            Messages.showErrorDialog((Project)project, (String)JSBundle.message((String)"node.js.quickfix.install.node.module.error.no.interpreter.text", (Object[])new Object[0]), (String)JSBundle.message((String)"node.js.quickfix.install.node.module.error.no.interpreter.title", (Object[])new Object[0]));
            return;
        }
        if ((packageJson = InstallNodeModuleQuickFix.savePackageJson(project, packageJson)) == null) {
            return;
        }
        String extra = InstallNodeModuleQuickFix.buildExtraOptions(project, this.myAsDevDependency);
        String moduleName = this.myModuleElement.getModuleName();
        if (moduleName == null) {
            return;
        }
        DaemonCodeAnalyzer.getInstance((Project)project).restart(psiFile);
        if (project.getBasePath() == null) {
            return;
        }
        PackageManagementService.Listener listener2 = InstallNodeModuleQuickFix.createListener(project, packageJson, moduleName);
        NpmPackageInstallerLight installerLight = (NpmPackageInstallerLight)ServiceManager.getService(NpmPackageInstallerLight.class);
        File workingDir = new File(packageJson.getParent().getPath());
        installerLight.installPackage(project, interpreter, moduleName, null, workingDir, listener2, extra);
    }

    @Nullable
    public static String buildExtraOptions(@NotNull Project project, boolean asDevDependency) {
        if (project == null) {
            InstallNodeModuleQuickFix.$$$reportNull$$$0(17);
        }
        boolean yarn = NpmUtil.isYarnAlikePackageRef(NpmManager.getInstance(project).getPackageRef());
        if (asDevDependency) {
            return yarn ? "--dev" : "--save-dev";
        }
        return yarn ? null : "--save";
    }

    @NotNull
    public static PackageManagementService.Listener createListener(final @NotNull Project project, @Nullable VirtualFile packageJson, @NotNull String moduleName) {
        if (project == null) {
            InstallNodeModuleQuickFix.$$$reportNull$$$0(18);
        }
        if (moduleName == null) {
            InstallNodeModuleQuickFix.$$$reportNull$$$0(19);
        }
        final Runnable done = PackageJsonDependenciesExternalUpdateManager.getInstance(project).externalUpdateStarted(packageJson, moduleName);
        PackageManagementService.Listener listener2 = new PackageManagementService.Listener(){

            public void operationStarted(String packageName) {
            }

            public void operationFinished(String packageName, @Nullable PackageManagementService.ErrorDescription errorDescription) {
                done.run();
                if (errorDescription != null) {
                    Messages.showErrorDialog((Project)project, (String)JSBundle.message((String)"node.js.quickfix.install.node.module.error.prefix.text", (Object[])new Object[]{errorDescription.getMessage()}), (String)JSBundle.message((String)"node.js.quickfix.install.node.module.error.no.interpreter.title", (Object[])new Object[0]));
                }
            }
        };
        if (listener2 == null) {
            InstallNodeModuleQuickFix.$$$reportNull$$$0(20);
        }
        return listener2;
    }

    @Override
    public int compareTo(@NotNull FileModifier o) {
        if (o == null) {
            InstallNodeModuleQuickFix.$$$reportNull$$$0(21);
        }
        if (o instanceof InstallNodeModuleQuickFix) {
            return Comparing.compare((int)this.getCompareId(), (int)((InstallNodeModuleQuickFix)o).getCompareId());
        }
        return 0;
    }

    private static VirtualFile savePackageJson(Project project, VirtualFile packageJson) {
        FileDocumentManager documentManager;
        Document document2;
        PsiFile psiFile = RecordModuleIntoPackageJsonQuickFix.ensurePackageJsonExist(project, packageJson, null);
        VirtualFile virtualFile = packageJson = psiFile != null ? psiFile.getVirtualFile() : packageJson;
        if (packageJson != null && (document2 = (documentManager = FileDocumentManager.getInstance()).getDocument(packageJson)) != null) {
            documentManager.saveDocument(document2);
        }
        return packageJson;
    }

    static void showSelectPackagePopupIfRequired(@NotNull Project project, @NotNull List<VirtualFile> packageJsonFiles, @NotNull Consumer<? super VirtualFile> consumer) {
        if (project == null) {
            InstallNodeModuleQuickFix.$$$reportNull$$$0(22);
        }
        if (packageJsonFiles == null) {
            InstallNodeModuleQuickFix.$$$reportNull$$$0(23);
        }
        if (consumer == null) {
            InstallNodeModuleQuickFix.$$$reportNull$$$0(24);
        }
        if ((packageJsonFiles = ContainerUtil.filter(packageJsonFiles, file2 -> file2.isValid())).isEmpty()) {
            consumer.consume(null);
            return;
        }
        if (packageJsonFiles.size() == 1 || ApplicationManager.getApplication().isUnitTestMode()) {
            consumer.consume(packageJsonFiles.get(0));
            return;
        }
        Collections.sort(packageJsonFiles, NodeModuleUtil.VIRTUAL_FILE_COMPARATOR);
        JBList list2 = new JBList();
        ArrayList<String> data = new ArrayList<String>();
        for (VirtualFile file3 : packageJsonFiles) {
            data.add(file3.getPath());
        }
        list2.setListData(ArrayUtil.toObjectArray(data));
        List finalPackageJsonFiles = packageJsonFiles;
        JBPopup popup = JBPopupFactory.getInstance().createListPopupBuilder((JList)list2).setTitle("Select package.json File").setItemChoosenCallback(() -> {
            int index = list2.getSelectedIndex();
            if (index >= 0) {
                consumer.consume(finalPackageJsonFiles.get(index));
            }
        }).createPopup();
        Editor editor = FileEditorManager.getInstance((Project)project).getSelectedTextEditor();
        if (editor != null) {
            popup.showInBestPositionFor(editor);
        } else {
            popup.showCenteredInCurrentWindow(project);
        }
    }

    private int getCompareId() {
        if (this.myInstallAll) {
            return 0;
        }
        return 1;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 20: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 20: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFiles";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/modules/InstallNodeModuleQuickFix";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 15: 
            case 17: 
            case 18: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 14: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleName";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageJsonFiles";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/modules/InstallNodeModuleQuickFix";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "createListener";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 20: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "applyFixImpl";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "invokeAction";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "buildExtraOptions";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "createListener";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "compareTo";
                break;
            }
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "showSelectPackagePopupIfRequired";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 20: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static abstract class ModuleElementBase<T extends PsiElement>
    implements ModuleElement {
        protected final SmartPsiElementPointer<T> myPointer;

        ModuleElementBase(@NotNull T element) {
            if (element == null) {
                ModuleElementBase.$$$reportNull$$$0(0);
            }
            this.myPointer = SmartPointerManager.getInstance((Project)element.getProject()).createSmartPsiElementPointer(element);
        }

        @Override
        @Nullable
        public String getModuleName() {
            PsiElement element = this.myPointer.getElement();
            if (element == null || !element.isValid()) {
                return null;
            }
            return JSFileReferencesUtil.getNodeModuleName(this.getModuleNameImpl(element));
        }

        protected abstract String getModuleNameImpl(@NotNull T var1);

        @Override
        @NotNull
        public Project getProject() {
            Project project = this.myPointer.getProject();
            if (project == null) {
                ModuleElementBase.$$$reportNull$$$0(1);
            }
            return project;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/javascript/modules/InstallNodeModuleQuickFix$ModuleElementBase";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/javascript/modules/InstallNodeModuleQuickFix$ModuleElementBase";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getProject";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    static class StringLiteralModuleElement
    extends ModuleElementBase<PsiElement> {
        StringLiteralModuleElement(@NotNull PsiElement literal) {
            if (literal == null) {
                StringLiteralModuleElement.$$$reportNull$$$0(0);
            }
            super(literal);
        }

        @Override
        protected String getModuleNameImpl(@NotNull PsiElement literal) {
            if (literal == null) {
                StringLiteralModuleElement.$$$reportNull$$$0(1);
            }
            return StringUtil.notNullize((String)literal.getText());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "literal";
            objectArray2[1] = "com/intellij/lang/javascript/modules/InstallNodeModuleQuickFix$StringLiteralModuleElement";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getModuleNameImpl";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    static class ES6FromClauseModuleElement
    extends ModuleElementBase<ES6FromClause> {
        ES6FromClauseModuleElement(@NotNull ES6FromClause element) {
            if (element == null) {
                ES6FromClauseModuleElement.$$$reportNull$$$0(0);
            }
            super(element);
        }

        @Override
        protected String getModuleNameImpl(@NotNull ES6FromClause element) {
            if (element == null) {
                ES6FromClauseModuleElement.$$$reportNull$$$0(1);
            }
            return JSStringUtil.unquoteStringLiteralValue(StringUtil.notNullize((String)element.getReferenceText()));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "element";
            objectArray2[1] = "com/intellij/lang/javascript/modules/InstallNodeModuleQuickFix$ES6FromClauseModuleElement";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getModuleNameImpl";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static interface ModuleElement {
        @Nullable
        public String getModuleName();

        @NotNull
        public Project getProject();
    }
}

