/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.navigation;

import com.intellij.codeInsight.navigation.actions.TypeDeclarationProvider;
import com.intellij.lang.ecmascript6.resolve.JSFileReferencesUtil;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.dialects.JSDialectSpecificHandlersFactory;
import com.intellij.lang.javascript.frameworks.commonjs.CommonJSUtil;
import com.intellij.lang.javascript.index.JSSymbolUtil;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSPsiElementBase;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.resolve.JSClassResolver;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.types.JSNamedType;
import com.intellij.lang.javascript.psi.types.TypeScriptTypeParser;
import com.intellij.lang.javascript.psi.util.JSStubBasedPsiTreeUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class JavaScriptTypeDeclarationProvider
implements TypeDeclarationProvider {
    public PsiElement[] getSymbolTypeDeclarations(@NotNull PsiElement symbol) {
        PsiElement[] elements;
        if (symbol == null) {
            JavaScriptTypeDeclarationProvider.$$$reportNull$$$0(0);
        }
        if (!(symbol instanceof JSNamedElement)) {
            return null;
        }
        JSType type = null;
        if (symbol instanceof JSFunction) {
            type = ((JSFunction)symbol).getReturnType();
        } else if (symbol instanceof JSVariable) {
            Collection<PsiElement> constructors = JavaScriptTypeDeclarationProvider.findReferencedModuleConstructors((JSVariable)symbol);
            if (!constructors.isEmpty()) {
                return constructors.toArray(PsiElement.EMPTY_ARRAY);
            }
            type = ((JSVariable)symbol).getJSType();
        } else if (symbol instanceof JSExpression) {
            type = JSResolveUtil.getExpressionJSType((JSExpression)symbol);
        }
        if (DialectDetector.isTypeScript(symbol) && (elements = TypeScriptTypeParser.resolveElementsByType(type).toArray(PsiElement.EMPTY_ARRAY)).length > 0) {
            return elements;
        }
        if (type instanceof JSNamedType) {
            PsiFile containingFile = symbol.getContainingFile();
            String s = type.getResolvedTypeText();
            boolean ecmaL4 = DialectDetector.isActionScript((PsiElement)containingFile);
            GlobalSearchScope scope = JSResolveUtil.getResolveScope((PsiElement)containingFile);
            PsiElement item = JSDialectSpecificHandlersFactory.forElement(symbol).getClassResolver().findClassByQName(s, symbol);
            if (item == null) {
                ArrayList result2 = new ArrayList();
                JSClassResolver.processElementsByNameIncludingImplicit(s, scope, false, (Processor<? super JSPsiElementBase>)((Processor)namedElement -> {
                    boolean ecmalL4File = DialectDetector.isActionScript((PsiElement)namedElement.getContainingFile());
                    if (ecmalL4File != ecmaL4) {
                        return true;
                    }
                    result2.add(0, namedElement);
                    return true;
                }));
                if (!result2.isEmpty()) {
                    item = (PsiElement)result2.get(0);
                }
            }
            if (item != null && item.isPhysical()) {
                return new PsiElement[]{item};
            }
        }
        return new PsiElement[]{symbol};
    }

    @NotNull
    private static Collection<PsiElement> findReferencedModuleConstructors(JSVariable element) {
        if (element instanceof JSParameter) {
            JSLiteralExpression argument = JSSymbolUtil.getParameterInitializationIfRequireArgument((JSParameter)element);
            if (argument != null) {
                PsiReference[] references = argument.getReferences();
                Collection<PsiElement> modules = JSFileReferencesUtil.getMostPriorityModules((PsiElement)element, references);
                for (PsiElement resolve : modules) {
                    if (!(resolve instanceof JSFile)) continue;
                    Collection<? extends PsiElement> exportedElements = JSResolveUtil.getExportedElements((JSFile)resolve);
                    Collection<Object> collection = exportedElements.isEmpty() ? Collections.singleton(resolve) : Collections.unmodifiableCollection(exportedElements);
                    if (collection == null) {
                        JavaScriptTypeDeclarationProvider.$$$reportNull$$$0(1);
                    }
                    return collection;
                }
            }
        } else {
            JSExpression initializer = element.getInitializer();
            if (initializer instanceof JSCallExpression) {
                Collection<PsiElement> collection = JavaScriptTypeDeclarationProvider.findReferencedModuleConstructorIfRequireCall((JSCallExpression)initializer);
                if (collection == null) {
                    JavaScriptTypeDeclarationProvider.$$$reportNull$$$0(2);
                }
                return collection;
            }
        }
        List<PsiElement> list2 = Collections.emptyList();
        if (list2 == null) {
            JavaScriptTypeDeclarationProvider.$$$reportNull$$$0(3);
        }
        return list2;
    }

    @NotNull
    private static Collection<PsiElement> findReferencedModuleConstructorIfRequireCall(@NotNull JSCallExpression callExpression) {
        if (callExpression == null) {
            JavaScriptTypeDeclarationProvider.$$$reportNull$$$0(4);
        }
        List result2 = ContainerUtil.newSmartList();
        PsiElement module = CommonJSUtil.findReferencedModuleIfRequireCall(callExpression);
        if (module instanceof JSFile) {
            Collection<? extends PsiElement> exportedElements = JSResolveUtil.getExportedElements((JSFile)module);
            for (PsiElement psiElement : exportedElements) {
                PsiElement element;
                String reference;
                if (psiElement instanceof JSDefinitionExpression && (reference = ((JSDefinitionExpression)psiElement).getInitializerReference()) != null && (element = JSStubBasedPsiTreeUtil.resolveLocally(reference, psiElement)) != null) {
                    result2.add(element);
                    continue;
                }
                if (psiElement == null) continue;
                result2.add(psiElement);
            }
        }
        if (result2.isEmpty()) {
            result2.add(module);
        }
        List list2 = result2;
        if (list2 == null) {
            JavaScriptTypeDeclarationProvider.$$$reportNull$$$0(5);
        }
        return list2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "symbol";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/navigation/JavaScriptTypeDeclarationProvider";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callExpression";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/navigation/JavaScriptTypeDeclarationProvider";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "findReferencedModuleConstructors";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "findReferencedModuleConstructorIfRequireCall";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getSymbolTypeDeclarations";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "findReferencedModuleConstructorIfRequireCall";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

