/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.ecma6.impl;

import com.intellij.lang.javascript.psi.JSSourceElement;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptFunction;
import com.intellij.lang.javascript.psi.stubs.TypeScriptFunctionStub;
import com.intellij.lang.javascript.psi.util.JSStubBasedPsiTreeUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

interface TypeScriptOverloadsMixin
extends TypeScriptFunction {
    @Nullable
    public TypeScriptOverloadsMixin doGetPrevOverloadCandidate();

    @Nullable
    public TypeScriptOverloadsMixin doGetNextOverloadCandidate();

    @Nullable
    public TypeScriptFunctionStub getGreenStub();

    @Nullable
    default public TypeScriptFunction getNextOverloadOrImplementation() {
        if (!this.isOverloadDeclaration()) {
            return null;
        }
        return TypeScriptOverloadsMixin.getNextOverloadFunction(this);
    }

    @NotNull
    default public List<TypeScriptFunction> getOverloadDeclarations() {
        if (this.hasOverloadDeclarations()) {
            List<TypeScriptFunction> list2 = TypeScriptOverloadsMixin.getOverloadDeclarationsImpl(this, false);
            if (list2 == null) {
                TypeScriptOverloadsMixin.$$$reportNull$$$0(0);
            }
            return list2;
        }
        List list3 = ContainerUtil.emptyList();
        if (list3 == null) {
            TypeScriptOverloadsMixin.$$$reportNull$$$0(1);
        }
        return list3;
    }

    default public boolean hasOverloadDeclarations() {
        TypeScriptFunctionStub stub = this.getGreenStub();
        if (stub != null) {
            return stub.hasOverloadDeclarations();
        }
        State state = TypeScriptOverloadsMixin.calcOverloadState(this);
        return state == State.IS_OVERLOAD_IMPLEMENTATION || state == State.HAS_OVERLOADS || state == State.IS_OVERLOAD_AND_HAS_OVERLOADS;
    }

    default public boolean isOverloadImplementation() {
        TypeScriptFunctionStub stub = this.getGreenStub();
        if (stub != null) {
            return stub.isOverloadImplementation();
        }
        return TypeScriptOverloadsMixin.calcOverloadState(this) == State.IS_OVERLOAD_IMPLEMENTATION;
    }

    default public boolean isOverloadDeclaration() {
        TypeScriptFunctionStub stub = this.getGreenStub();
        if (stub != null) {
            return stub.isOverloadDeclaration();
        }
        State state = TypeScriptOverloadsMixin.calcOverloadState(this);
        return state == State.IS_OVERLOAD || state == State.IS_OVERLOAD_AND_HAS_OVERLOADS;
    }

    public static TypeScriptOverloadsMixin getNextOverloadFunction(@NotNull TypeScriptOverloadsMixin function) {
        TypeScriptOverloadsMixin nextFunction;
        if (function == null) {
            TypeScriptOverloadsMixin.$$$reportNull$$$0(2);
        }
        return (nextFunction = function.doGetNextOverloadCandidate()) != null && StringUtil.equals((CharSequence)function.getName(), (CharSequence)nextFunction.getName()) ? nextFunction : null;
    }

    public static State calcOverloadState(@NotNull TypeScriptOverloadsMixin function) {
        if (function == null) {
            TypeScriptOverloadsMixin.$$$reportNull$$$0(3);
        }
        return (State)((Object)CachedValuesManager.getCachedValue((PsiElement)function, () -> {
            boolean hasOverloads;
            boolean isOverload = function.getBlock() == null && TypeScriptOverloadsMixin.getNextOverloadFunction(function) != null;
            boolean bl = hasOverloads = !TypeScriptOverloadsMixin.getOverloadDeclarationsImpl(function, true).isEmpty();
            if (isOverload) {
                return CachedValueProvider.Result.create((Object)((Object)(hasOverloads ? State.IS_OVERLOAD_AND_HAS_OVERLOADS : State.IS_OVERLOAD)), (Object[])new Object[]{function});
            }
            if (function.getBlock() != null && hasOverloads) {
                return CachedValueProvider.Result.create((Object)((Object)State.IS_OVERLOAD_IMPLEMENTATION), (Object[])new Object[]{function});
            }
            if (hasOverloads) {
                return CachedValueProvider.Result.create((Object)((Object)State.HAS_OVERLOADS), (Object[])new Object[]{function});
            }
            return CachedValueProvider.Result.create((Object)((Object)State.IS_NOT_OVERLOAD), (Object[])new Object[]{function});
        }));
    }

    public static List<TypeScriptFunction> getOverloadDeclarationsImpl(@NotNull TypeScriptOverloadsMixin function, boolean firstOnly) {
        if (function == null) {
            TypeScriptOverloadsMixin.$$$reportNull$$$0(4);
        }
        String name = function.getName();
        TypeScriptOverloadsMixin prevSibling = function.doGetPrevOverloadCandidate();
        if (prevSibling != null) {
            SmartList result2 = new SmartList();
            while (prevSibling != null && StringUtil.equals((CharSequence)name, (CharSequence)prevSibling.getName()) && prevSibling.isOverloadDeclaration()) {
                result2.add(0, prevSibling);
                if (firstOnly) {
                    return result2;
                }
                prevSibling = prevSibling.doGetPrevOverloadCandidate();
            }
            return result2;
        }
        return ContainerUtil.emptyList();
    }

    @Nullable
    public static JSSourceElement getSourceElementStubSafely(@NotNull PsiElement source, boolean forward) {
        PsiElement result2;
        if (source == null) {
            TypeScriptOverloadsMixin.$$$reportNull$$$0(5);
        }
        PsiElement psiElement = result2 = forward ? JSStubBasedPsiTreeUtil.getNextSibling(source) : JSStubBasedPsiTreeUtil.getPrevSibling(source);
        while (result2 != null && !(result2 instanceof JSSourceElement)) {
            result2 = forward ? JSStubBasedPsiTreeUtil.getNextSibling(result2) : JSStubBasedPsiTreeUtil.getPrevSibling(result2);
        }
        return result2 != null ? (JSSourceElement)result2 : null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/ecma6/impl/TypeScriptOverloadsMixin";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getOverloadDeclarations";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/ecma6/impl/TypeScriptOverloadsMixin";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getNextOverloadFunction";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "calcOverloadState";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getOverloadDeclarationsImpl";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getSourceElementStubSafely";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static enum State {
        IS_NOT_OVERLOAD,
        IS_OVERLOAD,
        IS_OVERLOAD_AND_HAS_OVERLOADS,
        IS_OVERLOAD_IMPLEMENTATION,
        HAS_OVERLOADS;

    }
}

