/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.impl;

import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSEmbeddedContent;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.impl.JSElementIterator;
import com.intellij.lang.javascript.psi.util.ControlFlowUtils;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.EmptyIterable;
import java.util.Iterator;
import org.jetbrains.annotations.NotNull;

public class FindReferenceUtil {
    private FindReferenceUtil() {
    }

    public static Iterable<PsiElement> getReferencesAfter(@NotNull JSVariable variable, int textOffset) {
        if (variable == null) {
            FindReferenceUtil.$$$reportNull$$$0(0);
        }
        return FindReferenceUtil.getReferences(variable, textOffset);
    }

    private static Iterable<PsiElement> getReferences(final @NotNull JSVariable variable, final int minTextOffset) {
        JSElement iteratedScope;
        if (variable == null) {
            FindReferenceUtil.$$$reportNull$$$0(1);
        }
        if ((iteratedScope = (JSElement)ObjectUtils.tryCast((Object)PsiTreeUtil.findFirstParent((PsiElement)variable, element -> JSUtils.isScopeOwner(element) || element instanceof JSFile || element instanceof JSEmbeddedContent), JSElement.class)) == null) {
            return EmptyIterable.getInstance();
        }
        return new Iterable<PsiElement>(){

            @Override
            public Iterator<PsiElement> iterator() {
                return new JSReferenceIterator(variable, minTextOffset, Integer.MAX_VALUE, iteratedScope);
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "variable";
        objectArray2[1] = "com/intellij/lang/javascript/psi/impl/FindReferenceUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getReferencesAfter";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getReferences";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static final class JSReferenceIterator
    extends JSElementIterator {
        private final JSVariable variable;
        private final String variableName;

        public JSReferenceIterator(@NotNull JSVariable variable, int minTextOffset, int maxTextOffset, @NotNull JSElement scope) {
            if (variable == null) {
                JSReferenceIterator.$$$reportNull$$$0(0);
            }
            if (scope == null) {
                JSReferenceIterator.$$$reportNull$$$0(1);
            }
            super(scope, false, minTextOffset, maxTextOffset);
            this.variable = variable;
            this.variableName = variable.getName();
        }

        @Override
        public boolean visitElement(PsiElement element) {
            if (!element.getText().equals(this.variableName) || !(element instanceof JSReferenceExpression)) {
                return false;
            }
            JSVariable referent = ControlFlowUtils.resolveVariable((JSExpression)((JSReferenceExpression)element));
            return referent != null && this.variable.equals(referent);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "variable";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "scope";
                    break;
                }
            }
            objectArray[1] = "com/intellij/lang/javascript/psi/impl/FindReferenceUtil$JSReferenceIterator";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

