/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.resolve;

import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.resolve.JSEvaluateContext;
import com.intellij.lang.javascript.psi.resolve.JSGenericTypesEvaluator;
import com.intellij.lang.javascript.psi.resolve.JSTypeEvaluator;
import com.intellij.lang.javascript.psi.resolve.JSTypeProcessor;
import com.intellij.lang.javascript.psi.resolve.context.JSApplyContextElement;
import com.intellij.lang.javascript.psi.resolve.context.JSApplyContextUtil;
import com.intellij.lang.javascript.psi.stubs.TypeScriptMergedTypeImplicitElement;
import com.intellij.lang.javascript.psi.types.JSCompositeTypeImpl;
import com.intellij.lang.javascript.psi.types.JSEvaluableType;
import com.intellij.lang.javascript.psi.types.JSFreshObjectLiteralType;
import com.intellij.lang.javascript.psi.types.guard.JSTypeGuardChecker;
import com.intellij.lang.javascript.psi.types.guard.JavaScriptTypeGuard;
import com.intellij.lang.typescript.resolve.TypeScriptGenericTypesEvaluator;
import com.intellij.psi.PsiElement;
import com.intellij.util.ObjectUtils;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSTypeEvaluationHelper {
    public static final JSTypeEvaluationHelper DEFAULT = new JSTypeEvaluationHelper();

    public JSGenericTypesEvaluator getGenericTypeEvaluator() {
        return TypeScriptGenericTypesEvaluator.getInstance();
    }

    public void applyContextAndProcess(@NotNull JSType type, @NotNull JSEvaluateContext context, @Nullable PsiElement source, @NotNull JSTypeProcessor processor) {
        if (type == null) {
            JSTypeEvaluationHelper.$$$reportNull$$$0(0);
        }
        if (context == null) {
            JSTypeEvaluationHelper.$$$reportNull$$$0(1);
        }
        if (processor == null) {
            JSTypeEvaluationHelper.$$$reportNull$$$0(2);
        }
        if (type instanceof JSEvaluableType) {
            type = type.substitute();
        }
        if (!context.isJSElementsToApplyEmpty()) {
            JSApplyContextElement pop = context.popJSElementToApply();
            JSType resultType = JSApplyContextUtil.applyContextElementToType(type, pop);
            if (resultType != null) {
                resultType = this.getGuardedTypeByEvaluateContext(resultType, context, source);
                this.applyContextAndProcess(resultType, context, source, processor);
            }
            context.pushJSElementToApply(pop);
            return;
        }
        type = this.getGenericTypeEvaluator().evaluateGenerics(type, (JSExpression)context.getProcessedExpression(), null);
        if (context.isTypeGuessed() && type.getSource().isStrict()) {
            type = JSTypeUtils.copyWithStrictRecursive(type, false);
        }
        if ((type = JSCompositeTypeImpl.optimizeTypeForSubstitute(type, (PsiElement)context.getProcessedExpression())) instanceof JSFreshObjectLiteralType && context.getSource() instanceof JSVariable) {
            type = ((JSFreshObjectLiteralType)type).removeFreshness();
        }
        processor.process(type, context, source);
    }

    @Nullable
    @Contract(value="!null,_,_ -> !null")
    protected JSType getGuardedTypeByEvaluateContext(@Nullable JSType type, @NotNull JSEvaluateContext context, @Nullable PsiElement source) {
        PsiElement resolvedElement;
        if (context == null) {
            JSTypeEvaluationHelper.$$$reportNull$$$0(3);
        }
        if ((resolvedElement = context.getSource()) == null && source != null && source != JSTypeEvaluator.EXPLICIT_TYPE_MARKER_ELEMENT && source.isValid()) {
            resolvedElement = source;
        }
        return this.getGuardedTypeByEvaluateContext(type, context, resolvedElement, context.getProcessedExpression());
    }

    @Nullable
    @Contract(value="!null,_,_,_ -> !null")
    protected JSType getGuardedTypeByEvaluateContext(@Nullable JSType type, @NotNull JSEvaluateContext context, @Nullable PsiElement resolvedElement, @Nullable JSReferenceExpression processedExpression) {
        if (context == null) {
            JSTypeEvaluationHelper.$$$reportNull$$$0(4);
        }
        if (resolvedElement != null && processedExpression != null && this.shouldGetTypeFromTypeGuard(context) && context.isJSElementsToApplyEmpty()) {
            JSType guardType;
            PsiElement namedCandidate = resolvedElement;
            if (resolvedElement instanceof TypeScriptMergedTypeImplicitElement) {
                namedCandidate = (PsiElement)ObjectUtils.chooseNotNull((Object)((TypeScriptMergedTypeImplicitElement)resolvedElement).getExplicitElement(), (Object)resolvedElement);
            }
            return (guardType = this.getTypeFromTypeGuard(namedCandidate, processedExpression, type, resolvedElement)) == null ? type : guardType;
        }
        return type;
    }

    protected boolean shouldGetTypeFromTypeGuard(@NotNull JSEvaluateContext context) {
        if (context == null) {
            JSTypeEvaluationHelper.$$$reportNull$$$0(5);
        }
        return context.isAstAccessAllowed();
    }

    @Nullable
    public JSType getTypeFromTypeGuard(@NotNull PsiElement namedElement, @Nullable JSReferenceExpression expression, @Nullable JSType preprocessedType, @Nullable PsiElement resolvedElement) {
        if (namedElement == null) {
            JSTypeEvaluationHelper.$$$reportNull$$$0(6);
        }
        if (expression != null && JSTypeGuardChecker.isAvailable((PsiElement)expression, namedElement)) {
            return this.createGuard(expression, preprocessedType, resolvedElement).getNarrowedType();
        }
        return preprocessedType;
    }

    @NotNull
    protected JSTypeGuardChecker createGuard(@NotNull JSReferenceExpression reference, @Nullable JSType startType, @Nullable PsiElement resolveElement) {
        if (reference == null) {
            JSTypeEvaluationHelper.$$$reportNull$$$0(7);
        }
        JSTypeGuardChecker jSTypeGuardChecker = new JSTypeGuardChecker(reference, startType, false, JavaScriptTypeGuard.useAutoVariableType(reference, resolveElement), false);
        if (jSTypeGuardChecker == null) {
            JSTypeEvaluationHelper.$$$reportNull$$$0(8);
        }
        return jSTypeGuardChecker;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namedElement";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/resolve/JSTypeEvaluationHelper";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/resolve/JSTypeEvaluationHelper";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "createGuard";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "applyContextAndProcess";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getGuardedTypeByEvaluateContext";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "shouldGetTypeFromTypeGuard";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getTypeFromTypeGuard";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createGuard";
                break;
            }
            case 8: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

