/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.resolve;

import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionUtil;
import com.intellij.codeInsight.completion.PrefixMatcher;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.lang.javascript.completion.JSCompletionUtil;
import com.intellij.lang.javascript.completion.JSLookupPriority;
import com.intellij.lang.javascript.completion.JSLookupUtilImpl;
import com.intellij.lang.javascript.completion.JSVariantsProcessorMerger;
import com.intellij.lang.javascript.dialects.JSDialectSpecificHandlersFactory;
import com.intellij.lang.javascript.frameworks.commonjs.CommonJSUtil;
import com.intellij.lang.javascript.index.JSSymbolUtil;
import com.intellij.lang.javascript.psi.JSArgumentList;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSDestructuringProperty;
import com.intellij.lang.javascript.psi.JSExecutionScope;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSNamespace;
import com.intellij.lang.javascript.psi.JSObjectLiteralExpression;
import com.intellij.lang.javascript.psi.JSParameterItem;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSPsiElementBase;
import com.intellij.lang.javascript.psi.JSQualifiedName;
import com.intellij.lang.javascript.psi.JSQualifiedNameImpl;
import com.intellij.lang.javascript.psi.JSRecordType;
import com.intellij.lang.javascript.psi.JSRecursiveElementVisitor;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSThisExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.JSWithStatement;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptInterface;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeMember;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSSuperExpression;
import com.intellij.lang.javascript.psi.jsdoc.JSDocComment;
import com.intellij.lang.javascript.psi.jsdoc.JSDocTagValue;
import com.intellij.lang.javascript.psi.resolve.BaseJSSymbolProcessor;
import com.intellij.lang.javascript.psi.resolve.JSCompletionPlaceFilter;
import com.intellij.lang.javascript.psi.resolve.JSCompletionProcessor;
import com.intellij.lang.javascript.psi.resolve.JSContextResolver;
import com.intellij.lang.javascript.psi.resolve.JSEvaluateContext;
import com.intellij.lang.javascript.psi.resolve.JSEvaluationResultContext;
import com.intellij.lang.javascript.psi.resolve.JSGenericTypesEvaluatorBase;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.resolve.JSTypeEvaluator;
import com.intellij.lang.javascript.psi.resolve.JSTypeInfo;
import com.intellij.lang.javascript.psi.resolve.JSVariantRecordTypeConverter;
import com.intellij.lang.javascript.psi.resolve.accessibility.JSPropertyAccessorChecker;
import com.intellij.lang.javascript.psi.stubs.JSImplicitElement;
import com.intellij.lang.javascript.psi.types.JSContext;
import com.intellij.lang.javascript.psi.types.JSNamedType;
import com.intellij.lang.javascript.psi.types.JSNamedTypeFactory;
import com.intellij.lang.javascript.psi.types.JSTypeSubstitutor;
import com.intellij.lang.javascript.psi.types.JSTypeWithOuterGenerics;
import com.intellij.lang.javascript.psi.util.JSStubBasedPsiTreeUtil;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.lang.javascript.refactoring.JSNamesValidation;
import com.intellij.lang.javascript.refactoring.JSVisibilityUtil;
import com.intellij.lang.javascript.settings.JSApplicationSettings;
import com.intellij.lang.javascript.validation.fixes.TypeScriptImplementMemberUtil;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiQualifiedReference;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.QualifiedName;
import com.intellij.util.Processor;
import com.intellij.util.ThreeState;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VariantsProcessor
extends BaseJSSymbolProcessor
implements JSCompletionProcessor {
    private final Set<JSQualifiedName> myNeighbourReferences;
    private final Set<String> myPopulatedResultsNames;
    private final boolean hasSomeSmartnessAvailable;
    private final boolean myProcessOnlyProperties;
    private final boolean myProcessOnlyTypes;
    private final JSCompletionPlaceFilter myPlaceFilter;
    @Nullable
    private final String myReferencedParameterName;
    @Nullable
    private final PsiElement myOriginalElement;
    private final boolean myContextIsPropertyOfConstructorParameter;
    private final PrefixMatcher myPrefixMatcher;
    @NotNull
    private final JSVariantsProcessorMerger myVariantsProcessorMerger;

    public VariantsProcessor(@NotNull PsiFile targetFile, @NotNull PsiElement context, boolean forcedOnlyTypeBased, @NotNull CompletionParameters parameters, @NotNull CompletionResultSet resultSet) {
        if (targetFile == null) {
            VariantsProcessor.$$$reportNull$$$0(0);
        }
        if (context == null) {
            VariantsProcessor.$$$reportNull$$$0(1);
        }
        if (parameters == null) {
            VariantsProcessor.$$$reportNull$$$0(2);
        }
        if (resultSet == null) {
            VariantsProcessor.$$$reportNull$$$0(3);
        }
        super(targetFile.getOriginalFile(), context);
        this.myNeighbourReferences = new THashSet();
        this.myPopulatedResultsNames = new THashSet();
        this.myContextIsPropertyOfConstructorParameter = VariantsProcessor.initContextIsPropertyOfConstructorParameter(context);
        this.myPrefixMatcher = resultSet.getPrefixMatcher();
        int limit = JSCompletionUtil.getCompletionLimit();
        boolean isExtendedCompletion = parameters.isExtendedCompletion();
        this.myVariantsProcessorMerger = new JSVariantsProcessorMerger(context, (element, priority) -> {
            if (!JSLookupUtilImpl.willCreateLookupElement(priority)) {
                return false;
            }
            return JSLookupUtilImpl.matchElementWithContext(element, this.myContext);
        }, limit, !isExtendedCompletion);
        boolean processOnlyTypes = false;
        this.myCurrentFile = targetFile.getOriginalFile() == targetFile ? null : targetFile.getOriginalFile().getVirtualFile();
        JSClass jsClass = (JSClass)PsiTreeUtil.getParentOfType((PsiElement)context, JSClass.class);
        if (forcedOnlyTypeBased || JSApplicationSettings.getInstance().isOnlyTypeBasedCompletion() && !isExtendedCompletion) {
            this.forceSetAddOnlyCompleteMatches();
        }
        String referencedParameterName = null;
        if (context instanceof JSReferenceExpression) {
            JSExpression qualifier;
            JSParameterItem parameter;
            JSReferenceExpression refExpr = (JSReferenceExpression)context;
            PsiElement parent = refExpr.getParent();
            if (parent instanceof JSArgumentList && (parameter = JSResolveUtil.findParameterForUsedArgument((JSExpression)refExpr, (JSArgumentList)parent)) != null) {
                referencedParameterName = parameter.getName();
            }
            if ((qualifier = refExpr.getQualifier()) != null) {
                if (qualifier instanceof JSThisExpression || qualifier instanceof JSSuperExpression) {
                    if (qualifier instanceof JSThisExpression) {
                        JSNamespace ns = JSContextResolver.resolveContext((PsiElement)qualifier);
                        this.updateTypeInfoFromThis(ns);
                    }
                    if (jsClass != null) {
                        this.forceSetAddOnlyCompleteMatches();
                        this.updateCanUseOnlyCompleteMatches(jsClass);
                    } else if (JSResolveUtil.getTypeFromTagNameInMxml(this.myTargetFile.getContext()) != null) {
                        this.forceSetAddOnlyCompleteMatches();
                    }
                }
                JSExpression originalQualifier = VariantsProcessor.getOriginalQualifier(qualifier);
                CompletionTypeProcessor processor = new CompletionTypeProcessor((PsiElement)originalQualifier);
                processor.evaluateQualifier(qualifier, originalQualifier);
                if (processor.isStrictlyTyped()) {
                    this.forceSetAddOnlyCompleteMatches();
                }
            } else if (JSResolveUtil.isExprInTypeContext(refExpr) || this.ecmal4 && JSResolveUtil.isInPlaceWhereTypeCanBeDuringCompletion((PsiElement)refExpr)) {
                this.forceSetAddOnlyCompleteMatches();
                processOnlyTypes = true;
                this.addPackageScope(jsClass, (PsiElement)refExpr);
            } else if (PsiTreeUtil.getParentOfType((PsiElement)context, JSWithStatement.class) == null) {
                this.forceSetAddOnlyCompleteMatches();
            }
        } else if (context instanceof JSProperty) {
            String qName;
            JSObjectLiteralExpression objLiteral = (JSObjectLiteralExpression)context.getParent();
            JSType expectedType = TypeScriptImplementMemberUtil.filterExpectedTypeForImplement(JSDialectSpecificHandlersFactory.findExpectedType((JSExpression)objLiteral));
            JSRecordType recordType = JSVariantRecordTypeConverter.getTypeAsRecord(expectedType, context);
            if (recordType != null) {
                this.myTypeInfo.addRecordType(recordType);
                this.forceSetAddOnlyCompleteMatches();
            } else if (expectedType instanceof JSNamedType && (qName = JSTypeUtils.getQualifiedNameMatchingType(expectedType, true)) != null) {
                this.myTypeInfo.addType((JSNamedType)expectedType, true);
            }
            JSNamespace guessedNs = VariantsProcessor.guessNamespaceFromProperty((JSProperty)context);
            if (guessedNs != null) {
                this.addTypeHierarchy(guessedNs);
            }
        } else if (context instanceof JSDocTagValue) {
            processOnlyTypes = true;
        } else if (context instanceof JSDestructuringProperty) {
            PsiElement parent = context.getParent();
            JSTypeEvaluator.evaluateExpressionOrElementTypes(this.myTargetFile, new CompletionTypeProcessor(parent), parent);
        }
        this.myProcessOnlyTypes = processOnlyTypes;
        this.myPlaceFilter = JSCompletionPlaceFilter.forPlace(context);
        boolean bl = this.myProcessOnlyProperties = context instanceof JSProperty && !this.myContextIsPropertyOfConstructorParameter || context instanceof JSDestructuringProperty;
        if (this.myTypeInfo.typeWasProcessed() && !this.myContextIsPropertyOfConstructorParameter && !this.myProcessOnlyProperties && !this.myTypeInfo.isGlobalContext()) {
            this.myTypeInfo.addBaseObjectType();
        }
        this.hasSomeSmartnessAvailable = this.myTypeInfo.hasExplicitNamespace();
        this.myOriginalElement = CompletionUtil.getOriginalElement((PsiElement)context);
        this.myReferencedParameterName = referencedParameterName;
        this.initCheckFileLevelAccess();
    }

    private static boolean initContextIsPropertyOfConstructorParameter(PsiElement context) {
        if (!(context instanceof JSProperty)) {
            return false;
        }
        PsiElement argList = context.getParent().getParent();
        if (!(argList instanceof JSArgumentList)) {
            return false;
        }
        PsiElement callExpr = argList.getParent();
        if (!(callExpr instanceof JSCallExpression)) {
            return false;
        }
        JSExpression methodExpression = ((JSCallExpression)callExpr).getMethodExpression();
        return methodExpression instanceof JSReferenceExpression;
    }

    @Override
    @NotNull
    protected JSTypeInfo createTypeInfo(@NotNull JSTypeInfo.GlobalStatusHint globalStatusHint) {
        if (globalStatusHint == null) {
            VariantsProcessor.$$$reportNull$$$0(4);
        }
        JSTypeInfo jSTypeInfo = new JSTypeInfo(globalStatusHint){

            @Override
            public void addNamespace(@NotNull JSNamespace namespace, boolean isTopClassInHierarchy) {
                if (namespace == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (VariantsProcessor.this.myContextIsPropertyOfConstructorParameter) {
                    JSParameterItem matchedParameter;
                    PsiElement grandParent;
                    JSQualifiedName qualifiedName = namespace.getQualifiedName();
                    qualifiedName = JSQualifiedNameImpl.create("options", qualifiedName);
                    namespace = JSNamedTypeFactory.createNamespace(qualifiedName, namespace.getJSContext(), VariantsProcessor.this.myContext, namespace.isSourceStrict());
                    PsiElement parent = VariantsProcessor.this.myContext.getParent();
                    if (parent instanceof JSExpression && (grandParent = parent.getParent()) instanceof JSArgumentList && (matchedParameter = JSResolveUtil.findParameterForUsedArgument((JSExpression)parent, (JSArgumentList)grandParent)) != null && matchedParameter.getName() != null) {
                        qualifiedName = JSQualifiedNameImpl.create(matchedParameter.getName(), qualifiedName);
                        JSNamespace paramNs = JSNamedTypeFactory.createNamespace(qualifiedName, namespace.getJSContext(), matchedParameter instanceof PsiElement ? (PsiElement)matchedParameter : null, namespace.isSourceStrict());
                        super.addNamespace(paramNs, isTopClassInHierarchy);
                    }
                }
                super.addNamespace(namespace, isTopClassInHierarchy);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "namespace", "com/intellij/lang/javascript/psi/resolve/VariantsProcessor$1", "addNamespace"));
            }
        };
        if (jSTypeInfo == null) {
            VariantsProcessor.$$$reportNull$$$0(5);
        }
        return jSTypeInfo;
    }

    private void updateCanUseOnlyCompleteMatches(JSClass jsClass) {
        JSAttributeList attributeList;
        JSAttributeList jSAttributeList = attributeList = jsClass != null ? jsClass.getAttributeList() : null;
        if (attributeList != null && attributeList.hasModifier(JSAttributeList.ModifierType.DYNAMIC)) {
            this.allowPartialResults();
        }
    }

    public void addPushedVariants(@NotNull Set<String> pushedVariants) {
        if (pushedVariants == null) {
            VariantsProcessor.$$$reportNull$$$0(6);
        }
        this.myPopulatedResultsNames.addAll(pushedVariants);
    }

    public void populateCompletionList(Collection<? extends LookupElement> resultsAsObjects, boolean keepOverloads, @NotNull CompletionResultSet resultSet) {
        if (resultSet == null) {
            VariantsProcessor.$$$reportNull$$$0(7);
        }
        if (resultsAsObjects == null) {
            return;
        }
        Set<Object> visited = keepOverloads ? new HashSet() : this.myPopulatedResultsNames;
        for (LookupElement lookupElement : resultsAsObjects) {
            String text = lookupElement.getLookupString();
            if (this.myPopulatedResultsNames.contains(text)) continue;
            visited.add(text);
            resultSet.addElement(lookupElement);
        }
        if (keepOverloads) {
            this.myPopulatedResultsNames.addAll(visited);
        }
    }

    public void collectReferencesUsedInCurrentScope(final PsiElement reference, final boolean qualified) {
        JSExecutionScope scope = (JSExecutionScope)PsiTreeUtil.getParentOfType((PsiElement)reference, JSExecutionScope.class);
        assert (scope != null) : reference.getContainingFile().getName();
        new JSRecursiveElementVisitor(){

            public void visitJSReferenceExpression(JSReferenceExpression node) {
                JSQualifiedName name;
                if (node != reference && node.getQualifier() != null == qualified && (name = JSSymbolUtil.getAccurateReferenceName((PsiQualifiedReference)node)) != null) {
                    VariantsProcessor.this.myNeighbourReferences.add(name);
                }
                super.visitJSReferenceExpression(node);
            }

            public void visitJSFunctionDeclaration(@NotNull JSFunction node) {
                if (node == null) {
                    2.$$$reportNull$$$0(0);
                }
            }

            public void visitJSFunctionExpression(@NotNull JSFunctionExpression node) {
                if (node == null) {
                    2.$$$reportNull$$$0(1);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "node";
                objectArray2[1] = "com/intellij/lang/javascript/psi/resolve/VariantsProcessor$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitJSFunctionDeclaration";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitJSFunctionExpression";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }.visitElement((PsiElement)scope);
    }

    @Override
    protected boolean isStrictTypingPossible(PsiElement source, @NotNull JSType type) {
        if (type == null) {
            VariantsProcessor.$$$reportNull$$$0(8);
        }
        if (type.getSource().isStrict()) {
            source = JSTypeEvaluator.EXPLICIT_TYPE_MARKER_ELEMENT;
        }
        return super.isStrictTypingPossible(source, type);
    }

    @Override
    @NotNull
    protected List<JSNamespace> addGenericArgumentsForParentClasses(@NotNull JSNamespace namespace, @NotNull List<JSNamespace> parentClasses) {
        JSTypeSubstitutor genericArguments;
        if (namespace == null) {
            VariantsProcessor.$$$reportNull$$$0(9);
        }
        if (parentClasses == null) {
            VariantsProcessor.$$$reportNull$$$0(10);
        }
        if ((genericArguments = JSTypeWithOuterGenerics.getGenericArguments(namespace)) == null || genericArguments.isEmpty()) {
            List<JSNamespace> list2 = parentClasses;
            if (list2 == null) {
                VariantsProcessor.$$$reportNull$$$0(11);
            }
            return list2;
        }
        List list3 = ContainerUtil.map(parentClasses, parentClass -> {
            JSQualifiedName parentClassQName = parentClass.getQualifiedName();
            assert (parentClassQName != null);
            JSQualifiedName namespaceQName = namespace.getQualifiedName();
            assert (namespaceQName != null);
            JSTypeSubstitutor parentClassTypeSubstitutor = JSGenericTypesEvaluatorBase.applyTypeSubstitutorUpToParentClass(namespaceQName.getQualifiedName(), parentClassQName.getQualifiedName(), this.myContext, genericArguments);
            return new JSTypeWithOuterGenerics((JSType)parentClass, parentClassTypeSubstitutor);
        });
        if (list3 == null) {
            VariantsProcessor.$$$reportNull$$$0(12);
        }
        return list3;
    }

    public void addNeighbourReferences(boolean onlyApplyPriority) {
        for (JSQualifiedName neighbourReference : this.myNeighbourReferences) {
            if (!this.myTypeInfo.hasMatchedNamespace(neighbourReference.getParent(), JSContext.STATIC)) continue;
            this.myVariantsProcessorMerger.addNeighbourReference(neighbourReference, onlyApplyPriority);
        }
    }

    @NotNull
    public Collection<LookupElement> getCurrentResults() {
        this.postProcessElements(true);
        List<LookupElement> list2 = this.myVariantsProcessorMerger.values();
        if (list2 == null) {
            VariantsProcessor.$$$reportNull$$$0(13);
        }
        return list2;
    }

    public void postProcessElements(boolean onlyApplyPriority) {
        this.addNeighbourReferences(onlyApplyPriority);
    }

    @NotNull
    public Collection<LookupElement> getFinalResults() {
        this.addElementsFromRecordTypes();
        this.postProcessElements(false);
        List<LookupElement> list2 = this.myVariantsProcessorMerger.values();
        if (list2 == null) {
            VariantsProcessor.$$$reportNull$$$0(14);
        }
        return list2;
    }

    private void addElementsFromRecordTypes() {
        if (this.myTypeInfo.getRecordTypes().isEmpty()) {
            return;
        }
        for (JSRecordType recordType : this.myTypeInfo.getRecordTypes()) {
            this.myVariantsProcessorMerger.addRecordTypeElements(recordType, this.myTargetFile, this.myContext);
        }
    }

    @Override
    public String getRequiredName() {
        return null;
    }

    @Override
    public boolean doAdd(@NotNull JSPsiElementBase element) {
        if (element == null) {
            VariantsProcessor.$$$reportNull$$$0(15);
        }
        return this.doAdd(element, null);
    }

    public boolean doAdd(@NotNull JSPsiElementBase element, @Nullable JSTypeSubstitutor typeSubstitutor) {
        JSDocComment comment;
        if (element == null) {
            VariantsProcessor.$$$reportNull$$$0(16);
        }
        ProgressManager.checkCanceled();
        String name = element.getName();
        if (!(name != null && JSNamesValidation.isUnqualifiedType(name) && this.myPrefixMatcher.prefixMatches(name) && this.myPlaceFilter.isAcceptable(element))) {
            return true;
        }
        JSAttributeList.AccessType accessType = element.getAccessType();
        if (this.isOriginalElement(element)) {
            return true;
        }
        if (this.myPopulatedResultsNames.contains(name)) {
            return true;
        }
        if (this.isAcceptable(element) != null) {
            return true;
        }
        if (JSPropertyAccessorChecker.getPropertyAccessError(this.myOriginalElement, (PsiElement)element, true) != null) {
            return true;
        }
        boolean isClassMember = element.getContext() instanceof JSClass;
        if (isClassMember && JSResolveUtil.isConstructorFunction((PsiElement)element)) {
            return true;
        }
        if (element instanceof JSProperty && (comment = JSStubBasedPsiTreeUtil.findDocComment((PsiElement)element)) != null && comment.hasConstructsTag()) {
            return true;
        }
        if (isClassMember && accessType == JSAttributeList.AccessType.PRIVATE) {
            return true;
        }
        if (this.myProcessOnlyProperties && !this.isPropertyCandidate(element)) {
            return true;
        }
        Ref typeHierarchyLevel = new Ref((Object)-1);
        Ref isAccessible = Ref.create((Object)true);
        BaseJSSymbolProcessor.MatchType matchType = this.calcMatchType(element, accessType, (Ref<Integer>)typeHierarchyLevel, (Ref<Boolean>)isAccessible);
        if (element instanceof JSClass && !((Boolean)isAccessible.get()).booleanValue()) {
            return true;
        }
        if (matchType == BaseJSSymbolProcessor.MatchType.PARTIAL || !((Boolean)isAccessible.get()).booleanValue() && VariantsProcessor.isCompleteOrWithContextMatchType(matchType)) {
            if (this.myPrivateSharpFieldAccess || !JSUtils.isPrivateSharpItem((PsiElement)element)) {
                return this.addPartialMatch((PsiElement)element, name);
            }
        } else if (VariantsProcessor.isCompleteOrWithContextMatchType(matchType)) {
            return this.addCompleteMatch((PsiElement)element, name, matchType, (Integer)typeHierarchyLevel.get(), typeSubstitutor);
        }
        return true;
    }

    protected boolean isOriginalElement(@NotNull JSPsiElementBase element) {
        PsiElement parent;
        if (element == null) {
            VariantsProcessor.$$$reportNull$$$0(17);
        }
        if (element.isEquivalentTo(this.myOriginalElement)) {
            return true;
        }
        return this.myOriginalElement instanceof JSReferenceExpression && (parent = this.myOriginalElement.getParent()) instanceof JSDefinitionExpression && element.isEquivalentTo(parent);
    }

    public boolean isPropertyCandidate(@NotNull JSPsiElementBase element) {
        if (element == null) {
            VariantsProcessor.$$$reportNull$$$0(18);
        }
        if (element instanceof JSImplicitElement && ((JSImplicitElement)element).getType() == JSImplicitElement.Type.Property) {
            return true;
        }
        if (element instanceof JSDefinitionExpression) {
            return true;
        }
        return element instanceof JSProperty || element instanceof TypeScriptTypeMember && JSUtils.getMemberContainingClass((PsiElement)element) instanceof TypeScriptInterface;
    }

    @NotNull
    private BaseJSSymbolProcessor.MatchType calcMatchType(@NotNull JSPsiElementBase element, @NotNull JSAttributeList.AccessType accessType, @NotNull Ref<Integer> typeHierarchyLevel, @NotNull Ref<Boolean> isAccessible) {
        if (element == null) {
            VariantsProcessor.$$$reportNull$$$0(19);
        }
        if (accessType == null) {
            VariantsProcessor.$$$reportNull$$$0(20);
        }
        if (typeHierarchyLevel == null) {
            VariantsProcessor.$$$reportNull$$$0(21);
        }
        if (isAccessible == null) {
            VariantsProcessor.$$$reportNull$$$0(22);
        }
        BaseJSSymbolProcessor.MatchType matchType = this.isAcceptableQualifiedItem(element, typeHierarchyLevel, isAccessible);
        if (accessType == JSAttributeList.AccessType.PRIVATE && this.myProcessOnlyTypes) {
            matchType = BaseJSSymbolProcessor.MatchType.PARTIAL;
        }
        if (VariantsProcessor.isCompleteOrWithContextMatchType(matchType) && this.myPlaceFilter.isPartialResult(element)) {
            matchType = BaseJSSymbolProcessor.MatchType.PARTIAL;
        }
        if (matchType == BaseJSSymbolProcessor.MatchType.COMPLETE && (Integer)typeHierarchyLevel.get() > 0 && !((Boolean)isAccessible.get()).booleanValue()) {
            matchType = BaseJSSymbolProcessor.MatchType.PARTIAL;
        }
        BaseJSSymbolProcessor.MatchType matchType2 = matchType;
        if (matchType2 == null) {
            VariantsProcessor.$$$reportNull$$$0(23);
        }
        return matchType2;
    }

    @Override
    @NotNull
    protected JSAttributeList.AccessType getElementAccessType(@NotNull JSPsiElementBase element) {
        boolean seemsToBePrivateSymbol;
        if (element == null) {
            VariantsProcessor.$$$reportNull$$$0(24);
        }
        if ((seemsToBePrivateSymbol = JSVisibilityUtil.seemsToBePrivateSymbol(element.getName())) && element.getAccessType() == JSAttributeList.AccessType.PACKAGE_LOCAL) {
            JSAttributeList.AccessType accessType = JSAttributeList.AccessType.PRIVATE;
            if (accessType == null) {
                VariantsProcessor.$$$reportNull$$$0(25);
            }
            return accessType;
        }
        JSAttributeList.AccessType accessType = super.getElementAccessType(element);
        if (accessType == null) {
            VariantsProcessor.$$$reportNull$$$0(26);
        }
        return accessType;
    }

    @Nullable
    private static JSNamespace guessNamespaceFromProperty(@NotNull JSProperty element) {
        JSExpression methodExpr;
        PsiElement grandGrandParent;
        PsiElement grandParent;
        if (element == null) {
            VariantsProcessor.$$$reportNull$$$0(27);
        }
        if ((grandParent = element.getParent().getParent()) instanceof JSArgumentList && (grandGrandParent = grandParent.getParent()) instanceof JSCallExpression && (methodExpr = ((JSCallExpression)grandGrandParent).getMethodExpression()) instanceof JSReferenceExpression) {
            ArrayList<String> names = new ArrayList<String>(3);
            JSExpression qualifyingExpression = JSSymbolUtil.getFirstLiteralOrExprArg((JSArgumentList)grandParent);
            String method = qualifyingExpression != null ? StringUtil.unquoteString((String)qualifyingExpression.getText()) : methodExpr.getText();
            QualifiedName qName = StringUtil.isQuotedString((String)method) ? QualifiedName.fromComponents((String[])new String[]{method}) : QualifiedName.fromDottedString((String)method);
            names.addAll(qName.getComponents());
            return JSNamedTypeFactory.createNamespace(JSQualifiedNameImpl.fromComponents(names), JSContext.UNKNOWN, (PsiElement)element, false);
        }
        return null;
    }

    private boolean addCompleteMatch(@NotNull PsiElement element, @Nullable String name, @NotNull BaseJSSymbolProcessor.MatchType matchType, int nestingLevel, @Nullable JSTypeSubstitutor typeSubstitutor) {
        if (element == null) {
            VariantsProcessor.$$$reportNull$$$0(28);
        }
        if (matchType == null) {
            VariantsProcessor.$$$reportNull$$$0(29);
        }
        if (name == null) {
            return true;
        }
        if (element instanceof JSPsiElementBase && this.myPlaceFilter.isLoweredPriority((JSPsiElementBase)element)) {
            ++nestingLevel;
        }
        JSLookupPriority priority = this.getPriority(name, matchType, nestingLevel);
        return this.myVariantsProcessorMerger.addResult(element, name, priority, matchType, typeSubstitutor);
    }

    private JSLookupPriority getPriority(@NotNull String name, @NotNull BaseJSSymbolProcessor.MatchType matchType, int nestingLevel) {
        if (name == null) {
            VariantsProcessor.$$$reportNull$$$0(30);
        }
        if (matchType == null) {
            VariantsProcessor.$$$reportNull$$$0(31);
        }
        if (this.myTypeInfo.isGlobalContext()) {
            nestingLevel += 5;
        }
        return this.myTypeInfo.isGlobalContext() && !this.myProcessOnlyTypes ? JSLookupPriority.getLookupPriority(BaseJSSymbolProcessor.MatchType.PARTIAL, false, false) : JSLookupPriority.getSameTypeValue(name.equals(this.myReferencedParameterName), matchType, nestingLevel);
    }

    private boolean addPartialMatch(@NotNull PsiElement element, @Nullable String name) {
        if (element == null) {
            VariantsProcessor.$$$reportNull$$$0(32);
        }
        if (name == null || this.addOnlyCompleteMatches()) {
            return true;
        }
        boolean fromRelevantFileOrDirectory = this.isFromRelevantFileOrDirectory();
        JSLookupPriority priority = JSLookupPriority.getLookupPriority(null, fromRelevantFileOrDirectory, this.hasSomeSmartnessAvailable);
        return this.myVariantsProcessorMerger.addResult(element, name, priority, BaseJSSymbolProcessor.MatchType.PARTIAL, null);
    }

    @Override
    @NotNull
    public PsiFile getTargetFile() {
        PsiFile psiFile = this.myTargetFile;
        if (psiFile == null) {
            VariantsProcessor.$$$reportNull$$$0(33);
        }
        return psiFile;
    }

    @Override
    @NotNull
    public PrefixMatcher getPrefixMatcher() {
        PrefixMatcher prefixMatcher = this.myPrefixMatcher;
        if (prefixMatcher == null) {
            VariantsProcessor.$$$reportNull$$$0(34);
        }
        return prefixMatcher;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 23: 
            case 25: 
            case 26: 
            case 33: 
            case 34: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 23: 
            case 25: 
            case 26: 
            case 33: 
            case 34: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetFile";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resultSet";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "globalStatusHint";
                break;
            }
            case 5: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 23: 
            case 25: 
            case 26: 
            case 33: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/resolve/VariantsProcessor";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pushedVariants";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namespace";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentClasses";
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 24: 
            case 27: 
            case 28: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "accessType";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeHierarchyLevel";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "isAccessible";
                break;
            }
            case 29: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "matchType";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/resolve/VariantsProcessor";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createTypeInfo";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "addGenericArgumentsForParentClasses";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getCurrentResults";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getFinalResults";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "calcMatchType";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getElementAccessType";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "getTargetFile";
                break;
            }
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "getPrefixMatcher";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createTypeInfo";
                break;
            }
            case 5: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 23: 
            case 25: 
            case 26: 
            case 33: 
            case 34: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "addPushedVariants";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "populateCompletionList";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isStrictTypingPossible";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "addGenericArgumentsForParentClasses";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "doAdd";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "isOriginalElement";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "isPropertyCandidate";
                break;
            }
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "calcMatchType";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getElementAccessType";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "guessNamespaceFromProperty";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "addCompleteMatch";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "getPriority";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "addPartialMatch";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 23: 
            case 25: 
            case 26: 
            case 33: 
            case 34: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class CompletionTypeProcessor
    extends BaseJSSymbolProcessor.JSTypeProcessorBase {
        private ThreeState strictlyTyped = ThreeState.UNSURE;
        @Nullable
        private final PsiElement myOriginalQualifier;

        CompletionTypeProcessor(PsiElement qualifier) {
            this.myOriginalQualifier = qualifier;
        }

        private boolean isStrictlyTyped() {
            return this.strictlyTyped != ThreeState.UNSURE && this.strictlyTyped.toBoolean();
        }

        @Override
        public void processNamespace(@NotNull JSNamespace namespace, @NotNull JSEvaluateContext context, PsiElement source) {
            if (namespace == null) {
                CompletionTypeProcessor.$$$reportNull$$$0(0);
            }
            if (context == null) {
                CompletionTypeProcessor.$$$reportNull$$$0(1);
            }
            if (context.ensureProcessed((JSType)namespace)) {
                return;
            }
            if (!JSTypeUtils.processExpandedType(this, (JSType)namespace, context, source)) {
                return;
            }
            if (namespace.getQualifiedName() == null) {
                return;
            }
            boolean isExportNamespace = CommonJSUtil.isExportNamespace(namespace);
            JSNamespace ns = JSNamedTypeFactory.createNamespace(namespace.getQualifiedName(), namespace.getJSContext(), namespace.getSource().getSourceElement(), true, true, namespace.isLocal());
            VariantsProcessor.this.addTypeHierarchy(ns);
            if (this.strictlyTyped != ThreeState.NO) {
                this.strictlyTyped = ThreeState.fromBoolean((namespace.isSourceStrict() || isExportNamespace ? 1 : 0) != 0);
            }
        }

        @Override
        public void process(@NotNull JSType type, @NotNull JSEvaluateContext evaluateContext, PsiElement source) {
            if (type == null) {
                CompletionTypeProcessor.$$$reportNull$$$0(2);
            }
            if (evaluateContext == null) {
                CompletionTypeProcessor.$$$reportNull$$$0(3);
            }
            JSTypeUtils.processExpandedType((Processor<? super JSType>)((Processor)candidate -> {
                this.processCandidate((JSType)candidate, evaluateContext, source);
                return true;
            }), type, false, true, false);
            this.processCandidate(type, evaluateContext, source);
            this.addFullQualifierAsNamespace(this.myOriginalQualifier, type);
        }

        @Override
        public void processResolvedElement(@NotNull PsiElement element, @NotNull JSEvaluationResultContext evaluateContext) {
            if (element == null) {
                CompletionTypeProcessor.$$$reportNull$$$0(4);
            }
            if (evaluateContext == null) {
                CompletionTypeProcessor.$$$reportNull$$$0(5);
            }
            if (element instanceof JSClass) {
                VariantsProcessor.this.setAddOnlyCompleteMatches();
            }
            super.processResolvedElement(element, evaluateContext);
        }

        @Override
        protected void applyTypeToState(JSType type, PsiElement source) {
            super.applyTypeToState(type, source);
            if (type instanceof JSRecordType) {
                if (type.getSource().isStrict()) {
                    VariantsProcessor.this.setAddOnlyCompleteMatches();
                }
                return;
            }
            JSNamespace namespace = JSTypeUtils.getNamespaceMatchingType(type, true);
            if (namespace == null || namespace.getQualifiedName() == null) {
                return;
            }
            if (this.strictlyTyped != ThreeState.NO) {
                this.strictlyTyped = ThreeState.fromBoolean((boolean)VariantsProcessor.this.isStrictTypingPossible(source, type));
            }
        }

        @Override
        protected boolean isMakeAddedNamespaceStrict() {
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "namespace";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
                case 3: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "evaluateContext";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/lang/javascript/psi/resolve/VariantsProcessor$CompletionTypeProcessor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "processNamespace";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "process";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "processResolvedElement";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

