/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.types.guard.operations;

import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.types.JSAnyType;
import com.intellij.lang.javascript.psi.types.JSCompositeTypeBaseImpl;
import com.intellij.lang.javascript.psi.types.JSDecoratedType;
import com.intellij.lang.javascript.psi.types.JSUnionType;
import com.intellij.lang.javascript.psi.types.guard.JSTypeFacts;
import com.intellij.lang.javascript.psi.types.guard.JSTypeGuardChecker;
import com.intellij.lang.javascript.psi.types.guard.JSTypeGuardUtil;
import com.intellij.lang.javascript.psi.types.guard.TypeScriptTypeRelations;
import com.intellij.lang.javascript.psi.types.guard.operations.JSApplyTypeOperationContext;
import com.intellij.lang.javascript.psi.types.guard.operations.JSConditionalTypeOperationBase;
import com.intellij.lang.javascript.psi.types.guard.operations.JSInferDecoratorsContext;
import com.intellij.lang.javascript.psi.types.guard.operations.JSTypeOperation;
import com.intellij.lang.javascript.psi.types.primitives.JSNullType;
import com.intellij.lang.javascript.psi.types.primitives.TypeScriptNeverJSTypeImpl;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.containers.Predicate;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public final class JSNarrowTypeByEqualityOperation
extends JSConditionalTypeOperationBase {
    @NotNull
    private final JSType myExpressionType;
    @NotNull
    private final Set<JSDecoratedType.TypeDecoration> myDecorations;
    private final boolean myDoubleEquals;

    public JSNarrowTypeByEqualityOperation(@NotNull JSTypeOperation prev, @NotNull IElementType sign, @NotNull JSExpression expression, boolean assumeTrue) {
        if (prev == null) {
            JSNarrowTypeByEqualityOperation.$$$reportNull$$$0(0);
        }
        if (sign == null) {
            JSNarrowTypeByEqualityOperation.$$$reportNull$$$0(1);
        }
        if (expression == null) {
            JSNarrowTypeByEqualityOperation.$$$reportNull$$$0(2);
        }
        super(prev, assumeTrue);
        this.myExpressionType = JSTypeGuardUtil.getOperationType(expression);
        this.myDoubleEquals = sign == JSTokenTypes.EQEQ || sign == JSTokenTypes.NE;
        this.myDecorations = JSTypeGuardChecker.getDecoratorsForNullOrUndefinedExpression(this.myDoubleEquals, expression, this.myAssumeTrue);
    }

    @Override
    @NotNull
    protected JSType applyForPrevType(@NotNull JSApplyTypeOperationContext context, @NotNull JSType type) {
        if (context == null) {
            JSNarrowTypeByEqualityOperation.$$$reportNull$$$0(3);
        }
        if (type == null) {
            JSNarrowTypeByEqualityOperation.$$$reportNull$$$0(4);
        }
        if (!(type instanceof JSUnionType) && !JSTypeGuardUtil.isUnitType(type)) {
            JSType jSType = type;
            if (jSType == null) {
                JSNarrowTypeByEqualityOperation.$$$reportNull$$$0(5);
            }
            return jSType;
        }
        JSType valueType = context.expandOperationType(this.myExpressionType);
        if (valueType == null) {
            JSType jSType = type;
            if (jSType == null) {
                JSNarrowTypeByEqualityOperation.$$$reportNull$$$0(6);
            }
            return jSType;
        }
        if (JSCompositeTypeBaseImpl.isNullOrUndefinedType(valueType)) {
            boolean valueIsNull = valueType instanceof JSNullType;
            JSTypeFacts.SimpleFact facts = this.myDoubleEquals ? (this.myAssumeTrue ? JSTypeFacts.SimpleFact.EQUndefinedOrNull : JSTypeFacts.SimpleFact.NEUndefinedOrNull) : (valueIsNull ? (this.myAssumeTrue ? JSTypeFacts.SimpleFact.EQNull : JSTypeFacts.SimpleFact.NENull) : (this.myAssumeTrue ? JSTypeFacts.SimpleFact.EQUndefined : JSTypeFacts.SimpleFact.NEUndefined));
            JSType jSType = type instanceof JSAnyType ? type : JSTypeFacts.TYPE_FACTS.getTypeWithFact(type, facts, (PsiElement)context.getContextReference(), context.strictNullChecks());
            if (jSType == null) {
                JSNarrowTypeByEqualityOperation.$$$reportNull$$$0(7);
            }
            return jSType;
        }
        if (this.myAssumeTrue) {
            JSType narrowType = TypeScriptTypeRelations.filterType(type, (Predicate<? super JSType>)((Predicate)el -> this.myDoubleEquals ? TypeScriptTypeRelations.isCoercibleUnderDoubleEquals(el, valueType) || TypeScriptTypeRelations.areTypesComparable(el, valueType, context.getProcessingContext()) : TypeScriptTypeRelations.areTypesComparable(el, valueType, context.getProcessingContext())), (PsiElement)context.getContextReference());
            JSType jSType = narrowType instanceof TypeScriptNeverJSTypeImpl ? type : JSTypeGuardUtil.replacePrimitivesWithLiterals(narrowType, valueType, (PsiElement)context.getContextReference());
            if (jSType == null) {
                JSNarrowTypeByEqualityOperation.$$$reportNull$$$0(8);
            }
            return jSType;
        }
        if (JSTypeGuardUtil.isUnitType(valueType)) {
            JSType regularType = TypeScriptTypeRelations.getRegularTypeOfLiteralType(valueType);
            JSType resultType = TypeScriptTypeRelations.filterType(type, (Predicate<? super JSType>)((Predicate)el -> {
                JSType literalType = TypeScriptTypeRelations.getRegularTypeOfLiteralType(el);
                return literalType != null && !literalType.isEquivalentTo(regularType, null, true);
            }), (PsiElement)context.getContextReference());
            JSType jSType = context.processNeverType(type, resultType);
            if (jSType == null) {
                JSNarrowTypeByEqualityOperation.$$$reportNull$$$0(9);
            }
            return jSType;
        }
        JSType jSType = type;
        if (jSType == null) {
            JSNarrowTypeByEqualityOperation.$$$reportNull$$$0(10);
        }
        return jSType;
    }

    @Override
    @NotNull
    public Set<JSDecoratedType.TypeDecoration> inferTypeDecoratorsImpl(@NotNull JSInferDecoratorsContext context) {
        if (context == null) {
            JSNarrowTypeByEqualityOperation.$$$reportNull$$$0(11);
        }
        Set<JSDecoratedType.TypeDecoration> set = this.mergeSimilarDecorators(this.myDecorations, super.inferTypeDecoratorsImpl(context));
        if (set == null) {
            JSNarrowTypeByEqualityOperation.$$$reportNull$$$0(12);
        }
        return set;
    }

    @Override
    protected boolean checkOwnEquality(@NotNull JSTypeOperation sameTypeOperation) {
        if (sameTypeOperation == null) {
            JSNarrowTypeByEqualityOperation.$$$reportNull$$$0(13);
        }
        JSNarrowTypeByEqualityOperation operation = (JSNarrowTypeByEqualityOperation)sameTypeOperation;
        return this.checkTypeEquals(this.myExpressionType, operation.myExpressionType) && this.myDoubleEquals == operation.myDoubleEquals;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prev";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sign";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 3: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/types/guard/operations/JSNarrowTypeByEqualityOperation";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sameTypeOperation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/types/guard/operations/JSNarrowTypeByEqualityOperation";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "applyForPrevType";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "inferTypeDecoratorsImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "applyForPrevType";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: {
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "inferTypeDecoratorsImpl";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "checkOwnEquality";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

