/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.refactoring.extractMethod;

import com.intellij.codeInsight.hint.HintManagerImpl;
import com.intellij.codeInsight.hint.HintUtil;
import com.intellij.lang.javascript.refactoring.extractMethod.JSExtractFunctionHandler;
import com.intellij.lang.javascript.refactoring.extractMethod.JSScopeSelectionUI;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.ui.popup.JBPopupAdapter;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.JBPopupListener;
import com.intellij.openapi.ui.popup.LightweightWindowEvent;
import com.intellij.openapi.util.Pass;
import com.intellij.psi.PsiElement;
import com.intellij.ui.LightweightHint;
import com.intellij.ui.components.JBList;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Component;
import java.awt.Point;
import java.util.Collection;
import java.util.List;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jetbrains.annotations.NotNull;

public class JSScopeSelectionPopup
implements JSScopeSelectionUI {
    private final Editor editor;
    private LightweightHint myLastHint;

    public JSScopeSelectionPopup(Editor editor) {
        this.editor = editor;
    }

    @Override
    public void show(@NotNull JSExtractFunctionHandler.IntroductionScope defaultSuggestedScope, final @NotNull List<? extends JSScopeSelectionUI.ScopePresentation> scopeList, @NotNull Pass<? super JSExtractFunctionHandler.IntroductionScope> callback) {
        if (defaultSuggestedScope == null) {
            JSScopeSelectionPopup.$$$reportNull$$$0(0);
        }
        if (scopeList == null) {
            JSScopeSelectionPopup.$$$reportNull$$$0(1);
        }
        if (callback == null) {
            JSScopeSelectionPopup.$$$reportNull$$$0(2);
        }
        final LogicalPosition initialPos = this.editor.offsetToLogicalPosition(this.editor.getCaretModel().getOffset());
        final JBList list2 = new JBList((Collection)ContainerUtil.map(scopeList, presentation -> presentation.getScope()));
        list2.setSelectedValue((Object)defaultSuggestedScope, true);
        list2.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                int index = list2.getSelectedIndex();
                if (index < 0) {
                    return;
                }
                JSScopeSelectionUI.ScopePresentation presentation = (JSScopeSelectionUI.ScopePresentation)scopeList.get(index);
                int hintPosition = presentation.getHintPosition();
                LogicalPosition position = JSScopeSelectionPopup.this.editor.offsetToLogicalPosition(hintPosition);
                JSScopeSelectionPopup.this.editor.getScrollingModel().scrollTo(position, ScrollType.MAKE_VISIBLE);
                JSScopeSelectionPopup.this.editor.getScrollingModel().runActionOnScrollingFinished(() -> {
                    JComponent label = HintUtil.createInformationLabel((String)presentation.getSignature());
                    LightweightHint hint = new LightweightHint(label);
                    JSScopeSelectionPopup.this.myLastHint = hint;
                    HintManagerImpl hintManager = HintManagerImpl.getInstanceImpl();
                    Point p = HintManagerImpl.getHintPosition((LightweightHint)hint, (Editor)JSScopeSelectionPopup.this.editor, (LogicalPosition)position, (short)3);
                    hintManager.showEditorHint(hint, JSScopeSelectionPopup.this.editor, p, 48, 0, false, HintManagerImpl.createHintHint((Editor)JSScopeSelectionPopup.this.editor, (Point)p, (LightweightHint)hint, (short)3).setContentActive(false).setAwtTooltip(true).setShowImmediately(true));
                });
            }
        });
        list2.setCellRenderer((ListCellRenderer)new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list2, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                Component rendererComponent = super.getListCellRendererComponent((JList<?>)list2, value, index, isSelected, cellHasFocus);
                JSExtractFunctionHandler.IntroductionScope scope = (JSExtractFunctionHandler.IntroductionScope)value;
                PsiElement expr = scope.parent;
                if (expr.isValid()) {
                    this.setText(scope.presentation);
                }
                return rendererComponent;
            }
        });
        JBPopupFactory.getInstance().createListPopupBuilder((JList)list2).setTitle("Choose Destination Scope").setMovable(false).setResizable(false).setRequestFocus(true).setItemChoosenCallback(() -> callback.pass(list2.getSelectedValue())).addListener((JBPopupListener)new JBPopupAdapter(){

            public void onClosed(@NotNull LightweightWindowEvent event) {
                if (event == null) {
                    3.$$$reportNull$$$0(0);
                }
                JSScopeSelectionPopup.this.editor.getScrollingModel().scrollTo(initialPos, ScrollType.CENTER);
                if (JSScopeSelectionPopup.this.myLastHint != null) {
                    JSScopeSelectionPopup.this.myLastHint.hide();
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/lang/javascript/refactoring/extractMethod/JSScopeSelectionPopup$3", "onClosed"));
            }
        }).createPopup().showInBestPositionFor(this.editor);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "defaultSuggestedScope";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "scopeList";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "callback";
                break;
            }
        }
        objectArray[1] = "com/intellij/lang/javascript/refactoring/extractMethod/JSScopeSelectionPopup";
        objectArray[2] = "show";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

