/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.refactoring.introduceVariable;

import com.intellij.codeInsight.highlighting.ReadWriteAccessDetector;
import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.impl.ConstantNode;
import com.intellij.lang.Language;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.JSLanguageDialect;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.findUsages.JSReadWriteAccessDetector;
import com.intellij.lang.javascript.formatter.JSCodeStyleSettings;
import com.intellij.lang.javascript.inspections.NewLineEraser;
import com.intellij.lang.javascript.intentions.destructuring.JSDestructuringIntentionBase;
import com.intellij.lang.javascript.intentions.destructuring.JSStatementDestructuringIntentionBase;
import com.intellij.lang.javascript.intentions.destructuring.JSSubsequentIndexingToDestructuringIntention;
import com.intellij.lang.javascript.intentions.destructuring.JSSubsequentPropertyAccessToDestructuringIntention;
import com.intellij.lang.javascript.names.JSNameSuggestionsUtil;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSDestructuringArray;
import com.intellij.lang.javascript.psi.JSDestructuringContainer;
import com.intellij.lang.javascript.psi.JSDestructuringObject;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFieldVariable;
import com.intellij.lang.javascript.psi.JSIndexedPropertyAccessExpression;
import com.intellij.lang.javascript.psi.JSInitializerOwner;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSQualifiedExpression;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.JSThisExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.impl.JSPsiElementFactory;
import com.intellij.lang.javascript.psi.types.guard.JSTypeGuardUtil;
import com.intellij.lang.javascript.refactoring.JSIntroduceTargetChooser;
import com.intellij.lang.javascript.refactoring.inline.JSInlineHandler;
import com.intellij.lang.javascript.refactoring.introduceVariable.JSNoBalloonIntroduceVariableHandler;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Pass;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.refactoring.BaseRefactoringProcessor;
import com.intellij.refactoring.IntroduceTargetChooser;
import com.intellij.refactoring.RefactoringActionHandler;
import com.intellij.refactoring.actions.BaseRefactoringAction;
import com.intellij.refactoring.introduce.inplace.OccurrencesChooser;
import com.intellij.refactoring.ui.ConflictsDialog;
import com.intellij.util.Function;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import gnu.trove.TObjectIntHashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSIntroduceDestructuringVariablesAction
extends BaseRefactoringAction {
    private static final String VAR_PREFIX = "const ";
    private static final String TEMP_VAR_NAME = "_tmp_webstorm_";
    private boolean myIsIndexer;

    public JSIntroduceDestructuringVariablesAction() {
        this.getTemplatePresentation().setText(JSBundle.message((String)"refactoring.destructuring.vars.for.refactor.this", (Object[])new Object[0]));
    }

    protected boolean isAvailableInEditorOnly() {
        return true;
    }

    protected boolean isEnabledOnElements(@NotNull PsiElement[] elements) {
        if (elements == null) {
            JSIntroduceDestructuringVariablesAction.$$$reportNull$$$0(0);
        }
        return true;
    }

    public static JSQualifiedExpression findReference(Editor editor, PsiFile file2) {
        int offset = editor.getCaretModel().getOffset();
        JSQualifiedExpression ref = JSIntroduceDestructuringVariablesAction.findRef(file2, offset);
        return ref != null ? ref : JSIntroduceDestructuringVariablesAction.findRef(file2, offset - 1);
    }

    @Nullable
    private static JSQualifiedExpression findRef(PsiFile file2, int offset) {
        PsiElement element = file2.findElementAt(offset);
        if (element == null) {
            return null;
        }
        PsiElement elementParent = element.getParent();
        if (elementParent instanceof JSIndexedPropertyAccessExpression) {
            return (JSQualifiedExpression)elementParent;
        }
        if (elementParent instanceof JSLiteralExpression) {
            return (JSQualifiedExpression)ObjectUtils.tryCast((Object)elementParent.getParent(), JSIndexedPropertyAccessExpression.class);
        }
        JSReferenceExpression referenceExpression = (JSReferenceExpression)ObjectUtils.tryCast((Object)elementParent, JSReferenceExpression.class);
        if (referenceExpression != null && referenceExpression.getQualifier() == null) {
            PsiElement parent = referenceExpression.getParent();
            if (parent instanceof JSIndexedPropertyAccessExpression) {
                return (JSQualifiedExpression)parent;
            }
            return (JSQualifiedExpression)ObjectUtils.tryCast((Object)parent, JSReferenceExpression.class);
        }
        JSThisExpression thisExpression = (JSThisExpression)ObjectUtils.tryCast((Object)elementParent, JSThisExpression.class);
        if (thisExpression != null) {
            return (JSQualifiedExpression)ObjectUtils.tryCast((Object)thisExpression.getParent(), JSReferenceExpression.class);
        }
        return referenceExpression;
    }

    @Nullable
    protected RefactoringActionHandler getHandler(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            JSIntroduceDestructuringVariablesAction.$$$reportNull$$$0(1);
        }
        return this.createHandler();
    }

    @NotNull
    public RefactoringActionHandler createHandler() {
        RefactoringActionHandler refactoringActionHandler = new RefactoringActionHandler(){

            public void invoke(@NotNull Project project, Editor editor, PsiFile file2, DataContext dataContext) {
                JSQualifiedExpression parent;
                if (project == null) {
                    1.$$$reportNull$$$0(0);
                }
                if ((parent = JSIntroduceDestructuringVariablesAction.findReference(editor, file2)) == null) {
                    return;
                }
                if (!(parent instanceof JSIndexedPropertyAccessExpression && !this.isInsideBrackets(file2, editor) || parent.getParent() instanceof JSReferenceExpression)) {
                    JSExpression qualifier = parent.getQualifier();
                    if (!(qualifier instanceof JSQualifiedExpression || qualifier instanceof JSThisExpression || qualifier instanceof JSCallExpression)) {
                        return;
                    }
                    editor.getCaretModel().moveToOffset(qualifier.getTextRange().getEndOffset() - 1);
                }
                new IntroduceTemporaryVariableHandler(project, editor, file2).invoke(project, editor, file2, dataContext);
            }

            private boolean isInsideBrackets(PsiFile file2, Editor editor) {
                int offset = editor.getCaretModel().getOffset();
                PsiElement element = file2.findElementAt(offset);
                if (element == null) {
                    return false;
                }
                IElementType elementType = PsiUtilCore.getElementType((PsiElement)element);
                if (elementType == JSTokenTypes.LBRACKET || elementType == JSTokenTypes.RBRACKET) {
                    return true;
                }
                elementType = PsiUtilCore.getElementType((PsiElement)PsiTreeUtil.prevLeaf((PsiElement)element));
                if (elementType == JSTokenTypes.LBRACKET || elementType == JSTokenTypes.RBRACKET) {
                    return true;
                }
                elementType = PsiUtilCore.getElementType((PsiElement)PsiTreeUtil.nextLeaf((PsiElement)element));
                return elementType == JSTokenTypes.LBRACKET || elementType == JSTokenTypes.RBRACKET;
            }

            public void invoke(@NotNull Project project, @NotNull PsiElement[] elements, DataContext dataContext) {
                if (project == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (elements == null) {
                    1.$$$reportNull$$$0(2);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "project";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[0] = "elements";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/lang/javascript/refactoring/introduceVariable/JSIntroduceDestructuringVariablesAction$1";
                objectArray[2] = "invoke";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        if (refactoringActionHandler == null) {
            JSIntroduceDestructuringVariablesAction.$$$reportNull$$$0(2);
        }
        return refactoringActionHandler;
    }

    protected boolean isAvailableForLanguage(Language language) {
        if (!(language instanceof JSLanguageDialect)) {
            return false;
        }
        DialectOptionHolder holder = ((JSLanguageDialect)language).getOptionHolder();
        return holder.isECMA6 || holder.isTypeScript;
    }

    protected void chooseOccurrences(Editor editor, Map<OccurrencesChooser.ReplaceChoice, List<JSExpression>> occurrencesMap, Pass<OccurrencesChooser.ReplaceChoice> callback) {
        new OccurrencesChooser<JSExpression>(editor){

            protected TextRange getOccurrenceRange(JSExpression occurrence) {
                return occurrence.getParent().getTextRange();
            }
        }.showChooser(callback, occurrencesMap);
    }

    @NotNull
    private JSIntroduceTargetChooser<JSExpression> createChooser() {
        JSIntroduceTargetChooser<JSExpression> jSIntroduceTargetChooser = (e, elements, callback, presenter) -> this.chooseElement(e, (Function<? super JSExpression, String>)presenter, (Pass<? super JSExpression>)new Pass<JSExpression>(){

            public void pass(JSExpression expression) {
                JSIntroduceDestructuringVariablesAction.this.myIsIndexer = JSIntroduceDestructuringVariablesAction.shouldIntroduceIndexer(expression);
                callback.pass((Object)expression);
            }
        }, ContainerUtil.filter((Collection)elements, el -> JSIntroduceDestructuringVariablesAction.isSuitable(el)));
        if (jSIntroduceTargetChooser == null) {
            JSIntroduceDestructuringVariablesAction.$$$reportNull$$$0(3);
        }
        return jSIntroduceTargetChooser;
    }

    protected void chooseElement(Editor e, Function<? super JSExpression, String> presenter, Pass<? super JSExpression> callback, List<? extends JSExpression> filteredElements) {
        if (filteredElements.size() == 0) {
            return;
        }
        if (filteredElements.size() == 1) {
            callback.pass((Object)filteredElements.get(0));
            return;
        }
        IntroduceTargetChooser.showChooser((Editor)e, filteredElements, callback, presenter, (String)"Select destructuring assignment target");
    }

    private static boolean shouldIntroduceIndexer(@NotNull JSExpression expression) {
        if (expression == null) {
            JSIntroduceDestructuringVariablesAction.$$$reportNull$$$0(4);
        }
        return expression.getParent() instanceof JSIndexedPropertyAccessExpression;
    }

    private static boolean isSuitable(@NotNull JSExpression el) {
        if (el == null) {
            JSIntroduceDestructuringVariablesAction.$$$reportNull$$$0(5);
        }
        if (el instanceof JSLiteralExpression) {
            return false;
        }
        PsiElement parent = el.getParent();
        if (parent instanceof JSQualifiedExpression) {
            if (parent instanceof JSIndexedPropertyAccessExpression) {
                return JSDestructuringIntentionBase.isValidIndexer((JSIndexedPropertyAccessExpression)parent);
            }
            return true;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/refactoring/introduceVariable/JSIntroduceDestructuringVariablesAction";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "el";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/refactoring/introduceVariable/JSIntroduceDestructuringVariablesAction";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createHandler";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createChooser";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isEnabledOnElements";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getHandler";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "shouldIntroduceIndexer";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isSuitable";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static enum Filter {
        Allow,
        Drop,
        DropAllBefore;

    }

    private class IntroduceTemporaryVariableHandler
    extends JSNoBalloonIntroduceVariableHandler {
        private final Project myProject;
        private final Editor myEditor;
        private final PsiFile myFile;
        private final TObjectIntHashMap<String> myNamesToIntroduce;

        private IntroduceTemporaryVariableHandler(Project project, Editor editor, PsiFile file2) {
            super(JSIntroduceDestructuringVariablesAction.this.createChooser());
            this.myNamesToIntroduce = new TObjectIntHashMap();
            this.myProject = project;
            this.myEditor = editor;
            this.myFile = file2;
        }

        @Override
        @NotNull
        protected JSExpression[] findOccurrences(@NotNull Pair<JSExpression, TextRange> expressionDescriptor, @NotNull JSElement scope) {
            if (expressionDescriptor == null) {
                IntroduceTemporaryVariableHandler.$$$reportNull$$$0(0);
            }
            if (scope == null) {
                IntroduceTemporaryVariableHandler.$$$reportNull$$$0(1);
            }
            JSExpression[] occurrences = super.findOccurrences(expressionDescriptor, scope);
            JSExpression sourceExpression = (JSExpression)expressionDescriptor.first;
            HashSet<String> writeUsageItems = new HashSet<String>();
            ArrayList<JSExpression> results = new ArrayList<JSExpression>();
            Arrays.sort(occurrences, Comparator.comparing(o -> o.getTextOffset()));
            for (JSExpression o2 : occurrences) {
                Filter filter = this.filter(o2, writeUsageItems);
                if (filter == Filter.Allow) {
                    results.add(o2);
                    continue;
                }
                if (filter != Filter.DropAllBefore || o2.getTextOffset() > sourceExpression.getTextOffset()) continue;
                results.clear();
                results.add(o2);
            }
            JSExpression[] jSExpressionArray = (JSExpression[])ContainerUtil.toArray(results, JSExpression[]::new);
            if (jSExpressionArray == null) {
                IntroduceTemporaryVariableHandler.$$$reportNull$$$0(2);
            }
            return jSExpressionArray;
        }

        private boolean validateAgainstTypeGuards(@NotNull List<JSExpression> results, @NotNull MultiMap<PsiElement, String> conflicts) {
            if (results == null) {
                IntroduceTemporaryVariableHandler.$$$reportNull$$$0(3);
            }
            if (conflicts == null) {
                IntroduceTemporaryVariableHandler.$$$reportNull$$$0(4);
            }
            boolean hasNonAffected = false;
            boolean hasAffected = false;
            boolean hasNonEq = false;
            JSType type = null;
            for (JSExpression result2 : results) {
                if (!(result2 instanceof JSReferenceExpression)) continue;
                JSType typeAfterGuard = JSTypeGuardUtil.getTypeIfAffectedByTypeGuard((JSReferenceExpression)result2);
                if (typeAfterGuard != null) {
                    hasAffected = true;
                    conflicts.putValue((Object)result2, (Object)JSBundle.message((String)"refactoring.destructuring.vars.intention.guard.conflict", (Object[])new Object[]{typeAfterGuard.getTypeText()}));
                    if (type == null) {
                        type = typeAfterGuard;
                        continue;
                    }
                    if (type.isEquivalentTo(typeAfterGuard, null)) continue;
                    hasNonEq = true;
                    continue;
                }
                hasNonAffected = true;
            }
            if (hasAffected && hasNonAffected) {
                return false;
            }
            return conflicts.isEmpty() || !hasNonEq;
        }

        private Filter filter(JSExpression o, Set<String> writeUsageItems) {
            PsiElement parent = o.getParent();
            if (JSReadWriteAccessDetector.ourInstance.getExpressionAccess(parent) != ReadWriteAccessDetector.Access.Read) {
                writeUsageItems.add(StringUtil.collapseWhiteSpace((CharSequence)parent.getText()));
                return Filter.Drop;
            }
            if (writeUsageItems.contains(StringUtil.collapseWhiteSpace((CharSequence)parent.getText()))) {
                return Filter.DropAllBefore;
            }
            if (!JSIntroduceDestructuringVariablesAction.this.myIsIndexer) {
                return parent instanceof JSReferenceExpression && ((JSReferenceExpression)parent).getReferenceName() != null ? Filter.Allow : Filter.Drop;
            }
            if (!(parent instanceof JSIndexedPropertyAccessExpression)) {
                return Filter.Drop;
            }
            return JSDestructuringIntentionBase.isValidIndexer((JSIndexedPropertyAccessExpression)parent) ? Filter.Allow : Filter.Drop;
        }

        @Override
        protected void chooseOccurrencesToReplace(Editor editor, final Map<OccurrencesChooser.ReplaceChoice, List<JSExpression>> occurrencesMap, final Pass<OccurrencesChooser.ReplaceChoice> callback) {
            JSIntroduceDestructuringVariablesAction.this.chooseOccurrences(editor, occurrencesMap, new Pass<OccurrencesChooser.ReplaceChoice>(){

                public void pass(OccurrencesChooser.ReplaceChoice choice) {
                    MultiMap conflicts = MultiMap.createSmart();
                    if (!IntroduceTemporaryVariableHandler.this.validateAgainstTypeGuards(choice.isAll() ? ContainerUtil.flatten(occurrencesMap.values()) : (List)occurrencesMap.get(OccurrencesChooser.ReplaceChoice.NO), (MultiMap<PsiElement, String>)conflicts)) {
                        if (ApplicationManager.getApplication().isUnitTestMode()) {
                            throw new BaseRefactoringProcessor.ConflictsInTestsException(conflicts.values());
                        }
                        ConflictsDialog dialog = new ConflictsDialog(IntroduceTemporaryVariableHandler.this.myProject, conflicts, () -> callback.pass((Object)choice), false, true);
                        if (!dialog.showAndGet()) {
                            return;
                        }
                    }
                    callback.pass((Object)choice);
                }
            });
        }

        @Override
        protected void afterIntroduce() {
            PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)this.myProject);
            documentManager.commitDocument(this.myEditor.getDocument());
            JSQualifiedExpression parent = JSIntroduceDestructuringVariablesAction.findReference(this.myEditor, this.myFile);
            if (parent == null) {
                return;
            }
            JSReferenceExpression parentQualifier = (JSReferenceExpression)ObjectUtils.tryCast((Object)parent.getQualifier(), JSReferenceExpression.class);
            assert (parentQualifier != null);
            String semicolon = JSCodeStyleSettings.getSemicolon((PsiElement)parent);
            PsiElement resolved = parentQualifier.resolve();
            assert (resolved instanceof JSFieldVariable);
            JSStatement parentStatement = (JSStatement)PsiTreeUtil.getParentOfType((PsiElement)resolved, JSStatement.class);
            assert (parentStatement != null) : "parent statement != null; resolved: " + resolved.getClass().getCanonicalName();
            SmartPsiElementPointer pointer = SmartPointerManager.createPointer((PsiElement)resolved);
            String varName = ((JSFieldVariable)resolved).getName();
            HashMap conflictingNameAliases = new HashMap();
            ReferencesSearch.search((PsiElement)resolved).forEach(r -> {
                PsiElement parentExp = r.getElement().getParent();
                if (parentExp instanceof JSReferenceExpression) {
                    String name = ((JSReferenceExpression)parentExp).getReferenceName();
                    if (name != null) {
                        this.myNamesToIntroduce.put((Object)name, -1);
                        parentExp.replace((PsiElement)JSPsiElementFactory.createJSExpression(this.aliasIfNeeded(parentStatement, conflictingNameAliases, name), parentExp));
                    }
                } else if (parentExp instanceof JSIndexedPropertyAccessExpression && JSDestructuringIntentionBase.isValidIndexer((JSIndexedPropertyAccessExpression)parentExp)) {
                    JSExpression expression = ((JSIndexedPropertyAccessExpression)parentExp).getIndexExpression();
                    assert (expression != null);
                    int value = (int)JSDestructuringIntentionBase.toDouble((JSLiteralExpression)expression);
                    String name = JSNameSuggestionsUtil.generateOrdinal(value);
                    this.myNamesToIntroduce.put((Object)name, value);
                    parentExp.replace((PsiElement)JSPsiElementFactory.createJSExpression(this.aliasIfNeeded(parentStatement, conflictingNameAliases, name), parentExp));
                }
            });
            StringBuilder varBuilder = new StringBuilder(JSIntroduceDestructuringVariablesAction.VAR_PREFIX);
            boolean first = true;
            for (Object name : this.myNamesToIntroduce.keys()) {
                if (!first) {
                    varBuilder.append(", ");
                }
                first = false;
                varBuilder.append(conflictingNameAliases.containsKey((String)name) ? conflictingNameAliases.get((String)name) : name).append(" = ").append(varName);
                if (!JSIntroduceDestructuringVariablesAction.this.myIsIndexer) {
                    varBuilder.append(".").append(name);
                    continue;
                }
                varBuilder.append("[").append(this.myNamesToIntroduce.get((Object)((String)name))).append("]");
            }
            varBuilder.append(semicolon);
            JSStatement statement = (JSStatement)PsiTreeUtil.getParentOfType((PsiElement)pointer.getElement(), JSStatement.class);
            assert (statement != null);
            PsiElement newStatement = statement.getParent().addAfter((PsiElement)JSPsiElementFactory.createJSStatement(varBuilder.toString(), (PsiElement)statement), (PsiElement)statement);
            this.myEditor.getCaretModel().moveToOffset(newStatement.getTextRange().getEndOffset() - semicolon.length() - 1);
            JSStatementDestructuringIntentionBase intention = JSIntroduceDestructuringVariablesAction.this.myIsIndexer ? new JSSubsequentIndexingToDestructuringIntention() : new JSSubsequentPropertyAccessToDestructuringIntention();
            intention.invoke(this.myProject, this.myEditor, this.myFile);
            documentManager.commitDocument(this.myEditor.getDocument());
            JSVariable variable = (JSVariable)ObjectUtils.tryCast((Object)pointer.getElement(), JSVariable.class);
            if (variable == null) {
                return;
            }
            pointer = SmartPointerManager.createPointer((PsiElement)variable);
            new JSInlineHandler(true).inlineElement(this.myProject, this.myEditor, (PsiElement)variable);
            variable = (JSVariable)ObjectUtils.tryCast((Object)pointer.getElement(), JSVariable.class);
            if (variable != null && variable.isValid()) {
                JSVarStatement varStatement = variable.getStatement();
                NewLineEraser eraser = varStatement == null ? null : new NewLineEraser((PsiElement)varStatement);
                variable.delete();
                if (eraser != null) {
                    eraser.process();
                }
            }
        }

        @Override
        protected int getCustomFinalOffset() {
            JSStatement jsStatement;
            JSDestructuringContainer container = (JSDestructuringContainer)SyntaxTraverser.psiTraverser((PsiElement)this.myFile).filter(JSDestructuringContainer.class).filter(c -> this.isOurContainer((JSDestructuringContainer)c, this.myNamesToIntroduce)).first();
            if (container != null && (jsStatement = (JSStatement)PsiTreeUtil.getParentOfType((PsiElement)container, JSStatement.class)) != null) {
                return jsStatement.getTextRange().getEndOffset() - JSCodeStyleSettings.getSemicolon((PsiElement)this.myFile).length();
            }
            return -1;
        }

        private boolean isOurContainer(JSDestructuringContainer c, TObjectIntHashMap<String> namesToIntroduce) {
            if (!JSIntroduceDestructuringVariablesAction.this.myIsIndexer && c instanceof JSDestructuringObject) {
                return Arrays.stream(((JSDestructuringObject)c).getProperties()).map(p -> p.getName()).allMatch(n -> namesToIntroduce.containsKey(n));
            }
            if (JSIntroduceDestructuringVariablesAction.this.myIsIndexer && c instanceof JSDestructuringArray) {
                JSInitializerOwner[] elements = ((JSDestructuringArray)c).getElements();
                for (int i = 0; i < elements.length; ++i) {
                    JSInitializerOwner element = elements[i];
                    if (!(element instanceof JSVariable)) {
                        return false;
                    }
                    String name = element.getName();
                    if (name == null) {
                        return false;
                    }
                    for (Object key : namesToIntroduce.keys()) {
                        if (namesToIntroduce.get((Object)((String)key)) != i || name.startsWith((String)key)) continue;
                        return false;
                    }
                }
                return true;
            }
            return false;
        }

        private String aliasIfNeeded(JSStatement parentStatement, Map<String, String> conflictingNameAliases, String name) {
            if (conflictingNameAliases.containsKey(name)) {
                return conflictingNameAliases.get(name);
            }
            String newName = JSNameSuggestionsUtil.ensureUniqueVariableName(name, parentStatement.getParent(), ContainerUtil.emptyList(), false);
            conflictingNameAliases.put(name, newName);
            return newName;
        }

        @Override
        @Nullable
        protected Expression createCustomTemplateExpression(PsiElement selectedElement) {
            return new ConstantNode(JSIntroduceDestructuringVariablesAction.TEMP_VAR_NAME);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "expressionDescriptor";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "scope";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/javascript/refactoring/introduceVariable/JSIntroduceDestructuringVariablesAction$IntroduceTemporaryVariableHandler";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "results";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "conflicts";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/javascript/refactoring/introduceVariable/JSIntroduceDestructuringVariablesAction$IntroduceTemporaryVariableHandler";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "findOccurrences";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "findOccurrences";
                    break;
                }
                case 2: {
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "validateAgainstTypeGuards";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

