/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.service.ui;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.execution.impl.ConsoleViewImpl;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.icons.AllIcons;
import com.intellij.ide.errorTreeView.ErrorTreeElement;
import com.intellij.ide.errorTreeView.NewErrorTreeViewPanel;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.integration.JSAnnotationError;
import com.intellij.lang.javascript.service.JSLanguageServiceQueue;
import com.intellij.lang.javascript.service.ui.JSConsoleViewPanel;
import com.intellij.lang.javascript.service.ui.JSLanguageServiceConsole;
import com.intellij.lang.javascript.service.ui.JSLanguageServiceErrorTreeViewPanel;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowAnchor;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.ui.LayeredIcon;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.impl.ContentImpl;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.ImmutableList;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.ui.StatusText;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSLanguageServiceToolWindowManager
implements Disposable {
    public static final String EMPTY_TEXT = " ";
    private static final int IGNORE_CODE = -1;
    @NotNull
    protected final Project myProject;
    @Nullable
    private volatile NewErrorTreeViewPanel myCurrentErrorTreeViewPanel;
    private volatile NewErrorTreeViewPanel myProjectErrorTreeViewPanel;
    private volatile boolean myInitialized;
    private volatile boolean myDisposed;
    @Nullable
    protected volatile ToolWindow myToolWindow;
    @NotNull
    protected final String myHelpId;
    @Nullable
    private final LayeredIcon myIcon;
    @Nullable
    private final Icon myErrorIcon;
    @Nullable
    private final AnAction[] myCommonActions;
    @NotNull
    private final String myToolWindowName;
    @Nullable
    private volatile List<JSAnnotationError> myLastResult;
    protected final Map<String, JSLanguageServiceConsole> myServiceConsoles;
    private final Set<String> myDisconnectedConsoles;

    public JSLanguageServiceToolWindowManager(@NotNull Project project, @NotNull String toolWindowName, @NotNull String helpId, @Nullable Icon icon, AnAction ... commonPanelActions) {
        if (project == null) {
            JSLanguageServiceToolWindowManager.$$$reportNull$$$0(0);
        }
        if (toolWindowName == null) {
            JSLanguageServiceToolWindowManager.$$$reportNull$$$0(1);
        }
        if (helpId == null) {
            JSLanguageServiceToolWindowManager.$$$reportNull$$$0(2);
        }
        this.myDisposed = false;
        this.myServiceConsoles = ContainerUtil.newConcurrentMap();
        this.myDisconnectedConsoles = ContainerUtil.newConcurrentSet();
        this.myProject = project;
        this.myToolWindowName = toolWindowName;
        this.myHelpId = helpId;
        this.myCommonActions = commonPanelActions;
        this.myIcon = JSLanguageServiceToolWindowManager.createIcon(icon, false);
        this.myErrorIcon = JSLanguageServiceToolWindowManager.createIcon(icon, true);
    }

    private static LayeredIcon createIcon(@Nullable Icon rawIcon, boolean error) {
        if (rawIcon == null) {
            return null;
        }
        LayeredIcon icon = new LayeredIcon(2);
        icon.setIcon(rawIcon, 0);
        Icon errorPoint = AllIcons.Ide.ErrorPoint;
        icon.setIcon(error ? errorPoint : EmptyIcon.create((Icon)errorPoint), 1, 4);
        return icon;
    }

    public boolean needActivateProgressPanel() {
        return false;
    }

    public void setProgressText(@Nullable String text) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        NewErrorTreeViewPanel myErrorPanel = this.myCurrentErrorTreeViewPanel;
        if (myErrorPanel != null) {
            if (StringUtil.isEmpty((String)text)) {
                myErrorPanel.clearProgressData();
            } else {
                myErrorPanel.setProgressText(text);
            }
        }
    }

    public synchronized void connectToProcessHandler(@NotNull String serviceId, @NotNull ProcessHandler handler) {
        if (serviceId == null) {
            JSLanguageServiceToolWindowManager.$$$reportNull$$$0(3);
        }
        if (handler == null) {
            JSLanguageServiceToolWindowManager.$$$reportNull$$$0(4);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (this.myProject.isDisposed() || !this.myProject.isOpen() || this.myDisposed) {
            return;
        }
        this.init();
        this.cleanErrorsPanel();
        JSLanguageServiceQueue.LOGGER.debug("Creating language service " + this.myToolWindowName);
        assert (this.myToolWindow != null);
        ToolWindow toolWindow = this.myToolWindow;
        if (toolWindow != null) {
            ConsoleViewImpl console = this.createConsole();
            console.attachToProcess(handler);
            JSConsoleViewPanel consolePanel = new JSConsoleViewPanel(this.myProject, this.myHelpId, null, (ConsoleView)console, this.getConsoleActions());
            JSLanguageServiceConsole oldConsole = this.myServiceConsoles.get(serviceId);
            if (oldConsole != null) {
                if (!this.myDisconnectedConsoles.remove(serviceId)) {
                    JSLanguageServiceQueue.LOGGER.debug("Old console wasn't disconnected. Tool window: " + this.myToolWindowName + " id: " + serviceId);
                    try {
                        this.disconnectFromProcessHandler(serviceId, false);
                    }
                    catch (Exception e) {
                        JSLanguageServiceQueue.LOGGER.debug("Error while dispose: " + serviceId);
                    }
                }
                JSLanguageServiceToolWindowManager.disposePreviousConsole(oldConsole);
            }
            this.myServiceConsoles.put(serviceId, new JSLanguageServiceConsole(serviceId, toolWindow, console, consolePanel));
            this.updateCurrentErrorsEmptyText(this.createOrGetCurrentTreeViewPanel());
        }
    }

    @Nullable
    protected AnAction[] getConsoleActions() {
        return this.myCommonActions;
    }

    @NotNull
    protected ConsoleViewImpl createConsole() {
        ConsoleViewImpl consoleViewImpl = new ConsoleViewImpl(this.myProject, GlobalSearchScope.allScope((Project)this.myProject), true, false);
        if (consoleViewImpl == null) {
            JSLanguageServiceToolWindowManager.$$$reportNull$$$0(5);
        }
        return consoleViewImpl;
    }

    public void show() {
        ToolWindow toolWindow = this.myToolWindow;
        if (toolWindow != null) {
            toolWindow.show(null);
        }
    }

    public void lazyInit(@NotNull Condition<JSLanguageServiceToolWindowManager> checkInit) {
        if (checkInit == null) {
            JSLanguageServiceToolWindowManager.$$$reportNull$$$0(6);
        }
        StartupManager.getInstance((Project)this.myProject).runWhenProjectIsInitialized(() -> ApplicationManager.getApplication().invokeLater(() -> {
            if (checkInit.value((Object)this)) {
                this.init();
            }
            DaemonCodeAnalyzer.getInstance((Project)this.myProject).restart();
        }, this.myProject.getDisposed()));
    }

    public synchronized void init() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (this.myProject.isDisposed()) {
            return;
        }
        if (!this.myInitialized || this.myToolWindow == null) {
            ToolWindowManager manager2 = ToolWindowManager.getInstance((Project)this.myProject);
            ToolWindow toolWindow = manager2.registerToolWindow(this.myToolWindowName, true, ToolWindowAnchor.BOTTOM, (Disposable)this.myProject, true);
            toolWindow.setIcon((Icon)this.myIcon);
            this.myToolWindow = toolWindow;
            this.myInitialized = true;
            JSLanguageServiceQueue.LOGGER.debug("Initialized tool window " + this.myToolWindowName);
            this.initDefaultPanels(toolWindow);
        }
    }

    protected void initDefaultPanels(ToolWindow toolWindow) {
        this.createCurrentTreeViewPanel();
    }

    private void createCurrentTreeViewPanel() {
        if (this.myCurrentErrorTreeViewPanel != null) {
            return;
        }
        ToolWindow toolWindow = this.myToolWindow;
        if (this.myInitialized && toolWindow != null) {
            ContentImpl content = this.createCurrentErrorContent(toolWindow);
            toolWindow.getContentManager().setSelectedContent((Content)content);
        }
    }

    private ContentImpl createCurrentErrorContent(ToolWindow toolWindow) {
        Ref content = new Ref();
        JSLanguageServiceErrorTreeViewPanel errorTreeViewPanel = this.createCurrentErrorsPanel(toolWindow, (Ref<ContentImpl>)content);
        Disposer.register((Disposable)this.myProject, (Disposable)errorTreeViewPanel);
        ContentImpl contentImpl = new ContentImpl((JComponent)((Object)errorTreeViewPanel), this.getCurrentErrorsTitle(), false);
        contentImpl.setHelpId(this.myHelpId);
        contentImpl.setCloseable(false);
        content.set((Object)contentImpl);
        toolWindow.getContentManager().addContent((Content)content.get(), 0);
        this.myCurrentErrorTreeViewPanel = errorTreeViewPanel;
        return (ContentImpl)content.get();
    }

    @NotNull
    protected String getCurrentErrorsTitle() {
        if ("Errors" == null) {
            JSLanguageServiceToolWindowManager.$$$reportNull$$$0(7);
        }
        return "Errors";
    }

    @Nullable
    protected final NewErrorTreeViewPanel getCurrentErrorTreeViewPanel() {
        return this.myCurrentErrorTreeViewPanel;
    }

    @NotNull
    protected String getProjectErrorsTitle() {
        if ("Project Errors" == null) {
            JSLanguageServiceToolWindowManager.$$$reportNull$$$0(8);
        }
        return "Project Errors";
    }

    @NotNull
    protected JSLanguageServiceErrorTreeViewPanel createCurrentErrorsPanel(final ToolWindow toolWindow, final Ref<ContentImpl> content) {
        JSLanguageServiceErrorTreeViewPanel panel = new JSLanguageServiceErrorTreeViewPanel(this.myProject, this.myHelpId, () -> {
            this.myLastResult = null;
        }, this.getErrorPanelLeftActions(), this.getErrorPanelRightActions(false)){

            public void close() {
                JSLanguageServiceToolWindowManager.this.closeCurrentErrorsPanel(toolWindow, (Ref<ContentImpl>)content);
            }
        };
        if (this.needActivateProgressPanel()) {
            panel.setProgressText(EMPTY_TEXT);
        }
        this.updateCurrentErrorsEmptyText(panel);
        JSLanguageServiceErrorTreeViewPanel jSLanguageServiceErrorTreeViewPanel = panel;
        if (jSLanguageServiceErrorTreeViewPanel == null) {
            JSLanguageServiceToolWindowManager.$$$reportNull$$$0(9);
        }
        return jSLanguageServiceErrorTreeViewPanel;
    }

    protected void closeCurrentErrorsPanel(ToolWindow toolWindow, Ref<ContentImpl> content) {
        toolWindow.hide(() -> {
            this.myLastResult = null;
            toolWindow.setIcon((Icon)this.myIcon);
            ContentImpl contentImpl = (ContentImpl)content.get();
            if (contentImpl != null) {
                toolWindow.getContentManager().removeContent((Content)contentImpl, true);
            }
            ContentImpl newContentImpl = this.createCurrentErrorContent(toolWindow);
            toolWindow.getContentManager().setSelectedContent((Content)newContentImpl);
        });
    }

    protected AnAction[] getErrorPanelRightActions(boolean all) {
        return AnAction.EMPTY_ARRAY;
    }

    protected AnAction[] getErrorPanelLeftActions() {
        return this.myCommonActions;
    }

    public void setName(@Nullable String newName) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.init();
        this.setNameNoInit(newName);
        this.updateCurrentErrorsEmptyText(this.createOrGetCurrentTreeViewPanel());
    }

    private void setNameNoInit(@Nullable String newName) {
        ToolWindow window = this.myToolWindow;
        if (window != null) {
            String fullName = StringUtil.isEmptyOrSpaces((String)newName) ? this.myToolWindowName : this.myToolWindowName + EMPTY_TEXT + newName;
            window.setStripeTitle(fullName);
        }
    }

    @Nullable
    private NewErrorTreeViewPanel createProjectErrorsPanel() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        NewErrorTreeViewPanel panel = this.myProjectErrorTreeViewPanel;
        if (panel != null) {
            return panel;
        }
        ToolWindow toolWindow = this.myToolWindow;
        if (toolWindow == null) {
            this.init();
            toolWindow = this.myToolWindow;
        }
        if (toolWindow == null) {
            return null;
        }
        Ref content = new Ref();
        JSLanguageServiceErrorTreeViewPanel errorTreeViewPanel = this.createProjectErrorsPanel(toolWindow, (Ref<ContentImpl>)content);
        Disposer.register((Disposable)this.myProject, (Disposable)errorTreeViewPanel);
        ContentImpl contentImpl = new ContentImpl((JComponent)((Object)errorTreeViewPanel), this.getProjectErrorsTitle(), false);
        contentImpl.setHelpId(this.myHelpId);
        contentImpl.setCloseable(false);
        content.set((Object)contentImpl);
        toolWindow.getContentManager().addContent((Content)content.get());
        this.myProjectErrorTreeViewPanel = errorTreeViewPanel;
        return errorTreeViewPanel;
    }

    @NotNull
    protected JSLanguageServiceErrorTreeViewPanel createProjectErrorsPanel(final ToolWindow toolWindow, final Ref<ContentImpl> content) {
        JSLanguageServiceErrorTreeViewPanel jSLanguageServiceErrorTreeViewPanel = new JSLanguageServiceErrorTreeViewPanel(this.myProject, this.myHelpId, null, this.getErrorPanelLeftActions(), this.getErrorPanelRightActions(true)){

            public void close() {
                NewErrorTreeViewPanel oldPanel = JSLanguageServiceToolWindowManager.this.myProjectErrorTreeViewPanel;
                JSLanguageServiceToolWindowManager.this.myProjectErrorTreeViewPanel = null;
                toolWindow.hide(() -> {
                    ContentImpl contentImpl = (ContentImpl)content.get();
                    if (contentImpl != null) {
                        toolWindow.getContentManager().removeContent((Content)contentImpl, true);
                    }
                    if (oldPanel != null) {
                        Disposer.dispose((Disposable)oldPanel);
                    }
                });
            }
        };
        if (jSLanguageServiceErrorTreeViewPanel == null) {
            JSLanguageServiceToolWindowManager.$$$reportNull$$$0(10);
        }
        return jSLanguageServiceErrorTreeViewPanel;
    }

    public void disconnectFromProcessHandler(@NotNull String serviceId, boolean closeAssociatedConsoleView) {
        JSLanguageServiceConsole console;
        if (serviceId == null) {
            JSLanguageServiceToolWindowManager.$$$reportNull$$$0(11);
        }
        if ((console = this.myServiceConsoles.get(serviceId)) != null) {
            if (closeAssociatedConsoleView) {
                this.myServiceConsoles.remove(serviceId);
                JSLanguageServiceToolWindowManager.disposePreviousConsole(console);
            } else if (this.myDisconnectedConsoles.add(serviceId)) {
                console.print("\nDisconnected");
            }
            this.setProgressText(null);
        }
    }

    private static void disposePreviousConsole(@NotNull JSLanguageServiceConsole console) {
        if (console == null) {
            JSLanguageServiceToolWindowManager.$$$reportNull$$$0(12);
        }
        Disposer.dispose((Disposable)console);
    }

    public void logProjectErrors(@NotNull ImmutableList<JSAnnotationError> results, boolean setActive) {
        NewErrorTreeViewPanel panel;
        if (results == null) {
            JSLanguageServiceToolWindowManager.$$$reportNull$$$0(13);
        }
        if ((panel = this.createProjectErrorsPanel()) == null) {
            return;
        }
        this.logErrorsImpl(panel, (List<JSAnnotationError>)results);
        ToolWindow window = this.myToolWindow;
        if (window == null) {
            return;
        }
        if (setActive) {
            this.setActivePanel(panel, window);
        }
    }

    private void setActivePanel(NewErrorTreeViewPanel panel, ToolWindow window) {
        for (Content content : window.getContentManager().getContents()) {
            if (content.getComponent() != panel) continue;
            window.getContentManager().setSelectedContent(content);
            break;
        }
        this.show();
    }

    protected NewErrorTreeViewPanel createOrGetCurrentTreeViewPanel() {
        this.init();
        return this.myCurrentErrorTreeViewPanel;
    }

    public void logCurrentErrors(@NotNull List<JSAnnotationError> results, boolean setActive) {
        ArrayList<JSAnnotationError> list2;
        if (results == null) {
            JSLanguageServiceToolWindowManager.$$$reportNull$$$0(14);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        NewErrorTreeViewPanel errorTreeViewPanel = this.createOrGetCurrentTreeViewPanel();
        if (errorTreeViewPanel == null) {
            return;
        }
        ToolWindow toolWindow = this.myToolWindow;
        if (this.myInitialized && !(list2 = new ArrayList<JSAnnotationError>(results)).equals(this.myLastResult)) {
            this.logErrorsImpl(errorTreeViewPanel, list2);
            this.myLastResult = list2;
            if (toolWindow != null && this.myIcon != null) {
                LayeredIcon newIcon;
                Icon oldIcon = toolWindow.getIcon();
                Object object = newIcon = list2.size() > 0 && list2.stream().anyMatch(el -> "error".equals(el.getCategory())) ? this.myErrorIcon : this.myIcon;
                if (oldIcon != newIcon) {
                    toolWindow.setIcon((Icon)newIcon);
                }
            }
        }
        if (toolWindow != null && setActive) {
            this.setActivePanel(errorTreeViewPanel, toolWindow);
        }
    }

    private void logErrorsImpl(NewErrorTreeViewPanel errorTreeViewPanel, List<JSAnnotationError> list2) {
        errorTreeViewPanel.getErrorViewStructure().clear();
        for (JSAnnotationError compilerResult : list2) {
            int category;
            String path = compilerResult.getAbsoluteFilePath();
            VirtualFile file2 = null;
            if (path != null) {
                file2 = LocalFileSystem.getInstance().findFileByPath(FileUtil.toSystemIndependentName((String)path));
            }
            if ((category = JSLanguageServiceToolWindowManager.parseCategory(compilerResult)) == -1) continue;
            this.doAddMessage(errorTreeViewPanel, compilerResult, file2, category);
        }
        errorTreeViewPanel.updateTree();
    }

    private static int parseCategory(@NotNull JSAnnotationError compilerResult) {
        String category;
        if (compilerResult == null) {
            JSLanguageServiceToolWindowManager.$$$reportNull$$$0(15);
        }
        if ((category = compilerResult.getCategory()) == null) {
            return 4;
        }
        switch (StringUtil.toLowerCase((String)category)) {
            case "info": {
                return 3;
            }
            case "hide": {
                return -1;
            }
            case "warning": {
                return 5;
            }
        }
        return 4;
    }

    protected void doAddMessage(@NotNull NewErrorTreeViewPanel errorTreeViewPanel, @NotNull JSAnnotationError compilerResult, @Nullable VirtualFile file2, int category) {
        if (errorTreeViewPanel == null) {
            JSLanguageServiceToolWindowManager.$$$reportNull$$$0(16);
        }
        if (compilerResult == null) {
            JSLanguageServiceToolWindowManager.$$$reportNull$$$0(17);
        }
        String description = StringUtil.notNullize((String)compilerResult.getDescription());
        String[] messages = description.split("\n");
        errorTreeViewPanel.addMessage(category, messages, file2, compilerResult.getLine(), compilerResult.getColumn(), null);
    }

    public synchronized void dispose() {
        this.disposeConsoles();
        this.resetToolWindow();
        this.myDisposed = true;
    }

    private synchronized void disposeConsoles() {
        for (JSLanguageServiceConsole console : this.myServiceConsoles.values()) {
            if (console == null) continue;
            try {
                Disposer.dispose((Disposable)console);
            }
            catch (Exception e) {
                JSLanguageServiceQueue.LOGGER.error(e.getMessage(), (Throwable)e);
            }
        }
        this.myServiceConsoles.clear();
    }

    public void cleanErrorsPanel() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        NewErrorTreeViewPanel panel = this.myCurrentErrorTreeViewPanel;
        if (panel != null) {
            panel.getErrorViewStructure().clear();
            panel.updateTree();
            this.myLastResult = null;
            this.updateCurrentErrorsEmptyText(panel);
        }
    }

    protected void updateCurrentErrorsEmptyText(@NotNull NewErrorTreeViewPanel panel) {
        if (panel == null) {
            JSLanguageServiceToolWindowManager.$$$reportNull$$$0(18);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (!this.hasActiveConsoles()) {
            JSLanguageServiceToolWindowManager.setNotStartedText(panel);
            return;
        }
        panel.getEmptyText().setText(JSLanguageServiceErrorTreeViewPanel.getDefaultNoErrorsText());
    }

    protected final boolean hasActiveConsoles() {
        return this.myServiceConsoles.size() - this.myDisconnectedConsoles.size() > 0;
    }

    private static void setNotStartedText(@NotNull NewErrorTreeViewPanel panel) {
        if (panel == null) {
            JSLanguageServiceToolWindowManager.$$$reportNull$$$0(19);
        }
        StatusText text = panel.getEmptyText();
        text.clear();
        text.setText(JSBundle.message((String)"javascript.language.service.tracking.is.not.started", (Object[])new Object[0]));
    }

    public synchronized void resetToolWindow() {
        NewErrorTreeViewPanel allErrorTreeViewPanel;
        NewErrorTreeViewPanel panel;
        if (this.myProject.isDefault()) {
            return;
        }
        if (!this.myServiceConsoles.isEmpty()) {
            return;
        }
        if (!this.myProject.isDisposed()) {
            ApplicationManager.getApplication().assertIsDispatchThread();
            ToolWindowManager.getInstance((Project)this.myProject).unregisterToolWindow(this.myToolWindowName);
        }
        if ((panel = this.myCurrentErrorTreeViewPanel) != null) {
            Disposer.dispose((Disposable)panel);
        }
        if ((allErrorTreeViewPanel = this.myProjectErrorTreeViewPanel) != null) {
            Disposer.dispose((Disposable)allErrorTreeViewPanel);
        }
        this.myProjectErrorTreeViewPanel = null;
        this.myToolWindow = null;
        this.myCurrentErrorTreeViewPanel = null;
        this.myLastResult = null;
    }

    public synchronized void partiallyResetToolWindow() {
        ToolWindow window = this.myToolWindow;
        if (window == null) {
            return;
        }
        if (this.hasActiveConsoles()) {
            return;
        }
        window.setIcon((Icon)this.myIcon);
        this.cleanErrorsPanel();
        this.setNameNoInit(null);
    }

    @Nullable
    public ErrorTreeElement getSelectedElement() {
        JComponent contentComponent;
        Content selectedContent;
        ToolWindow toolWindow = this.myToolWindow;
        if (toolWindow != null && (selectedContent = toolWindow.getContentManager().getSelectedContent()) != null && (contentComponent = selectedContent.getComponent()) instanceof JSLanguageServiceErrorTreeViewPanel) {
            return ((JSLanguageServiceErrorTreeViewPanel)((Object)contentComponent)).getSelectedErrorTreeElement();
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolWindowName";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "helpId";
                break;
            }
            case 3: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "serviceId";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "handler";
                break;
            }
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/service/ui/JSLanguageServiceToolWindowManager";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "checkInit";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "console";
                break;
            }
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "results";
                break;
            }
            case 15: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "compilerResult";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "errorTreeViewPanel";
                break;
            }
            case 18: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "panel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/service/ui/JSLanguageServiceToolWindowManager";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createConsole";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getCurrentErrorsTitle";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getProjectErrorsTitle";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "createCurrentErrorsPanel";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "createProjectErrorsPanel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "connectToProcessHandler";
                break;
            }
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "lazyInit";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "disconnectFromProcessHandler";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "disposePreviousConsole";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "logProjectErrors";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "logCurrentErrors";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "parseCategory";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "doAddMessage";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "updateCurrentErrorsEmptyText";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "setNotStartedText";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

