/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.validation.fixes;

import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.impl.ConstantNode;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.dialects.JSDialectSpecificHandlersFactory;
import com.intellij.lang.javascript.dialects.JSLanguageFeature;
import com.intellij.lang.javascript.ecmascript6.JSInsertThisFix;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSObjectLiteralExpression;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.ecma6.ES6Decorator;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptEnum;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptModule;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptObjectType;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.psi.util.JSClassUtils;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.lang.javascript.validation.fixes.BaseCreateJSVariableIntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class CreateJSVariableIntentionAction
extends BaseCreateJSVariableIntentionAction {
    @NonNls
    private final boolean isField;
    private final boolean isConstant;
    private final boolean myIsModuleScope;

    public CreateJSVariableIntentionAction(String referencedName, boolean isField, boolean isConstant, boolean isModuleScope) {
        super(referencedName);
        this.isField = isField;
        this.isConstant = isConstant;
        this.myIsModuleScope = isModuleScope;
    }

    @NotNull
    public String getName() {
        String string = JSBundle.message((String)(this.isField && !this.myIsModuleScope ? (this.myIsProperty ? "javascript.create.property.intention.name" : (this.isConstant ? "javascript.create.constant.field.intention.name" : "javascript.create.field.intention.name")) : (this.isConstant ? "javascript.create.constant.intention.name" : "javascript.create.variable.intention.name")), (Object[])new Object[]{this.myReferencedName});
        if (string == null) {
            CreateJSVariableIntentionAction.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    protected boolean produceDeclarationInScope(PsiElement element) {
        return this.isField;
    }

    @Override
    @NotNull
    protected Pair<JSReferenceExpression, PsiElement> calculateAnchors(PsiElement psiElement) {
        ES6Decorator decorator = (ES6Decorator)PsiTreeUtil.getParentOfType((PsiElement)psiElement, ES6Decorator.class);
        JSReferenceExpression referenceExpression = (JSReferenceExpression)PsiTreeUtil.getNonStrictParentOfType((PsiElement)psiElement, (Class[])new Class[]{JSReferenceExpression.class});
        if (decorator != null) {
            if (this.isField) {
                Pair pair = Pair.create((Object)referenceExpression, (Object)decorator.getOwner().getLastChild());
                if (pair == null) {
                    CreateJSVariableIntentionAction.$$$reportNull$$$0(1);
                }
                return pair;
            }
            Pair pair = Pair.create((Object)referenceExpression, (Object)decorator.getOwner());
            if (pair == null) {
                CreateJSVariableIntentionAction.$$$reportNull$$$0(2);
            }
            return pair;
        }
        Pair<JSReferenceExpression, PsiElement> pair = super.calculateAnchors(psiElement);
        if (pair == null) {
            CreateJSVariableIntentionAction.$$$reportNull$$$0(3);
        }
        return pair;
    }

    @Override
    protected void buildTemplate(Template template, JSReferenceExpression referenceExpression, boolean isStaticContext, @NotNull PsiElement anchorParent) {
        boolean hasTypes;
        String varDeclarationText;
        boolean creatingInDifferentFile;
        JSExpression qualifier;
        if (anchorParent == null) {
            CreateJSVariableIntentionAction.$$$reportNull$$$0(4);
        }
        if (anchorParent instanceof JSObjectLiteralExpression) {
            String name = referenceExpression != null ? referenceExpression.getReferenceName() : this.myReferencedName;
            template.addTextSegment(name + ": ");
            JSType expectedType = referenceExpression != null ? JSDialectSpecificHandlersFactory.findExpectedType((JSExpression)referenceExpression) : null;
            String defaultValue = JSTypeUtils.defaultValueOfType(expectedType);
            template.addVariable((Expression)new ConstantNode(defaultValue), true);
            return;
        }
        DialectOptionHolder holder = DialectDetector.dialectOfElement(anchorParent);
        boolean isActionScript = holder != null && holder.isECMA4;
        PsiElement contextClass = CreateJSVariableIntentionAction.findClass(anchorParent);
        boolean isPropertyLikeSyntax = contextClass instanceof JSClass || contextClass instanceof TypeScriptObjectType;
        JSExpression jSExpression = qualifier = referenceExpression == null ? null : referenceExpression.getQualifier();
        if (contextClass instanceof JSClass) {
            this.addAccessModifier(template, referenceExpression, isStaticContext, (JSClass)contextClass);
        }
        boolean exportWithoutFrom = this.isExportWithoutFrom();
        boolean bl = creatingInDifferentFile = referenceExpression == null && !exportWithoutFrom || qualifier != null && referenceExpression.getContainingFile() != anchorParent.getContainingFile();
        String refText = referenceExpression == null ? this.myReferencedName : (isActionScript || isPropertyLikeSyntax ? referenceExpression.getReferenceName() : referenceExpression.getText());
        String string = varDeclarationText = this.isConstant ? "const " : JSChangeUtil.getVariablePrefix(anchorParent) + " ";
        if (isActionScript) {
            template.addTextSegment(varDeclarationText);
        } else if (qualifier == null && !this.isField && !isPropertyLikeSyntax || creatingInDifferentFile || anchorParent instanceof TypeScriptModule || exportWithoutFrom) {
            if (referenceExpression != null) {
                refText = referenceExpression.getReferenceName();
            }
            if ((creatingInDifferentFile && anchorParent instanceof JSFile || this.myIsModuleScope) && !exportWithoutFrom) {
                if (this.isExportDefault()) {
                    template.addTextSegment("export default " + refText + ";\n");
                } else {
                    template.addTextSegment("export ");
                }
            }
            if (!creatingInDifferentFile || exportWithoutFrom || anchorParent instanceof JSFile) {
                template.addTextSegment(varDeclarationText);
            }
        }
        if (JSUtils.isPrivateFieldSharpAccessContext((PsiElement)referenceExpression)) {
            template.addTextSegment("#");
        }
        if (refText != null) {
            template.addTextSegment(refText);
        }
        template.addEndVariable();
        boolean isEnumContext = contextClass instanceof TypeScriptEnum;
        boolean bl2 = hasTypes = holder != null && holder.hasFeature(JSLanguageFeature.TYPES);
        if (referenceExpression != null) {
            if (isActionScript || (contextClass != null && !isEnumContext || this.myIsModuleScope) && hasTypes) {
                template.addTextSegment(":");
                this.guessTypeAndAddTemplateVariable(template, (JSExpression)referenceExpression, anchorParent, false);
                if (this.isConstant) {
                    template.addTextSegment(" = ");
                    this.addCompletionVar(template);
                }
            } else if (qualifier != null && contextClass == null) {
                template.addTextSegment(" = ");
                ConstantNode expression = new ConstantNode("undefined");
                template.addVariable("__type" + referenceExpression.getText(), (Expression)expression, (Expression)expression, true);
            }
        }
        if (!isEnumContext) {
            this.addSemicolonSegment(template, anchorParent);
        } else {
            TypeScriptEnum classEnum = (TypeScriptEnum)contextClass;
            if (classEnum.getFields().length > 0) {
                template.addTextSegment(",");
            }
        }
    }

    @Override
    protected JSReferenceExpression beforeStartTemplateAction(JSReferenceExpression referenceExpression, Editor editor, @NotNull PsiElement anchor, boolean isStaticContext) {
        JSReferenceExpression expression;
        if (anchor == null) {
            CreateJSVariableIntentionAction.$$$reportNull$$$0(5);
        }
        if ((expression = super.beforeStartTemplateAction(referenceExpression, editor, anchor, isStaticContext)) == null) {
            return null;
        }
        if (JSClassUtils.isES6ClassImplementation((PsiElement)expression) && expression.getQualifier() == null && this.isField) {
            return (JSReferenceExpression)JSInsertThisFix.insertThisQualifier((JSExpression)expression, editor);
        }
        return expression;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 4: 
            case 5: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 4: 
            case 5: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/validation/fixes/CreateJSVariableIntentionAction";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anchorParent";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anchor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "calculateAnchors";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/validation/fixes/CreateJSVariableIntentionAction";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "buildTemplate";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "beforeStartTemplateAction";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 4: 
            case 5: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

