/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.intentions;

import com.intellij.codeInsight.daemon.impl.DaemonTooltipWithActionRendererKt;
import com.intellij.codeInsight.hint.HintManager;
import com.intellij.codeInsight.hint.HintManagerImpl;
import com.intellij.codeInsight.hint.HintUtil;
import com.intellij.codeInsight.hint.QuestionAction;
import com.intellij.codeInsight.intention.HighPriorityAction;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.HintAction;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.LocalQuickFixOnPsiElement;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.icons.AllIcons;
import com.intellij.lang.ASTNode;
import com.intellij.lang.ecmascript6.psi.impl.ES6CreateImportUtil;
import com.intellij.lang.ecmascript6.psi.impl.ES6ImportPsiUtil;
import com.intellij.lang.ecmascript6.resolve.ES6ImportHandler;
import com.intellij.lang.ecmascript6.resolve.ES6PsiUtil;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.dialects.JSXHarmonyLanguageDialect;
import com.intellij.lang.javascript.ecmascript6.ES6QualifiedNamedElementRenderer;
import com.intellij.lang.javascript.flex.JSQualifiedNamedElementRenderer;
import com.intellij.lang.javascript.formatter.JSCodeStyleSettings;
import com.intellij.lang.javascript.modules.ES6ImportAction;
import com.intellij.lang.javascript.modules.JSModuleNameInfo;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSRecursiveWalkingElementVisitor;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSXmlLiteralExpression;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptModule;
import com.intellij.lang.javascript.psi.ecma6.impl.JSXXmlLiteralExpressionImpl;
import com.intellij.lang.javascript.psi.resolve.JSResolveResult;
import com.intellij.lang.javascript.settings.JSApplicationSettings;
import com.intellij.lang.javascript.validation.TypeScriptReferenceChecker;
import com.intellij.lang.typescript.intentions.TypeScriptImportAction;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.ResolveResult;
import com.intellij.ui.LightweightHint;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Consumer;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeScriptAddImportStatementFix
extends LocalQuickFixOnPsiElement
implements HintAction,
HighPriorityAction {
    @Nullable
    private final String myName;
    private final ES6ImportAction.ImportElementFilter myFilter;
    protected volatile boolean myNeedHint;
    private final boolean mySeveralVariants;
    @Nullable
    private final String myElementText;

    public TypeScriptAddImportStatementFix(@Nullable String name, @NotNull PsiElement context, boolean needHint, @NotNull ES6ImportAction.ImportElementFilter filter) {
        if (context == null) {
            TypeScriptAddImportStatementFix.$$$reportNull$$$0(0);
        }
        if (filter == null) {
            TypeScriptAddImportStatementFix.$$$reportNull$$$0(1);
        }
        super(context);
        this.myName = name;
        this.myNeedHint = needHint;
        this.myFilter = filter;
        List<JSElement> candidates = this.getCandidates(null);
        this.mySeveralVariants = candidates.size() > 1;
        JSElement firstItem = (JSElement)ContainerUtil.getFirstItem(candidates);
        if (firstItem != null) {
            String newText;
            String elementText = new ES6QualifiedNamedElementRenderer<JSElement>().getElementText(firstItem);
            if (this.mySeveralVariants) {
                newText = elementText;
            } else {
                String nameToShow = elementText + " " + JSQualifiedNamedElementRenderer.getContainerText(firstItem);
                newText = this.getSimpleImportText(firstItem, nameToShow);
            }
            this.myElementText = newText;
        } else {
            this.myElementText = null;
        }
    }

    public TypeScriptAddImportStatementFix(@Nullable String name, @NotNull PsiElement context, boolean needHint) {
        if (context == null) {
            TypeScriptAddImportStatementFix.$$$reportNull$$$0(2);
        }
        this(name, context, needHint, new ES6ImportAction.DefaultElementFilter());
    }

    public TypeScriptAddImportStatementFix(@Nullable String name, @NotNull PsiElement context) {
        if (context == null) {
            TypeScriptAddImportStatementFix.$$$reportNull$$$0(3);
        }
        this(name, context, true);
    }

    @Nls
    @NotNull
    public String getText() {
        String string = this.getFamilyName();
        if (string == null) {
            TypeScriptAddImportStatementFix.$$$reportNull$$$0(4);
        }
        return string;
    }

    @Nls
    @NotNull
    public String getFamilyName() {
        String string = TypeScriptAddImportStatementFix.getActionName();
        if (string == null) {
            TypeScriptAddImportStatementFix.$$$reportNull$$$0(5);
        }
        return string;
    }

    private void disableHint() {
        this.myNeedHint = false;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file2) {
        List<JSElement> candidates;
        if (project == null) {
            TypeScriptAddImportStatementFix.$$$reportNull$$$0(6);
        }
        return !(candidates = this.getCandidates(editor)).isEmpty();
    }

    @NotNull
    protected ES6ImportAction.ImportElementFilter getFilter() {
        ES6ImportAction.ImportElementFilter importElementFilter = this.myFilter;
        if (importElementFilter == null) {
            TypeScriptAddImportStatementFix.$$$reportNull$$$0(7);
        }
        return importElementFilter;
    }

    @Nullable
    private String getImportedName() {
        return this.myName;
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file2) throws IncorrectOperationException {
        if (project == null) {
            TypeScriptAddImportStatementFix.$$$reportNull$$$0(8);
        }
        this.createAction(editor).execute();
    }

    public void invoke(@NotNull Project project, @NotNull PsiFile file2, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        ES6ImportAction action;
        List<JSElement> candidates;
        if (project == null) {
            TypeScriptAddImportStatementFix.$$$reportNull$$$0(9);
        }
        if (file2 == null) {
            TypeScriptAddImportStatementFix.$$$reportNull$$$0(10);
        }
        if (startElement == null) {
            TypeScriptAddImportStatementFix.$$$reportNull$$$0(11);
        }
        if (endElement == null) {
            TypeScriptAddImportStatementFix.$$$reportNull$$$0(12);
        }
        if ((candidates = (action = this.createAction(null)).getCandidates()).size() == 1) {
            action.execute();
        }
    }

    public boolean fixSilently(@NotNull Editor editor) {
        if (editor == null) {
            TypeScriptAddImportStatementFix.$$$reportNull$$$0(13);
        }
        if (!JSApplicationSettings.getInstance().haTSUnambiguousImportsOnTheFlyEffective(editor.getProject())) {
            return false;
        }
        List<JSElement> candidates = this.createAction(null).getCandidates();
        if (candidates.size() == 1) {
            this.createAction(null).execute();
            return true;
        }
        return false;
    }

    public boolean startInWriteAction() {
        return false;
    }

    public ImportAllQuickFix createImportAllFix() {
        return new ImportAllQuickFix();
    }

    public boolean showHint(@NotNull Editor editor) {
        if (editor == null) {
            TypeScriptAddImportStatementFix.$$$reportNull$$$0(14);
        }
        if (!JSApplicationSettings.getInstance().showTSImportPopupEffective(editor.getProject()) || !this.myNeedHint || this.myName == null || this.myName.length() <= 1) {
            return false;
        }
        Project project = editor.getProject();
        if (project == null) {
            return false;
        }
        PsiElement element = this.getStartElement();
        if (element == null || this.myElementText == null || !this.myFilter.isValidContext(element) || Boolean.TRUE.equals(element.getUserData(ES6ImportAction.NO_HINT_KEY))) {
            return false;
        }
        TextRange range = InjectedLanguageManager.getInstance((Project)element.getProject()).injectedToHost(element, element.getTextRange());
        ES6ImportAction action = this.createAction(editor);
        this.showHint(project, editor, range, action);
        return true;
    }

    private void showHint(@NotNull Project project, final @NotNull Editor editor, @NotNull TextRange range, @NotNull ES6ImportAction action) {
        CustomShortcutSet importAll;
        String allShortcutText;
        if (project == null) {
            TypeScriptAddImportStatementFix.$$$reportNull$$$0(15);
        }
        if (editor == null) {
            TypeScriptAddImportStatementFix.$$$reportNull$$$0(16);
        }
        if (range == null) {
            TypeScriptAddImportStatementFix.$$$reportNull$$$0(17);
        }
        if (action == null) {
            TypeScriptAddImportStatementFix.$$$reportNull$$$0(18);
        }
        if (StringUtil.isEmptyOrSpaces((String)(allShortcutText = KeymapUtil.getFirstKeyboardShortcutText((ShortcutSet)(importAll = DaemonTooltipWithActionRendererKt.getRunActionCustomShortcutSet()))))) {
            this.showSimpleHint(editor, range, action);
            return;
        }
        String message = this.getHintMessage(allShortcutText);
        if (message == null) {
            return;
        }
        JComponent label = HintUtil.createQuestionLabel((String)message, (Icon)AllIcons.General.ContextHelp);
        final AnAction anAction = this.createImportAllAction(editor, project, importAll);
        LightweightHint hint = new LightweightHint(label){

            public void hide() {
                anAction.unregisterCustomShortcutSet(editor.getContentComponent());
                super.hide();
            }
        };
        HintManagerImpl.getInstanceImpl().showQuestionHint(editor, range.getStartOffset(), range.getEndOffset(), hint, (QuestionAction)action, (short)1);
    }

    private void showSimpleHint(@NotNull Editor editor, @NotNull TextRange range, @NotNull ES6ImportAction action) {
        String message;
        if (editor == null) {
            TypeScriptAddImportStatementFix.$$$reportNull$$$0(19);
        }
        if (range == null) {
            TypeScriptAddImportStatementFix.$$$reportNull$$$0(20);
        }
        if (action == null) {
            TypeScriptAddImportStatementFix.$$$reportNull$$$0(21);
        }
        if ((message = this.getHintMessage(null)) == null) {
            return;
        }
        HintManager.getInstance().showQuestionHint(editor, message, range.getStartOffset(), range.getEndOffset(), (QuestionAction)action);
    }

    @NotNull
    private AnAction createImportAllAction(final @NotNull Editor editor, final @NotNull Project project, final @NotNull CustomShortcutSet importAll) {
        if (editor == null) {
            TypeScriptAddImportStatementFix.$$$reportNull$$$0(22);
        }
        if (project == null) {
            TypeScriptAddImportStatementFix.$$$reportNull$$$0(23);
        }
        if (importAll == null) {
            TypeScriptAddImportStatementFix.$$$reportNull$$$0(24);
        }
        AnAction anAction = new AnAction(){
            {
                this.registerCustomShortcutSet((ShortcutSet)importAll, editor.getContentComponent());
            }

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (project.isDisposed()) {
                    return;
                }
                ImportAllQuickFix fix = TypeScriptAddImportStatementFix.this.createImportAllFix();
                PsiElement startElement = TypeScriptAddImportStatementFix.this.getStartElement();
                if (startElement == null || !startElement.isValid()) {
                    return;
                }
                PsiFile containingFile = startElement.getContainingFile();
                if (fix.isAvailable(project, editor, containingFile)) {
                    fix.invoke(project, editor, containingFile);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/lang/typescript/intentions/TypeScriptAddImportStatementFix$2", "actionPerformed"));
            }
        };
        if (anAction == null) {
            TypeScriptAddImportStatementFix.$$$reportNull$$$0(25);
        }
        return anAction;
    }

    @Nullable
    private String getHintMessage(@Nullable String allShortcut) {
        String suffix;
        if (this.myElementText == null) {
            return null;
        }
        String importShortcut = KeymapUtil.getFirstKeyboardShortcutText((AnAction)ActionManager.getInstance().getAction("ShowIntentionActions"));
        String string = suffix = StringUtil.isEmptyOrSpaces((String)allShortcut) ? "" : " " + JSBundle.message((String)"ts.add.import.hint.all.part", (Object[])new Object[]{allShortcut});
        if (this.mySeveralVariants) {
            return JSBundle.message((String)"ts.add.import.hint.multiple.text", (Object[])new Object[]{this.myElementText, importShortcut}) + suffix;
        }
        return JSBundle.message((String)"ts.add.import.hint.text", (Object[])new Object[]{this.myElementText, importShortcut}) + suffix;
    }

    @Nullable
    private String getSimpleImportText(@NotNull JSElement toImport, @NotNull String nameToShow) {
        JSElement module;
        if (toImport == null) {
            TypeScriptAddImportStatementFix.$$$reportNull$$$0(26);
        }
        if (nameToShow == null) {
            TypeScriptAddImportStatementFix.$$$reportNull$$$0(27);
        }
        if ((module = ES6PsiUtil.getExportScope((PsiElement)toImport)) == null || !ES6PsiUtil.isExternalModule((PsiElement)module)) {
            return nameToShow;
        }
        String fromText = this.getFromText(toImport, (PsiElement)module);
        if (fromText == null) {
            return null;
        }
        boolean isDefault = ES6ImportHandler.isExportedWithDefault((PsiElement)toImport);
        String quote = ES6ImportPsiUtil.invertQuote(JSCodeStyleSettings.getQuote((PsiElement)toImport));
        return quote + "import " + (isDefault ? this.getImportedName() : "{" + this.getImportedName() + "}") + " from " + fromText + quote;
    }

    @Nullable
    private String getFromText(@NotNull JSElement toImport, @NotNull PsiElement module) {
        if (toImport == null) {
            TypeScriptAddImportStatementFix.$$$reportNull$$$0(28);
        }
        if (module == null) {
            TypeScriptAddImportStatementFix.$$$reportNull$$$0(29);
        }
        if (module instanceof TypeScriptModule) {
            return ((TypeScriptModule)module).getExternalModuleText();
        }
        JSModuleNameInfo text = ES6CreateImportUtil.getExternalFileModuleName(toImport, this.getStartElement(), false);
        return text == null ? null : text.getPath();
    }

    @NotNull
    private List<JSElement> getCandidates(@Nullable Editor editor) {
        List<JSElement> list2 = this.createAction(editor).getCandidates();
        if (list2 == null) {
            TypeScriptAddImportStatementFix.$$$reportNull$$$0(30);
        }
        return list2;
    }

    @NotNull
    private ES6ImportAction createAction(@Nullable Editor editor) {
        ES6ImportAction eS6ImportAction = this.createAction(editor, this.getStartElement(), this.getImportedName(), this.getFilter());
        if (eS6ImportAction == null) {
            TypeScriptAddImportStatementFix.$$$reportNull$$$0(31);
        }
        return eS6ImportAction;
    }

    @NotNull
    private ES6ImportAction createAction(@Nullable Editor editor, @Nullable PsiElement element, @Nullable String name, @NotNull ES6ImportAction.ImportElementFilter filter) {
        if (filter == null) {
            TypeScriptAddImportStatementFix.$$$reportNull$$$0(32);
        }
        TypeScriptImportAction typeScriptImportAction = new TypeScriptImportAction(editor, element, name, filter){

            @Override
            public void executeFor(@NotNull JSElement candidate, @Nullable Consumer<? super JSElement> postProcess) {
                if (candidate == null) {
                    3.$$$reportNull$$$0(0);
                }
                TypeScriptAddImportStatementFix.this.disableHint();
                super.executeFor(candidate, postProcess);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "candidate", "com/intellij/lang/typescript/intentions/TypeScriptAddImportStatementFix$3", "executeFor"));
            }
        };
        if (typeScriptImportAction == null) {
            TypeScriptAddImportStatementFix.$$$reportNull$$$0(33);
        }
        return typeScriptImportAction;
    }

    public static String getActionName() {
        return JSBundle.message((String)"ts.add.import.statement.family.name", (Object[])new Object[0]);
    }

    @NotNull
    public static String getImportAllActionName() {
        String string = JSBundle.message((String)"ts.add.import.all.family.name", (Object[])new Object[0]);
        if (string == null) {
            TypeScriptAddImportStatementFix.$$$reportNull$$$0(34);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 25: 
            case 30: 
            case 31: 
            case 33: 
            case 34: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 25: 
            case 30: 
            case 31: 
            case 33: 
            case 34: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 25: 
            case 30: 
            case 31: 
            case 33: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/typescript/intentions/TypeScriptAddImportStatementFix";
                break;
            }
            case 6: 
            case 8: 
            case 9: 
            case 15: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startElement";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "endElement";
                break;
            }
            case 13: 
            case 14: 
            case 16: 
            case 19: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 17: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 18: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "importAll";
                break;
            }
            case 26: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toImport";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nameToShow";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/typescript/intentions/TypeScriptAddImportStatementFix";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilter";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "createImportAllAction";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "getCandidates";
                break;
            }
            case 31: 
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "createAction";
                break;
            }
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "getImportAllActionName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 25: 
            case 30: 
            case 31: 
            case 33: 
            case 34: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "fixSilently";
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "showHint";
                break;
            }
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "showSimpleHint";
                break;
            }
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "createImportAllAction";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "getSimpleImportText";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "getFromText";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "createAction";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 25: 
            case 30: 
            case 31: 
            case 33: 
            case 34: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class ImportAllQuickFix
    implements LocalQuickFix,
    IntentionAction {
        private ImportAllQuickFix() {
        }

        @Nls(capitalization=Nls.Capitalization.Sentence)
        @NotNull
        public String getText() {
            String string = this.getFamilyName();
            if (string == null) {
                ImportAllQuickFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Nls(capitalization=Nls.Capitalization.Sentence)
        @NotNull
        public String getFamilyName() {
            String string = TypeScriptAddImportStatementFix.getImportAllActionName();
            if (string == null) {
                ImportAllQuickFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file2) {
            if (project == null) {
                ImportAllQuickFix.$$$reportNull$$$0(2);
            }
            return TypeScriptAddImportStatementFix.this.getCandidates(editor).size() >= 1;
        }

        public void invoke(@NotNull Project project, Editor editor, PsiFile file2) throws IncorrectOperationException {
            PsiElement element;
            if (project == null) {
                ImportAllQuickFix.$$$reportNull$$$0(3);
            }
            if ((element = TypeScriptAddImportStatementFix.this.getStartElement()) == null || !element.isValid()) {
                return;
            }
            JSElement scope = ES6PsiUtil.getExportScope(element);
            if (scope == null) {
                return;
            }
            final HashMap<String, PsiElement> nameToElement = new HashMap<String, PsiElement>();
            scope.accept((PsiElementVisitor)new JSRecursiveWalkingElementVisitor(){

                public void visitJSReferenceExpression(JSReferenceExpression node) {
                    if (ImportAllQuickFix.this.isAcceptableUnresolvedReference(node)) {
                        nameToElement.putIfAbsent(node.getReferenceName(), node);
                    }
                    super.visitJSReferenceExpression(node);
                }

                public void visitJSLiteralExpression(JSLiteralExpression node) {
                    if (ImportAllQuickFix.this.isAcceptableUnresolvedJSXLiteral(node)) {
                        PsiElement psiName;
                        ASTNode nameNode = node.getNode().findChildByType(JSTokenTypes.XML_TAG_NAME);
                        PsiElement psiElement = psiName = nameNode == null ? null : nameNode.getPsi();
                        if (psiName != null) {
                            nameToElement.putIfAbsent(node.getName(), psiName);
                        }
                    }
                    super.visitJSLiteralExpression(node);
                }
            });
            HashSet imported = new HashSet();
            nameToElement.forEach((name, el) -> {
                ES6ImportAction action = TypeScriptAddImportStatementFix.this.createAction(editor, el, name, new ES6ImportAction.DefaultElementFilter(){

                    @Override
                    public boolean isValidContext(@NotNull PsiElement context) {
                        if (context == null) {
                            2.$$$reportNull$$$0(0);
                        }
                        return context.isValid();
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/lang/typescript/intentions/TypeScriptAddImportStatementFix$ImportAllQuickFix$2", "isValidContext"));
                    }
                });
                List<JSElement> candidates = action.getDistinctCandidatesSync();
                if (candidates.size() == 1) {
                    imported.add(name);
                    action.executeFor((JSElement)Objects.requireNonNull(ContainerUtil.getFirstItem(candidates)), null);
                }
            });
            if (TypeScriptAddImportStatementFix.this.myName != null && !imported.contains(TypeScriptAddImportStatementFix.this.myName)) {
                TypeScriptAddImportStatementFix.this.invoke(project, editor, file2);
            }
        }

        private boolean isAcceptableUnresolvedJSXLiteral(@NotNull JSLiteralExpression node) {
            if (node == null) {
                ImportAllQuickFix.$$$reportNull$$$0(4);
            }
            return node instanceof JSXXmlLiteralExpressionImpl && StringUtil.isCapitalized((String)node.getName()) && !JSXHarmonyLanguageDialect.areReferencesResolvedOrEmpty((JSXmlLiteralExpression)node);
        }

        private boolean isAcceptableUnresolvedReference(@NotNull JSReferenceExpression node) {
            JSExpression qualifier;
            if (node == null) {
                ImportAllQuickFix.$$$reportNull$$$0(5);
            }
            if ((qualifier = node.getQualifier()) != null) {
                return false;
            }
            Object[] results = node.multiResolve(false);
            if (results.length == 0) {
                return true;
            }
            if (results.length != 1 || Arrays.stream(results).anyMatch(ResolveResult::isValidResult)) {
                return false;
            }
            JSResolveResult result2 = (JSResolveResult)ObjectUtils.tryCast((Object)ArrayUtil.getFirstElement((Object[])results), JSResolveResult.class);
            if (result2 == null) {
                return false;
            }
            return TypeScriptReferenceChecker.isAcceptableResolveKey(node, result2.getResolveProblemKey(), result2.getElement());
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
            PsiElement element;
            if (project == null) {
                ImportAllQuickFix.$$$reportNull$$$0(6);
            }
            if (descriptor2 == null) {
                ImportAllQuickFix.$$$reportNull$$$0(7);
            }
            if ((element = descriptor2.getStartElement()) != null) {
                this.invoke(project, null, element.getContainingFile());
            }
        }

        public boolean startInWriteAction() {
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/typescript/intentions/TypeScriptAddImportStatementFix$ImportAllQuickFix";
                    break;
                }
                case 2: 
                case 3: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "node";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getText";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/typescript/intentions/TypeScriptAddImportStatementFix$ImportAllQuickFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "isAvailable";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "invoke";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "isAcceptableUnresolvedJSXLiteral";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "isAcceptableUnresolvedReference";
                    break;
                }
                case 6: 
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

