/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.plugins.intelliLang.inject;

import com.intellij.lang.Language;
import com.intellij.lang.LanguageNamesValidation;
import com.intellij.lang.javascript.JavascriptLanguage;
import com.intellij.lang.javascript.refactoring.JSNamesValidation;
import com.intellij.lang.refactoring.NamesValidator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.plugins.intelliLang.inject.JSTaggedLiteralInjection;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBTextField;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.intellij.plugins.intelliLang.inject.config.BaseInjection;
import org.intellij.plugins.intelliLang.inject.config.ui.AbstractInjectionPanel;
import org.intellij.plugins.intelliLang.inject.config.ui.AdvancedPanel;
import org.intellij.plugins.intelliLang.inject.config.ui.LanguagePanel;
import org.jetbrains.annotations.NotNull;

public class JSTaggedLiteralPanel
extends AbstractInjectionPanel<JSTaggedLiteralInjection> {
    private JBTextField myTagExpressionField;
    private JPanel myRootPanel;
    private LanguagePanel myLanguagePanel;
    private JTextField myNameTextField;
    private AdvancedPanel myAdvancedPanel;
    private boolean myUseGeneratedName;

    public JSTaggedLiteralPanel(@NotNull JSTaggedLiteralInjection injection, @NotNull Project project) {
        if (injection == null) {
            JSTaggedLiteralPanel.$$$reportNull$$$0(0);
        }
        if (project == null) {
            JSTaggedLiteralPanel.$$$reportNull$$$0(1);
        }
        super((BaseInjection)injection, project);
        this.$$$setupUI$$$();
        this.init(injection.copy());
    }

    protected void apply(JSTaggedLiteralInjection other) {
        String name = this.myNameTextField.getText();
        String tagExpressionString = StringUtil.trim((String)this.myTagExpressionField.getText());
        if (!this.isValidTag(tagExpressionString)) {
            throw new RuntimeException("Template tag should be an identifier or dot-separated name: " + tagExpressionString);
        }
        other.setTemplateTag(tagExpressionString);
        boolean useGenerated = this.myUseGeneratedName && Comparing.equal((String)((JSTaggedLiteralInjection)this.myOrigInjection).getDisplayName(), (String)name);
        String newName = useGenerated || StringUtil.isEmptyOrSpaces((String)name) ? other.getGeneratedName() : name;
        other.setDisplayName(newName);
    }

    private boolean isValidTag(String value) {
        List names = StringUtil.split((String)value, (String)".", (boolean)true, (boolean)false);
        for (int i = 0; i < names.size(); ++i) {
            String name = (String)names.get(0);
            if (i != 0 ? JSNamesValidation.isIdentifierName(name) : ((NamesValidator)LanguageNamesValidation.INSTANCE.forLanguage((Language)JavascriptLanguage.INSTANCE)).isIdentifier(name, this.myProject)) continue;
            return false;
        }
        return true;
    }

    protected void resetImpl() {
        this.myNameTextField.setText(((JSTaggedLiteralInjection)this.myOrigInjection).getDisplayName());
        this.myTagExpressionField.setText(((JSTaggedLiteralInjection)this.myOrigInjection).getTemplateTag());
        this.myUseGeneratedName = Comparing.equal((String)((JSTaggedLiteralInjection)this.myOrigInjection).getDisplayName(), (String)((JSTaggedLiteralInjection)this.myOrigInjection).getGeneratedName());
    }

    public JPanel getComponent() {
        return this.myRootPanel;
    }

    private void createUIComponents() {
        this.myLanguagePanel = new LanguagePanel(this.myProject, this.myOrigInjection);
        this.myAdvancedPanel = new AdvancedPanel(this.myProject, this.myOrigInjection);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "injection";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "project";
                break;
            }
        }
        objectArray[1] = "com/intellij/plugins/intelliLang/inject/JSTaggedLiteralPanel";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JTextField jTextField;
        JBTextField jBTextField;
        JPanel jPanel;
        this.createUIComponents();
        this.myRootPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(4, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithIndent");
        jPanel.add((Component)jPanel2, new GridConstraints(2, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        jPanel2.setBorder(IdeBorderFactory.PlainSmallWithIndent.createTitledBorder(null, (String)ResourceBundle.getBundle("messages/JavaScriptBundle").getString("intellilang.tagged.literal.expression.border.title"), (int)0, (int)0, null, null));
        JBLabel jBLabel = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel, ResourceBundle.getBundle("messages/JavaScriptBundle").getString("intellilang.tagged.literal.injection.name.label"));
        jPanel2.add((Component)jBLabel, new GridConstraints(0, 0, 1, 1, 0, 0, 0, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel2.add((Component)spacer, new GridConstraints(1, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        this.myTagExpressionField = jBTextField = new JBTextField();
        jPanel2.add((Component)jBTextField, new GridConstraints(0, 1, 1, 1, 0, 1, 3, 3, null, new Dimension(150, -1), null));
        LanguagePanel languagePanel = this.myLanguagePanel;
        JComponent jComponent = languagePanel.$$$getRootComponent$$$();
        jPanel.add((Component)jComponent, new GridConstraints(1, 0, 1, 1, 0, 1, 7, 0, null, null, null));
        AdvancedPanel advancedPanel = this.myAdvancedPanel;
        JComponent jComponent2 = advancedPanel.$$$getRootComponent$$$();
        jPanel.add((Component)jComponent2, new GridConstraints(3, 0, 1, 1, 0, 1, 7, 0, null, null, null));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel3, new GridConstraints(0, 0, 1, 1, 0, 3, 0, 0, null, null, null));
        JLabel jLabel = new JLabel();
        jLabel.setText("Name:");
        jLabel.setDisplayedMnemonic('N');
        jLabel.setDisplayedMnemonicIndex(0);
        jPanel3.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myNameTextField = jTextField = new JTextField();
        jPanel3.add((Component)jTextField, new GridConstraints(0, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        jBLabel.setLabelFor((Component)jBTextField);
        jLabel.setLabelFor(jTextField);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myRootPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }
}

