/*
 * Decompiled with CFR 0.152.
 */
package com.sixrr.inspectjs.validity;

import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.index.JSSymbolUtil;
import com.intellij.lang.javascript.psi.JSAssignmentExpression;
import com.intellij.lang.javascript.psi.JSBlockStatement;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSFunctionProperty;
import com.intellij.lang.javascript.psi.JSNewExpression;
import com.intellij.lang.javascript.psi.JSRecursiveWalkingElementVisitor;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSReturnStatement;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.util.ControlFlowUtils;
import com.intellij.lang.javascript.validation.ValidateTypesUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.util.PsiTreeUtil;
import com.sixrr.inspectjs.BaseInspectionVisitor;
import com.sixrr.inspectjs.InspectionJSBundle;
import com.sixrr.inspectjs.JSGroupNames;
import com.sixrr.inspectjs.JavaScriptInspection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FunctionWithInconsistentReturnsJSInspectionBase
extends JavaScriptInspection {
    protected static boolean missingReturnStatementProblem(JSFunction function) {
        return function.getReturnType() != null && DialectDetector.isActionScript((PsiElement)function);
    }

    private static boolean functionHasReturnValues(JSFunction function) {
        ReturnValuesVisitor visitor = new ReturnValuesVisitor(function);
        function.acceptChildren((PsiElementVisitor)visitor);
        return visitor.hasReturnValues();
    }

    private static boolean functionHasValuelessReturns(@NotNull JSFunction function) {
        if (function == null) {
            FunctionWithInconsistentReturnsJSInspectionBase.$$$reportNull$$$0(0);
        }
        if (function.isGenerator()) {
            return false;
        }
        PsiElement lastChild = function.getLastChild();
        if (lastChild instanceof JSBlockStatement && ControlFlowUtils.statementMayCompleteNormally((JSStatement)lastChild)) {
            return true;
        }
        ValuelessReturnVisitor visitor = new ValuelessReturnVisitor();
        function.acceptChildren((PsiElementVisitor)visitor);
        return visitor.hasValuelessReturns();
    }

    @NotNull
    public String getDisplayName() {
        String string = InspectionJSBundle.message("function.with.inconsistent.returns.display.name", new Object[0]);
        if (string == null) {
            FunctionWithInconsistentReturnsJSInspectionBase.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    public String getGroupDisplayName() {
        String string = JSGroupNames.VALIDITY_GROUP_NAME;
        if (string == null) {
            FunctionWithInconsistentReturnsJSInspectionBase.$$$reportNull$$$0(2);
        }
        return string;
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    @Nullable
    protected String buildErrorString(Object ... args) {
        JSFunction function = (JSFunction)PsiTreeUtil.getParentOfType((PsiElement)((PsiElement)args[0]), JSFunction.class);
        assert (function != null);
        if (FunctionWithInconsistentReturnsJSInspectionBase.missingReturnStatementProblem(function)) {
            return InspectionJSBundle.message("missing.return.statement.error.string", new Object[0]);
        }
        if (FunctionWithInconsistentReturnsJSInspectionBase.functionHasIdentifier(function)) {
            return InspectionJSBundle.message("function.has.inconsistent.return.points.error.string", new Object[0]);
        }
        return InspectionJSBundle.message("anonymous.function.has.inconsistent.return.points.error.string", new Object[0]);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new Visitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/sixrr/inspectjs/validity/FunctionWithInconsistentReturnsJSInspectionBase";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/sixrr/inspectjs/validity/FunctionWithInconsistentReturnsJSInspectionBase";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroupDisplayName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "functionHasValuelessReturns";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class ValuelessReturnVisitor
    extends JSRecursiveWalkingElementVisitor {
        private boolean hasValuelessReturns = false;

        ValuelessReturnVisitor() {
        }

        public void visitJSReturnStatement(JSReturnStatement statement) {
            super.visitJSReturnStatement(statement);
            if (statement.getExpression() == null) {
                this.hasValuelessReturns = true;
            }
        }

        public void visitJSFunctionDeclaration(JSFunction function) {
        }

        public void visitJSFunctionExpression(JSFunctionExpression node) {
        }

        public boolean hasValuelessReturns() {
            return this.hasValuelessReturns;
        }
    }

    private static class ReturnValuesVisitor
    extends JSRecursiveWalkingElementVisitor {
        private final JSFunction function;
        private boolean hasReturnValues = false;

        ReturnValuesVisitor(JSFunction function) {
            this.function = function;
        }

        public void visitJSReturnStatement(JSReturnStatement statement) {
            super.visitJSReturnStatement(statement);
            JSExpression expression = statement.getExpression();
            if (expression != null) {
                JSExpression methodExpression;
                if (expression instanceof JSNewExpression && (methodExpression = ((JSNewExpression)expression).getMethodExpression()) instanceof JSReferenceExpression && ((JSReferenceExpression)methodExpression).resolve() == this.function) {
                    return;
                }
                this.hasReturnValues = true;
            }
        }

        public void visitJSFunctionDeclaration(JSFunction function) {
        }

        public void visitJSFunctionExpression(JSFunctionExpression node) {
        }

        public void visitJSFunctionProperty(JSFunctionProperty functionProperty) {
        }

        public boolean hasReturnValues() {
            return this.hasReturnValues;
        }
    }

    private static class Visitor
    extends BaseInspectionVisitor {
        private Visitor() {
        }

        @Override
        protected ProblemHighlightType getProblemHighlightType(PsiElement location) {
            DialectOptionHolder dialect = DialectDetector.dialectOfElement(location);
            return dialect != null && dialect.isECMA4 ? ProblemHighlightType.GENERIC_ERROR : super.getProblemHighlightType(location);
        }

        @Override
        protected void registerFunctionError(JSFunction function) {
            JSBlockStatement body;
            if (FunctionWithInconsistentReturnsJSInspectionBase.missingReturnStatementProblem(function) && (body = function.getBlock()) != null) {
                this.registerError(Visitor.findValidEditorLocation(body.getLastChild()));
                return;
            }
            super.registerFunctionError(function);
        }

        public void visitJSFunctionDeclaration(JSFunction function) {
            if (DialectDetector.isTypeScript((PsiElement)function)) {
                return;
            }
            super.visitJSFunctionDeclaration(function);
            if (Visitor.functionHasReturnsErrors(function)) {
                this.registerFunctionError(function);
            }
        }

        private static boolean functionHasReturnsErrors(JSFunction function) {
            JSExpression qualifierQualifier;
            JSReferenceExpression referenceExpression;
            JSExpression qualifier;
            JSExpression expression;
            JSAssignmentExpression assignmentExpression;
            JSExpression lOperand;
            JSType type;
            JSType jSType = type = function.hasExplicitlyDeclaredReturnType() ? function.getReturnType() : null;
            if (type == null && !FunctionWithInconsistentReturnsJSInspectionBase.functionHasReturnValues(function)) {
                return false;
            }
            if (type != null && ValidateTypesUtil.emptyReturnIsAcceptable(function, type) || !FunctionWithInconsistentReturnsJSInspectionBase.functionHasValuelessReturns(function)) {
                return false;
            }
            PsiElement parent = function.getParent();
            return !(parent instanceof JSAssignmentExpression) || !((lOperand = (assignmentExpression = (JSAssignmentExpression)parent).getLOperand()) instanceof JSDefinitionExpression) || !((expression = ((JSDefinitionExpression)lOperand).getExpression()) instanceof JSReferenceExpression) || !((qualifier = (referenceExpression = (JSReferenceExpression)expression).getQualifier()) instanceof JSReferenceExpression) || !"prototype".equals(((JSReferenceExpression)qualifier).getReferencedName()) || !((qualifierQualifier = ((JSReferenceExpression)qualifier).getQualifier()) instanceof JSReferenceExpression) || !JSSymbolUtil.referencesInterface((JSReferenceExpression)qualifierQualifier);
        }

        public void visitJSFunctionExpression(JSFunctionExpression node) {
            super.visitJSFunctionExpression(node);
            if (Visitor.functionHasReturnsErrors((JSFunction)node)) {
                this.registerFunctionError((JSFunction)node);
            }
        }
    }
}

