/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.cucumber.steps;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.cucumber.BDDFrameworkType;
import org.jetbrains.plugins.cucumber.CucumberJvmExtensionPoint;
import org.jetbrains.plugins.cucumber.OptionalStepDefinitionExtensionPoint;
import org.jetbrains.plugins.cucumber.inspections.CucumberStepDefinitionCreationContext;
import org.jetbrains.plugins.cucumber.psi.GherkinFile;
import org.jetbrains.plugins.cucumber.psi.GherkinStep;
import org.jetbrains.plugins.cucumber.steps.AbstractStepDefinition;

public class CucumberStepsIndex {
    private static final Logger LOG = Logger.getInstance((String)CucumberStepsIndex.class.getName());
    private final Map<BDDFrameworkType, CucumberJvmExtensionPoint> myExtensionMap = new HashMap<BDDFrameworkType, CucumberJvmExtensionPoint>();
    private final Map<CucumberJvmExtensionPoint, Object> myExtensionData = new HashMap<CucumberJvmExtensionPoint, Object>();
    private Project myProject;

    public static CucumberStepsIndex getInstance(Project project) {
        CucumberStepsIndex result = (CucumberStepsIndex)ServiceManager.getService((Project)project, CucumberStepsIndex.class);
        result.myProject = project;
        return result;
    }

    public CucumberStepsIndex(Project project) {
        for (CucumberJvmExtensionPoint e : CucumberJvmExtensionPoint.EP_NAME.getExtensionList()) {
            this.myExtensionMap.put(e.getStepFileType(), e);
            this.myExtensionData.put(e, e.getDataObject(project));
        }
    }

    public Object getExtensionDataObject(CucumberJvmExtensionPoint e) {
        return this.myExtensionData.get(e);
    }

    public PsiFile createStepDefinitionFile(@NotNull PsiDirectory dir, @NotNull String fileNameWithoutExtension, @NotNull BDDFrameworkType frameworkType) {
        CucumberJvmExtensionPoint ep;
        if (dir == null) {
            CucumberStepsIndex.$$$reportNull$$$0(0);
        }
        if (fileNameWithoutExtension == null) {
            CucumberStepsIndex.$$$reportNull$$$0(1);
        }
        if (frameworkType == null) {
            CucumberStepsIndex.$$$reportNull$$$0(2);
        }
        if ((ep = this.myExtensionMap.get(frameworkType)) == null) {
            LOG.error(String.format("Unsupported step definition file type %s", frameworkType.toString()));
            return null;
        }
        return ep.getStepDefinitionCreator().createStepDefinitionContainer(dir, fileNameWithoutExtension);
    }

    public boolean validateNewStepDefinitionFileName(@NotNull PsiDirectory directory, @NotNull String fileName, @NotNull BDDFrameworkType frameworkType) {
        if (directory == null) {
            CucumberStepsIndex.$$$reportNull$$$0(3);
        }
        if (fileName == null) {
            CucumberStepsIndex.$$$reportNull$$$0(4);
        }
        if (frameworkType == null) {
            CucumberStepsIndex.$$$reportNull$$$0(5);
        }
        CucumberJvmExtensionPoint ep = this.myExtensionMap.get(frameworkType);
        assert (ep != null);
        return ep.getStepDefinitionCreator().validateNewStepDefinitionFileName(directory.getProject(), fileName);
    }

    @Nullable
    public AbstractStepDefinition findStepDefinition(@NotNull PsiFile featureFile, @NotNull GherkinStep step) {
        Collection<AbstractStepDefinition> definitions;
        if (featureFile == null) {
            CucumberStepsIndex.$$$reportNull$$$0(6);
        }
        if (step == null) {
            CucumberStepsIndex.$$$reportNull$$$0(7);
        }
        return (definitions = this.findStepDefinitions(featureFile, step)).isEmpty() ? null : definitions.iterator().next();
    }

    @NotNull
    public Collection<AbstractStepDefinition> findStepDefinitions(@NotNull PsiFile featureFile, @NotNull GherkinStep step) {
        Module module;
        if (featureFile == null) {
            CucumberStepsIndex.$$$reportNull$$$0(8);
        }
        if (step == null) {
            CucumberStepsIndex.$$$reportNull$$$0(9);
        }
        if ((module = ModuleUtilCore.findModuleForPsiElement((PsiElement)featureFile)) == null) {
            List<AbstractStepDefinition> list = Collections.emptyList();
            if (list == null) {
                CucumberStepsIndex.$$$reportNull$$$0(10);
            }
            return list;
        }
        String substitutedName = step.getSubstitutedName();
        if (substitutedName == null) {
            List<AbstractStepDefinition> list = Collections.emptyList();
            if (list == null) {
                CucumberStepsIndex.$$$reportNull$$$0(11);
            }
            return list;
        }
        HashMap definitionsByClass = new HashMap();
        List<AbstractStepDefinition> allSteps = this.loadStepsFor(featureFile, module);
        for (AbstractStepDefinition stepDefinition : allSteps) {
            int newPatternLength;
            if (!stepDefinition.matches(substitutedName) || !stepDefinition.supportsStep(step)) continue;
            Pattern currentLongestPattern = CucumberStepsIndex.getPatternByDefinition((AbstractStepDefinition)definitionsByClass.get(stepDefinition.getClass()));
            Pattern newPattern = CucumberStepsIndex.getPatternByDefinition(stepDefinition);
            int n = newPatternLength = newPattern != null ? newPattern.pattern().length() : -1;
            if (currentLongestPattern != null && currentLongestPattern.pattern().length() >= newPatternLength) continue;
            definitionsByClass.put(stepDefinition.getClass(), stepDefinition);
        }
        Collection<AbstractStepDefinition> collection = definitionsByClass.values();
        if (collection == null) {
            CucumberStepsIndex.$$$reportNull$$$0(12);
        }
        return collection;
    }

    @Nullable
    private static Pattern getPatternByDefinition(@Nullable AbstractStepDefinition definition) {
        if (definition == null) {
            return null;
        }
        return definition.getPattern();
    }

    public List<AbstractStepDefinition> findStepDefinitionsByPattern(@NotNull String pattern, @NotNull Module module) {
        if (pattern == null) {
            CucumberStepsIndex.$$$reportNull$$$0(13);
        }
        if (module == null) {
            CucumberStepsIndex.$$$reportNull$$$0(14);
        }
        List<AbstractStepDefinition> allSteps = this.loadStepsFor(null, module);
        ArrayList<AbstractStepDefinition> result = new ArrayList<AbstractStepDefinition>();
        for (AbstractStepDefinition stepDefinition : allSteps) {
            String elementText = stepDefinition.getCucumberRegex();
            if (elementText == null || !elementText.equals(pattern)) continue;
            result.add(stepDefinition);
        }
        return result;
    }

    public List<AbstractStepDefinition> getAllStepDefinitions(@NotNull PsiFile featureFile) {
        Module module;
        if (featureFile == null) {
            CucumberStepsIndex.$$$reportNull$$$0(15);
        }
        if ((module = ModuleUtilCore.findModuleForPsiElement((PsiElement)featureFile)) == null) {
            return Collections.emptyList();
        }
        return this.loadStepsFor(featureFile, module);
    }

    private List<AbstractStepDefinition> loadStepsFor(@Nullable PsiFile featureFile, @NotNull Module module) {
        if (module == null) {
            CucumberStepsIndex.$$$reportNull$$$0(16);
        }
        ArrayList<AbstractStepDefinition> result = new ArrayList<AbstractStepDefinition>();
        for (CucumberJvmExtensionPoint extension : this.myExtensionMap.values()) {
            result.addAll(extension.loadStepsFor(featureFile, module));
        }
        return result;
    }

    public Set<CucumberStepDefinitionCreationContext> getStepDefinitionContainers(@NotNull GherkinFile featureFile) {
        if (featureFile == null) {
            CucumberStepsIndex.$$$reportNull$$$0(17);
        }
        HashSet<CucumberStepDefinitionCreationContext> result = new HashSet<CucumberStepDefinitionCreationContext>();
        for (CucumberJvmExtensionPoint ep : this.myExtensionMap.values()) {
            if (ep instanceof OptionalStepDefinitionExtensionPoint && !((OptionalStepDefinitionExtensionPoint)ep).participateInStepDefinitionCreation((PsiElement)featureFile)) continue;
            Collection<? extends PsiFile> psiFiles = ep.getStepDefinitionContainers(featureFile);
            BDDFrameworkType frameworkType = ep.getStepFileType();
            for (PsiFile psiFile : psiFiles) {
                result.add(new CucumberStepDefinitionCreationContext(psiFile, frameworkType));
            }
        }
        return result;
    }

    public void reset() {
        for (CucumberJvmExtensionPoint e : this.myExtensionMap.values()) {
            e.reset(this.myProject);
        }
    }

    public void flush() {
        for (CucumberJvmExtensionPoint e : this.myExtensionMap.values()) {
            e.flush(this.myProject);
        }
    }

    public Map<BDDFrameworkType, CucumberJvmExtensionPoint> getExtensionMap() {
        return this.myExtensionMap;
    }

    public int getExtensionCount() {
        return this.myExtensionMap.size();
    }

    public boolean isGherkin6Supported(@NotNull Module module) {
        if (module == null) {
            CucumberStepsIndex.$$$reportNull$$$0(18);
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return true;
        }
        for (CucumberJvmExtensionPoint ep : this.myExtensionMap.values()) {
            if (!ep.isGherkin6Supported(module)) continue;
            return true;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dir";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileNameWithoutExtension";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "frameworkType";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directory";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileName";
                break;
            }
            case 6: 
            case 8: 
            case 15: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "featureFile";
                break;
            }
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "step";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/cucumber/steps/CucumberStepsIndex";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pattern";
                break;
            }
            case 14: 
            case 16: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/cucumber/steps/CucumberStepsIndex";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "findStepDefinitions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createStepDefinitionFile";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "validateNewStepDefinitionFileName";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "findStepDefinition";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "findStepDefinitions";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "findStepDefinitionsByPattern";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getAllStepDefinitions";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "loadStepsFor";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getStepDefinitionContainers";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "isGherkin6Supported";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

